<?php

namespace App\Controller;


use App\Entity\User;
use Doctrine\DBAL\Driver\Connection;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Mime\Email;

class ApiController extends AbstractController
{
    private $em;
    private $conn;
    private $mailer;

    public function __construct(EntityManagerInterface $entityManager, Connection $conn, MailerInterface $mailer)
    {
        $this->em = $entityManager;
        $this->conn = $conn;
        $this->mailer = $mailer;
    }

    /**
     * @Route("/api", name="app_api")
     */
    public function index(): Response
    {
        return new JsonResponse(true);
    }




    /**
     * @Route("/api/check_send_temporary_code", name="api_check_send_temporary_code")
     */
    public function apiCheckSendTemporaryCode($channel = "all"): Response
    {

        $roles = $this->getUser()->getRoles();
        $directaccess = false;
        $action = '';


        $user = $this->getUser();
        $user->setReadmode(false);
        // vérifier s'il y a un code temporaire encore valable
        $rs = $this->conn->executeQuery("
                                        select
                                            CASE 
                                                WHEN temporary_code_expired_at::timestamp(0) is null THEN 'update' 
                                                WHEN now()::timestamp(0) > temporary_code_expired_at::timestamp(0) THEN 'update'
                                                ELSE 'not_update'
                                            END as todo
                                        from actor
                                        where id = " . $user->getId()
        )->fetchAll();

        // Générer un code temporaire valable
        if ($rs[0]['todo'] == 'update') {
            $dt = new \DateTime();
            $dt->setTimestamp(time() + ($this->getParameter("temporary_code_keeplive") * 60));
            $user->setTemporarycode(mt_rand(1000, 9999))->setTemporaryCodeExpiredAt($dt)->setLoginAttemptNumber($this->getParameter("login_attempt_number"));
            $this->em->persist($user);
            $this->em->flush($user);
        }

        $code = $user->getTemporaryCode();

        // Envoi du code via canal SMS ou email ou les deux canaux
        $channel = trim(strtolower($user->getOptEmailOrSms()));
        $channel = ($channel == '' || $channel == null) ? 'all' : $channel;




        if(count($roles) == 1 && $roles[0] == 'ROLE_ACTEUR'){
            $directaccess = true;
            $action =  $this->generateUrl('fos_user_security_check');
        }

        if(count($roles) == 1 && $roles[0] == 'ROLE_USER'){
            $directaccess = true;
            $action =  $this->generateUrl('fos_user_security_check');
        }
        if(count($roles) == 2 && in_array("ROLE_ACTEUR", $roles) && in_array("ROLE_USER", $roles)){
            $directaccess = true;
            $action =  $this->generateUrl('fos_user_security_check');
        }


        $typeChannelSelected    = '';
        $channelSelected        = '';

        if(!$directaccess){

            if ($channel == "email" || $channel == "all") {
                //$this->forward("App\Controller\OtpController::sendTemporaryCodeByEmail", ['user' => $user->getId(), 'code' => $code])->getContent();
                $typeChannelSelected    = "Email";
                $channelSelected        = $this->obfuscateEmail(($user->getSecondaryEmail() != '' && $user->getSecondaryEmail() != null ) ? $user->getSecondaryEmail() : $user->getEmail());
            }

            if ($channel == "sms" || $channel == "all") {
                //$this->forward("App\Controller\OtpController::sendTemporaryCodeByBySMS", ['user' => $user->getId(), 'code' => $code])->getContent();
                $typeChannelSelected    = "SMS";
                $channelSelected        = $this->obfuscatePhoneNumber($user->getMobile());
            }
        }

        return new JsonResponse([
            'code'          => 200,
            'username'      => $this->getUser()->getUsername(),
            'directaccess'  => $directaccess,
            'action'        => $action,

            'typechannel'   => $typeChannelSelected,
            'channel'       => $channelSelected,
            'messageOPT'    => ""
        ]);

    }

    /**
     * @Route("/api/send_temporary_code", name="api_send_temporary_code")
     */
    public function apiSendTemporaryCode($channel = "all"): Response
    {

        $roles = $this->getUser()->getRoles();
        $directaccess = false;
        $action = '';


        $user = $this->getUser();
        $user->setReadmode(false);
        // vérifier s'il y a un code temporaire encore valable
        $rs = $this->conn->executeQuery("
                                        select
                                            CASE 
                                                WHEN temporary_code_expired_at::timestamp(0) is null THEN 'update' 
                                                WHEN now()::timestamp(0) > temporary_code_expired_at::timestamp(0) THEN 'update'
                                                ELSE 'not_update'
                                            END as todo
                                        from actor
                                        where id = " . $user->getId()
        )->fetchAll();

        // Générer un code temporaire valable
        if ($rs[0]['todo'] == 'update') {
            $dt = new \DateTime();
            $dt->setTimestamp(time() + ($this->getParameter("temporary_code_keeplive") * 60));
            $user->setTemporarycode(mt_rand(1000, 9999))->setTemporaryCodeExpiredAt($dt)->setLoginAttemptNumber($this->getParameter("login_attempt_number"));
            $this->em->persist($user);
            $this->em->flush($user);
        }

        $code = $user->getTemporaryCode();

        // Envoi du code via canal SMS ou email ou les deux canaux
        $channel = trim(strtolower($user->getOptEmailOrSms()));
        $channel = ($channel == '' || $channel == null) ? 'all' : $channel;




        if(count($roles) == 1 && $roles[0] == 'ROLE_ACTEUR'){
            $directaccess = true;
            $action =  $this->generateUrl('fos_user_security_check');
        }

        if(count($roles) == 1 && $roles[0] == 'ROLE_USER'){
            $directaccess = true;
            $action =  $this->generateUrl('fos_user_security_check');
        }
        if(count($roles) == 2 && in_array("ROLE_ACTEUR", $roles) && in_array("ROLE_USER", $roles)){
            $directaccess = true;
            $action =  $this->generateUrl('fos_user_security_check');
        }

        if(!$directaccess){

            $typeChannelSelected    = '';
            $channelSelected        = '';

            if ($channel == "email" || $channel == "all") {
                $this->forward("App\Controller\OtpController::sendTemporaryCodeByEmail", ['user' => $user->getId(), 'code' => $code])->getContent();
                $typeChannelSelected    = "Email";
                $channelSelected        = $this->obfuscateEmail(($user->getSecondaryEmail() != '' && $user->getSecondaryEmail() != null ) ? $user->getSecondaryEmail() : $user->getEmail());
            }

            if ($channel == "sms" || $channel == "all") {
                $this->forward("App\Controller\OtpController::sendTemporaryCodeByBySMS", ['user' => $user->getId(), 'code' => $code])->getContent();
                $typeChannelSelected    = "SMS";
                $channelSelected        = $this->obfuscatePhoneNumber($user->getMobile());
            }
        }

        return new JsonResponse([
            'code'          => 200,
            'username'      => $this->getUser()->getUsername(),
            'directaccess'  => $directaccess,
            'action'        => $action,

            'typechannel'   => $typeChannelSelected,
            'channel'       => $channelSelected,
            'messageOPT'    => "<strong>Veuillez entrer le code reçu <br> $channelSelected : </strong>"
        ]);

    }

    private function obfuscateEmail($email)
    {
        $em     = explode("@",$email);
        $name   = implode('@', array_slice($em, 0, count($em)-1));
        $len    = strlen($name);
        //$len  = floor(strlen($name)/2);

        return substr($name,0, 3) . str_repeat('*', $len-2) . "@" . end($em);
    }

    private function obfuscatePhoneNumber($mobnum)
    {
        for($i=2;$i<strlen($mobnum)-2;$i++)
        {
            $mobnum = substr_replace($mobnum,"*",$i,1);
        }
        return $mobnum;
    }

    /**
     * @Route("/api/check_temporary_code", name="api_check_temporary_code")
     */
    public function apiCheckTemporaryCode(Request $request): Response
    {
        $user = $this->getUser();

        $tempoarycode = $request->get("tempoarycode");
        $error = 'Code Erroné';

        // si c'est le bon code temporaire alors on vérifie si l'utilisateur déja active, n'a pas encore atteint les 3 tentatives d'accès et son token est encore valide
        if ($user->getTemporaryCode() == $tempoarycode) {
            $rs = $this->conn->executeQuery("
                                    select
                                        CASE 
                                            WHEN temporary_code_expired_at::timestamp(0) is null                  THEN 'Code Expiré' 
                                            WHEN now()::timestamp(0) > temporary_code_expired_at::timestamp(0)    THEN 'Code Expiré'
                                            WHEN login_attempt_number::integer = 0                                THEN 'Compte Inactif'
                                            WHEN login_attempt_number is null                                     THEN 'Compte Inactif'
                                            WHEN enabled != true                                                  THEN 'Compte Inactif'
                                            ELSE 'success'
                                        END as todo
                                    from actor
                                    where id = " . $user->getId()
            )->fetchAll();
            if ($rs[0]['todo'] == 'success') {
                $user->setReadmode(false);
                $this->em->persist($user);
                $this->em->flush();

                // donner l'autorisation à l'utilisateur
                return new JsonResponse(['code' => 200, 'check' => true, 'action' => $this->generateUrl('fos_user_security_check')]);
            }
            $error = $rs[0]['todo'];
        }

        if ($user->getLoginAttemptNumber() == 0) $user->setEnabled(false);
        if ($user->getLoginAttemptNumber() > 0) $user->setLoginAttemptNumber($user->getLoginAttemptNumber() - 1);

        $this->em->persist($user);
        $this->em->flush($user);

        return new JsonResponse(['code' => 403, 'check' => false, 'error' => $error]);
    }


    /**
     * @Route("/api/readmode", name="api_readmode")
     */
    public function apiReadMode(Request $request): Response
    {
        $user = $this->getUser();

        $user->setReadmode(true);
        $this->em->persist($user);
        $this->em->flush();
        return new JsonResponse(['code' => 200, 'check' => true, 'action' => $this->generateUrl('fos_user_security_check')]);

    }

    private function getRole($user):string{
        if($user->hasRole('ADMIN_JURIDIQUE'))   return 'ADMIN_JURIDIQUE';
        if($user->hasRole('ADMIN_REGIONALE'))   return 'ADMIN_REGIONALE';
        if($user->hasRole('ADMIN_LOCAL'))       return 'ADMIN_LOCAL';
        return 'ROLE_ACTEUR';
    }

    /**
     * @Route("/api/get/listpro", name="api_listpro")
     */
    public function getListPro(Request $request): Response
    {
        $user = $this->getUser();
        $tab = [];
        $q = $this->em->getRepository(User::class)->createQueryBuilder("u")
            ->select("u")->distinct()
            ->innerJoin("u.actorJobs", "lieu_exercice")->leftJoin("lieu_exercice.job", "j")
            ->leftJoin("lieu_exercice.establishment", "etablissement_exercice")
            ->leftJoin("etablissement_exercice.governorate", "gouvernorat_exercice")
            ->leftJoin("etablissement_exercice.governorate", "g")
            ->leftJoin("u.occupation", "o");

        $role = $this->getRole($user);

        if($role == 'ROLE_ACTEUR'){
            $q->andWhere("u.id = :iduser")->setParameter("iduser", $user->getId());
        }

        if($role == 'ADMIN_REGIONALE'){
            $q->andWhere("g.id = :idgouvernorat")->setParameter("idgouvernorat", $user->getGovernorate()->getId());
        }

        if($role == 'ADMIN_LOCAL'){
            $tabAdminLocal = [];
            foreach($user->getEstablishment() as $item){
                $tabAdminLocal[] = $item->getId();
                foreach($item->getEstablishments() as $detail){
                    $tabAdminLocal[] = $detail->getId();
                }
            }
            $q->andWhere("etablissement_exercice.id in (:ids)")->setParameter("ids", $tabAdminLocal);
        }

        $list = $q->getQuery()->getResult();
        foreach ($list as $item){
            $etablissements = [];
            foreach($item->getActorJobs() as $etablissement){
                $etablissements[] = [
                    'name'          => $etablissement->getEstablishment()->getDesignation(),
                    'adresse'       => $etablissement->getEstablishment()->getAddress(),
                    'gouvernorat'   => $etablissement->getEstablishment()->getGovernorate()->getDesignation()
                ];
            };

            $tab[] = [
                "name"              => $item->getFirstName().' '.$item->getLastName(),
                "username"          => $item->getEmail(),
                "email"             => $item->getPersonalAddress(),
                "mobile"            => $item->getMobile(),
                "etablissements"    => $etablissements
            ];
        }

        return new JsonResponse(['code' => 200, 'data' => $tab]);

    }



}
