<?php

namespace App\Controller;

use Symfony\Component\Security\Core\Encoder\EncoderFactoryInterface;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Controller managing the password change.
 *
 * @author Thibault Duplessis <thibault.duplessis@gmail.com>
 * @author Christophe Coevoet <stof@notk.org>
 */
class ChangePasswordController extends Controller
{
    private $encoderFactory;

    public function __construct(EncoderFactoryInterface $encoderFactory)
    {
        $this->encoderFactory = $encoderFactory;
    }

    /**
     * Description :: check user old password
     * @Route("/check_before_change_password_ajax", name="check_before_change_password_ajax")
     */
    public function checkBeforeChangePasswordAjax(Request $request)
    {
        $oldPassword = $request->request->get('oldPassword');
        $newPassword = $request->request->get('newPassword');
        $user = $this->getUser();

        if (!($this->encoderFactory->getEncoder($user)->isPasswordValid($user->getPassword(), $oldPassword, $user->getSalt()))) {
            return new JsonResponse(array(
                'status' => 500,
                'message' => "Veuillez vérifier votre mot de passe actuel!"
            ));
        } else {
            $user->setPlainPassword($newPassword);
            $user->setTemporaryPassword(null);
            $this->get('fos_user.user_manager')->updateUser($user);
            $this->addFlash('success','Mot de passe changé avec succès');
        }

        return new JsonResponse(array(
            'status' => 200,
            'message' => "Mot de passe changé avec succès."
        ));
    }
}
