<?php

namespace App\Controller;

use App\DBAL\Demand\DemandDbal;
use App\Entity\Main\Data;
use App\Entity\Main\DataFile;
use App\Entity\Main\Demand;
use App\Entity\Main\Site;
use App\Entity\Main\User;
use App\Service\AppParams;
use App\Service\EmailsTemplateSender;
use App\Service\Functions;
use App\Service\GlobalServices;
use Doctrine\DBAL\Driver\Connection;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\QueryBuilder;
use Omines\DataTablesBundle\Adapter\ArrayAdapter;
use Omines\DataTablesBundle\Adapter\Doctrine\ORMAdapter;
use Omines\DataTablesBundle\Column\DateTimeColumn;
use Omines\DataTablesBundle\Column\TextColumn;
use Omines\DataTablesBundle\DataTableFactory;
use PhpOffice\PhpSpreadsheet\Reader\Xls;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Reader\Csv;


/**
 * @Route("/data")
 */
class DataController extends AbstractController
{
    protected $em;
    protected $globalServices;
    private $functions;
    private $emailsTemplateSender;
    private $conn;
    private $appParams;

    public function __construct(EntityManagerInterface $entityManager,
                                GlobalServices         $globalServices,
                                Functions              $functions,
                                EmailsTemplateSender   $emailsTemplateSender,
                                Connection             $conn,
                                AppParams              $appParams)
    {
        $this->em = $entityManager;
        $this->globalServices = $globalServices;
        $this->functions = $functions;
        $this->emailsTemplateSender = $emailsTemplateSender;
        $this->conn = $conn;
        $this->appParams = $appParams;
    }

    /**
     * Description :: list of data
     * @Route("/list", name="data_list")
     */
    public function list(Request $request, DataTableFactory $dataTableFactory)
    {
        // check if the user changed his password and validated the cgu before redirection to list data
        if ($this->getUser()->getVisitor() && !$this->getUser()->getVisitor()->getValidateCgu()) {
            if ($this->getUser()->getTemporaryPassword()) {
                return $this->redirectToRoute('edit_password');
            } else {
                $this->addFlash('danger', "You must accept the terms and conditions and the privacy policy!");
                return $this->redirectToRoute('home');
            }

        }

        return $this->render('data/list.html.twig', [
            'seasons' => $this->em->getRepository(Data::class)->seasonListData(),
            'sites' => $this->em->getRepository(Site::class)->findList()
        ]);
    }

    /**
     * Description :: the filter of data in the list
     * @Route("/filter_data_ajax", name="filter_data_ajax")
     */
    public function filterDataAjax(Request $request)
    {
        $filters = $request->get('filter');

        $countByZoneSQL = 'select id, sum(nbr_patient) as total , zone
                from (
                    SELECT count(d.id) as nbr_patient, d.season, s.id, s.zone 
                    FROM data d LEFT JOIN site s on d.site_id = s.id WHERE 1';
        if (array_key_exists("season", $filters) && $filters['season'] != "") {
            $seasons = explode(',', $filters['season']);
            if (in_array('all', $seasons) === false) {
                $countByZoneSQL .= ' and d.season IN ("' . implode("\",\"", $seasons) . '")';
            }
        }

        if (array_key_exists("zone", $filters) && $filters['zone'] != "") {

            $zone = explode(',', $filters['zone']);
            $countByZoneSQL .= ' and s.id IN ("' . implode("\",\"", $zone) . '")';

        }
        if (array_key_exists("age", $filters) && $filters['age'] != "") {
            $age = explode(',', $filters['age']);
            $countByZoneSQL .= ' and ( if(d.both_age_unit = 3, (d.both_age/365)  between ' . (int)$age[0] . ' and ' . (int)$age[1] . ', 
             if(d.both_age_unit = 2 , (d.both_age/12)  between ' . (int)$age[0] . ' and ' . (int)$age[1] . ',
              d.both_age  between ' . (int)$age[0] . ' and ' . (int)$age[1] . ')))';
        }

        $countByZoneSQL .= ' GROUP BY d.season, s.zone
                        ) as tmp1  
                        GROUP BY id ORDER BY zone ';

        //echo $countByZoneSQL; exit;

        $countByZone = $this->conn->fetchAll($countByZoneSQL);


        $countBySeasonSQL = 'SELECT count(d.id) as nbr_patient, d.season, s.id, s.zone 
                    FROM data d LEFT JOIN site s on d.site_id = s.id WHERE 1';
        if (array_key_exists("season", $filters) && $filters['season'] != "") {
            $seasons = explode(',', $filters['season']);
            if (in_array('all', $seasons) === false) {
                $countBySeasonSQL .= ' and d.season IN ("' . implode("\",\"", $seasons) . '")';
            }
        }

        if (array_key_exists("zone", $filters) && $filters['zone'] != "") {

            $zone = explode(',', $filters['zone']);
            $countBySeasonSQL .= ' and s.id IN ("' . implode("\",\"", $zone) . '")';
        }
        if (array_key_exists("age", $filters) && $filters['age'] != "") {
            $age = explode(',', $filters['age']);
            $countBySeasonSQL .= ' and ( 
             if(d.both_age_unit = 3, (d.both_age/365)  between ' . (int)$age[0] . ' and ' . (int)$age[1] . ', 
             if(d.both_age_unit = 2 , (d.both_age/12)  between ' . (int)$age[0] . ' and ' . (int)$age[1] . ',
              d.both_age  between ' . (int)$age[0] . ' and ' . (int)$age[1] . ')))';
        }
        $sqlseason = $countBySeasonSQL;
        $sqlseason .= " GROUP BY d.season ORDER BY d.season";
        $countBySeasonSQL .= ' GROUP BY d.season, s.zone ORDER BY s.zone, d.season';

        $countBySeason = $this->conn->fetchAll($countBySeasonSQL);

        $finalArray = array();

        foreach ($countByZone as $zone) {
            $siteArray = array();
            foreach ($countBySeason as $key => $value) {
                if ($zone["id"] == $value["id"]) {
                    array_push($siteArray, $value);
                }
            }
            array_push($zone, $siteArray);
            array_push($finalArray, $zone);
            unset($siteArray);
        }

        if ($filters !== null) {
            // save details of each filter in the table historic
            if (array_key_exists("season", $filters) && $filters['season'] != "") {
                $this->globalServices->saveHistoric($this->getUser(), "Filter by season " . $filters['season'], 3);
            }

            if (array_key_exists("zone", $filters) && $filters['zone'] != "") {
                $zoneList = $this->em->getRepository(Site::class)->zoneList(explode(',', $filters['zone']));

                $zoneArray = array();
                foreach ($zoneList as $zone) {
                    array_push($zoneArray, $zone["zone"]);
                }
                $this->globalServices->saveHistoric($this->getUser(), "Filter by geographical zones " . implode(" / ", $zoneArray), 3);
            }

            if (array_key_exists("age", $filters) && $filters['age'] != "") {
                $this->globalServices->saveHistoric($this->getUser(), "Filter by patients between " . $filters['age'][0] . " and " . $filters['age'][1] . " years old ", 3);
            }
        }

        return new JsonResponse([
            'status' => 200,
            'recap' => $finalArray,
            'season' => $this->conn->fetchAll($sqlseason),
            'age' => $filters["age"],
            'filter' => $request->get('filter')
        ]);
    }

    /**
     * Description ::
     * @Route("/export_request", name="export_request")
     */
    public function exportRequest(Request $request)
    {
        //save the action of exportation in the historic table
        $this->globalServices->saveHistoric($this->getUser(), "Exporting data", 1);

        // get details of filter
        $filters = $request->get('filters');

        $zones = $this->em->getRepository(Site::class)->findBy(array('id' => explode(',', $filters["zone"])));
        $zoneArray = array();
        foreach ($zones as $zone) {
            array_push($zoneArray, $zone->getZone());
        }

        $checkedArray = array();
        $seasonArray = array();
        $listSeasonsAsString = "";
        foreach (json_decode($filters["checked"], true) as $checked) {
            $zone = $this->em->getRepository(Site::class)->find(array('id' => $checked[1]));
            array_push($checkedArray, $checked[0] . ' / ' . str_replace($checked[1], $zone->getZone(), $checked[1]));
            array_push($seasonArray, $checked[0]);
        }
        if (!empty($seasonArray)) {
            $result = implode(",", $seasonArray);
            $uniqueSeasons = array_unique(explode(',', $result));
            $listSeasonsAsString = implode(",", $uniqueSeasons);
        }
        // create a new demand of export
        $demand = new Demand();
//        $filters["season"] ? $demand->setSeason($filters["season"]) : null;
        if ($listSeasonsAsString != "") {
            $demand->setSeason($listSeasonsAsString);
        }
        $filters["zone"] ? $demand->setZone($filters["zone"]) : null;
        $filters["age"] ? $demand->setAge($filters["age"]) : null;
        $demand->setState(DemandDbal::WAITING);
        $demand->setUser($this->getUser());
        $demand->setChecked($filters["checked"]);
        $this->em->persist($demand);
        $this->em->flush();
        // end creation of demand

        $email = $this->getUser()->getEmail();
        $path = $this->getParameter("PATH_EXPORT");

        // after the file is generated, an email will be automatically sent to the user who created the request contains the result

        //Dev
//        exec('/usr/bin/nohup php7.3 ' . $path . '/bin/console app:export ' . $demand->getId() . ' ' . $email . '  ' . str_replace(" ", "_", $this->getUser()->getManager()->getFullName()) . ' >/dev/null 2>&1 &');
        //Prod
        exec('/usr/bin/nohup php ' . $path . '/bin/console app:export ' . $demand->getId() . ' ' . $email . '  ' . str_replace(" ", "_", $this->getUser()->getManager()->getFullName()) . ' >/dev/null 2>&1 &');


        return new JsonResponse(array(
            'status' => 200,
            'message' => 'An email will be sent when the export is ready'
        ));
    }

    /**
     * @Route("/export_request_data", name="export_request_data")
     */
    public function ExportRequestData()
    {
        // check if the user changed his password and validated the cgu before redirection
        if ($this->getUser()->getVisitor() && !$this->getUser()->getVisitor()->getValidateCgu()) {
            if ($this->getUser()->getTemporaryPassword()) {
                return $this->redirectToRoute('edit_password');
            } else {
                $this->addFlash('danger', "You must accept the terms and conditions and the privacy policy!");
                return $this->redirectToRoute('home');
            }
        }
        return $this->render('data/request_data.html.twig');
    }

    /**
     * Description :: list of file data imported
     * @Route("/file_list", name="data_file_list")
     */
    public function fileList(Request $request, DataTableFactory $dataTableFactory)
    {
        // check if the user is a manger or not
        if (!$this->getUser()->getManager()) {
            $this->addFlash('danger', "This page is accessible only by platform administrators!");
            return $this->redirectToRoute('error_page');
        }

        $datatable = $dataTableFactory->create([])
            ->createAdapter(ORMAdapter::class, [
                'entity' => DataFile::class,
                'query' => function (QueryBuilder $builder) {
                    $builder
                        ->select('file')
                        ->from(DataFile::class, 'file')
                        ->orderBy("file.createdAt", "DESC");
                }
            ])
            ->add('fileName', TextColumn::class, [
                'label' => 'File name',
                'field' => 'file.fileNameOrigine',
                'orderable' => false,
            ])
            ->add('createdAt', DateTimeColumn::class, [
                'label' => 'Date',
                'format' => 'd-m-Y H:i',
                'orderable' => false,
                'field' => 'file.createdAt'
            ])
            ->add('buttons', TextColumn::class, [
                'label' => 'Action',
                'raw' => true,
                'className' => 'dt-action-btns',
                'render' => function ($value, $entity) {
                    $buttons = "";
                    $buttons .= '<a href="javascript:;" class="ml-2 text-primary btn-delete-action m-r-5" title="Remove" data-id="' . $entity->getId() . '"><i class="fas fa-trash-alt"></i></a>';
                    $buttons .= '<a href= "' . $this->getParameter('relative_upload_data_directory') . "/" . $entity->getFileName() . '" 
                    download="' . (($entity->getFileNameOrigine()) ? $entity->getFileNameOrigine() : $entity->getFileName()) . '" class="ml-2 text-primary" title="Download" target="_blank"><i class="fas fa-file-download"></i></a>';

                    return sprintf($buttons);
                }
            ])
            ->handleRequest($request);

        if ($datatable->isCallback()) {
            return $datatable->getResponse();
        }

        return $this->render('data/file_list.html.twig', [
            'datatable' => $datatable,
            'sites' => $this->em->getRepository(Site::class)->findBy(array(), array('zone' => 'ASC'))
        ]);
    }

    /**
     * Description :: add data from file to DB
     * @Route("/data_add_file", name="data_add_file")
     */
    public function dataAddFile(Request $request)
    {
        ini_set('memory_limit', '2048M');
        // check the user is a manger or not , because only manger can add file
        if (!$this->getUser()->getManager()) {
            $this->addFlash('danger', "This page is accessible only by platform administrators!");
            return $this->redirectToRoute('error_page');
        }

        set_time_limit(7200);
        ini_set('memory_limit', '-1');
        $data = $request->request->get('data');
        $file = $request->files->get("data")['file'];

        // get the extension of the file added
        $ext = strtolower(pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION));

        // initialisation des variables
        $wrongFieldsInFile = [];
        $filename = "";
        $status = 200;
        $message = "File added successfully.";

//        if ($ext == "xlsx") {
//            $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
//        } elseif ($ext == "xls") {
//            $reader = new Xls();
//        } else {
//            $reader = new Csv();
//        }

        if ($ext == "csv") {
            $reader = new Csv();
            $reader->setReadDataOnly(true);
            $spreadsheet = $reader->load($file->getRealPath());
            $sheetData = $spreadsheet->getActiveSheet();
            $nbrRows = $sheetData->getHighestRow();

            if ($nbrRows > 1) {
                $listWorksheetInfo = $reader->listWorksheetInfo($file->getRealPath());
                $nbrColumn = $listWorksheetInfo[0]["lastColumnIndex"];
                $columnName = 'A';
                $arrayColumnName = array();
                while ($nbrColumn-- >= 0) {
                    array_push($arrayColumnName, $columnName);
                    $columnName++;
                }

                $highestColumn = $sheetData->getHighestColumn();
                $headings = $sheetData->rangeToArray('A1:' . $highestColumn . '1', NULL, TRUE, FALSE);
                $allHeadings = array(
                    'site_id',
                    'id_site',
                    'season',
                    'id_bdd_philippe',
                    'OHC_TECH_ID',
                    'OHC_TECH_IdIntegration',
                    'OHC_TECH_SEA_ID',
                    'date_last_modified',
                    'id_last_modificator',
                    'name_last_modificator',
                    'is_validated',
                    'form_type',
                    'both_comp_a_diag',
                    'both_a_diag',
                    'both_a_diag_icd',
                    'both_doa',
                    'both_id_hospital',
                    'both_id_patient',
                    'doq',
                    'both_sex',
                    'dob',
                    'communication',
                    'consents',
                    'residence',
                    'institutionalized',
                    'exclussion_hosp',
                    'soc_class',
                    'smoking_hab',
                    'both_chronic_cond_yn',
                    'both_display_clinical3',
                    'both_chronic_cvd_blood',
                    'both_chronic_copd',
                    'both_chronic_asthma',
                    'both_chronic_diabetes',
                    'both_chronic_immuno',
                    'both_chronic_renal',
                    'both_chronic_rheumatologic_autoimmune_dis',
                    'both_chronic_neurological_neuromuscular_dis',
                    'both_chronic_cirrhosis_liver_dis',
                    'both_chronic_neoplasm',
                    'both_chronic_obesity',
                    'both_chronic_malnutri',
                    'both_chronic_active_tuberculosis',
                    'both_chronic_hiv_infection',
                    'both_chronic_hiv_exposure',
                    'both_chronic_other',
                    'hosp_12m',
                    'av_current_days',
                    'both_av_current',
                    'both_av_starting_date',
                    'previous_lab',
                    'both_influ_vac_current_season',
                    'both_vac_14d_before_ili_sym',
                    'dov',
                    'vac_name',
                    'vac_type',
                    'both_vac_preceding_season',
                    'both_swab_date',
                    'both_swab_date_unknow',
                    'swab_sent',
                    'swab_np',
                    'swab_n',
                    'swab_p',
                    'dol',
                    'hypoxia_adm',
                    'lethargy_adm',
                    'both_severity_oxygen_saturation',
                    'both_severity_oxygen_saturation_unknow',
                    'both_severity_respiration_rate',
                    'both_severity_respiration_rate_unknow',
                    'blood_urea_nitrogen',
                    'both_severity_supp_oxygen',
                    'both_severity_vaso_support',
                    'both_icu_adm',
                    'both_death_hosp',
                    'both_severity_mech_vent',
                    'both_discharged_date',
                    'both_d_diag1',
                    'both_d_diag2',
                    'both_d_diag3',
                    'both_d_icd',
                    'both_positive_result',
                    'both_display_labo2',
                    'both_lab_flu_h1n1',
                    'both_lab_flu_h3n2',
                    'both_lab_flu_yamagata',
                    'both_lab_flu_victoria',
                    'both_lab_flu_h1nother',
                    'both_lab_flu_h3nother',
                    'both_lab_flu_a_nosub',
                    'both_lab_flu_b_nosub',
                    'both_lab2_corona_yesno',
                    'both_lab2_metaneumo_yesno',
                    'both_lab2_rs_yesno',
                    'both_lab2_adeno_yesno',
                    'both_lab2_boca_yesno',
                    'both_lab2_pi_yesno',
                    'both_lab2_rhino_yesno',
                    'lab_mix',
                    'both_detected_coinfection',
                    'lab_negative',
                    'sym_7d_yn',
                    'both_display_ilisystemic',
                    'both_ilisystemic_fever',
                    'both_ilisystemic_malaise',
                    'both_ilisystemic_headache',
                    'both_ilisystemic_myalgia',
                    'both_ilirespiratory_cough',
                    'both_ilirespiratory_sorethroat',
                    'both_ilirespiratory_shortnessbreath',
                    'both_display_ilirespiratory',
                    'both_ilirespiratory_nasalcongestion',
                    'doo',
                    'both_epi_isl',
                    'both_display_clinical2',
                    'both_display_clinical4',
                    'both_display_clinical5',
                    'both_display_clinical6',
                    'both_display_clinical7',
                    'both_pregnancy_status',
                    'both_pregnancy_weeks',
                    'both_pregnancy_weeks_unknow',
                    'both_display_hasonesymptoms',
                    'comp_ili',
                    'comp_ili_7d',
                    'more_comply',
                    'both_test_other_virus',
                    'both_display_test_other2',
                    'display_titre_labo',
                    'both_height',
                    'both_weight',
                    'both_height_unknow',
                    'both_weight_unknow',
                    'birthweight',
                    'gestbirth_wk_yn',
                    'gestbirth_wk',
                    'exclu_breast_fed',
                    'breastfed_yn',
                    'breastfed_month_time',
                    'temperature_adm',
                    'both_chronic_prematurity',
                    'less_chronic_down_syndrom',
                    'less_chronic_congenital_heart_dis',
                    'more_chronic_leukemia',
                    'both_chronic_hemoglobinopathies',
                    'both_antibio_preceding',
                    'both_antibio_preceding_date',
                    'both_frailty_score_unknow',
                    'less_influ_vac_current_season_2_doses',
                    'barthel_index',
                    'both_severity_confusion',
                    'both_severity_apnea',
                    'both_discharge_another_hopital',
                    'both_frailty_score_discharge',
                    'both_frailty_score_discharge_unknow',
                    'both_sample_submited',
                    'both_display_gisaid',
                    'less_display_intro',
                    'more_display_intro',
                    'SysStartTime',
                    'SysEndTime',
                    'OHC_CleSignature',
                    'OHC_Signature',
                    'both_display_clinical6b',
                    'both_lab2_corona',
                    'both_lab2_metaneumo',
                    'both_lab2_rs',
                    'both_lab2_adeno',
                    'both_lab2_boca',
                    'both_lab2_pi',
                    'both_lab2_rhino',
                    'both_display_hasothersymptoms',
                    'both_othersymptoms_nausea',
                    'both_othersymptoms_diarrhea',
                    'both_othersymptoms_smell',
                    'both_othersymptoms_chestpain',
                    'both_ilirespiratory_wheezing',
                    'both_antibio_during',
                    'both_antibio_during_date',
                    'both_antiviral_preceding',
                    'both_antiviral_preceding_date',
                    'both_antiviral_during',
                    'both_antiviral_during_date',
                    'both_vac_history_validated',
                    'more_display_comment',
                    'less_display_comment',
                    'both_lab2_sarscov2',
                    'both_lab2_sarscov2_yesno',
                    'both_lab2_evd68',
                    'both_lab2_evd68_yesno',
                    'both_lab2_others',
                    'both_lab2_others_yesno',
                    'more_covid_firstdose',
                    'more_covid_full',
                    'more_covid_vaccine',
                    'flu_vac_2010_11',
                    'flu_vac_2011_12',
                    'flu_vac_2012_13',
                    'flu_vac_2013_14',
                    'flu_vac_2014_15',
                    'flu_vac_2015_16',
                    'flu_vac_2016_17',
                    'flu_vac_2017_18',
                    'flu_vac_2018_19',
                    'flu_vac_2019_20',
                    'flu_vac_2020_21',
                    'flu_vac_2021_22',
                    'flu_vac_2022_23',
                    'flu_vac_2023_24',
                    'flu_vac_2024_25',
                    'flu_vac_2026_27',
                    'ecmo',
                    'reason_no_com',
                    'consul_3m',
                    'both_display_how_patient_was_identified',
                    'both_display_clinical5bis',
                    'both_display_covid_vaccine',
                    'both_display_intro',
                    'contra_flu',
                    'sudden',
                    'polypnea',
                    'both_severity_blood_pressure',
                    'both_severity_blood_pressure_unknow',
                    'both_lab2_enterovirus',
                    'both_lab2_enterovirus_yesno',
                    'both_lab2_merscov',
                    'both_lab2_merscov_yesno',
                    'both_lab2_picornavirus',
                    'both_lab2_picornavirus_yesno',
                    'both_lab2_sarscov',
                    'both_lab2_sarscov_yesno',
                    'both_sample_submited_influenza',
                    'both_epi_isl_influenza',
                    'both_sample_submited_sars_cov2',
                    'both_epi_isl_sars_cov2',
                    'both_sample_submited_rsv',
                    'both_epi_isl_rsv'
                );

                // "12_13","13_14","14_15","15_16","16_17","17_18","18_19","19_20","20_21", a ajouter pour prendre en consideration les anciennes variables des saisons < 21_22
//                $allSeason = array("12_13","13_14","14_15","15_16","16_17","17_18","18_19","19_20","20_21","21_22", "22_23", "23_24", "24_25", "25_26", "26_27", "27_28", "28_29", "29_30");
                $allSeason = array("21_22", "22_23", "23_24", "24_25", "25_26", "26_27", "27_28", "28_29", "29_30");

                if (empty(array_intersect($headings[0], $allHeadings))) {
                    $status = 500;
                    $message = "Wrong file uploaded!";
                } else {
                    $columnsLettre = array_combine($headings[0], $arrayColumnName);

                    $columns = [];
                    foreach ($columnsLettre as $property => $lettre) {
                        $columns[$property] = array_column($sheetData->rangeToArray($lettre . '2:' . $lettre . $nbrRows, null, true, true, false), 0);
                    }

                    // récupération id site depuis une des colonnes du fichier reçu
                    $zoneID = (isset($columns['id_site'])) ? $columns['id_site'][0] : ((isset($columns['site_id'])) ? $columns['site_id'][0] : 0);

                    // récupération de l'id site depuis le formulaire
                    $zoneID = (isset($data["zone"]) && $data["zone"] != '') ? $data["zone"] : $zoneID;

                    // si pas d'id site ni dans le fichier ni depuis le formulaire dans ce cas on arrête l'import
                    if ($zoneID == 0) {
                        return new JsonResponse(array(
                            'status' => 500,
                            'message' => "Site not found"
                        ));
                    }

                    // get the site of data from the zoneId
                    $site = $this->em->getRepository(Site::class)->find($zoneID);

                    // generate a new name for the file
                    $newFilename = uniqid("data_") . strtotime(date("Y-m-d H:i:s")) . '.' . $file->getClientOriginalExtension();

                    // add a new dataFile and save it
                    $newDataFile = new DataFile();
                    $newDataFile->setFileName($newFilename)->setFileNameOrigine($file->getClientOriginalName())->setSite($site);
                    $this->em->persist($newDataFile);
                    $this->em->flush();
                    // end save datafile

                    // get the last datafile
                    $lastDataFile = $this->em->getRepository(DataFile::class)->findOneBy([], ['id' => 'DESC']);

                    $seasonVerif = false;

                    for ($i = 0; $i <= ($nbrRows - 2); $i++) {
                        $field = [];
                        // correspondance pour les saison 22_23 et 21_22
                        // NOTE : all variable _unknown = 1 ==> that's mean these fields can be empty

                        if (array_key_exists("season", $columns) && in_array($columns['season'][$i], $allSeason)) {

                            $seasonVerif = true;
                            $data = new Data();
                            $data->setSite($site);
                            $data->setDataFile($lastDataFile);
                            $data->setCreatedAt(new \DateTime());
                            $data->setUpdatedAt(new \DateTime());

                            array_key_exists("season", $columns) ? $data->setSeason($columns['season'][$i]) : $data->setSeason(null);
                            array_key_exists("id_bdd_philippe", $columns) ? $data->setIdBddPhilippe($columns['id_bdd_philippe'][$i]) : $data->setIdBddPhilippe(null);
                            array_key_exists("id_site_bdd_philippe", $columns) ? $data->setIdSiteBddPhilippe($columns['id_site_bdd_philippe'][$i]) : $data->setIdSiteBddPhilippe(null);
                            array_key_exists("OHC_TECH_ID", $columns) ? $data->setOhcTechId($columns['OHC_TECH_ID'][$i]) : $data->setOhcTechId(null);
                            array_key_exists("OHC_TECH_IdIntegration", $columns) ? $data->setOhcTechIdintegration($columns['OHC_TECH_IdIntegration'][$i]) : $data->setOhcTechIdintegration(null);
                            array_key_exists("OHC_TECH_SEA_ID", $columns) ? $data->setOhcTechSeaId($columns['OHC_TECH_SEA_ID'][$i]) : $data->setOhcTechSeaId(null);
                            array_key_exists("date_last_modified", $columns) ? $data->setDateLastModified($columns['date_last_modified'][$i]) : $data->setDateLastModified(null);
                            array_key_exists("id_last_modificator", $columns) ? $data->setIdLastModificator($columns['id_last_modificator'][$i]) : $data->setIdLastModificator(null);
                            array_key_exists("name_last_modificator", $columns) ? $data->setNameLastModificator($columns['name_last_modificator'][$i]) : $data->setNameLastModificator(null);
                            array_key_exists("is_validated", $columns) ? $data->setIsValidated($columns['is_validated'][$i]) : $data->setIsValidated(null);
                            array_key_exists("form_type", $columns) ? $data->setFormType($columns['form_type'][$i]) : $data->setFormType(null);

                            $age = null;
                            if (array_key_exists("both_age", $columns) && $columns['both_age'][$i] != null && array_key_exists("both_age_unit", $columns) && $columns['both_age_unit'][$i] != null) {
                                if ($columns['both_age_unit'][$i] == 1) {
                                    $age = $columns['both_age'][$i];
                                } elseif ($columns['both_age_unit'][$i] == 2) {
                                    $age = $columns['both_age'][$i] / 12;
                                } elseif ($columns['both_age_unit'][$i] == 3) {
                                    $age = $columns['both_age'][$i] / 365;
                                }
                            }

                            if (array_key_exists("both_age", $columns)) {
                                $data->setBothage($columns['both_age'][$i]);
                                if (!is_int($columns['both_age'][$i])) {
                                    array_push($field, ['field' => 'both_age']);
                                }
                            }

                            if (array_key_exists("both_age_unit", $columns)) {
                                $data->setBothageunit($columns['both_age_unit'][$i]);
                                if (!in_array($columns['both_age_unit'][$i], [1, 2, 3])) {
                                    array_push($field, ['field' => 'both_age_unit']);
                                }
                            }

                            if (array_key_exists("both_comp_a_diag", $columns)) {
                                $data->setBothCompADiag($columns['both_comp_a_diag'][$i]);
                                if (!in_array($columns['both_comp_a_diag'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_comp_a_diag']);
                                }
                            }

                            if (array_key_exists("both_a_diag", $columns) && array_key_exists("both_a_diag_unknow", $columns)) {
                                $data->setBothADiag($columns['both_a_diag'][$i]);
                                $data->setBothAdiagUnknow($columns['both_a_diag_unknow'][$i]);
                                if ($columns['both_a_diag'][$i] != null && ($columns['both_a_diag_unknow'][$i] == null || $columns['both_a_diag_unknow'][$i] == 0)) {
                                    $bool = true;
                                    $replace = array('[', ']', '"', ' ', "'");
                                    $result = str_replace($replace, "", $columns['both_a_diag'][$i]);
                                    $result_both_a_diag = explode(',', $result);
                                    if (count($result_both_a_diag) == 1) {
                                        if (!preg_match('/^([0-9]{3})$|^([A-Z]{1}[0-9]{2})$|^([0-9]{3}[.][0-9]{1,2})$|^([A-Z]{1}[0-9]{2}[.][0-9]{1,2})$/', $result_both_a_diag[0])) {
                                            $bool = false;
                                        }
                                    } elseif (count($result_both_a_diag) > 1) {
                                        foreach ($result_both_a_diag as $item) {
                                            if (!preg_match('/^([0-9]{3})$|^([A-Z]{1}[0-9]{2})$|^([0-9]{3}[.][0-9]{1,2})$|^([A-Z]{1}[0-9]{2}[.][0-9]{1,2})$/', $item)) {
                                                $bool = false;
                                            }
                                        }
                                    }
                                    if (!$bool) {
                                        array_push($field, ['field' => 'both_a_diag']);
                                    }
                                } elseif ($columns['both_a_diag'][$i] == null && ($columns['both_a_diag_unknow'][$i] == null || $columns['both_a_diag_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_a_diag_unknow']);
                                } elseif ($columns['both_a_diag'][$i] != null && $columns['both_a_diag_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_a_diag_unknow']);
                                }
                            }

                            if (array_key_exists("both_a_diag_icd", $columns)) {
                                $data->setBothADiagIcd($columns['both_a_diag_icd'][$i]);
                                if ($columns['both_a_diag_icd'][$i] != null && !in_array($columns['both_a_diag_icd'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_a_diag_icd']);
                                }
                            }

                            if (array_key_exists("both_case_identified_based_logs_respiratory", $columns)) {
                                $data->setBothCaseIdentifiedBasedLogsRespiratory($columns['both_case_identified_based_logs_respiratory'][$i]);
                                if (!in_array($columns['both_case_identified_based_logs_respiratory'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_case_identified_based_logs_respiratory']);
                                }
                            }

//                            if (array_key_exists("both_case_identified_based_positive_swab", $columns)) {
//                                $data->setBothCaseIdentifiedBasedPositiveSwab($columns['both_case_identified_based_positive_swab'][$i]);
//                                if (!in_array($columns['both_case_identified_based_positive_swab'][$i], [0, 1])) {
//                                    array_push($field, ['field' => 'both_case_identified_based_positive_swab']);
//                                }
//                            }

                            if (array_key_exists("both_case_identified_based_testing", $columns)) {
                                $data->setBothCaseIdentifiedBasedTesting($columns['both_case_identified_based_testing'][$i]);
                                if (!in_array($columns['both_case_identified_based_testing'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_case_identified_based_testing']);
                                }
                            }

                            if (array_key_exists("both_case_definition_used", $columns)) {
                                $data->setBothCaseDefinitionUsed($columns['both_case_definition_used'][$i]);
                                if (!in_array($columns['both_case_definition_used'][$i], [1, 2, 3, 4, 5, 6, 7])) {
                                    array_push($field, ['field' => 'both_case_definition_used']);
                                }
                            }

                            array_key_exists("both_case_definition_other_detail", $columns) ? $data->setBothCaseDefinitionOtherDetail($columns['both_case_definition_other_detail'][$i]) : $data->setBothCaseDefinitionOtherDetail(null);

                            if (array_key_exists("both_doa", $columns) && ($columns['both_doa'][$i] != null)) {
                                $columns['both_doa'][$i] = str_replace("/", "-", $columns['both_doa'][$i]);
                                if (strtotime($columns['both_doa'][$i])) {
                                    $bothDoa = date('d/m/Y', strtotime($columns['both_doa'][$i]));
                                    $data->setBothDoa($bothDoa);
                                    //set week_number
                                    $bothDoaDate = \DateTime::createFromFormat('d/m/Y', $bothDoa);
                                    if ($bothDoaDate) {
                                        // Get week number (W) and year (o)
                                        $weekYear = $bothDoaDate->format("W--o");
                                        $data->setweekNumber($weekYear);
                                    }
                                } else {
                                    $data->setBothDoa($columns['both_doa'][$i]);
                                    array_push($field, ['field' => 'both_doa']);
                                }
                            } else {
                                $data->setBothDoa(null);
                                array_push($field, ['field' => 'both_doa']);
                            }

                            if (array_key_exists("both_id_hospital", $columns) && ($columns['both_id_hospital'][$i] != null)) {
                                $data->setBothIdHospital($columns['both_id_hospital'][$i]);
                            } else {
                                $data->setBothIdHospital(null);
                                array_push($field, ['field' => 'both_id_hospital']);
                            }

                            if (array_key_exists("both_id_patient", $columns) && ($columns['both_id_patient'][$i] != null)) {
                                $data->setBothIdPatient($columns['both_id_patient'][$i]);
                            } else {
                                $data->setBothIdPatient(null);
                                array_push($field, ['field' => 'both_id_patient']);
                            }

                            if (array_key_exists("both_sex", $columns)) {
                                $data->setBothSex($columns['both_sex'][$i]);
                                if (!in_array($columns['both_sex'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_sex']);
                                }
                            }

                            if (array_key_exists("both_chronic_cond_yn", $columns)) {
                                $data->setBothChronicCondYn($columns['both_chronic_cond_yn'][$i]);
                                if (!in_array($columns['both_chronic_cond_yn'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_cond_yn']);
                                }
                            }

                            if (array_key_exists("both_chronic_cvd_blood", $columns)) {
                                $data->setBothChronicCvdBlood($columns['both_chronic_cvd_blood'][$i]);
                                if ($columns['both_chronic_cvd_blood'][$i] != null && !in_array($columns['both_chronic_cvd_blood'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_cvd_blood']);
                                }
                            }

                            if (array_key_exists("both_chronic_copd", $columns)) {
                                $data->setBothChronicCopd($columns['both_chronic_copd'][$i]);
                                if (!in_array($columns['both_chronic_copd'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_copd']);
                                }
                            }

                            if (array_key_exists("both_chronic_asthma", $columns)) {
                                $data->setBothChronicAsthma($columns['both_chronic_asthma'][$i]);
                                if ($columns['both_chronic_asthma'][$i] != null && !in_array($columns['both_chronic_asthma'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_asthma']);
                                }
                            }

                            if (array_key_exists("both_chronic_diabetes", $columns)) {
                                $data->setBothChronicDiabetes($columns['both_chronic_diabetes'][$i]);
                                if ($columns['both_chronic_diabetes'][$i] != null && !in_array($columns['both_chronic_diabetes'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_diabetes']);
                                }
                            }

                            if (array_key_exists("both_chronic_immuno", $columns)) {
                                $data->setBothChronicImmuno($columns['both_chronic_immuno'][$i]);
                                if ($columns['both_chronic_immuno'][$i] != null && !in_array($columns['both_chronic_immuno'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_immuno']);
                                }
                            }

                            if (array_key_exists("both_chronic_renal", $columns)) {
                                $data->setBothChronicRenal($columns['both_chronic_renal'][$i]);
                                if ($columns['both_chronic_renal'][$i] != null && !in_array($columns['both_chronic_renal'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_renal']);
                                }
                            }

                            if (array_key_exists("both_chronic_rheumatologic_autoimmune_dis", $columns)) {
                                $data->setBothChronicRheumatologicAutoimmuneDis($columns['both_chronic_rheumatologic_autoimmune_dis'][$i]);
                                if ($columns['both_chronic_rheumatologic_autoimmune_dis'][$i] != null && !in_array($columns['both_chronic_rheumatologic_autoimmune_dis'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_rheumatologic_autoimmune_dis']);
                                }
                            }

                            if (array_key_exists("both_chronic_neurological_neuromuscular_dis", $columns)) {
                                $data->setBothChronicNeurologicalNeuromuscularDis($columns['both_chronic_neurological_neuromuscular_dis'][$i]);
                                if ($columns['both_chronic_neurological_neuromuscular_dis'][$i] != null && !in_array($columns['both_chronic_neurological_neuromuscular_dis'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_neurological_neuromuscular_dis']);
                                }
                            }

                            if (array_key_exists("both_chronic_cirrhosis_liver_dis", $columns)) {
                                $data->setBothChronicCirrhosisLiverDis($columns['both_chronic_cirrhosis_liver_dis'][$i]);
                                if ($columns['both_chronic_cirrhosis_liver_dis'][$i] != null && !in_array($columns['both_chronic_cirrhosis_liver_dis'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_cirrhosis_liver_dis']);
                                }
                            }

                            if (array_key_exists("both_chronic_neoplasm", $columns)) {
                                $data->setBothChronicNeoplasm($columns['both_chronic_neoplasm'][$i]);
                                if ($columns['both_chronic_neoplasm'][$i] != null && !in_array($columns['both_chronic_neoplasm'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_neoplasm']);
                                }
                            }

                            if (array_key_exists("both_chronic_obesity", $columns)) {
                                $data->setBothChronicObesity($columns['both_chronic_obesity'][$i]);
                                if ($columns['both_chronic_obesity'][$i] != null && !in_array($columns['both_chronic_obesity'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_obesity']);
                                }
                            }

                            if (array_key_exists("both_chronic_malnutri", $columns)) {
                                $data->setBothChronicMalnutri($columns['both_chronic_malnutri'][$i]);
                                if ($columns['both_chronic_malnutri'][$i] != null && !in_array($columns['both_chronic_malnutri'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_malnutri']);
                                }
                            }

                            if (array_key_exists("both_chronic_active_tuberculosis", $columns)) {
                                $data->setBothChronicActiveTuberculosis($columns['both_chronic_active_tuberculosis'][$i]);
                                if ($columns['both_chronic_active_tuberculosis'][$i] != null && !in_array($columns['both_chronic_active_tuberculosis'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_active_tuberculosis']);
                                }
                            }

                            if (array_key_exists("both_chronic_hiv_infection", $columns)) {
                                $data->setBothChronicHivInfection($columns['both_chronic_hiv_infection'][$i]);
                                if ($columns['both_chronic_hiv_infection'][$i] != null && !in_array($columns['both_chronic_hiv_infection'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_hiv_infection']);
                                }
                            }

                            if (array_key_exists("both_chronic_hiv_exposure", $columns)) {
                                $data->setBothChronicHivExposure($columns['both_chronic_hiv_exposure'][$i]);
                                if ($columns['both_chronic_hiv_exposure'][$i] != null && !in_array($columns['both_chronic_hiv_exposure'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_hiv_exposure']);
                                }
                            }

                            if (array_key_exists("both_chronic_other", $columns)) {
                                $data->setBothChronicOther($columns['both_chronic_other'][$i]);
                                if ($columns['both_chronic_other'][$i] != null && !in_array($columns['both_chronic_other'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_other']);
                                }
                            }

                            if (array_key_exists("both_influ_vac_current_season", $columns)) {
                                $data->setBothInfluVacCurrentSeason($columns['both_influ_vac_current_season'][$i]);
                                if (!in_array($columns['both_influ_vac_current_season'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_influ_vac_current_season']);
                                }
                            }

                            if (array_key_exists("both_vac_14d_before_ili_sym", $columns)) {
                                $data->setBothVac14dBeforeIliSym($columns['both_vac_14d_before_ili_sym'][$i]);
                                if ($columns['both_vac_14d_before_ili_sym'][$i] != null && !in_array($columns['both_vac_14d_before_ili_sym'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_vac_14d_before_ili_sym']);
                                }
                            }

                            if (array_key_exists("both_vac_preceding_season", $columns)) {
                                $data->setBothVacPrecedingSeason($columns['both_vac_preceding_season'][$i]);
                                if (!in_array($columns['both_vac_preceding_season'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_vac_preceding_season']);
                                }
                            }

                            if (array_key_exists("both_swab_date", $columns) && array_key_exists("both_swab_date_unknow", $columns)) {
                                $data->setBothSwabDateUnknow($columns['both_swab_date_unknow'][$i]);
                                if ($columns['both_swab_date'][$i] != null) {
                                    $columns['both_swab_date'][$i] = str_replace("/", "-", $columns['both_swab_date'][$i]);
                                    if (strtotime($columns['both_swab_date'][$i])) {
                                        $data->setBothSwabDate(date('d/m/Y', strtotime($columns['both_swab_date'][$i])));
                                    } else {
                                        $data->setBothSwabDate($columns['both_swab_date'][$i]);
                                        array_push($field, ['field' => 'both_swab_date']);
                                    }
                                } else {
                                    $data->setBothSwabDate(null);
                                    array_push($field, ['field' => 'both_swab_date']);
                                }
                                if ($columns['both_swab_date'][$i] == null && ($columns['both_swab_date_unknow'][$i] == null || $columns['both_swab_date_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_swab_date_unknow']);
                                } elseif ($columns['both_swab_date'][$i] != null && $columns['both_swab_date_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_swab_date_unknow']);
                                }
                            } else {
                                $data->setBothSwabDate(null);
                                $data->setBothSwabDateUnknow(null);
                                array_push($field, ['field' => 'both_swab_date']);
                            }

                            if (array_key_exists("both_severity_oxygen_saturation", $columns) && array_key_exists("both_severity_oxygen_saturation_unknow", $columns)) {
                                $data->setBothSeverityOxygenSaturationUnknow($columns['both_severity_oxygen_saturation_unknow'][$i]);
                                if ($columns['both_severity_oxygen_saturation'][$i] != null) {
                                    if ((preg_match("/^[0-9]{1,3}$/", $columns['both_severity_oxygen_saturation'][$i])) && (strlen($columns['both_severity_oxygen_saturation'][$i]) <= 3)) {
                                        $data->setBothSeverityOxygenSaturation($columns['both_severity_oxygen_saturation'][$i]);
                                    } else {
                                        $data->setBothSeverityOxygenSaturation($columns['both_severity_oxygen_saturation'][$i]);
                                        array_push($field, ['field' => 'both_severity_oxygen_saturation']);
                                    }
                                } else {
                                    $data->setBothSeverityOxygenSaturation(null);
                                    array_push($field, ['field' => 'both_severity_oxygen_saturation']);
                                }
                                if ($columns['both_severity_oxygen_saturation'][$i] == null && ($columns['both_severity_oxygen_saturation_unknow'][$i] == null || $columns['both_severity_oxygen_saturation_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_severity_oxygen_saturation_unknow']);
                                } elseif ($columns['both_severity_oxygen_saturation'][$i] != null && $columns['both_severity_oxygen_saturation_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_severity_oxygen_saturation_unknow']);
                                }
                            } else {
                                $data->setBothSeverityOxygenSaturationUnknow(null);
                                $data->setBothSeverityOxygenSaturation(null);
                            }

                            if (array_key_exists("both_severity_blood_pressure", $columns) && array_key_exists("both_severity_blood_pressure_unknow", $columns)) {
                                $data->setBothSeverityBloodPressureUnknow($columns['both_severity_blood_pressure_unknow'][$i]);
                                if ($columns['both_severity_blood_pressure'][$i] != null) {
                                    if ((preg_match("/^[0-9]{3}\/[0-9]{3}$/", $columns['both_severity_blood_pressure'][$i])) && (strlen($columns['both_severity_blood_pressure'][$i]) == 7)) {
                                        $data->setBothSeverityBloodPressure($columns['both_severity_blood_pressure'][$i]);
                                    } else {
                                        $data->setBothSeverityBloodPressure($columns['both_severity_blood_pressure'][$i]);
                                        array_push($field, ['field' => 'both_severity_blood_pressure']);
                                    }
                                } else {
                                    $data->setBothSeverityBloodPressure(null);
                                    array_push($field, ['field' => 'both_severity_blood_pressure']);
                                }
                                if ($columns['both_severity_blood_pressure'][$i] == null && ($columns['both_severity_blood_pressure_unknow'][$i] == null || $columns['both_severity_blood_pressure_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_severity_blood_pressure_unknow']);
                                } elseif ($columns['both_severity_blood_pressure'][$i] != null && $columns['both_severity_blood_pressure_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_severity_blood_pressure_unknow']);
                                }
                            } else {
                                $data->setBothSeverityBloodPressure(null);
                                $data->setBothSeverityBloodPressureUnknow(null);
                            }

                            if (array_key_exists("both_severity_respiration_rate", $columns) && array_key_exists("both_severity_respiration_rate_unknow", $columns)) {
                                $data->setBothSeverityRespirationRateUnknow($columns['both_severity_respiration_rate_unknow'][$i]);
                                if ($columns['both_severity_respiration_rate'][$i] != null) {
                                    if ((preg_match("/^[0-9]{1,2}$/", $columns['both_severity_respiration_rate'][$i])) && (strlen($columns['both_severity_respiration_rate'][$i]) <= 2)) {
                                        $data->setBothSeverityRespirationRate($columns['both_severity_respiration_rate'][$i]);
                                    } else {
                                        $data->setBothSeverityRespirationRate($columns['both_severity_respiration_rate'][$i]);
                                        array_push($field, ['field' => 'both_severity_respiration_rate']);
                                    }
                                } else {
                                    $data->setBothSeverityRespirationRate(null);
                                    array_push($field, ['field' => 'both_severity_respiration_rate']);
                                }
                                if ($columns['both_severity_respiration_rate'][$i] == null && ($columns['both_severity_respiration_rate_unknow'][$i] == null || $columns['both_severity_respiration_rate_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_severity_respiration_rate_unknow']);
                                } elseif ($columns['both_severity_respiration_rate'][$i] != null && $columns['both_severity_respiration_rate_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_severity_respiration_rate_unknow']);
                                }
                            } else {
                                $data->setBothSeverityRespirationRateUnknow(null);
                                $data->setBothSeverityRespirationRate(null);
                            }

                            if (array_key_exists("both_severity_supp_oxygen", $columns)) {
                                $data->setBothSeveritySuppOxygen($columns['both_severity_supp_oxygen'][$i]);
                                if (!in_array($columns['both_severity_supp_oxygen'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_severity_supp_oxygen']);
                                }
                            }

                            if (array_key_exists("both_severity_vaso_support", $columns)) {
                                $data->setBothSeverityVasoSupport($columns['both_severity_vaso_support'][$i]);
                                if (!in_array($columns['both_severity_vaso_support'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_severity_vaso_support']);
                                }
                            }

                            if (array_key_exists("both_icu_adm", $columns)) {
                                $data->setBothIcuAdm($columns['both_icu_adm'][$i]);
                                if (!in_array($columns['both_icu_adm'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_icu_adm']);
                                }
                            }

                            if (array_key_exists("both_death_hosp", $columns)) {
                                $data->setBothDeathHosp($columns['both_death_hosp'][$i]);
                                if (!in_array($columns['both_death_hosp'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_death_hosp']);
                                }
                            }

                            if (array_key_exists("both_severity_mech_vent", $columns)) {
                                $data->setBothSeverityMechVent($columns['both_severity_mech_vent'][$i]);
                                if (!in_array($columns['both_severity_mech_vent'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_severity_mech_vent']);
                                }
                            }

                            if (array_key_exists("both_severity_high_dependence_unit", $columns)) {
                                $data->setBothSeverityHighDependenceUnit($columns['both_severity_high_dependence_unit'][$i]);
                                if (!in_array($columns['both_severity_high_dependence_unit'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_severity_high_dependence_unit']);
                                }
                            }

                            if (array_key_exists("both_discharged_date", $columns) && ($columns['both_discharged_date'][$i] != null)) {
                                $columns['both_discharged_date'][$i] = str_replace("/", "-", $columns['both_discharged_date'][$i]);
                                if (strtotime($columns['both_doa'][$i])) {
                                    $data->setBothDischargedDate(date('d/m/Y', strtotime($columns['both_discharged_date'][$i])));
                                } else {
                                    $data->setBothDischargedDate($columns['both_discharged_date'][$i]);
                                    array_push($field, ['field' => 'both_discharged_date']);
                                }
                            } else {
                                $data->setBothDischargedDate(null);
                                array_push($field, ['field' => 'both_discharged_date']);
                            }

                            if (array_key_exists("both_d_diag1", $columns) && array_key_exists("both_d_diag1_unknow", $columns)) {
                                $data->setBothDDiag1Unknow($columns['both_d_diag1_unknow'][$i]);
                                if ($columns['both_d_diag1'][$i] != null) {
                                    if ((preg_match("/^([0-9]{3})$|^([A-Z]{1}[0-9]{2})$|^([0-9]{3}[.][0-9]{1,2})$|^([A-Z]{1}[0-9]{2}[.][0-9]{1,2})$/", $columns['both_d_diag1'][$i]))) {
                                        $data->setBothDDiag1($columns['both_d_diag1'][$i]);
                                    } else {
                                        $data->setBothDDiag1($columns['both_d_diag1'][$i]);
                                        array_push($field, ['field' => 'both_d_diag1']);
                                    }
                                } else {
                                    $data->setBothDDiag1(null);
                                    array_push($field, ['field' => 'both_d_diag1']);
                                }
                                if ($columns['both_d_diag1'][$i] == null && ($columns['both_d_diag1_unknow'][$i] == null || $columns['both_d_diag1_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_d_diag1_unknow']);
                                } elseif ($columns['both_d_diag1'][$i] != null && $columns['both_d_diag1_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_d_diag1_unknow']);
                                }
                            } else {
                                $data->setBothDDiag1Unknow(null);
                                $data->setBothDDiag1(null);
                            }

                            if (array_key_exists("both_d_diag2", $columns) && array_key_exists("both_d_diag2_unknow", $columns)) {
                                $data->setBothDDiag2Unknow($columns['both_d_diag2_unknow'][$i]);
                                if ($columns['both_d_diag2'][$i] != null) {
                                    if ((preg_match("/^([0-9]{3})$|^([A-Z]{1}[0-9]{2})$|^([0-9]{3}[.][0-9]{1,2})$|^([A-Z]{1}[0-9]{2}[.][0-9]{1,2})$/", $columns['both_d_diag2'][$i]))) {
                                        $data->setBothDDiag2($columns['both_d_diag2'][$i]);
                                    } else {
                                        $data->setBothDDiag2($columns['both_d_diag2'][$i]);
                                        array_push($field, ['field' => 'both_d_diag2']);
                                    }
                                } else {
                                    $data->setBothDDiag2(null);
                                    array_push($field, ['field' => 'both_d_diag2']);
                                }
                                if ($columns['both_d_diag2'][$i] == null && ($columns['both_d_diag2_unknow'][$i] == null || $columns['both_d_diag2_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_d_diag2_unknow']);
                                } elseif ($columns['both_d_diag2'][$i] != null && $columns['both_d_diag2_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_d_diag2_unknow']);
                                }
                            } else {
                                $data->setBothDDiag2Unknow(null);
                                $data->setBothDDiag2(null);
                            }
                            if (array_key_exists("both_d_diag3", $columns) && array_key_exists("both_d_diag3_unknow", $columns)) {
                                $data->setBothDDiag3Unknow($columns['both_d_diag3_unknow'][$i]);
                                if ($columns['both_d_diag3'][$i] != null) {
                                    if ((preg_match("/^([0-9]{3})$|^([A-Z]{1}[0-9]{2})$|^([0-9]{3}[.][0-9]{1,2})$|^([A-Z]{1}[0-9]{2}[.][0-9]{1,2})$/", $columns['both_d_diag3'][$i]))) {
                                        $data->setBothDDiag3($columns['both_d_diag3'][$i]);
                                    } else {
                                        $data->setBothDDiag3($columns['both_d_diag3'][$i]);
                                        array_push($field, ['field' => 'both_d_diag3']);
                                    }
                                } else {
                                    $data->setBothDDiag3(null);
                                    array_push($field, ['field' => 'both_d_diag3']);
                                }
                                if ($columns['both_d_diag3'][$i] == null && ($columns['both_d_diag3_unknow'][$i] == null || $columns['both_d_diag3_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_d_diag3_unknow']);
                                } elseif ($columns['both_d_diag3'][$i] != null && $columns['both_d_diag3_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_d_diag3_unknow']);
                                }
                            } else {
                                $data->setBothDDiag3Unknow(null);
                                $data->setBothDDiag3(null);
                            }

                            if (array_key_exists("both_d_icd", $columns)) {
                                $data->setBothDICD($columns['both_d_icd'][$i]);
                                if (!in_array($columns['both_d_icd'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_d_icd']);
                                }
                            }

                            if (array_key_exists("both_positive_result", $columns)) {
                                $data->setBothPositiveResult($columns['both_positive_result'][$i]);
                                if (!in_array($columns['both_positive_result'][$i], [0, 1, 2])) {
                                    array_push($field, ['field' => 'both_positive_result']);
                                }
                            }

                            if (array_key_exists("both_lab_flu_h1n1", $columns)) {
                                $data->setBothLabFluH1n1($columns['both_lab_flu_h1n1'][$i]);
                                if ($columns['both_lab_flu_h1n1'][$i] != null && !in_array($columns['both_lab_flu_h1n1'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab_flu_h1n1']);
                                }
                            }

                            if (array_key_exists("both_lab_flu_h3n2", $columns)) {
                                $data->setBothLabFluH3n2($columns['both_lab_flu_h3n2'][$i]);
                                if ($columns['both_lab_flu_h3n2'][$i] != null && !in_array($columns['both_lab_flu_h3n2'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab_flu_h3n2']);
                                }
                            }

                            if (array_key_exists("both_lab_flu_yamagata", $columns)) {
                                $data->setBothLabFluYamagata($columns['both_lab_flu_yamagata'][$i]);
                                if ($columns['both_lab_flu_yamagata'][$i] != null && !in_array($columns['both_lab_flu_yamagata'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab_flu_yamagata']);
                                }
                            }

                            if (array_key_exists("both_lab_flu_victoria", $columns)) {
                                $data->setBothLabFluVictoria($columns['both_lab_flu_victoria'][$i]);
                                if ($columns['both_lab_flu_victoria'][$i] != null && !in_array($columns['both_lab_flu_victoria'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab_flu_victoria']);
                                }
                            }

                            if (array_key_exists("both_lab_flu_h1nother", $columns)) {
                                $data->setBothLabFluH1Nother($columns['both_lab_flu_h1nother'][$i]);
                                if ($columns['both_lab_flu_h1nother'][$i] != null && !in_array($columns['both_lab_flu_h1nother'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab_flu_h1nother']);
                                }
                            }

                            if (array_key_exists("both_lab_flu_h3nother", $columns)) {
                                $data->setBothLabFluH3Nother($columns['both_lab_flu_h3nother'][$i]);
                                if ($columns['both_lab_flu_h3nother'][$i] != null && !in_array($columns['both_lab_flu_h3nother'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab_flu_h3nother']);
                                }
                            }

                            if (array_key_exists("both_lab_flu_a_nosub", $columns)) {
                                $data->setBothLabFluANosub($columns['both_lab_flu_a_nosub'][$i]);
                                if ($columns['both_lab_flu_a_nosub'][$i] != null && !in_array($columns['both_lab_flu_a_nosub'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab_flu_a_nosub']);
                                }
                            }

                            if (array_key_exists("both_lab_flu_b_nosub", $columns)) {
                                $data->setBothLabFluBNosub($columns['both_lab_flu_b_nosub'][$i]);
                                if ($columns['both_lab_flu_b_nosub'][$i] != null && !in_array($columns['both_lab_flu_b_nosub'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab_flu_b_nosub']);
                                }
                            }

                            if (array_key_exists("both_lab2_corona_yesno", $columns)) {
                                $data->setBothLab2CoronaYesno($columns['both_lab2_corona_yesno'][$i]);
                                if ($columns['both_lab2_corona_yesno'][$i] != null && !in_array($columns['both_lab2_corona_yesno'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab2_corona_yesno']);
                                }
                            }

                            if (array_key_exists("both_lab2_metaneumo_yesno", $columns)) {
                                $data->setBothLab2MetaneumoYesno($columns['both_lab2_metaneumo_yesno'][$i]);
                                if ($columns['both_lab2_metaneumo_yesno'][$i] != null && !in_array($columns['both_lab2_metaneumo_yesno'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab2_metaneumo_yesno']);
                                }
                            }

                            if (array_key_exists("both_lab2_rs_yesno", $columns)) {
                                $data->setBothLab2RsYesno($columns['both_lab2_rs_yesno'][$i]);
                                if ($columns['both_lab2_rs_yesno'][$i] != null && !in_array($columns['both_lab2_rs_yesno'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab2_rs_yesno']);
                                }
                            }

                            if (array_key_exists("both_lab2_adeno_yesno", $columns)) {
                                $data->setBothLab2AdenoYesno($columns['both_lab2_adeno_yesno'][$i]);
                                if ($columns['both_lab2_adeno_yesno'][$i] != null && !in_array($columns['both_lab2_adeno_yesno'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab2_adeno_yesno']);
                                }
                            }

                            if (array_key_exists("both_lab2_boca_yesno", $columns)) {
                                $data->setBothLab2BocaYesno($columns['both_lab2_boca_yesno'][$i]);
                                if ($columns['both_lab2_boca_yesno'][$i] != null && !in_array($columns['both_lab2_boca_yesno'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab2_boca_yesno']);
                                }
                            }

                            if (array_key_exists("both_lab2_pi_yesno", $columns)) {
                                $data->setBothLab2PiYesno($columns['both_lab2_pi_yesno'][$i]);
                                if ($columns['both_lab2_pi_yesno'][$i] != null && !in_array($columns['both_lab2_pi_yesno'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab2_pi_yesno']);
                                }
                            }

                            if (array_key_exists("both_lab2_rhino_yesno", $columns)) {
                                $data->setBothLab2RhinoYesno($columns['both_lab2_rhino_yesno'][$i]);
                                if ($columns['both_lab2_rhino_yesno'][$i] != null && !in_array($columns['both_lab2_rhino_yesno'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab2_rhino_yesno']);
                                }
                            }

                            if (array_key_exists("both_ilisystemic_fever", $columns)) {
                                $data->setBothIlisystemicFever($columns['both_ilisystemic_fever'][$i]);
                                if (!in_array($columns['both_ilisystemic_fever'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_ilisystemic_fever']);
                                }
                            }

                            if (array_key_exists("both_ilisystemic_malaise", $columns)) {
                                $data->setBothIlisystemicMalaise($columns['both_ilisystemic_malaise'][$i]);
                                if (!in_array($columns['both_ilisystemic_malaise'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_ilisystemic_malaise']);
                                }
                            }

                            if (array_key_exists("both_ilisystemic_headache", $columns)) {
                                $data->setBothIlisystemicHeadache($columns['both_ilisystemic_headache'][$i]);
                                if (!in_array($columns['both_ilisystemic_headache'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_ilisystemic_headache']);
                                }
                            }

                            if (array_key_exists("both_ilisystemic_myalgia", $columns)) {
                                $data->setBothIlisystemicMyalgia($columns['both_ilisystemic_myalgia'][$i]);
                                if (!in_array($columns['both_ilisystemic_myalgia'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_ilisystemic_myalgia']);
                                }
                            }

                            if (array_key_exists("both_ilirespiratory_cough", $columns)) {
                                $data->setBothIlirespiratoryCough($columns['both_ilirespiratory_cough'][$i]);
                                if (!in_array($columns['both_ilirespiratory_cough'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_ilirespiratory_cough']);
                                }
                            }

                            if (array_key_exists("both_ilirespiratory_sorethroat", $columns)) {
                                $data->setBothIlirespiratorySorethroat($columns['both_ilirespiratory_sorethroat'][$i]);
                                if (!in_array($columns['both_ilirespiratory_sorethroat'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_ilirespiratory_sorethroat']);
                                }
                            }

                            if (array_key_exists("both_ilirespiratory_shortnessbreath", $columns)) {
                                $data->setBothIlirespiratoryShortnessbreath($columns['both_ilirespiratory_shortnessbreath'][$i]);
                                if (!in_array($columns['both_ilirespiratory_shortnessbreath'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_ilirespiratory_shortnessbreath']);
                                }
                            }

                            if (array_key_exists("both_ilirespiratory_nasalcongestion", $columns)) {
                                $data->setBothIlirespiratoryNasalcongestion($columns['both_ilirespiratory_nasalcongestion'][$i]);
                                if (!in_array($columns['both_ilirespiratory_nasalcongestion'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_ilirespiratory_nasalcongestion']);
                                }
                            }

                            if (array_key_exists("both_epi_isl", $columns) && $columns['both_epi_isl'][$i] != null) {
                                if ((preg_match("/^EPI_ISL_[0-9]{7}$/", $columns['both_epi_isl'][$i])) && (strlen($columns['both_epi_isl'][$i])) == 15) {
                                    $data->setBothEpiIsl($columns['both_epi_isl'][$i]);
                                } else {
                                    $data->setBothEpiIsl($columns['both_epi_isl'][$i]);
                                    array_push($field, ['field' => 'both_epi_isl']);
                                }
                            } else {
                                $data->setBothEpiIsl(null);
                            }

                            if (array_key_exists("both_pregnancy_status", $columns)) {
                                $data->setBothPregnancyStatus($columns['both_pregnancy_status'][$i]);
                                if (!in_array($columns['both_pregnancy_status'][$i], [0, 1, 2])) {
                                    array_push($field, ['field' => 'both_pregnancy_status']);
                                }
                            }

                            if (array_key_exists("both_pregnancy_weeks", $columns) && array_key_exists("both_pregnancy_weeks_unknow", $columns)) {
                                $data->setBothPregnancyWeeksUnknow($columns['both_pregnancy_weeks_unknow'][$i]);
                                if ($columns['both_pregnancy_weeks'][$i] != null) {
                                    if (is_int($columns['both_pregnancy_weeks'][$i])) {
                                        $data->setBothPregnancyWeeks($columns['both_pregnancy_weeks'][$i]);
                                    } else {
                                        $data->setBothPregnancyWeeks($columns['both_pregnancy_weeks'][$i]);
                                        array_push($field, ['field' => 'both_pregnancy_weeks']);
                                    }
                                } else {
                                    $data->setBothPregnancyWeeks(null);
                                }
                                if ($columns['both_pregnancy_weeks'][$i] == null && ($columns['both_pregnancy_weeks_unknow'][$i] == null || $columns['both_pregnancy_weeks_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_pregnancy_weeks_unknow']);
                                } elseif ($columns['both_pregnancy_weeks'][$i] != null && $columns['both_pregnancy_weeks_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_pregnancy_weeks_unknow']);
                                }
                            } else {
                                $data->setBothPregnancyWeeks(null);
                                $data->setBothPregnancyWeeksUnknow(null);
                            }

                            if (array_key_exists("both_test_other_virus", $columns)) {
                                $data->setBothTestOtherVirus($columns['both_test_other_virus'][$i]);
                                if (!in_array($columns['both_test_other_virus'][$i], [0, 1, 2])) {
                                    array_push($field, ['field' => 'both_test_other_virus']);
                                }
                            }

                            // variable both_height and both_weight by age
                            if ($age && $age < 5) {
                                if (array_key_exists("both_height", $columns) && array_key_exists("both_height_unknow", $columns)) {
                                    $data->setBothHeightUnknow($columns['both_height_unknow'][$i]);
                                    if ($columns['both_height'][$i] != null) {
                                        $columns['both_height'][$i] = str_replace(",", ".", $columns['both_height'][$i]);
                                        if ((preg_match("/^[0-9]{1,3}$|^[0-9]{1,3}[.][0-9]{1,3}$/", $columns['both_height'][$i]))) {
                                            $data->setBothHeight($columns['both_height'][$i]);
                                        } else {
                                            $data->setBothHeight($columns['both_height'][$i]);
                                            array_push($field, ['field' => 'both_height']);
                                        }
                                    } else {
                                        $data->setBothHeight(null);
                                        array_push($field, ['field' => 'both_height']);
                                    }
                                    if ($columns['both_height'][$i] == null && ($columns['both_height_unknow'][$i] == null || $columns['both_height_unknow'][$i] == 0)) {
                                        array_push($field, ['field' => 'both_height_unknow']);
                                    } elseif ($columns['both_height'][$i] != null && $columns['both_height_unknow'][$i] == 1) {
                                        array_push($field, ['field' => 'both_height_unknow']);
                                    }
                                } else {
                                    $data->setBothHeight(null);
                                    $data->setBothHeightUnknow(null);
                                    array_push($field, ['field' => 'both_height']);
                                }
                                if (array_key_exists("both_weight", $columns) && array_key_exists("both_weight_unknow", $columns)) {
                                    $data->setBothWeightUnknow($columns['both_weight_unknow'][$i]);
                                    if ($columns['both_weight'][$i] != null) {
                                        $columns['both_weight'][$i] = str_replace(",", ".", $columns['both_weight'][$i]);
                                        if ((preg_match("/^[0-9]{1,3}$|^[0-9]{1,3}[.][0-9]{1,3}$/", $columns['both_weight'][$i]))) {
                                            $data->setBothWeight($columns['both_weight'][$i]);
                                        } else {
                                            $data->setBothWeight($columns['both_weight'][$i]);
                                            array_push($field, ['field' => 'both_weight']);
                                        }
                                    } else {
                                        $data->setBothWeight(null);
                                        array_push($field, ['field' => 'both_weight']);
                                    }
                                    if ($columns['both_weight'][$i] == null && ($columns['both_weight_unknow'][$i] == null || $columns['both_weight_unknow'][$i] == 0)) {
                                        array_push($field, ['field' => 'both_weight_unknow']);
                                    } elseif ($columns['both_weight'][$i] != null && $columns['both_weight_unknow'][$i] == 1) {
                                        array_push($field, ['field' => 'both_weight_unknow']);
                                    }
                                } else {
                                    $data->setBothWeight(null);
                                    $data->setBothWeightUnknow(null);
                                    array_push($field, ['field' => 'both_weight']);
                                }

                                if (array_key_exists("both_severity_apnea", $columns)) {
                                    $data->setBothSeverityApnea($columns['both_severity_apnea'][$i]);
                                    if (!in_array($columns['both_severity_apnea'][$i], [0, 1, 2])) {
                                        array_push($field, ['field' => 'both_severity_apnea']);
                                    }
                                }

                            } else {
                                if (array_key_exists("both_height", $columns) && array_key_exists("both_height_unknow", $columns)) {
                                    $data->setBothHeightUnknow($columns['both_height_unknow'][$i]);
                                    if ($columns['both_height'][$i] != null) {
                                        $columns['both_height'][$i] = str_replace(",", ".", $columns['both_height'][$i]);
                                        if ((preg_match("/^[0-9]{1,3}$|^[0-9]{1,3}[.][0-9]{1,3}$/", $columns['both_height'][$i]))) {
                                            $data->setBothHeight($columns['both_height'][$i]);
                                        } else {
                                            $data->setBothHeight($columns['both_height'][$i]);
                                            array_push($field, ['field' => 'both_height']);
                                        }
                                    } else {
                                        $data->setBothHeight(null);
                                    }
                                    if ($columns['both_height'][$i] == null && ($columns['both_height_unknow'][$i] == null || $columns['both_height_unknow'][$i] == 0)) {
                                        array_push($field, ['field' => 'both_height_unknow']);
                                    } elseif ($columns['both_height'][$i] != null && $columns['both_height_unknow'][$i] == 1) {
                                        array_push($field, ['field' => 'both_height_unknow']);
                                    }
                                } else {
                                    $data->setBothHeight(null);
                                    $data->setBothHeightUnknow(null);

                                }

                                if (array_key_exists("both_weight", $columns) && array_key_exists("both_weight_unknow", $columns)) {
                                    $data->setBothWeightUnknow($columns['both_weight_unknow'][$i]);
                                    if ($columns['both_weight'][$i] != null) {
                                        $columns['both_weight'][$i] = str_replace(",", ".", $columns['both_weight'][$i]);
                                        if ((preg_match("/^[0-9]{1,3}$|^[0-9]{1,3}[.][0-9]{1,3}$/", $columns['both_weight'][$i]))) {
                                            $data->setBothWeight($columns['both_weight'][$i]);
                                        } else {
                                            $data->setBothWeight($columns['both_weight'][$i]);
                                            array_push($field, ['field' => 'both_weight']);
                                        }
                                    } else {
                                        $data->setBothWeight(null);
                                    }
                                    if ($columns['both_weight'][$i] == null && ($columns['both_weight_unknow'][$i] == null || $columns['both_weight_unknow'][$i] == 0)) {
                                        array_push($field, ['field' => 'both_weight_unknow']);
                                    } elseif ($columns['both_weight'][$i] != null && $columns['both_weight_unknow'][$i] == 1) {
                                        array_push($field, ['field' => 'both_weight_unknow']);
                                    }
                                } else {
                                    $data->setBothWeight(null);
                                    $data->setBothWeightUnknow(null);
                                }

                                if (array_key_exists("both_severity_apnea", $columns)) {
                                    $data->setBothSeverityApnea($columns['both_severity_apnea'][$i]);
                                    if ($columns['both_severity_apnea'][$i] != null && !in_array($columns['both_severity_apnea'][$i], [0, 1, 9999])) {
                                        array_push($field, ['field' => 'both_severity_apnea']);
                                    }
                                }
                            }

                            if (array_key_exists("both_chronic_prematurity", $columns)) {
                                $data->setBothChronicPrematurity($columns['both_chronic_prematurity'][$i]);
                                if (!in_array($columns['both_chronic_prematurity'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_prematurity']);
                                }
                            }

                            if (array_key_exists("both_chronic_hemoglobinopathies", $columns)) {
                                $data->setBothChronicHemoglobinopathies($columns['both_chronic_hemoglobinopathies'][$i]);
                                if (!in_array($columns['both_chronic_hemoglobinopathies'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_chronic_hemoglobinopathies']);
                                }
                            }

                            if (array_key_exists("both_antibio_preceding", $columns)) {
                                $data->setBothAntibioPreceding($columns['both_antibio_preceding'][$i]);
                                if ($columns['both_antibio_preceding'][$i] != null && !in_array($columns['both_antibio_preceding'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_antibio_preceding']);
                                }
                            }

                            if (array_key_exists("both_antibio_preceding_date", $columns) && array_key_exists("both_antibio_preceding_date_unknow", $columns)) {
                                $data->setBothAntibioPrecedingDateUnknow($columns['both_antibio_preceding_date_unknow'][$i]);
                                if ($columns['both_antibio_preceding_date'][$i] != null) {
                                    $columns['both_antibio_preceding_date'][$i] = str_replace("/", "-", $columns['both_antibio_preceding_date'][$i]);
                                    if (strtotime($columns['both_antibio_preceding_date'][$i])) {
                                        $data->setBothAntibioPrecedingDate(date('d/m/Y', strtotime($columns['both_antibio_preceding_date'][$i])));
                                    } else {
                                        $data->setBothAntibioPrecedingDate($columns['both_antibio_preceding_date'][$i]);
                                        array_push($field, ['field' => 'both_antibio_preceding_date']);
                                    }
                                } else {
                                    $data->setBothAntibioPrecedingDate(null);
                                    array_push($field, ['field' => 'both_antibio_preceding_date']);
                                }
                                if ($columns['both_antibio_preceding_date'][$i] == null && ($columns['both_antibio_preceding_date_unknow'][$i] == null || $columns['both_antibio_preceding_date_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_antibio_preceding_date_unknow']);
                                } elseif ($columns['both_antibio_preceding_date'][$i] != null && $columns['both_antibio_preceding_date_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_antibio_preceding_date_unknow']);
                                }
                            } else {
                                $data->setBothAntibioPrecedingDate(null);
                                $data->setBothAntibioPrecedingDateUnknow(null);
                            }

                            // variable both_frailty_score and both_frailty_score_discharge with condition age
                            if ($age && $age >= 50) {
                                if (array_key_exists("both_frailty_score", $columns) && array_key_exists("both_frailty_score_unknow", $columns)) {
                                    $data->setBothFrailtyScore($columns['both_frailty_score'][$i]);
                                    $data->setBothFrailtyScoreUnknow($columns['both_frailty_score_unknow'][$i]);
                                    if (!in_array($columns['both_frailty_score'][$i], [1, 2, 3, 4, 5, 6, 7, 8, 9]) && ($columns['both_frailty_score_unknow'][$i] == null || $columns['both_frailty_score_unknow'][$i] == 0)) {
                                        array_push($field, ['field' => 'both_frailty_score']);
                                    } elseif (in_array($columns['both_frailty_score'][$i], [1, 2, 3, 4, 5, 6, 7, 8, 9]) && ($columns['both_frailty_score_unknow'][$i] == 1)) {
                                        array_push($field, ['field' => 'both_frailty_score_unknow']);
                                    }
                                }
                                if (array_key_exists("both_frailty_score_discharge", $columns) && array_key_exists("both_frailty_score_discharge_unknow", $columns)) {
                                    $data->setBothFrailtyScoreDischarge($columns['both_frailty_score_discharge'][$i]);
                                    $data->setBothFrailtyScoreDischargeUnknow($columns['both_frailty_score_discharge_unknow'][$i]);
                                    if (!in_array($columns['both_frailty_score_discharge'][$i], [1, 2, 3, 4, 5, 6, 7, 8, 9]) && ($columns['both_frailty_score_discharge_unknow'][$i] == null || $columns['both_frailty_score_discharge_unknow'][$i] == 0)) {
                                        array_push($field, ['field' => 'both_frailty_score_discharge']);
                                    } elseif (in_array($columns['both_frailty_score_discharge'][$i], [1, 2, 3, 4, 5, 6, 7, 8, 9]) && ($columns['both_frailty_score_discharge_unknow'][$i] == 1)) {
                                        array_push($field, ['field' => 'both_frailty_score_discharge_unknow']);
                                    }
                                }

                            } else {
                                if (array_key_exists("both_frailty_score", $columns) && array_key_exists("both_frailty_score_unknow", $columns)) {
                                    $data->setBothFrailtyScore($columns['both_frailty_score'][$i]);
                                    $data->setBothFrailtyScoreUnknow($columns['both_frailty_score_unknow'][$i]);
                                    if ($columns['both_frailty_score'][$i] != null) {
                                        if (!in_array($columns['both_frailty_score'][$i], [1, 2, 3, 4, 5, 6, 7, 8, 9]) && ($columns['both_frailty_score_unknow'][$i] == null || $columns['both_frailty_score_unknow'][$i] == 0)) {
                                            array_push($field, ['field' => 'both_frailty_score']);
                                        } elseif (in_array($columns['both_frailty_score'][$i], [1, 2, 3, 4, 5, 6, 7, 8, 9]) && ($columns['both_frailty_score_unknow'][$i] == 1)) {
                                            array_push($field, ['field' => 'both_frailty_score_unknow']);
                                        }
                                    }
                                }
                                if (array_key_exists("both_frailty_score_discharge", $columns) && array_key_exists("both_frailty_score_discharge_unknow", $columns)) {
                                    $data->setBothFrailtyScoreDischarge($columns['both_frailty_score_discharge'][$i]);
                                    $data->setBothFrailtyScoreDischargeUnknow($columns['both_frailty_score_discharge_unknow'][$i]);
                                    if ($columns['both_frailty_score_discharge'][$i] != null) {
                                        if (!in_array($columns['both_frailty_score_discharge'][$i], [1, 2, 3, 4, 5, 6, 7, 8, 9]) && ($columns['both_frailty_score_discharge_unknow'][$i] == null || $columns['both_frailty_score_discharge_unknow'][$i] == 0)) {
                                            array_push($field, ['field' => 'both_frailty_score_discharge']);
                                        } elseif (in_array($columns['both_frailty_score_discharge'][$i], [1, 2, 3, 4, 5, 6, 7, 8, 9]) && ($columns['both_frailty_score_discharge_unknow'][$i] == 1)) {
                                            array_push($field, ['field' => 'both_frailty_score_discharge_unknow']);
                                        }
                                    }
                                }
                            }

                            if (array_key_exists("both_severity_confusion", $columns)) {
                                $data->setBothSeverityConfusion($columns['both_severity_confusion'][$i]);
                                if (!in_array($columns['both_severity_confusion'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_severity_confusion']);
                                }
                            }

                            if (array_key_exists("both_discharge_another_hopital", $columns)) {
                                $data->setBothDischargeAnotherHopital($columns['both_discharge_another_hopital'][$i]);
                                if (!in_array($columns['both_discharge_another_hopital'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_discharge_another_hopital']);
                                }
                            }

                            if (array_key_exists("both_sample_submited", $columns)) {
                                $data->setBothSampleSubmited($columns['both_sample_submited'][$i]);
                                if (!in_array($columns['both_sample_submited'][$i], [0, 1, 2])) {
                                    array_push($field, ['field' => 'both_sample_submited']);
                                }
                            }

                            if (array_key_exists("both_sample_type", $columns)) {
                                $data->setBothSampleType($columns['both_sample_type'][$i]);
                                if ($columns['both_sample_type'][$i] != null && !in_array($columns['both_sample_type'][$i], [1, 2, 3])) {
                                    array_push($field, ['field' => 'both_sample_type']);
                                }
                            }

                            if (array_key_exists("both_lab2_corona", $columns)) {
                                $data->setBothLab2Corona($columns['both_lab2_corona'][$i]);
                                if ($columns['both_lab2_corona'][$i] != null && !in_array($columns['both_lab2_corona'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_corona']);
                                }
                            }

                            if (array_key_exists("both_lab2_metaneumo", $columns)) {
                                $data->setBothLab2Metaneumo($columns['both_lab2_metaneumo'][$i]);
                                if ($columns['both_lab2_metaneumo'][$i] != null && !in_array($columns['both_lab2_metaneumo'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_metaneumo']);
                                }
                            }

                            if (array_key_exists("both_lab2_rs", $columns)) {
                                $data->setBothLab2Rs($columns['both_lab2_rs'][$i]);
                                if ($columns['both_lab2_rs'][$i] != null && !in_array($columns['both_lab2_rs'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_rs']);
                                }
                            }

                            if (array_key_exists("both_lab2_adeno", $columns)) {
                                $data->setBothLab2Adeno($columns['both_lab2_adeno'][$i]);
                                if ($columns['both_lab2_adeno'][$i] != null && !in_array($columns['both_lab2_adeno'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_adeno']);
                                }
                            }

                            if (array_key_exists("both_lab2_boca", $columns)) {
                                $data->setBothLab2Boca($columns['both_lab2_boca'][$i]);
                                if ($columns['both_lab2_boca'][$i] != null && !in_array($columns['both_lab2_boca'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_boca']);
                                }
                            }

                            if (array_key_exists("both_lab2_pi", $columns)) {
                                $data->setBothLab2Pi($columns['both_lab2_pi'][$i]);
                                if ($columns['both_lab2_pi'][$i] != null && !in_array($columns['both_lab2_pi'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_pi']);
                                }
                            }

                            if (array_key_exists("both_lab2_rhino", $columns)) {
                                $data->setBothLab2Rhino($columns['both_lab2_rhino'][$i]);
                                if ($columns['both_lab2_rhino'][$i] != null && !in_array($columns['both_lab2_rhino'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_rhino']);
                                }
                            }

                            if (array_key_exists("both_othersymptoms_nausea", $columns)) {
                                $data->setBothOthersymptomsNausea($columns['both_othersymptoms_nausea'][$i]);
                                if (!in_array($columns['both_othersymptoms_nausea'][$i], [0, 1, 2])) {
                                    array_push($field, ['field' => 'both_othersymptoms_nausea']);
                                }
                            }

                            if (array_key_exists("both_othersymptoms_diarrhea", $columns)) {
                                $data->setBothOthersymptomsDiarrhea($columns['both_othersymptoms_diarrhea'][$i]);
                                if (!in_array($columns['both_othersymptoms_diarrhea'][$i], [0, 1, 2])) {
                                    array_push($field, ['field' => 'both_othersymptoms_diarrhea']);
                                }
                            }

                            if (array_key_exists("both_othersymptoms_smell", $columns)) {
                                $data->setBothOthersymptomsSmell($columns['both_othersymptoms_smell'][$i]);
                                if (!in_array($columns['both_othersymptoms_smell'][$i], [0, 1, 2])) {
                                    array_push($field, ['field' => 'both_othersymptoms_smell']);
                                }
                            }

                            if (array_key_exists("both_othersymptoms_chestpain", $columns)) {
                                $data->setBothOthersymptomsChestpain($columns['both_othersymptoms_chestpain'][$i]);
                                if (!in_array($columns['both_othersymptoms_chestpain'][$i], [0, 1, 2])) {
                                    array_push($field, ['field' => 'both_othersymptoms_chestpain']);
                                }
                            }

                            if (array_key_exists("both_ilirespiratory_wheezing", $columns)) {
                                $data->setBothIlirespiratoryWheezing($columns['both_ilirespiratory_wheezing'][$i]);
                                if (!in_array($columns['both_ilirespiratory_wheezing'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_ilirespiratory_wheezing']);
                                }
                            }

                            if (array_key_exists("both_antibio_during", $columns)) {
                                $data->setBothAntibioDuring($columns['both_antibio_during'][$i]);
                                if (!in_array($columns['both_antibio_during'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_antibio_during']);
                                }
                            }

                            if (array_key_exists("both_antibio_during_date", $columns) && array_key_exists("both_antibio_during_date_unknow", $columns)) {
                                $data->setBothAntibioDuringDateUnknow($columns['both_antibio_during_date_unknow'][$i]);
                                if ($columns['both_antibio_during_date'][$i] != null) {
                                    $columns['both_antibio_during_date'][$i] = str_replace("/", "-", $columns['both_antibio_during_date'][$i]);
                                    if (strtotime($columns['both_antibio_during_date'][$i])) {
                                        $data->setBothAntibioDuringDate(date('d/m/Y', strtotime($columns['both_antibio_during_date'][$i])));
                                    } else {
                                        $data->setBothAntibioDuringDate($columns['both_antibio_during_date'][$i]);
                                        array_push($field, ['field' => 'both_antibio_during_date']);
                                    }
                                } else {
                                    $data->setBothAntibioDuringDate(null);
                                }
                                if ($columns['both_antibio_during_date'][$i] == null && ($columns['both_antibio_during_date_unknow'][$i] == null || $columns['both_antibio_during_date_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_antibio_during_date_unknow']);
                                } elseif ($columns['both_antibio_during_date'][$i] != null && $columns['both_antibio_during_date_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_antibio_during_date_unknow']);
                                }
                            } else {
                                $data->setBothAntibioDuringDate(null);
                                $data->setBothAntibioDuringDateUnknow(null);
                            }

                            if (array_key_exists("both_antiviral_preceding", $columns)) {
                                $data->setBothAntiviralPreceding($columns['both_antiviral_preceding'][$i]);
                                if (!in_array($columns['both_antiviral_preceding'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_antiviral_preceding']);
                                }
                            }

                            if (array_key_exists("both_antiviral_preceding_date", $columns) && array_key_exists("both_antiviral_preceding_date_unknow", $columns)) {
                                $data->setBothAntiviralPrecedingDateUnknow($columns['both_antiviral_preceding_date_unknow'][$i]);
                                if ($columns['both_antiviral_preceding_date'][$i] != null) {
                                    $columns['both_antiviral_preceding_date'][$i] = str_replace("/", "-", $columns['both_antiviral_preceding_date'][$i]);
                                    if (strtotime($columns['both_antiviral_preceding_date'][$i])) {
                                        $data->setBothAntiviralPrecedingDate(date('d/m/Y', strtotime($columns['both_antiviral_preceding_date'][$i])));
                                    } else {
                                        $data->setBothAntiviralPrecedingDate($columns['both_antiviral_preceding_date'][$i]);
                                        array_push($field, ['field' => 'both_antiviral_preceding_date']);
                                    }
                                } else {
                                    $data->setBothAntiviralPrecedingDate(null);
                                }
                                if ($columns['both_antiviral_preceding_date'][$i] == null && ($columns['both_antiviral_preceding_date_unknow'][$i] == null || $columns['both_antiviral_preceding_date_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_antiviral_preceding_date_unknow']);
                                } elseif ($columns['both_antiviral_preceding_date'][$i] != null && $columns['both_antiviral_preceding_date_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_antiviral_preceding_date_unknow']);
                                }
                            } else {
                                $data->setBothAntiviralPrecedingDate(null);
                                $data->setBothAntiviralPrecedingDateUnknow(null);
                            }

                            if (array_key_exists("both_antiviral_during", $columns)) {
                                $data->setBothAntiviralDuring($columns['both_antiviral_during'][$i]);
                                if (!in_array($columns['both_antiviral_during'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_antiviral_during']);
                                }
                            }

                            if (array_key_exists("both_antiviral_during_date", $columns) && array_key_exists("both_antiviral_during_date_unknow", $columns)) {
                                $data->setBothAntiviralDuringDateUnknow($columns['both_antiviral_during_date_unknow'][$i]);
                                if ($columns['both_antiviral_during_date'][$i] != null) {
                                    $columns['both_antiviral_during_date'][$i] = str_replace("/", "-", $columns['both_antiviral_during_date'][$i]);
                                    if (strtotime($columns['both_antiviral_during_date'][$i])) {
                                        $data->setBothAntiviralDuringDate(date('d/m/Y', strtotime($columns['both_antiviral_during_date'][$i])));
                                    } else {
                                        $data->setBothAntiviralDuringDate($columns['both_antiviral_during_date'][$i]);
                                        array_push($field, ['field' => 'both_antiviral_during_date']);
                                    }
                                } else {
                                    $data->setBothAntiviralDuringDate(null);
                                }
                                if ($columns['both_antiviral_during_date'][$i] == null && ($columns['both_antiviral_during_date_unknow'][$i] == null || $columns['both_antiviral_during_date_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_antiviral_during_date_unknow']);
                                } elseif ($columns['both_antiviral_during_date'][$i] != null && $columns['both_antiviral_during_date_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_antiviral_during_date_unknow']);
                                }
                            } else {
                                $data->setBothAntiviralDuringDate(null);
                                $data->setBothAntiviralDuringDateUnknow(null);
                            }

                            if (array_key_exists("both_vac_history_validated", $columns)) {
                                $data->setBothVacHistoryValidated($columns['both_vac_history_validated'][$i]);
                                if ($columns['both_vac_history_validated'][$i] != null && !in_array($columns['both_vac_history_validated'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_vac_history_validated']);
                                }
                            }

                            if (array_key_exists("both_lab2_sarscov2", $columns)) {
                                $data->setBothLab2Sarscov2($columns['both_lab2_sarscov2'][$i]);
                                if ($columns['both_lab2_sarscov2'][$i] != null && !in_array($columns['both_lab2_sarscov2'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_sarscov2']);
                                }
                            }

                            if (array_key_exists("both_lab2_sarscov2_yesno", $columns)) {
                                $data->setBothLab2Sarscov2Yesno($columns['both_lab2_sarscov2_yesno'][$i]);
                                if ($columns['both_lab2_sarscov2_yesno'][$i] != null && !in_array($columns['both_lab2_sarscov2_yesno'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab2_sarscov2_yesno']);
                                }
                            }

                            if (array_key_exists("both_lab2_evd68", $columns)) {
                                $data->setBothLab2Evd68($columns['both_lab2_evd68'][$i]);
                                if ($columns['both_lab2_evd68'][$i] != null && !in_array($columns['both_lab2_evd68'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_evd68']);
                                }
                            }

                            if (array_key_exists("both_lab2_evd68_yesno", $columns)) {
                                $data->setBothLab2Evd68Yesno($columns['both_lab2_evd68_yesno'][$i]);
                                if ($columns['both_lab2_evd68_yesno'][$i] != null && !in_array($columns['both_lab2_evd68_yesno'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab2_evd68_yesno']);
                                }
                            }

                            if (array_key_exists("both_lab2_others", $columns)) {
                                $data->setBothLab2Others($columns['both_lab2_others'][$i]);
                                if ($columns['both_lab2_others'][$i] != null && !in_array($columns['both_lab2_others'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_others']);
                                }
                            }

                            if (array_key_exists("both_lab2_others_yesno", $columns)) {
                                $data->setBothLab2OthersYesno($columns['both_lab2_others_yesno'][$i]);
                                if ($columns['both_lab2_others_yesno'][$i] != null && !in_array($columns['both_lab2_others_yesno'][$i], [0, 1, 9999])) {
                                    array_push($field, ['field' => 'both_lab2_others_yesno']);
                                }
                            }
                            array_key_exists("both_lab2_others_detail", $columns) ? $data->setBothLab2OthersDetail($columns['both_lab2_others_detail'][$i]) : $data->setBothLab2OthersDetail(null);

                            if (array_key_exists("both_vac_type_vaccine", $columns)) {
                                $data->setBothVacTypeVaccine($columns['both_vac_type_vaccine'][$i]);
                                if ($columns['both_vac_type_vaccine'][$i] != null && !in_array($columns['both_vac_type_vaccine'][$i], [9999, 1, 2])) {
                                    array_push($field, ['field' => 'both_vac_type_vaccine']);
                                }
                            }

                            if (array_key_exists("both_covid_number_doses", $columns)) {
                                $data->setBothCovidNumberDoses($columns['both_covid_number_doses'][$i]);
                                if (!in_array(strtolower($columns['both_covid_number_doses'][$i]), ['None', 1, 2, 3, 9999])) {
                                    array_push($field, ['field' => 'both_covid_number_doses']);
                                }
                            }

                            if (array_key_exists("both_covid_last_dose_date", $columns) && array_key_exists("both_covid_last_dose_date_unknow", $columns)) {
                                $data->setBothCovidLastDoseDateUnknow($columns['both_covid_last_dose_date_unknow'][$i]);
                                if ($columns['both_covid_last_dose_date'][$i] != null) {
                                    $columns['both_covid_last_dose_date'][$i] = str_replace("/", "-", $columns['both_covid_last_dose_date'][$i]);
                                    if (strtotime($columns['both_covid_last_dose_date'][$i])) {
                                        $data->setBothCovidLastDoseDate(date('d/m/Y', strtotime($columns['both_covid_last_dose_date'][$i])));
                                    } else {
                                        $data->setBothCovidLastDoseDate($columns['both_covid_last_dose_date'][$i]);
                                        array_push($field, ['field' => 'both_covid_last_dose_date']);
                                    }
                                } else {
                                    $data->setBothCovidLastDoseDate(null);
                                }
                                if ($columns['both_covid_last_dose_date'][$i] == null && ($columns['both_covid_last_dose_date_unknow'][$i] == null || $columns['both_covid_last_dose_date_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_covid_last_dose_date_unknow']);
                                } elseif ($columns['both_covid_last_dose_date'][$i] != null && $columns['both_covid_last_dose_date_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_covid_last_dose_date_unknow']);
                                }
                            } else {
                                $data->setBothCovidLastDoseDate(null);
                                $data->setBothCovidLastDoseDateUnknow(null);
                            }

                            if (array_key_exists("both_covid_vaccine_mrna", $columns) && array_key_exists("both_covid_vaccine_unknow", $columns)) {
                                $data->setBothCovidVaccineMrna($columns['both_covid_vaccine_mrna'][$i]);
                                $data->setBothCovidVaccineUnknow($columns['both_covid_vaccine_unknow'][$i]);
                                if ($columns['both_covid_vaccine_mrna'][$i] != null) {
                                    if (!in_array($columns['both_covid_vaccine_mrna'][$i], [0, 1]) && ($columns['both_covid_vaccine_unknow'][$i] == null || $columns['both_covid_vaccine_unknow'][$i] == 0)) {
                                        array_push($field, ['field' => 'both_covid_vaccine_mrna']);
                                    } elseif (in_array($columns['both_covid_vaccine_mrna'][$i], [0, 1]) && ($columns['both_covid_vaccine_unknow'][$i] == 1)) {
                                        array_push($field, ['field' => 'both_covid_vaccine_unknow']);
                                    }
                                }
                            }

                            if (array_key_exists("both_covid_vaccine_inactivated_virion", $columns) && array_key_exists("both_covid_vaccine_unknow", $columns)) {
                                $data->setBothCovidVaccineInactivatedVirion($columns['both_covid_vaccine_inactivated_virion'][$i]);
                                $data->setBothCovidVaccineUnknow($columns['both_covid_vaccine_unknow'][$i]);
                                if ($columns['both_covid_vaccine_inactivated_virion'][$i] != null) {
                                    if (!in_array($columns['both_covid_vaccine_inactivated_virion'][$i], [0, 1]) && ($columns['both_covid_vaccine_unknow'][$i] == null || $columns['both_covid_vaccine_unknow'][$i] == 0)) {
                                        array_push($field, ['field' => 'both_covid_vaccine_inactivated_virion']);
                                    } elseif (in_array($columns['both_covid_vaccine_inactivated_virion'][$i], [0, 1]) && ($columns['both_covid_vaccine_unknow'][$i] == 1)) {
                                        array_push($field, ['field' => 'both_covid_vaccine_unknow']);
                                    }
                                }
                            }

                            if (array_key_exists("both_covid_vaccine_viral_vector", $columns) && array_key_exists("both_covid_vaccine_unknow", $columns)) {
                                $data->setBothCovidVaccineViralVector($columns['both_covid_vaccine_viral_vector'][$i]);
                                $data->setBothCovidVaccineUnknow($columns['both_covid_vaccine_unknow'][$i]);
                                if ($columns['both_covid_vaccine_viral_vector'][$i] != null) {
                                    if (!in_array($columns['both_covid_vaccine_viral_vector'][$i], [0, 1]) && ($columns['both_covid_vaccine_unknow'][$i] == null || $columns['both_covid_vaccine_unknow'][$i] == 0)) {
                                        array_push($field, ['field' => 'both_covid_vaccine_viral_vector']);
                                    } elseif (in_array($columns['both_covid_vaccine_viral_vector'][$i], [0, 1]) && ($columns['both_covid_vaccine_unknow'][$i] == 1)) {
                                        array_push($field, ['field' => 'both_covid_vaccine_unknow']);
                                    }
                                }
                            }

                            if (array_key_exists("both_covid_vaccine_protein_subunit", $columns) && array_key_exists("both_covid_vaccine_unknow", $columns)) {
                                $data->setBothCovidVaccineProteinSubunit($columns['both_covid_vaccine_protein_subunit'][$i]);
                                $data->setBothCovidVaccineUnknow($columns['both_covid_vaccine_unknow'][$i]);
                                if ($columns['both_covid_vaccine_protein_subunit'][$i] != null) {
                                    if (!in_array($columns['both_covid_vaccine_protein_subunit'][$i], [0, 1]) && ($columns['both_covid_vaccine_unknow'][$i] == null || $columns['both_covid_vaccine_unknow'][$i] == 0)) {
                                        array_push($field, ['field' => 'both_covid_vaccine_protein_subunit']);
                                    } elseif (in_array($columns['both_covid_vaccine_protein_subunit'][$i], [0, 1]) && ($columns['both_covid_vaccine_unknow'][$i] == 1)) {
                                        array_push($field, ['field' => 'both_covid_vaccine_unknow']);
                                    }
                                }
                            }

                            if (array_key_exists("both_swabcovid_date", $columns) && array_key_exists("both_swabcovid_date_unknow", $columns)) {
                                $data->setBothSwabcovidDateUnknow($columns['both_swabcovid_date_unknow'][$i]);
                                if ($columns['both_swabcovid_date'][$i] != null) {
                                    $columns['both_swabcovid_date'][$i] = str_replace("/", "-", $columns['both_swabcovid_date'][$i]);
                                    if (strtotime($columns['both_swabcovid_date'][$i])) {
                                        $data->setBothSwabcovidDate(date('d/m/Y', strtotime($columns['both_swabcovid_date'][$i])));
                                    } else {
                                        $data->setBothSwabcovidDate($columns['both_swabcovid_date'][$i]);
                                        array_push($field, ['field' => 'both_swabcovid_date']);
                                    }
                                } else {
                                    $data->setBothSwabcovidDate(null);
                                }
                                if ($columns['both_swabcovid_date'][$i] == null && ($columns['both_swabcovid_date_unknow'][$i] == null || $columns['both_swabcovid_date_unknow'][$i] == 0)) {
                                    array_push($field, ['field' => 'both_swabcovid_date_unknow']);
                                } elseif ($columns['both_swabcovid_date'][$i] != null && $columns['both_swabcovid_date_unknow'][$i] == 1) {
                                    array_push($field, ['field' => 'both_swabcovid_date_unknow']);
                                }
                            } else {
                                $data->setBothSwabcovidDate(null);
                                $data->setBothSwabcovidDateUnknow(null);
                            }

                            if (array_key_exists("both_lab2_enterovirus", $columns)) {
                                $data->setBothLab2Enterovirus($columns['both_lab2_enterovirus'][$i]);
                                if ($columns['both_lab2_enterovirus'][$i] != null && !in_array($columns['both_lab2_enterovirus'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_enterovirus']);
                                }
                            }
                            if (array_key_exists("both_lab2_enterovirus_yesno", $columns)) {
                                $data->setBothLab2EnterovirusYesno($columns['both_lab2_enterovirus_yesno'][$i]);
                                if ($columns['both_lab2_enterovirus_yesno'][$i] != null && !in_array($columns['both_lab2_enterovirus_yesno'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_enterovirus_yesno']);
                                }
                            }
                            if (array_key_exists("both_lab2_merscov", $columns)) {
                                $data->setBothLab2Merscov($columns['both_lab2_merscov'][$i]);
                                if ($columns['both_lab2_merscov'][$i] != null && !in_array($columns['both_lab2_merscov'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_merscov']);
                                }
                            }
                            if (array_key_exists("both_lab2_merscov_yesno", $columns)) {
                                $data->setBothLab2MerscovYesno($columns['both_lab2_merscov_yesno'][$i]);
                                if ($columns['both_lab2_merscov_yesno'][$i] != null && !in_array($columns['both_lab2_merscov_yesno'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_merscov_yesno']);
                                }
                            }
                            if (array_key_exists("both_lab2_picornavirus", $columns)) {
                                $data->setBothLab2Picornavirus($columns['both_lab2_picornavirus'][$i]);
                                if ($columns['both_lab2_picornavirus'][$i] != null && !in_array($columns['both_lab2_picornavirus'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_picornavirus']);
                                }
                            }
                            if (array_key_exists("both_lab2_picornavirus_yesno", $columns)) {
                                $data->setBothLab2PicornavirusYesno($columns['both_lab2_picornavirus_yesno'][$i]);
                                if ($columns['both_lab2_picornavirus_yesno'][$i] != null && !in_array($columns['both_lab2_picornavirus_yesno'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_picornavirus_yesno']);
                                }
                            }
                            if (array_key_exists("both_lab2_sarscov", $columns)) {
                                $data->setBothLab2Sarscov($columns['both_lab2_sarscov'][$i]);
                                if ($columns['both_lab2_sarscov'][$i] != null && !in_array($columns['both_lab2_sarscov'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_sarscov']);
                                }
                            }
                            if (array_key_exists("both_lab2_sarscov_yesno", $columns)) {
                                $data->setBothLab2SarscovYesno($columns['both_lab2_sarscov_yesno'][$i]);
                                if ($columns['both_lab2_sarscov_yesno'][$i] != null && !in_array($columns['both_lab2_sarscov_yesno'][$i], [0, 1])) {
                                    array_push($field, ['field' => 'both_lab2_sarscov_yesno']);
                                }
                            }

                            if (array_key_exists("both_sample_submited_influenza", $columns) && $columns['both_sample_submited_influenza'][$i] != null) {
                                if (array_key_exists("both_epi_isl_influenza", $columns) && $columns['both_epi_isl_influenza'][$i] != null) {
                                    if ((preg_match("/^EPI_ISL_[0-9]{8}$/", $columns['both_epi_isl_influenza'][$i])) && (strlen($columns['both_epi_isl_influenza'][$i])) == 16) {
                                        $data->setBothSampleSubmitedInfluenza($columns['both_sample_submited_influenza'][$i]);
                                        $data->setBothEpiIslInfluenza($columns['both_epi_isl_influenza'][$i]);
                                    } else {
                                        $data->setBothEpiIslInfluenza($columns['both_epi_isl_influenza'][$i]);
                                        $data->setBothSampleSubmitedInfluenza($columns['both_sample_submited_influenza'][$i]);
                                        $field[] = ['field' => 'both_epi_isl_influenza'];
                                    }
                                } else {
                                    $data->setBothSampleSubmitedInfluenza($columns['both_sample_submited_influenza'][$i]);
                                    $data->setBothEpiIslInfluenza(null);
                                }
                            } else {
                                $data->setBothSampleSubmitedInfluenza(null);
                                $data->setBothEpiIslInfluenza(null);
                            }
                            if (array_key_exists("both_sample_submited_sars_cov2", $columns) && $columns['both_sample_submited_sars_cov2'][$i] != null) {
                                if (array_key_exists("both_epi_isl_sars_cov2", $columns) && $columns['both_epi_isl_sars_cov2'][$i] != null) {
                                    if ((preg_match("/^EPI_ISL_[0-9]{8}$/", $columns['both_epi_isl_sars_cov2'][$i])) && (strlen($columns['both_epi_isl_sars_cov2'][$i])) == 16) {
                                        $data->setBothSampleSubmitedSarsCov2($columns['both_sample_submited_sars_cov2'][$i]);
                                        $data->setBothEpiIslSarsCov2($columns['both_epi_isl_sars_cov2'][$i]);
                                    } else {
                                        $data->setBothEpiIslSarsCov2($columns['both_epi_isl_sars_cov2'][$i]);
                                        $data->setBothSampleSubmitedSarsCov2($columns['both_sample_submited_sars_cov2'][$i]);
                                        $field[] = ['field' => 'both_epi_isl_sars_cov2'];
                                    }
                                } else {
                                    $data->setBothSampleSubmitedSarsCov2($columns['both_sample_submited_sars_cov2'][$i]);
                                    $data->setBothEpiIslSarsCov2(null);
                                }
                            } else {
                                $data->setBothSampleSubmitedSarsCov2(null);
                                $data->setBothEpiIslSarsCov2(null);
                            }
                            if (array_key_exists("both_sample_submited_rsv", $columns) && $columns['both_sample_submited_rsv'][$i] != null) {
                                if (array_key_exists("both_epi_isl_rsv", $columns) && $columns['both_epi_isl_rsv'][$i] != null) {
                                    if ((preg_match("/^EPI_ISL_[0-9]{8}$/", $columns['both_epi_isl_rsv'][$i])) && (strlen($columns['both_epi_isl_rsv'][$i])) == 16) {
                                        $data->setBothEpiIslRsv($columns['both_epi_isl_rsv'][$i]);
                                        $data->setBothSampleSubmitedRsv($columns['both_sample_submited_rsv'][$i]);
                                    } else {
                                        $data->setBothEpiIslRsv($columns['both_epi_isl_rsv'][$i]);
                                        $data->setBothSampleSubmitedRsv($columns['both_sample_submited_rsv'][$i]);
                                        $field[] = ['field' => 'both_epi_isl_rsv'];
                                    }
                                } else {
                                    $data->setBothSampleSubmitedRsv($columns['both_sample_submited_rsv'][$i]);
                                    $data->setBothEpiIslRsv(null);
                                }
                            } else {
                                $data->setBothSampleSubmitedRsv(null);
                                $data->setBothEpiIslRsv(null);
                            }

                            $data->setTocalculate(1);

                            if (count($field) > 0) {
                                array_push($wrongFieldsInFile, ['line' => $i + 2, 'fields' => $field]);
                            }
                            $this->em->persist($data);
                            unset($data);
                        }
                    }


                    // if we find variables that do not respect the given formats, we generate a file containing the list of these variables, and the user can download it .
                    if (count($wrongFieldsInFile) > 0) {
                        $pageTitle = "WRONG_DATA_IMPORT_EXCEL_FILE";
                        $header = array('line', 'fields');
                        $filename = $pageTitle . '_' . (new \DateTime())->format('d_m_Y_H_i') . '.xlsx';
                        $spreadsheet = new Spreadsheet();
                        $Excel_writer = new Xlsx($spreadsheet);
                        $spreadsheet->setActiveSheetIndex(0);
                        $activeSheet = $spreadsheet->getActiveSheet();

                        $col = 0;
                        foreach ($header as $key => $label) {
                            $activeSheet->setCellValue($this->functions->excelCellName($col) . '1', $label);
                            $col++;
                        }
                        $row = 2;
                        foreach ($wrongFieldsInFile as $line) {
                            $col = 0;
                            foreach ($header as $key => $label) {
                                if (is_array($line[$label])) {
                                    $value = "";
                                    foreach ($line[$label] as $item) {
                                        $value = $value . $item['field'] . ', ';
                                    }
                                } else {
                                    $value = $line[$label];
                                }
                                $activeSheet->setCellValue($this->functions->excelCellName($col) . $row, $value);
                                $col++;
                            }
                            $row++;
                        }
                        header('Content-Type: application/vnd.ms-excel');
                        header('Cache-Control: max-age=0');
                        $Excel_writer->save($this->getParameter('absolute_import_directory') . '/' . $filename);
                    }

                    // here we are going to check the season is it verified we are going to move the file data to the specific directory
                    // and we insert the data to the DB

                    if ($seasonVerif) {
                        try {
                            $file->move(
                                $this->getParameter('absolute_upload_data_directory'),
                                $newFilename
                            );
                        } catch (FileException $e) {
                            $status = 500;
                            $message = "An error occurred while uploading!";
                        }
                        // save the action of importing to the table historic
                        $this->globalServices->saveHistoric($this->getUser(), "Importing data", 2);

                        $this->em->flush();
                        // after adding the data to DB, we call the function runSQLAction to calculate and update variables in DB
                        $this->forward("App\Controller\VariableController::runSQLAction")->getContent();
                    } else {
                        $status = 500;
                        $message = "Please check if the file contains data and season greater than 2021";
                    }
                }
            } else {
                $status = 500;
                $message = "Empty file uploded!";
            }
        } else {
            $status = 500;
            $message = "Only CSV files are allowed!";
        }

        return new JsonResponse(array(
            'status' => $status,
            'listWrongFields' => $wrongFieldsInFile,
            'file' => count($wrongFieldsInFile) > 0 ? $this->getParameter('relative_import_directory') . "/" . $filename : null,
            'message' => $message
        ));
    }

    /**
     * @Route("/data_export/{email}",defaults={"email" = null}, name="data_data_export")
     */
    public function exportExcelDatatable(Request $request)
    {
        if (!$this->getUser()->getManager()) {
            $this->addFlash('danger', "This page is accessible only by platform administrators!");
            return $this->redirectToRoute('error_page');
        }

        set_time_limit(7200);
        ini_set('memory_limit', '-1');
        ini_set("max-execution_time", 0);

        $filters = $request->query->get('filters');

        $datasExport = $this->em->getRepository(Data::class)->dataExport($filters);

        $keys = array_keys($datasExport[0][0]);
        array_push($keys, "zone");
        $pageTitle = "data_list";
        $header = array();
        $headerBd = array();

        foreach ($keys as $key) {
            $headerBd[$key] = $key;
        }
        foreach ($keys as $key) {
            if ($key == "fluVac201011") {
                $header["flu_vac_2010_11"] = "flu_vac_2010_11";
            } elseif ($key == "fluVac201112") {
                $header["flu_vac_2011_12"] = "flu_vac_2011_12";
            } elseif ($key == "fluVac201213") {
                $header["flu_vac_2012_13"] = "flu_vac_2012_13";
            } elseif ($key == "fluVac201314") {
                $header["flu_vac_2013_14"] = "flu_vac_2013_14";
            } elseif ($key == "fluVac201415") {
                $header["flu_vac_2014_15"] = "flu_vac_2014_15";
            } elseif ($key == "fluVac201516") {
                $header["flu_vac_2015_16"] = "flu_vac_2015_16";
            } elseif ($key == "fluVac201617") {
                $header["flu_vac_2016_17"] = "flu_vac_2016_17";
            } elseif ($key == "fluVac201718") {
                $header["flu_vac_2017_18"] = "flu_vac_2017_18";
            } elseif ($key == "fluVac201819") {
                $header["flu_vac_2018_19"] = "flu_vac_2018_19";
            } elseif ($key == "fluVac201920") {
                $header["flu_vac_2019_20"] = "flu_vac_2019_20";
            } elseif ($key == "fluVac202021") {
                $header["flu_vac_2020_21"] = "flu_vac_2020_21";
            } elseif ($key == "fluVac202122") {
                $header["flu_vac_2021_22"] = "flu_vac_2021_22";
            } elseif ($key == "fluVac202223") {
                $header["flu_vac_2022_23"] = "flu_vac_2022_23";
            } elseif ($key == "fluVac202324") {
                $header["flu_vac_2023_24"] = "flu_vac_2023_24";
            } elseif ($key == "fluVac202425") {
                $header["flu_vac_2024_25"] = "flu_vac_2024_25";
            } elseif ($key == "fluVac202627") {
                $header["flu_vac_2026_27"] = "flu_vac_2026_27";
            } elseif ($key == "consul3m") {
                $header["consul_3m"] = "consul_3m";
            } elseif ($key == "compIli7d") {
                $header["comp_ili_7d"] = "comp_ili_7d";
            } elseif ($key == "sym7dYn") {
                $header["sym_7d_yn"] = "sym_7d_yn";
            } elseif ($key == "bothVac14dBeforeIliSym") {
                $header["both_vac_14d_before_ili_sym"] = "both_vac_14d_before_ili_sym";
            } elseif ($key == "hosp12m") {
                $header["hosp_12m"] = "hosp_12m";
            } elseif ($key == "ohcTechSeaId") {
                $header["OHC_TECH_SEA_ID"] = "OHC_TECH_SEA_ID";
            } elseif ($key == "ohcTechIdintegration") {
                $header["OHC_TECH_IdIntegration"] = "OHC_TECH_IdIntegration";
            } elseif ($key == "ohcTechId") {
                $header["OHC_TECH_ID"] = "OHC_TECH_ID";
            } else {
                $key = strtolower(preg_replace('/([A-Z])/', '_$1', $key));
                $header[$key] = $key;
            }

        }

        unset($header["id"]);
        unset($headerBd["id"]);
        $body = array();
        foreach ($datasExport as $dataExport) {
            $dataExport[0]["zone"] = $dataExport["zone"];
            array_push($body, $dataExport[0]);
        }
        $spreadsheet = new Spreadsheet();
        $Excel_writer = new Xlsx($spreadsheet);
        $spreadsheet->setActiveSheetIndex(0);
        $activeSheet = $spreadsheet->getActiveSheet();

        $col = 0;
        foreach ($header as $key => $label) {
            $activeSheet->setCellValue($this->globalServices->functions->excelCellName($col) . '1', $label);
            $col++;
        }
        $row = 2;
        foreach ($body as $line) {
            $col = 0;
            foreach ($headerBd as $key => $label) {
                $value = $line[$key];
                if (strpos($value, "</span>") > 0) {
                    $value = substr($value, strpos($value, '">') + 2, -7);
                }
                $activeSheet->setCellValue($this->functions->excelCellName($col) . $row, $value);
                $col++;
            }
            $row++;
        }
        $filename = $pageTitle . '_' . (new \DateTime())->format('d_m_Y_H_i_s') . '.xlsx';
        $email = $request->get('email');
        $fullName = $this->getUser()->getManager()->getFullName();
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $filename);
        header('Cache-Control: max-age=0');
        $Excel_writer->save($this->getParameter('absolute_upload_export_data_directory') . '/' . $filename);
        $this->emailsTemplateSender->email_send_export($request->getSchemeAndHttpHost() . '/public/uploads/export/' . $filename, $email, $fullName);
        exit();
    }

    /**
     * @Route("/export", name="data_export")
     */
    public function exctCurl(Request $request)
    {
        // verify the user connected
        if (!$this->getUser()->getManager()) {
            $this->addFlash('danger', "This page is accessible only by platform administrators!");
            return $this->redirectToRoute('error_page');
        }
        // save in the historic the action
        $this->globalServices->saveHistoric($this->getUser(), "Exporting data", 1);
        // get the request to execute and change her state in progress
        $demand = $this->em->getRepository(Demand::class)->find($request->request->get("id"));
        $demand->setState(DemandDbal::PROGRESS);
        $this->em->persist($demand);
        $this->em->flush();

        // get the details of the demand to be excuted
        $filters = array();
        $filters["season"] = explode(',', $demand->getSeason());
        $filters["zone"] = explode(',', $demand->getZone());
        $filters["age"] = $demand->getAge();

        $query = http_build_query(array('filters' => $filters));
        $query = urldecode($query);
        $url = $request->getSchemeAndHttpHost() . '/data/data_export/' . $demand->getUser()->getEmail() . '?' . $query;

        // initialize the curl
        $init = curl_init();
        curl_setopt_array($init, [CURLOPT_URL => $url, CURLOPT_TIMEOUT_MS => 10, CURLOPT_RETURNTRANSFER => TRUE]);
        curl_exec($init);
        curl_close($init);

        return new JsonResponse(array(
            'status' => 200,
            'message' => 'An email will be sent when the export is ready'
        ));
    }


    /**
     * Description :: delete a file data
     * NOTE : when we delete a file, all data related to that file will be deleted
     * @Route("/data_file_delete_ajax", name="data_file_delete_ajax")
     */
    public function deleteAjax(Request $request)
    {
        // verify the connected user
        if (!$this->getUser()->getManager()) {
            $this->addFlash('danger', "This page is accessible only by platform administrators!");
            return $this->redirectToRoute('error_page');
        }

        // get the data file to delete and verify if the file exist or not . if exist we delete from list file
        $dataFile = $this->em->getRepository(DataFile::class)->find($request->request->get("id"));
        if ($dataFile->getFileName() && file_exists($this->getParameter('absolute_upload_data_directory') . "/" . $dataFile->getFileName())) {
            unlink($this->getParameter('absolute_upload_data_directory') . "/" . $dataFile->getFileName());
        }
        $this->em->remove($dataFile);
        $this->em->flush();

        return new JsonResponse(array(
            'status' => 200,
            'message' => "File deleted successfully."
        ));
    }

    /**
     * Description :: data detail
     * @Route("/data_detail", name="data_detail")
     */
    public function dataDetail()
    {
        // check if the user changed his password and validated the cgu before redirection to list data
        if ($this->getUser()->getVisitor() && !$this->getUser()->getVisitor()->getValidateCgu()) {
            if ($this->getUser()->getTemporaryPassword()) {
                return $this->redirectToRoute('edit_password');
            } else {
                $this->addFlash('danger', "You must accept the terms and conditions and the privacy policy!");
                return $this->redirectToRoute('home');
            }

        }
        return $this->render('data/detail.html.twig', []);
    }

    /**
     * Description :: get the list of season to the page questionnaires and protocols
     * @Route("/season_list", name="season_list")
     */
    public function SeasonList(Request $request, DataTableFactory $dataTableFactory)
    {
        // check if the user changed his password and validated the cgu before redirection to list data
        if ($this->getUser()->getVisitor() && !$this->getUser()->getVisitor()->getValidateCgu()) {
            if ($this->getUser()->getTemporaryPassword()) {
                return $this->redirectToRoute('edit_password');
            } else {
                $this->addFlash('danger', "You must accept the terms and conditions and the privacy policy!");
                return $this->redirectToRoute('home');
            }

        }
        $datatable = $dataTableFactory->create([])
            ->createAdapter(ArrayAdapter::class, $this->em->getRepository(Data::class)->seasonListProtocol())
            ->add('season', TextColumn::class, [
                'label' => 'Season',
            ])
            ->add('pdfProtocole', TextColumn::class, [
                'label' => 'Protocole',
                'raw' => true,
                'className' => 'dt-action-btns',
                'render' => function ($value, $entity) {
                    // the variable $seasonFormat contains the full season with year like 20_21 => 2020_2021
                    $seasonFormat = explode('_', $entity['season']);
                    $buttons = "";
                    // retrieve the file if it exists in the list of files to download it
                    if (file_exists($this->getParameter('absolute_upload_protocol_directory') . "/GIHSN_Core_Protocol_20" . $seasonFormat[0] . "_20" . $seasonFormat[1] . ".pdf") == true) {
                        $buttons .= '<a href= "' . $this->getParameter('relative_upload_protocol_directory') . "/GIHSN_Core_Protocol_20" . $seasonFormat[0] . "_20" . $seasonFormat[1] . '.pdf" download="GIHSN Core Protocol 20' . $seasonFormat[0] . '-20' . $seasonFormat[1] . '.pdf" class="ml-2 text-primary" title="Download" target="_blank">
                                    <i class="fa-solid fa-file-pdf"></i></a>';
                    } else {
                        $buttons .= '<a href= "javascript:;" class="ml-2 text-primary disabled" title="Not found" target="_blank"><i class="fa-solid fa-file-pdf"></i> </a>';
                    }
                    return sprintf($buttons);
                }
            ])
            ->add('pdfQuestionnaires', TextColumn::class, [
                'label' => 'Questionnaires',
                'raw' => true,
                'className' => 'dt-action-btns',
                'render' => function ($value, $entity) {
                    // the variable $seasonFormat contains the full season with year like 20_21 => 2020_2021
                    $seasonFormat = explode('_', $entity['season']);
                    $buttons = "";
                    // retrieve the file if it exists in the list of files to download it
                    if (file_exists($this->getParameter('absolute_upload_protocol_directory') . "/GIHSN_ALL_AGES_QUESTIONNAIRE_20" . $seasonFormat[0] . "_20" . $seasonFormat[1] . ".pdf") == true) {
                        $buttons .= '<a href= "' . $this->getParameter('relative_upload_protocol_directory') . "/GIHSN_ALL_AGES_QUESTIONNAIRE_20" . $seasonFormat[0] . "_20" . $seasonFormat[1] . '.pdf" download="GIHSN ALL AGES QUESTIONNAIRE 20' . $seasonFormat[0] . "-20" . $seasonFormat[1] . '.pdf" class="ml-2 text-primary" title="Download" target="_blank">
                                    <i class="fa-solid fa-file-pdf"></i></a>';
                    } else {
                        if (file_exists($this->getParameter('absolute_upload_protocol_directory') . "/GIHSN_QUESTIONNAIRE_LESS_THAN_5_20" . $seasonFormat[0] . "_20" . $seasonFormat[1] . ".pdf") == true) {
                            $buttons .= '<a href= "' . $this->getParameter('relative_upload_protocol_directory') . "/GIHSN_QUESTIONNAIRE_LESS_THAN_5_20" . $seasonFormat[0] . "_20" . $seasonFormat[1] . '.pdf" download="GIHSN QUESTIONNAIRE LESS THAN 5 20' . $seasonFormat[0] . "-20" . $seasonFormat[1] . '.pdf" class="ml-2 text-primary" title="Download" target="_blank">
                                    <i class="fa-solid fa-file-pdf"></i></a>';
                        } else {
                            $buttons .= '<a href= "javascript:;" class="ml-2 text-primary disabled" title="Not found"><i class="fa-solid fa-file-pdf"></i> </a>';
                        }
                        if (file_exists($this->getParameter('absolute_upload_protocol_directory') . "/GIHSN_QUESTIONNAIRE_MORE_THAN_5_20" . $seasonFormat[0] . "_20" . $seasonFormat[1] . ".pdf") == true) {
                            $buttons .= '<a href= "' . $this->getParameter('relative_upload_protocol_directory') . "/GIHSN_QUESTIONNAIRE_MORE_THAN_5_20" . $seasonFormat[0] . "_20" . $seasonFormat[1] . '.pdf" download="GIHSN QUESTIONNAIRE MORE THAN 5 20' . $seasonFormat[0] . "-20" . $seasonFormat[1] . '.pdf" class="ml-2 text-primary" title="Download" target="_blank">
                                    <i class="fa-solid fa-file-pdf"></i></a>';
                        } else {
                            $buttons .= '<a href= "javascript:;" class="ml-2 text-primary disabled" title="Not found"><i class="fa-solid fa-file-pdf"></i> </a>';
                        }
                    }
                    return sprintf($buttons);
                }
            ])
            ->handleRequest($request);

        if ($datatable->isCallback()) {
            return $datatable->getResponse();
        }

        return $this->render('data/season_list.html.twig', [
            'datatable' => $datatable,
        ]);
    }

    /**
     * Description :: verify the format of the all fields and restore in a table with their occurrence identifiers
     * @Route("/field-occurrence-list", name="check_format_fields")
     */
    public function checkFieldsFormat(Request $request)
    {
        set_time_limit(7200);
        ini_set('memory_limit', '-1');
        ini_set("max-execution_time", 0);


        $result = [];
        $nbLinesInDataSQL = 'SELECT COUNT(id) AS nbLines FROM data';
        $nbLinesResult = $this->conn->fetchAll($nbLinesInDataSQL);
        $nbLinesInData = $nbLinesResult[0]['nbLines'];

        // 1- VAR both_comp_a_diag
        $both_comp_a_diagSQL = 'SELECT id  FROM data WHERE both_comp_a_diag NOT IN (0,1) OR both_comp_a_diag IS NULL';
        $both_comp_a_diagResult = $this->conn->fetchAll($both_comp_a_diagSQL);
        array_push($result, ['field' => 'both_comp_a_diag', 'nbErrorOccurrences' => $both_comp_a_diagResult ? count($both_comp_a_diagResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_comp_a_diagResult ? $both_comp_a_diagResult : []]);

        // 2- VAR both_a_diag_icd
        $both_a_diag_icdSQL = 'SELECT id FROM data WHERE both_a_diag_icd NOT IN (0,1) OR both_a_diag_icd != NULL';
        $both_a_diag_icdResult = $this->conn->fetchAll($both_a_diag_icdSQL);
        array_push($result, ['field' => 'both_a_diag_icd', 'nbErrorOccurrences' => $both_a_diag_icdResult ? count($both_a_diag_icdResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_a_diag_icdResult ? $both_a_diag_icdResult : []]);

        // 3 - var both_a_diag
        $both_a_diagSQL = "SELECT id , both_a_diag FROM data WHERE both_a_diag IS NOT NULL";
        $both_a_diagResult = $this->conn->fetchAll($both_a_diagSQL);
        $nbErrorOccurrences = 0;
        $errorIds = [];
        foreach ($both_a_diagResult as $item) {
            if ($item['both_a_diag'] && !empty($item['both_a_diag'])) {
                $replace = array('[', ']', '"', ' ', "'");
                $data = str_replace($replace, "", $item['both_a_diag']);
                $result_both_a_diag = explode(',', $data);
                if (count($result_both_a_diag) == 1) {
                    if (!preg_match('/^[0-9]{3}$|^[A-Z]{1}[0-9]{2}$|^[0-9]{3}[.][0-9]{1,2}$|^[A-Z]{1}[0-9]{2}[.][0-9]{1,2}$/', $result_both_a_diag[0])) {
                        $nbErrorOccurrences += 1;
                        array_push($errorIds, ['id' => $item['id']]);
                    }
                } elseif (count($result_both_a_diag) > 1) {
                    foreach ($result_both_a_diag as $i) {
                        if (!preg_match('/^[0-9]{3}$|^[A-Z]{1}[0-9]{2}$|^[0-9]{3}[.][0-9]{1,2}$|^[A-Z]{1}[0-9]{2}[.][0-9]{1,2}$/', $i)) {
                            $nbErrorOccurrences += 1;
                            array_push($errorIds, ['id' => $item['id']]);
                        }
                    }
                }

            }
        }
        array_push($result, ['field' => 'both_a_diag', 'nbErrorOccurrences' => $nbErrorOccurrences . '/' . $nbLinesInData, 'errorIds' => $errorIds ? array_unique($errorIds, SORT_REGULAR) : []]);

        // 4- VAR both_a_diag_unknow
        $both_a_diag_unknowSQL = 'SELECT id  FROM data WHERE both_a_diag_unknow != 1 OR both_a_diag_unknow != NULL';
        $both_a_diag_unknowResult = $this->conn->fetchAll($both_a_diag_unknowSQL);
        array_push($result, ['field' => 'both_a_diag_unknow', 'nbErrorOccurrences' => $both_a_diag_unknowResult ? count($both_a_diag_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_a_diag_unknowResult ? $both_a_diag_unknowResult : []]);

        // 5- VAR both_case_identified_based_logs_respiratory
        $both_case_identified_based_logs_respiratorySQL = 'SELECT id  FROM data WHERE both_case_identified_based_logs_respiratory NOT IN (0,1) OR both_case_identified_based_logs_respiratory IS NULL';
        $both_case_identified_based_logs_respiratoryResult = $this->conn->fetchAll($both_case_identified_based_logs_respiratorySQL);
        array_push($result, ['field' => 'both_case_identified_based_logs_respiratory', 'nbErrorOccurrences' => $both_case_identified_based_logs_respiratoryResult ? count($both_case_identified_based_logs_respiratoryResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_case_identified_based_logs_respiratoryResult ? $both_case_identified_based_logs_respiratoryResult : []]);

//        // 6- VAR both_case_identified_based_positive_swab
//        $both_case_identified_based_positive_swabSQL = 'SELECT id  FROM data WHERE both_case_identified_based_positive_swab NOT IN (0,1) OR both_case_identified_based_positive_swab IS NULL';
//        $both_case_identified_based_positive_swabResult = $this->conn->fetchAll($both_case_identified_based_positive_swabSQL);
//        array_push($result, ['field' => 'both_case_identified_based_positive_swab', 'nbErrorOccurrences' => $both_case_identified_based_positive_swabResult ? count($both_case_identified_based_positive_swabResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_case_identified_based_positive_swabResult ? $both_case_identified_based_positive_swabResult : []]);

        // 6- VAR both_case_identified_based_testing
        $both_case_identified_based_testingSQL = 'SELECT id  FROM data WHERE both_case_identified_based_testingResult NOT IN (0,1) OR both_case_identified_based_testing IS NULL';
        $both_case_identified_based_testingResult = $this->conn->fetchAll($both_case_identified_based_testingSQL);
        array_push($result, ['field' => 'both_case_identified_based_testing', 'nbErrorOccurrences' => $both_case_identified_based_testingResult ? count($both_case_identified_based_testingResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_case_identified_based_testingResult ? $both_case_identified_based_testingResult : []]);

        // 7- VAR both_doa
        $both_doaSQL = "SELECT id FROM data WHERE both_doa NOT REGEXP '^[0-9]{1,2}\\/[0-9]{1,2}\\/[0-9]{4}$' OR both_doa IS NULL OR LENGTH(both_doa) = 0";
        $both_doaResult = $this->conn->fetchAll($both_doaSQL);
        array_push($result, ['field' => 'both_doa', 'nbErrorOccurrences' => $both_doaResult ? count($both_doaResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_doaResult ? $both_doaResult : []]);

        // 8- VAR both_id_hospital
        $both_id_hospitalSQL = 'SELECT id FROM data WHERE  both_id_hospital IS NULL OR LENGTH(both_id_hospital) = 0';
        $both_id_hospitalResult = $this->conn->fetchAll($both_id_hospitalSQL);
        array_push($result, ['field' => 'both_id_hospital', 'nbErrorOccurrences' => $both_id_hospitalResult ? count($both_id_hospitalResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_id_hospitalResult ? $both_id_hospitalResult : []]);

        // 9- VAR both_id_patient
        $both_id_patientSQL = 'SELECT id FROM data WHERE  both_id_patient IS NULL OR LENGTH(both_id_patient) = 0';
        $both_id_patientResult = $this->conn->fetchAll($both_id_patientSQL);
        array_push($result, ['field' => 'both_id_patient', 'nbErrorOccurrences' => $both_id_patientResult ? count($both_id_patientResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_id_patientResult ? $both_id_patientResult : []]);

        // 10- VAR both_sex
        $both_sexSQL = 'SELECT id FROM data WHERE both_sex NOT IN (0,1) OR both_sex IS NULL OR LENGTH(both_sex) = 0';
        $both_sexResult = $this->conn->fetchAll($both_sexSQL);
        array_push($result, ['field' => 'both_sex', 'nbErrorOccurrences' => $both_sexResult ? count($both_sexResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_sexResult ? $both_sexResult : []]);

        // 11- VAR both_age
        $both_ageSQL = 'SELECT id FROM data WHERE both_age IS NULL OR LENGTH(both_age) = 0';
        $both_ageResult = $this->conn->fetchAll($both_ageSQL);
        array_push($result, ['field' => 'both_age', 'nbErrorOccurrences' => $both_ageResult ? count($both_ageResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_ageResult ? $both_ageResult : []]);

        // 12- VAR both_age_unit
        $both_age_unitSQL = 'SELECT id FROM data WHERE both_age_unit NOT IN (1,2,3) OR both_age_unit IS NULL OR LENGTH(both_age_unit) = 0';
        $both_age_unitResult = $this->conn->fetchAll($both_age_unitSQL);
        array_push($result, ['field' => 'both_age_unit', 'nbErrorOccurrences' => $both_age_unitResult ? count($both_age_unitResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_age_unitResult ? $both_age_unitResult : []]);

        // 13- VAR both_ilisystemic_fever
        $both_ilisystemic_feverSQL = 'SELECT id FROM data WHERE both_ilisystemic_fever NOT IN (0,1,2) OR both_ilisystemic_fever IS NULL';
        $both_ilisystemic_feverResult = $this->conn->fetchAll($both_ilisystemic_feverSQL);
        array_push($result, ['field' => 'both_ilisystemic_fever', 'nbErrorOccurrences' => $both_ilisystemic_feverResult ? count($both_ilisystemic_feverResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_ilisystemic_feverResult ? $both_ilisystemic_feverResult : []]);

        // 14- VAR both_ilisystemic_malaise
        $both_ilisystemic_malaiseSQL = 'SELECT id FROM data WHERE both_ilisystemic_malaise NOT IN (0,1,2) OR both_ilisystemic_malaise IS NULL';
        $both_ilisystemic_malaiseResult = $this->conn->fetchAll($both_ilisystemic_malaiseSQL);
        array_push($result, ['field' => 'both_ilisystemic_malaise', 'nbErrorOccurrences' => $both_ilisystemic_malaiseResult ? count($both_ilisystemic_malaiseResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_ilisystemic_malaiseResult ? $both_ilisystemic_malaiseResult : []]);

        // 15- VAR both_ilisystemic_headache
        $both_ilisystemic_headacheSQL = 'SELECT id FROM data WHERE both_ilisystemic_headache NOT IN (0,1,2) OR both_ilisystemic_headache IS NULL';
        $both_ilisystemic_headacheResult = $this->conn->fetchAll($both_ilisystemic_headacheSQL);
        array_push($result, ['field' => 'both_ilisystemic_headache', 'nbErrorOccurrences' => $both_ilisystemic_headacheResult ? count($both_ilisystemic_headacheResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_ilisystemic_headacheResult ? $both_ilisystemic_headacheResult : []]);

        // 16- VAR both_ilisystemic_myalgia
        $both_ilisystemic_myalgiaSQL = 'SELECT id FROM data WHERE both_ilisystemic_myalgia NOT IN (0,1,2) OR both_ilisystemic_myalgia IS NULL';
        $both_ilisystemic_myalgiaResult = $this->conn->fetchAll($both_ilisystemic_myalgiaSQL);
        array_push($result, ['field' => 'both_ilisystemic_myalgia', 'nbErrorOccurrences' => $both_ilisystemic_myalgiaResult ? count($both_ilisystemic_myalgiaResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_ilisystemic_myalgiaResult ? $both_ilisystemic_myalgiaResult : []]);

        // 17- VAR both_ilirespiratory_cough
        $both_ilirespiratory_coughSQL = 'SELECT id FROM data WHERE both_ilirespiratory_cough NOT IN (0,1,2) OR both_ilirespiratory_cough IS NULL';
        $both_ilirespiratory_coughResult = $this->conn->fetchAll($both_ilirespiratory_coughSQL);
        array_push($result, ['field' => 'both_ilirespiratory_cough', 'nbErrorOccurrences' => $both_ilirespiratory_coughResult ? count($both_ilirespiratory_coughResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_ilirespiratory_coughResult ? $both_ilirespiratory_coughResult : []]);

        // 18- VAR both_ilirespiratory_sorethroat
        $both_ilirespiratory_sorethroatSQL = 'SELECT id FROM data WHERE both_ilirespiratory_sorethroat NOT IN (0,1,2) OR both_ilirespiratory_sorethroat IS NULL';
        $both_ilirespiratory_sorethroatResult = $this->conn->fetchAll($both_ilirespiratory_sorethroatSQL);
        array_push($result, ['field' => 'both_ilirespiratory_sorethroat', 'nbErrorOccurrences' => $both_ilirespiratory_sorethroatResult ? count($both_ilirespiratory_sorethroatResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_ilirespiratory_sorethroatResult ? $both_ilirespiratory_sorethroatResult : []]);

        // 19- VAR both_ilirespiratory_shortnessbreath
        $both_ilirespiratory_shortnessbreathSQL = 'SELECT id FROM data WHERE both_ilirespiratory_shortnessbreath NOT IN (0,1,2) OR both_ilirespiratory_shortnessbreath IS NULL';
        $both_ilirespiratory_shortnessbreathResult = $this->conn->fetchAll($both_ilirespiratory_shortnessbreathSQL);
        array_push($result, ['field' => 'both_ilirespiratory_shortnessbreath', 'nbErrorOccurrences' => $both_ilirespiratory_shortnessbreathResult ? count($both_ilirespiratory_shortnessbreathResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_ilirespiratory_shortnessbreathResult ? $both_ilirespiratory_shortnessbreathResult : []]);

        // 20- VAR both_ilirespiratory_wheezing
        $both_ilirespiratory_wheezingSQL = 'SELECT id FROM data WHERE both_ilirespiratory_wheezing NOT IN (0,1,2) OR both_ilirespiratory_wheezing IS NULL';
        $both_ilirespiratory_wheezingResult = $this->conn->fetchAll($both_ilirespiratory_wheezingSQL);
        array_push($result, ['field' => 'both_ilirespiratory_wheezing', 'nbErrorOccurrences' => $both_ilirespiratory_wheezingResult ? count($both_ilirespiratory_wheezingResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_ilirespiratory_wheezingResult ? $both_ilirespiratory_wheezingResult : []]);

        // 21- VAR both_ilirespiratory_nasalcongestion
        $both_ilirespiratory_nasalcongestionSQL = 'SELECT id  FROM data WHERE both_ilirespiratory_nasalcongestion NOT IN (0,1,2) OR both_ilirespiratory_nasalcongestion IS NULL';
        $both_ilirespiratory_nasalcongestionResult = $this->conn->fetchAll($both_ilirespiratory_nasalcongestionSQL);
        array_push($result, ['field' => 'both_ilirespiratory_nasalcongestion', 'nbErrorOccurrences' => $both_ilirespiratory_nasalcongestionResult ? count($both_ilirespiratory_nasalcongestionResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_ilirespiratory_nasalcongestionResult ? $both_ilirespiratory_nasalcongestionResult : []]);

        // 22- VAR both_case_definition_used
        $both_case_definition_usedSQL = 'SELECT id  FROM data WHERE both_case_definition_used NOT IN (1,2,3,4,5,6,7) OR both_case_definition_used IS NULL OR LENGTH(both_case_definition_used) =0';
        $both_case_definition_usedResult = $this->conn->fetchAll($both_case_definition_usedSQL);
        array_push($result, ['field' => 'both_case_definition_used', 'nbErrorOccurrences' => $both_case_definition_usedResult ? count($both_case_definition_usedResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_case_definition_usedResult ? $both_case_definition_usedResult : []]);

////        // 23- VAR both_case_definition_other_detail -- this field is text type , that's mean can support any type of data
////        $both_case_definition_other_detailSQL = 'SELECT id  FROM data WHERE both_case_definition_other_detail ';
////        $both_case_definition_other_detailResult = $this->conn->fetchAll($both_case_definition_other_detailSQL);
////        array_push($result, ['field' => 'both_case_definition_other_detail', 'nbErrorOccurrences' => $both_case_definition_other_detailResult ? count($both_case_definition_other_detailResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_case_definition_other_detailResult ? $both_case_definition_other_detailResult : []]);

        // 24- VAR both_swab_date
        $both_swab_dateSQL = "SELECT id FROM data WHERE both_swab_date NOT REGEXP '^[0-9]{1,2}\\/[0-9]{1,2}\\/[0-9]{4}$' OR both_swab_date IS NULL OR LENGTH(both_swab_date) = 0";
        $both_swab_dateResult = $this->conn->fetchAll($both_swab_dateSQL);
        array_push($result, ['field' => 'both_swab_date', 'nbErrorOccurrences' => $both_swab_dateResult ? count($both_swab_dateResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_swab_dateResult ? $both_swab_dateResult : []]);

        // 25- VAR both_swab_date_unknow
        $both_swab_date_unknowSQL = 'SELECT id  FROM data WHERE both_swab_date_unknow != 1 OR both_swab_date_unknow != NULL';
        $both_swab_date_unknowResult = $this->conn->fetchAll($both_swab_date_unknowSQL);
        array_push($result, ['field' => 'both_swab_date_unknow', 'nbErrorOccurrences' => $both_swab_date_unknowResult ? count($both_swab_date_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_swab_date_unknowResult ? $both_swab_date_unknowResult : []]);

        // 26- VAR both_swabcovid_date
        $both_swabcovid_dateSQL = "SELECT id  FROM data WHERE both_swabcovid_date NOT REGEXP '^[0-9]{1,2}\\/[0-9]{1,2}\\/[0-9]{4}$' OR both_swabcovid_date IS NULL OR LENGTH(both_swabcovid_date) = 0";
        $both_swabcovid_dateResult = $this->conn->fetchAll($both_swabcovid_dateSQL);
        array_push($result, ['field' => 'both_swabcovid_date', 'nbErrorOccurrences' => $both_swabcovid_dateResult ? count($both_swabcovid_dateResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_swabcovid_dateResult ? $both_swabcovid_dateResult : []]);

        // 27- VAR both_swabcovid_date_unknow
        $both_swabcovid_date_unknowSQL = 'SELECT id  FROM data WHERE both_swabcovid_date_unknow != 1 OR both_swabcovid_date_unknow != NULL';
        $both_swabcovid_date_unknowResult = $this->conn->fetchAll($both_swabcovid_date_unknowSQL);
        array_push($result, ['field' => 'both_swabcovid_date_unknow', 'nbErrorOccurrences' => $both_swabcovid_date_unknowResult ? count($both_swabcovid_date_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_swabcovid_date_unknowResult ? $both_swabcovid_date_unknowResult : []]);

        // 28- VAR both_positive_result
        $both_positive_resultSQL = 'SELECT id FROM data WHERE both_positive_result NOT IN (0,1,2) OR both_positive_result IS NULL OR LENGTH(both_positive_result) = 0';
        $both_positive_resultResult = $this->conn->fetchAll($both_positive_resultSQL);
        array_push($result, ['field' => 'both_positive_result', 'nbErrorOccurrences' => $both_positive_resultResult ? count($both_positive_resultResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_positive_resultResult ? $both_positive_resultResult : []]);

        // 29- VAR both_lab_flu_h1n1
        $both_lab_flu_h1n1SQL = 'SELECT id FROM data WHERE both_lab_flu_h1n1 NOT IN (0,1) OR LENGTH(both_lab_flu_h1n1) = 0 OR both_lab_flu_h1n1 != NULL';
        $both_lab_flu_h1n1Result = $this->conn->fetchAll($both_lab_flu_h1n1SQL);
        array_push($result, ['field' => 'both_lab_flu_h1n1', 'nbErrorOccurrences' => $both_lab_flu_h1n1Result ? count($both_lab_flu_h1n1Result) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab_flu_h1n1Result ? $both_lab_flu_h1n1Result : []]);

        // 30- VAR both_lab_flu_h3n2
        $both_lab_flu_h3n2SQL = 'SELECT id  FROM data WHERE both_lab_flu_h3n2 NOT IN (0,1) OR LENGTH(both_lab_flu_h3n2) = 0 OR both_lab_flu_h3n2 != NULL';
        $both_lab_flu_h3n2Result = $this->conn->fetchAll($both_lab_flu_h3n2SQL);
        array_push($result, ['field' => 'both_lab_flu_h3n2', 'nbErrorOccurrences' => $both_lab_flu_h3n2Result ? count($both_lab_flu_h3n2Result) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab_flu_h3n2Result ? $both_lab_flu_h3n2Result : []]);

        // 31- VAR both_lab_flu_yamagata
        $both_lab_flu_yamagataSQL = 'SELECT id  FROM data WHERE both_lab_flu_yamagata NOT IN (0,1) OR LENGTH(both_lab_flu_yamagata) = 0 OR both_lab_flu_yamagata != NULL';
        $both_lab_flu_yamagataResult = $this->conn->fetchAll($both_lab_flu_yamagataSQL);
        array_push($result, ['field' => 'both_lab_flu_yamagata', 'nbErrorOccurrences' => $both_lab_flu_yamagataResult ? count($both_lab_flu_yamagataResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab_flu_yamagataResult ? $both_lab_flu_yamagataResult : []]);

        // 32- VAR both_lab_flu_victoria
        $both_lab_flu_victoriaSQL = 'SELECT id  FROM data WHERE both_lab_flu_victoria NOT IN (0,1) OR LENGTH(both_lab_flu_victoria) = 0 OR both_lab_flu_victoria != NULL';
        $both_lab_flu_victoriaResult = $this->conn->fetchAll($both_lab_flu_victoriaSQL);
        array_push($result, ['field' => 'both_lab_flu_victoria', 'nbErrorOccurrences' => $both_lab_flu_victoriaResult ? count($both_lab_flu_victoriaResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab_flu_victoriaResult ? $both_lab_flu_victoriaResult : []]);

        // VAR both_lab_flu_h1nother
        $both_lab_flu_h1notherSQL = 'SELECT id  FROM data WHERE both_lab_flu_h1nother NOT IN (0,1) OR LENGTH(both_lab_flu_h1nother) = 0 OR both_lab_flu_h1nother != NULL';
        $both_lab_flu_h1notherResult = $this->conn->fetchAll($both_lab_flu_h1notherSQL);
        array_push($result, ['field' => 'both_lab_flu_h1nother', 'nbErrorOccurrences' => $both_lab_flu_h1notherResult ? count($both_lab_flu_h1notherResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab_flu_h1notherResult ? $both_lab_flu_h1notherResult : []]);

        // VAR both_lab_flu_h3nother
        $both_lab_flu_h3notherSQL = 'SELECT id  FROM data WHERE both_lab_flu_h3nother NOT IN (0,1) OR LENGTH(both_lab_flu_h3nother) = 0 OR both_lab_flu_h3nother != NULL';
        $both_lab_flu_h3notherResult = $this->conn->fetchAll($both_lab_flu_h3notherSQL);
        array_push($result, ['field' => 'both_lab_flu_h3nother', 'nbErrorOccurrences' => $both_lab_flu_h3notherResult ? count($both_lab_flu_h3notherResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab_flu_h3notherResult ? $both_lab_flu_h3notherResult : []]);

        // 33- VAR both_lab_flu_a_nosub
        $both_lab_flu_a_nosubSQL = 'SELECT id  FROM data WHERE both_lab_flu_a_nosub NOT IN (0,1) OR LENGTH(both_lab_flu_a_nosub) = 0 OR both_lab_flu_a_nosub != NULL';
        $both_lab_flu_a_nosubResult = $this->conn->fetchAll($both_lab_flu_a_nosubSQL);
        array_push($result, ['field' => 'both_lab_flu_a_nosub', 'nbErrorOccurrences' => $both_lab_flu_a_nosubResult ? count($both_lab_flu_a_nosubResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab_flu_a_nosubResult ? $both_lab_flu_a_nosubResult : []]);

        // 34- VAR both_lab_flu_b_nosub
        $both_lab_flu_b_nosubSQL = 'SELECT id  FROM data WHERE both_lab_flu_b_nosub NOT IN (0,1) OR LENGTH(both_lab_flu_b_nosub) = 0 OR both_lab_flu_b_nosub != NULL';
        $both_lab_flu_b_nosubResult = $this->conn->fetchAll($both_lab_flu_b_nosubSQL);
        array_push($result, ['field' => 'both_lab_flu_b_nosub', 'nbErrorOccurrences' => $both_lab_flu_b_nosubResult ? count($both_lab_flu_b_nosubResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab_flu_b_nosubResult ? $both_lab_flu_b_nosubResult : []]);

        //  35- VAR both_test_other_virus
        $both_test_other_virusSQL = 'SELECT id  FROM data WHERE both_test_other_virus NOT IN (0,1,2) OR both_test_other_virus IS NULL OR LENGTH(both_test_other_virus) = 0';
        $both_test_other_virusResult = $this->conn->fetchAll($both_test_other_virusSQL);
        array_push($result, ['field' => 'both_test_other_virus', 'nbErrorOccurrences' => $both_test_other_virusResult ? count($both_test_other_virusResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_test_other_virusResult ? $both_test_other_virusResult : []]);

        // 36- VAR both_lab2_sarscov2
        $both_lab2_sarscov2SQL = 'SELECT id  FROM data WHERE both_lab2_sarscov2 NOT IN (0,1) OR LENGTH(both_lab2_sarscov2) = 0 OR both_lab2_sarscov2 != NULL';
        $both_lab2_sarscov2Result = $this->conn->fetchAll($both_lab2_sarscov2SQL);
        array_push($result, ['field' => 'both_lab2_sarscov2', 'nbErrorOccurrences' => $both_lab2_sarscov2Result ? count($both_lab2_sarscov2Result) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_sarscov2Result ? $both_lab2_sarscov2Result : []]);

        // 37- VAR both_lab2_sarscov2_yesno
        $both_lab2_sarscov2_yesnoSQL = 'SELECT id FROM data WHERE both_lab2_sarscov2_yesno NOT IN (0,1) OR LENGTH(both_lab2_sarscov2_yesno) = 0 OR both_lab2_sarscov2_yesno != NULL';
        $both_lab2_sarscov2_yesnoResult = $this->conn->fetchAll($both_lab2_sarscov2_yesnoSQL);
        array_push($result, ['field' => 'both_lab2_sarscov2_yesno', 'nbErrorOccurrences' => $both_lab2_sarscov2_yesnoResult ? count($both_lab2_sarscov2_yesnoResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_sarscov2_yesnoResult ? $both_lab2_sarscov2_yesnoResult : []]);

        // VAR both_lab2_evd68
        $both_lab2_evd68SQL = 'SELECT id  FROM data WHERE both_lab2_evd68 NOT IN (0,1) OR LENGTH(both_lab2_evd68) = 0 OR both_lab2_evd68 != NULL';
        $both_lab2_evd68Result = $this->conn->fetchAll($both_lab2_evd68SQL);
        array_push($result, ['field' => 'both_lab2_evd68', 'nbErrorOccurrences' => $both_lab2_evd68Result ? count($both_lab2_evd68Result) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_evd68Result ? $both_lab2_evd68Result : []]);

        // VAR both_lab2_evd68_yesno
        $both_lab2_evd68_yesnoSQL = 'SELECT id FROM data WHERE both_lab2_evd68_yesno NOT IN (0,1) OR LENGTH(both_lab2_evd68_yesno) = 0 OR both_lab2_evd68_yesno != NULL';
        $both_lab2_evd68_yesnoResult = $this->conn->fetchAll($both_lab2_evd68_yesnoSQL);
        array_push($result, ['field' => 'both_lab2_evd68_yesno', 'nbErrorOccurrences' => $both_lab2_evd68_yesnoResult ? count($both_lab2_evd68_yesnoResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_evd68_yesnoResult ? $both_lab2_evd68_yesnoResult : []]);

        // 38- VAR both_lab2_corona
        $both_lab2_coronaSQL = 'SELECT id  FROM data WHERE both_lab2_corona NOT IN (0,1) OR LENGTH(both_lab2_corona) = 0 OR both_lab2_corona != NULL';
        $both_lab2_coronaResult = $this->conn->fetchAll($both_lab2_coronaSQL);
        array_push($result, ['field' => 'both_lab2_corona', 'nbErrorOccurrences' => $both_lab2_coronaResult ? count($both_lab2_coronaResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_coronaResult ? $both_lab2_coronaResult : []]);

        // 39- VAR both_lab2_corona_yesno
        $both_lab2_corona_yesnoSQL = 'SELECT id  FROM data WHERE both_lab2_corona_yesno NOT IN (0,1) OR LENGTH(both_lab2_corona_yesno) = 0 OR both_lab2_corona_yesno != NULL';
        $both_lab2_corona_yesnoResult = $this->conn->fetchAll($both_lab2_corona_yesnoSQL);
        array_push($result, ['field' => 'both_lab2_corona_yesno', 'nbErrorOccurrences' => $both_lab2_corona_yesnoResult ? count($both_lab2_corona_yesnoResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_corona_yesnoResult ? $both_lab2_corona_yesnoResult : []]);

        // 40- VAR both_lab2_metaneumo
        $both_lab2_metaneumoSQL = 'SELECT id  FROM data WHERE both_lab2_metaneumo NOT IN (0,1) OR LENGTH(both_lab2_metaneumo) = 0 OR both_lab2_metaneumo != NULL';
        $both_lab2_metaneumoResult = $this->conn->fetchAll($both_lab2_metaneumoSQL);
        array_push($result, ['field' => 'both_lab2_metaneumo', 'nbErrorOccurrences' => $both_lab2_metaneumoResult ? count($both_lab2_metaneumoResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_metaneumoResult ? $both_lab2_metaneumoResult : []]);

        // 41- VAR both_lab2_metaneumo_yesno
        $both_lab2_metaneumo_yesnoSQL = 'SELECT id  FROM data WHERE both_lab2_metaneumo_yesno NOT IN (0,1) OR LENGTH(both_lab2_metaneumo_yesno) = 0 OR both_lab2_metaneumo_yesno != NULL';
        $both_lab2_metaneumo_yesnoResult = $this->conn->fetchAll($both_lab2_metaneumo_yesnoSQL);
        array_push($result, ['field' => 'both_lab2_metaneumo_yesno', 'nbErrorOccurrences' => $both_lab2_metaneumo_yesnoResult ? count($both_lab2_metaneumo_yesnoResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_metaneumo_yesnoResult ? $both_lab2_metaneumo_yesnoResult : []]);

        // 42- VAR both_lab2_rs
        $both_lab2_rsSQL = 'SELECT id  FROM data WHERE both_lab2_rs NOT IN (0,1) OR LENGTH(both_lab2_rs) = 0 OR both_lab2_rs != NULL';
        $both_lab2_rsResult = $this->conn->fetchAll($both_lab2_rsSQL);
        array_push($result, ['field' => 'both_lab2_rs', 'nbErrorOccurrences' => $both_lab2_rsResult ? count($both_lab2_rsResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_rsResult ? $both_lab2_rsResult : []]);

        // 43- VAR both_lab2_rs_yesno
        $both_lab2_rs_yesnoSQL = 'SELECT id  FROM data WHERE both_lab2_rs_yesno NOT IN (0,1) OR LENGTH(both_lab2_rs_yesno) = 0 OR both_lab2_rs_yesno != NULL';
        $both_lab2_rs_yesnoResult = $this->conn->fetchAll($both_lab2_rs_yesnoSQL);
        array_push($result, ['field' => 'both_lab2_rs_yesno', 'nbErrorOccurrences' => $both_lab2_rs_yesnoResult ? count($both_lab2_rs_yesnoResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_rs_yesnoResult ? $both_lab2_rs_yesnoResult : []]);

        // 44- VAR both_lab2_adeno
        $both_lab2_adenoSQL = 'SELECT id  FROM data WHERE both_lab2_adeno NOT IN (0,1) OR LENGTH(both_lab2_adeno) = 0 OR both_lab2_adeno != NULL';
        $both_lab2_adenoResult = $this->conn->fetchAll($both_lab2_adenoSQL);
        array_push($result, ['field' => 'both_lab2_adeno', 'nbErrorOccurrences' => $both_lab2_adenoResult ? count($both_lab2_adenoResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_adenoResult ? $both_lab2_adenoResult : []]);

        // 45- VAR both_lab2_adeno_yesno
        $both_lab2_adeno_yesnoSQL = 'SELECT id  FROM data WHERE both_lab2_adeno_yesno NOT IN (0,1) OR LENGTH(both_lab2_adeno_yesno) = 0 OR both_lab2_adeno_yesno != NULL';
        $both_lab2_adeno_yesnoResult = $this->conn->fetchAll($both_lab2_adeno_yesnoSQL);
        array_push($result, ['field' => 'both_lab2_adeno_yesno', 'nbErrorOccurrences' => $both_lab2_adeno_yesnoResult ? count($both_lab2_adeno_yesnoResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_adeno_yesnoResult ? $both_lab2_adeno_yesnoResult : []]);

        // 46- VAR both_lab2_boca
        $both_lab2_bocaSQL = 'SELECT id  FROM data WHERE both_lab2_boca NOT IN (0,1) OR LENGTH(both_lab2_boca) = 0 OR both_lab2_boca != NULL';
        $both_lab2_bocaResult = $this->conn->fetchAll($both_lab2_bocaSQL);
        array_push($result, ['field' => 'both_lab2_boca', 'nbErrorOccurrences' => $both_lab2_bocaResult ? count($both_lab2_bocaResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_bocaResult ? $both_lab2_bocaResult : []]);

        // 47- VAR both_lab2_boca_yesno
        $both_lab2_boca_yesnoSQL = 'SELECT id  FROM data WHERE both_lab2_boca_yesno NOT IN (0,1) OR LENGTH(both_lab2_boca_yesno) = 0 OR both_lab2_boca_yesno != NULL';
        $both_lab2_boca_yesnoResult = $this->conn->fetchAll($both_lab2_boca_yesnoSQL);
        array_push($result, ['field' => 'both_lab2_boca_yesno', 'nbErrorOccurrences' => $both_lab2_boca_yesnoResult ? count($both_lab2_boca_yesnoResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_boca_yesnoResult ? $both_lab2_boca_yesnoResult : []]);

        // 48- VAR both_lab2_pi
        $both_lab2_piSQL = 'SELECT id  FROM data WHERE both_lab2_pi NOT IN (0,1) OR LENGTH(both_lab2_pi) = 0 OR both_lab2_pi != NULL';
        $both_lab2_piResult = $this->conn->fetchAll($both_lab2_piSQL);
        array_push($result, ['field' => 'both_lab2_pi', 'nbErrorOccurrences' => $both_lab2_piResult ? count($both_lab2_piResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_piResult ? $both_lab2_piResult : []]);

        // 49- VAR both_lab2_pi_yesno
        $both_lab2_pi_yesnoSQL = 'SELECT id  FROM data WHERE both_lab2_pi_yesno NOT IN (0,1) OR LENGTH(both_lab2_pi_yesno) = 0 AND both_lab2_pi_yesno != NULL';
        $both_lab2_pi_yesnoResult = $this->conn->fetchAll($both_lab2_pi_yesnoSQL);
        array_push($result, ['field' => 'both_lab2_pi_yesno', 'nbErrorOccurrences' => $both_lab2_pi_yesnoResult ? count($both_lab2_pi_yesnoResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_pi_yesnoResult ? $both_lab2_pi_yesnoResult : []]);

        // 50- VAR both_lab2_rhino
        $both_lab2_rhinoSQL = 'SELECT id  FROM data WHERE both_lab2_rhino NOT IN (0,1) OR LENGTH(both_lab2_rhino) = 0 OR both_lab2_rhino != NULL';
        $both_lab2_rhinoResult = $this->conn->fetchAll($both_lab2_rhinoSQL);
        array_push($result, ['field' => 'both_lab2_rhino', 'nbErrorOccurrences' => $both_lab2_rhinoResult ? count($both_lab2_rhinoResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_rhinoResult ? $both_lab2_rhinoResult : []]);

        // 51- VAR both_lab2_rhino_yesno
        $both_lab2_rhino_yesnoSQL = 'SELECT id  FROM data WHERE both_lab2_rhino_yesno NOT IN (0,1) OR LENGTH(both_lab2_rhino_yesno) = 0 OR both_lab2_rhino_yesno != NULL';
        $both_lab2_rhino_yesnoResult = $this->conn->fetchAll($both_lab2_rhino_yesnoSQL);
        array_push($result, ['field' => 'both_lab2_rhino_yesno', 'nbErrorOccurrences' => $both_lab2_rhino_yesnoResult ? count($both_lab2_rhino_yesnoResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_rhino_yesnoResult ? $both_lab2_rhino_yesnoResult : []]);

        // 52- VAR both_lab2_others
        $both_lab2_othersSQL = 'SELECT id  FROM data WHERE both_lab2_others NOT IN (0,1) OR LENGTH(both_lab2_others) = 0 OR both_lab2_others != NULL';
        $both_lab2_othersResult = $this->conn->fetchAll($both_lab2_othersSQL);
        array_push($result, ['field' => 'both_lab2_others', 'nbErrorOccurrences' => $both_lab2_othersResult ? count($both_lab2_othersResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_othersResult ? $both_lab2_othersResult : []]);

        // 53- VAR both_lab2_others_yesno
        $both_lab2_others_yesnoSQL = 'SELECT id  FROM data WHERE both_lab2_others_yesno NOT IN (0,1) OR LENGTH(both_lab2_others_yesno) = 0 OR both_lab2_others_yesno != NULL';
        $both_lab2_others_yesnoResult = $this->conn->fetchAll($both_lab2_others_yesnoSQL);
        array_push($result, ['field' => 'both_lab2_others_yesno', 'nbErrorOccurrences' => $both_lab2_others_yesnoResult ? count($both_lab2_others_yesnoResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_others_yesnoResult ? $both_lab2_others_yesnoResult : []]);

        // 54- VAR both_lab2_others_detail : type of field is text and it is not required
//        $both_lab2_others_detailSQL = 'SELECT id  FROM data WHERE  both_lab2_others_detail IS NULL';
//        $both_lab2_others_detailResult = $this->conn->fetchAll($both_lab2_others_detailSQL);
//        array_push($result, ['field' => 'both_lab2_others_detail', 'nbErrorOccurrences' => $both_lab2_others_detailResult ? count($both_lab2_others_detailResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_lab2_others_detailResult ? $both_lab2_others_detailResult :[]]);

        // 55- VAR both_othersymptoms_nausea
        $both_othersymptoms_nauseaSQL = 'SELECT id  FROM data WHERE both_othersymptoms_nausea NOT IN (0,1,2) OR both_othersymptoms_nausea IS NULL OR LENGTH(both_othersymptoms_nausea) = 0 ';
        $both_othersymptoms_nauseaResult = $this->conn->fetchAll($both_othersymptoms_nauseaSQL);
        array_push($result, ['field' => 'both_othersymptoms_nausea', 'nbErrorOccurrences' => $both_othersymptoms_nauseaResult ? count($both_othersymptoms_nauseaResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_othersymptoms_nauseaResult ? $both_othersymptoms_nauseaResult : []]);

        // 56- VAR both_othersymptoms_diarrhea
        $both_othersymptoms_diarrheaSQL = 'SELECT id  FROM data WHERE both_othersymptoms_diarrhea NOT IN (0,1,2) OR both_othersymptoms_diarrhea IS NULL OR LENGTH(both_othersymptoms_diarrhea) = 0 ';
        $both_othersymptoms_diarrheaResult = $this->conn->fetchAll($both_othersymptoms_diarrheaSQL);
        array_push($result, ['field' => 'both_othersymptoms_diarrhea', 'nbErrorOccurrences' => $both_othersymptoms_diarrheaResult ? count($both_othersymptoms_diarrheaResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_othersymptoms_diarrheaResult ? $both_othersymptoms_diarrheaResult : []]);

        // 57- VAR both_othersymptoms_smell
        $both_othersymptoms_smellSQL = 'SELECT id  FROM data WHERE both_othersymptoms_smell NOT IN (0,1,2) OR both_othersymptoms_smell IS NULL OR LENGTH(both_othersymptoms_smell) = 0 ';
        $both_othersymptoms_smellResult = $this->conn->fetchAll($both_othersymptoms_smellSQL);
        array_push($result, ['field' => 'both_othersymptoms_smell', 'nbErrorOccurrences' => $both_othersymptoms_smellResult ? count($both_othersymptoms_smellResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_othersymptoms_smellResult ? $both_othersymptoms_smellResult : []]);

        // 58- VAR both_othersymptoms_chestpain
        $both_othersymptoms_chestpainSQL = 'SELECT id  FROM data WHERE both_othersymptoms_chestpain NOT IN (0,1,2) OR both_othersymptoms_chestpain IS NULL OR LENGTH(both_othersymptoms_chestpain) = 0 ';
        $both_othersymptoms_chestpainResult = $this->conn->fetchAll($both_othersymptoms_chestpainSQL);
        array_push($result, ['field' => 'both_othersymptoms_chestpain', 'nbErrorOccurrences' => $both_othersymptoms_chestpainResult ? count($both_othersymptoms_chestpainResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_othersymptoms_chestpainResult ? $both_othersymptoms_chestpainResult : []]);

        // 59- VAR both_pregnancy_status
        $both_pregnancy_statusSQL = 'SELECT id  FROM data WHERE both_pregnancy_status NOT IN (0,1,2) OR both_pregnancy_status IS NULL OR LENGTH(both_pregnancy_status) = 0';
        $both_pregnancy_statusResult = $this->conn->fetchAll($both_pregnancy_statusSQL);
        array_push($result, ['field' => 'both_pregnancy_status', 'nbErrorOccurrences' => $both_pregnancy_statusResult ? count($both_pregnancy_statusResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_pregnancy_statusResult ? $both_pregnancy_statusResult : []]);

        // 60- VAR both_pregnancy_weeks
        $both_pregnancy_weeksSQL = "SELECT id  FROM data WHERE (both_pregnancy_weeks NOT REGEXP '^[0-9]+$' AND both_pregnancy_weeks !='NULL') OR both_pregnancy_weeks !=NULL";
        $both_pregnancy_weeksResult = $this->conn->fetchAll($both_pregnancy_weeksSQL);
        array_push($result, ['field' => 'both_pregnancy_weeks', 'nbErrorOccurrences' => $both_pregnancy_weeksResult ? count($both_pregnancy_weeksResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_pregnancy_weeksResult ? $both_pregnancy_weeksResult : []]);

        // 61- VAR both_pregnancy_weeks_unknow
        $both_pregnancy_weeks_unknowSQL = 'SELECT id  FROM data WHERE both_pregnancy_weeks_unknow != 1 OR both_pregnancy_weeks_unknow != NULL';
        $both_pregnancy_weeks_unknowResult = $this->conn->fetchAll($both_pregnancy_weeks_unknowSQL);
        array_push($result, ['field' => 'both_pregnancy_weeks_unknow', 'nbErrorOccurrences' => $both_pregnancy_weeks_unknowResult ? count($both_pregnancy_weeks_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_pregnancy_weeks_unknowResult ? $both_pregnancy_weeks_unknowResult : []]);

        // 62- VAR both_height
        $both_heightSQL = "SELECT id  FROM data WHERE both_height NOT REGEXP '/^[0-9]{1,3}|[0-9]{1,3}[.][0-9]{1,3}$/' OR both_height IS NULL OR LENGTH(both_height) = 0";
        $both_heightResult = $this->conn->fetchAll($both_heightSQL);
        array_push($result, ['field' => 'both_height', 'nbErrorOccurrences' => $both_heightResult ? count($both_heightResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_heightResult ? $both_heightResult : []]);

        // 63- VAR both_height_unknow
        $both_height_unknowSQL = 'SELECT id FROM data WHERE both_height_unknow != 1 OR both_height_unknow != NULL';
        $both_height_unknowResult = $this->conn->fetchAll($both_height_unknowSQL);
        array_push($result, ['field' => 'both_height_unknow', 'nbErrorOccurrences' => $both_height_unknowResult ? count($both_height_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_height_unknowResult ? $both_height_unknowResult : []]);

        // 64- VAR both_weight
        $both_weightSQL = "SELECT id  FROM data WHERE  both_weight NOT REGEXP '^([0-9]{1,3}[.][0-9]{1,3}|[0-9]{1,3})$' OR both_weight IS NULL OR LENGTH(both_weight) = 0";
        $both_weightResult = $this->conn->fetchAll($both_weightSQL);
        array_push($result, ['field' => 'both_weight', 'nbErrorOccurrences' => $both_weightResult ? count($both_weightResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_weightResult ? $both_weightResult : []]);

        // 65- VAR both_weight_unknow
        $both_weight_unknowSQL = 'SELECT id  FROM data WHERE both_weight_unknow != 1 OR both_weight_unknow != NULL';
        $both_weight_unknowResult = $this->conn->fetchAll($both_weight_unknowSQL);
        array_push($result, ['field' => 'both_weight_unknow', 'nbErrorOccurrences' => $both_weight_unknowResult ? count($both_weight_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_weight_unknowResult ? $both_weight_unknowResult : []]);

        // 66- VAR both_chronic_cond_yn
        $both_chronic_cond_ynSQL = 'SELECT id  FROM data WHERE both_chronic_cond_yn NOT IN(0,1,2) OR both_chronic_cond_yn IS NULL OR LENGTH(both_chronic_cond_yn) = 0';
        $both_chronic_cond_ynResult = $this->conn->fetchAll($both_chronic_cond_ynSQL);
        array_push($result, ['field' => 'both_chronic_cond_yn', 'nbErrorOccurrences' => $both_chronic_cond_ynResult ? count($both_chronic_cond_ynResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_cond_ynResult ? $both_chronic_cond_ynResult : []]);

        // 67- VAR both_chronic_cvd_blood
        $both_chronic_cvd_bloodSQL = 'SELECT id  FROM data WHERE both_chronic_cvd_blood NOT IN(0,1) OR both_chronic_cvd_blood != NULL';
        $both_chronic_cvd_bloodResult = $this->conn->fetchAll($both_chronic_cvd_bloodSQL);
        array_push($result, ['field' => 'both_chronic_cvd_blood', 'nbErrorOccurrences' => $both_chronic_cvd_bloodResult ? count($both_chronic_cvd_bloodResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_cvd_bloodResult ? $both_chronic_cvd_bloodResult : []]);

        // 68- VAR both_chronic_copd
        $both_chronic_copdSQL = 'SELECT id  FROM data WHERE both_chronic_copd NOT IN(0,1) OR both_chronic_copd != NULL';
        $both_chronic_copdResult = $this->conn->fetchAll($both_chronic_copdSQL);
        array_push($result, ['field' => 'both_chronic_copd', 'nbErrorOccurrences' => $both_chronic_copdResult ? count($both_chronic_copdResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_copdResult ? $both_chronic_copdResult : []]);

        // 69- VAR both_chronic_asthma
        $both_chronic_asthmaSQL = 'SELECT id  FROM data WHERE both_chronic_asthma NOT IN(0,1) OR both_chronic_asthma != NULL';
        $both_chronic_asthmaResult = $this->conn->fetchAll($both_chronic_asthmaSQL);
        array_push($result, ['field' => 'both_chronic_asthma', 'nbErrorOccurrences' => $both_chronic_asthmaResult ? count($both_chronic_asthmaResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_asthmaResult ? $both_chronic_asthmaResult : []]);

        // 70- VAR both_chronic_diabetes
        $both_chronic_diabetesSQL = 'SELECT id  FROM data WHERE both_chronic_diabetes NOT IN(0,1) OR both_chronic_diabetes != NULL';
        $both_chronic_diabetesResult = $this->conn->fetchAll($both_chronic_diabetesSQL);
        array_push($result, ['field' => 'both_chronic_diabetes', 'nbErrorOccurrences' => $both_chronic_diabetesResult ? count($both_chronic_diabetesResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_diabetesResult ? $both_chronic_diabetesResult : []]);

        // 71- VAR both_chronic_immuno
        $both_chronic_immunoSQL = 'SELECT id  FROM data WHERE both_chronic_immuno NOT IN(0,1) OR both_chronic_immuno != NULL';
        $both_chronic_immunoResult = $this->conn->fetchAll($both_chronic_immunoSQL);
        array_push($result, ['field' => 'both_chronic_immuno', 'nbErrorOccurrences' => $both_chronic_immunoResult ? count($both_chronic_immunoResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_immunoResult ? $both_chronic_immunoResult : []]);

        // 72- VAR both_chronic_renal
        $both_chronic_renalSQL = 'SELECT id  FROM data WHERE both_chronic_renal NOT IN(0,1) OR both_chronic_renal != NULL';
        $both_chronic_renalResult = $this->conn->fetchAll($both_chronic_renalSQL);
        array_push($result, ['field' => 'both_chronic_renal', 'nbErrorOccurrences' => $both_chronic_renalResult ? count($both_chronic_renalResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_renalResult ? $both_chronic_renalResult : []]);

        // 73- VAR both_chronic_rheumatologic_autoimmune_dis
        $both_chronic_rheumatologic_autoimmune_disSQL = 'SELECT id  FROM data WHERE both_chronic_rheumatologic_autoimmune_dis NOT IN(0,1) OR both_chronic_rheumatologic_autoimmune_dis != NULL';
        $both_chronic_rheumatologic_autoimmune_disResult = $this->conn->fetchAll($both_chronic_rheumatologic_autoimmune_disSQL);
        array_push($result, ['field' => 'both_chronic_rheumatologic_autoimmune_dis', 'nbErrorOccurrences' => $both_chronic_rheumatologic_autoimmune_disResult ? count($both_chronic_rheumatologic_autoimmune_disResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_rheumatologic_autoimmune_disResult ? $both_chronic_rheumatologic_autoimmune_disResult : []]);

        // 74- VAR both_chronic_neurological_neuromuscular_dis
        $both_chronic_neurological_neuromuscular_disSQL = 'SELECT id  FROM data WHERE both_chronic_neurological_neuromuscular_dis NOT IN(0,1) OR both_chronic_neurological_neuromuscular_dis != NULL';
        $both_chronic_neurological_neuromuscular_disResult = $this->conn->fetchAll($both_chronic_neurological_neuromuscular_disSQL);
        array_push($result, ['field' => 'both_chronic_neurological_neuromuscular_dis', 'nbErrorOccurrences' => $both_chronic_neurological_neuromuscular_disResult ? count($both_chronic_neurological_neuromuscular_disResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_neurological_neuromuscular_disResult ? $both_chronic_neurological_neuromuscular_disResult : []]);

        // 75- VAR both_chronic_cirrhosis_liver_dis
        $both_chronic_cirrhosis_liver_disSQL = 'SELECT id  FROM data WHERE both_chronic_cirrhosis_liver_dis NOT IN(0,1) OR both_chronic_cirrhosis_liver_dis != NULL';
        $both_chronic_cirrhosis_liver_disResult = $this->conn->fetchAll($both_chronic_cirrhosis_liver_disSQL);
        array_push($result, ['field' => 'both_chronic_cirrhosis_liver_dis', 'nbErrorOccurrences' => $both_chronic_cirrhosis_liver_disResult ? count($both_chronic_cirrhosis_liver_disResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_cirrhosis_liver_disResult ? $both_chronic_cirrhosis_liver_disResult : []]);

        // 76- VAR both_chronic_neoplasm
        $both_chronic_neoplasmSQL = 'SELECT id  FROM data WHERE both_chronic_neoplasm NOT IN(0,1) OR both_chronic_neoplasm != NULL';
        $both_chronic_neoplasmResult = $this->conn->fetchAll($both_chronic_neoplasmSQL);
        array_push($result, ['field' => 'both_chronic_neoplasm', 'nbErrorOccurrences' => $both_chronic_neoplasmResult ? count($both_chronic_neoplasmResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_neoplasmResult ? $both_chronic_neoplasmResult : []]);

        // 77- VAR both_chronic_obesity
        $both_chronic_obesitySQL = 'SELECT id  FROM data WHERE both_chronic_obesity NOT IN(0,1) OR both_chronic_obesity != NULL';
        $both_chronic_obesityResult = $this->conn->fetchAll($both_chronic_obesitySQL);
        array_push($result, ['field' => 'both_chronic_obesity', 'nbErrorOccurrences' => $both_chronic_obesityResult ? count($both_chronic_obesityResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_obesityResult ? $both_chronic_obesityResult : []]);

        // 78- VAR both_chronic_active_tuberculosis
        $both_chronic_active_tuberculosisSQL = 'SELECT id  FROM data WHERE both_chronic_active_tuberculosis NOT IN(0,1) OR both_chronic_active_tuberculosis != NULL';
        $both_chronic_active_tuberculosisResult = $this->conn->fetchAll($both_chronic_active_tuberculosisSQL);
        array_push($result, ['field' => 'both_chronic_active_tuberculosis', 'nbErrorOccurrences' => $both_chronic_active_tuberculosisResult ? count($both_chronic_active_tuberculosisResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_active_tuberculosisResult ? $both_chronic_active_tuberculosisResult : []]);

        // 79- VAR both_chronic_malnutri
        $both_chronic_malnutriSQL = 'SELECT id  FROM data WHERE both_chronic_malnutri NOT IN(0,1) OR both_chronic_malnutri != NULL';
        $both_chronic_malnutriResult = $this->conn->fetchAll($both_chronic_malnutriSQL);
        array_push($result, ['field' => 'both_chronic_malnutri', 'nbErrorOccurrences' => $both_chronic_malnutriResult ? count($both_chronic_malnutriResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_malnutriResult ? $both_chronic_malnutriResult : []]);

        // 80- VAR both_chronic_hiv_infection
        $both_chronic_hiv_infectionSQL = 'SELECT id  FROM data WHERE both_chronic_hiv_infection NOT IN(0,1) OR both_chronic_hiv_infection != NULL';
        $both_chronic_hiv_infectionResult = $this->conn->fetchAll($both_chronic_hiv_infectionSQL);
        array_push($result, ['field' => 'both_chronic_hiv_infection', 'nbErrorOccurrences' => $both_chronic_hiv_infectionResult ? count($both_chronic_hiv_infectionResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_hiv_infectionResult ? $both_chronic_hiv_infectionResult : []]);

        // 81- VAR both_chronic_hemoglobinopathies
        $both_chronic_hemoglobinopathiesSQL = 'SELECT id  FROM data WHERE both_chronic_hemoglobinopathies NOT IN(0,1) OR both_chronic_hemoglobinopathies != NULL';
        $both_chronic_hemoglobinopathiesResult = $this->conn->fetchAll($both_chronic_hemoglobinopathiesSQL);
        array_push($result, ['field' => 'both_chronic_hemoglobinopathies', 'nbErrorOccurrences' => $both_chronic_hemoglobinopathiesResult ? count($both_chronic_hemoglobinopathiesResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_hemoglobinopathiesResult ? $both_chronic_hemoglobinopathiesResult : []]);

        // 82- VAR both_chronic_hiv_exposure
        $both_chronic_hiv_exposureSQL = 'SELECT id  FROM data WHERE both_chronic_hiv_exposure NOT IN(0,1) OR both_chronic_hiv_exposure != NULL';
        $both_chronic_hiv_exposureResult = $this->conn->fetchAll($both_chronic_hiv_exposureSQL);
        array_push($result, ['field' => 'both_chronic_hiv_exposure', 'nbErrorOccurrences' => $both_chronic_hiv_exposureResult ? count($both_chronic_hiv_exposureResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_hiv_exposureResult ? $both_chronic_hiv_exposureResult : []]);

        // 83- VAR both_chronic_prematurity
        $both_chronic_prematuritySQL = 'SELECT id  FROM data WHERE both_chronic_prematurity NOT IN(0,1) OR both_chronic_prematurity != NULL';
        $both_chronic_prematurityResult = $this->conn->fetchAll($both_chronic_prematuritySQL);
        array_push($result, ['field' => 'both_chronic_prematurity', 'nbErrorOccurrences' => $both_chronic_prematurityResult ? count($both_chronic_prematurityResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_prematurityResult ? $both_chronic_prematurityResult : []]);

        // 84- VAR both_chronic_other
        $both_chronic_otherSQL = 'SELECT id  FROM data WHERE both_chronic_other NOT IN(0,1) OR both_chronic_other != NULL';
        $both_chronic_otherResult = $this->conn->fetchAll($both_chronic_otherSQL);
        array_push($result, ['field' => 'both_chronic_other', 'nbErrorOccurrences' => $both_chronic_otherResult ? count($both_chronic_otherResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_chronic_otherResult ? $both_chronic_otherResult : []]);

        // 85- VAR both_antiviral_preceding
        $both_antiviral_precedingSQL = 'SELECT id  FROM data WHERE both_antiviral_preceding NOT IN(0,1) OR both_antiviral_preceding != NULL';
        $both_antiviral_precedingResult = $this->conn->fetchAll($both_antiviral_precedingSQL);
        array_push($result, ['field' => 'both_antiviral_preceding', 'nbErrorOccurrences' => $both_antiviral_precedingResult ? count($both_antiviral_precedingResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_antiviral_precedingResult ? $both_antiviral_precedingResult : []]);

        // 86- VAR both_antiviral_preceding_date
        $both_antiviral_preceding_dateSQL = "SELECT id  FROM data WHERE both_antiviral_preceding_date NOT REGEXP '^[0-9]{1,2}\\/[0-9]{1,2}\\/[0-9]{4}$' OR both_antiviral_preceding_date != NULL";
        $both_antiviral_preceding_dateResult = $this->conn->fetchAll($both_antiviral_preceding_dateSQL);
        array_push($result, ['field' => 'both_antiviral_preceding_date', 'nbErrorOccurrences' => $both_antiviral_preceding_dateResult ? count($both_antiviral_preceding_dateResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_antiviral_preceding_dateResult ? $both_antiviral_preceding_dateResult : []]);

        // 87- VAR both_antiviral_preceding_date_unknow
        $both_antiviral_preceding_date_unknowSQL = 'SELECT id  FROM data WHERE both_antiviral_preceding_date_unknow != 1 OR both_antiviral_preceding_date_unknow != NULL';
        $both_antiviral_preceding_date_unknowResult = $this->conn->fetchAll($both_antiviral_preceding_date_unknowSQL);
        array_push($result, ['field' => 'both_antiviral_preceding_date_unknow', 'nbErrorOccurrences' => $both_antiviral_preceding_date_unknowResult ? count($both_antiviral_preceding_date_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_antiviral_preceding_date_unknowResult ? $both_antiviral_preceding_date_unknowResult : []]);

        // 88- VAR both_antiviral_during
        $both_antiviral_duringSQL = 'SELECT id  FROM data WHERE both_antiviral_during NOT IN(0,1,2) OR both_antiviral_during IS NULL';
        $both_antiviral_duringResult = $this->conn->fetchAll($both_antiviral_duringSQL);
        array_push($result, ['field' => 'both_antiviral_during', 'nbErrorOccurrences' => $both_antiviral_duringResult ? count($both_antiviral_duringResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_antiviral_duringResult ? $both_antiviral_duringResult : []]);

        // 89- VAR both_antiviral_during_date
        $both_antiviral_during_dateSQL = "SELECT id  FROM data WHERE both_antiviral_during_date NOT REGEXP '^[0-9]{1,2}\\/[0-9]{1,2}\\/[0-9]{4}$' OR both_antiviral_during_date != NULL";
        $both_antiviral_during_dateResult = $this->conn->fetchAll($both_antiviral_during_dateSQL);
        array_push($result, ['field' => 'both_antiviral_during_date', 'nbErrorOccurrences' => $both_antiviral_during_dateResult ? count($both_antiviral_during_dateResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_antiviral_during_dateResult ? $both_antiviral_during_dateResult : []]);

        // 90- VAR both_antiviral_during_date_unknow
        $both_antiviral_during_date_unknowSQL = 'SELECT id  FROM data WHERE both_antiviral_during_date_unknow != 1 OR both_antiviral_during_date_unknow != NULL';
        $both_antiviral_during_date_unknowResult = $this->conn->fetchAll($both_antiviral_during_date_unknowSQL);
        array_push($result, ['field' => 'both_antiviral_during_date_unknow', 'nbErrorOccurrences' => $both_antiviral_during_date_unknowResult ? count($both_antiviral_during_date_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_antiviral_during_date_unknowResult ? $both_antiviral_during_date_unknowResult : []]);

        // 91- VAR both_antibio_preceding
        $both_antibio_precedingSQL = 'SELECT id  FROM data WHERE both_antibio_preceding NOT IN(0,1,2) OR both_antibio_preceding IS NULL';
        $both_antibio_precedingResult = $this->conn->fetchAll($both_antibio_precedingSQL);
        array_push($result, ['field' => 'both_antibio_preceding', 'nbErrorOccurrences' => $both_antibio_precedingResult ? count($both_antibio_precedingResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_antibio_precedingResult ? $both_antibio_precedingResult : []]);

        // 92- VAR both_antibio_preceding_date
        $both_antibio_preceding_dateSQL = "SELECT id  FROM data WHERE both_antibio_preceding_date NOT REGEXP '^[0-9]{1,2}\\/[0-9]{1,2}\\/[0-9]{4}$' OR both_antibio_preceding_date != NULL";
        $both_antibio_preceding_dateResult = $this->conn->fetchAll($both_antibio_preceding_dateSQL);
        array_push($result, ['field' => 'both_antibio_preceding_date', 'nbErrorOccurrences' => $both_antibio_preceding_dateResult ? count($both_antibio_preceding_dateResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_antibio_preceding_dateResult ? $both_antibio_preceding_dateResult : []]);

        // 93- VAR both_antibio_preceding_date_unknow
        $both_antibio_preceding_date_unknowSQL = 'SELECT id  FROM data WHERE both_antibio_preceding_date_unknow != 1 OR both_antibio_preceding_date_unknow != NULL';
        $both_antibio_preceding_date_unknowResult = $this->conn->fetchAll($both_antibio_preceding_date_unknowSQL);
        array_push($result, ['field' => 'both_antibio_preceding_date_unknow', 'nbErrorOccurrences' => $both_antibio_preceding_date_unknowResult ? count($both_antibio_preceding_date_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_antibio_preceding_date_unknowResult ? $both_antibio_preceding_date_unknowResult : []]);

        // 94- VAR both_antibio_during
        $both_antibio_duringSQL = 'SELECT id  FROM data WHERE both_antibio_during NOT IN(0,1,2) OR both_antibio_during IS NULL';
        $both_antibio_duringResult = $this->conn->fetchAll($both_antibio_duringSQL);
        array_push($result, ['field' => 'both_antibio_during', 'nbErrorOccurrences' => $both_antibio_duringResult ? count($both_antibio_duringResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_antibio_duringResult ? $both_antibio_duringResult : []]);

        // 95- VAR both_antibio_during_date
        $both_antibio_during_dateSQL = "SELECT id  FROM data WHERE both_antibio_during_date NOT REGEXP '^[0-9]{1,2}\\/[0-9]{1,2}\\/[0-9]{4}$' OR both_antibio_during_date != NULL";
        $both_antibio_during_dateResult = $this->conn->fetchAll($both_antibio_during_dateSQL);
        array_push($result, ['field' => 'both_antibio_during_date', 'nbErrorOccurrences' => $both_antibio_during_dateResult ? count($both_antibio_during_dateResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_antibio_during_dateResult ? $both_antibio_during_dateResult : []]);

        // 96- VAR both_antibio_during_date_unknow
        $both_antibio_during_date_unknowSQL = 'SELECT id  FROM data WHERE both_antibio_during_date_unknow != 1 OR both_antibio_during_date_unknow != NULL';
        $both_antibio_during_date_unknowResult = $this->conn->fetchAll($both_antibio_during_date_unknowSQL);
        array_push($result, ['field' => 'both_antibio_during_date_unknow', 'nbErrorOccurrences' => $both_antibio_during_date_unknowResult ? count($both_antibio_during_date_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_antibio_during_date_unknowResult ? $both_antibio_during_date_unknowResult : []]);

        // 97- VAR both_influ_vac_current_season
        $both_influ_vac_current_seasonSQL = 'SELECT id  FROM data WHERE both_influ_vac_current_season NOT IN(0,1,2) OR both_influ_vac_current_season IS NULL';
        $both_influ_vac_current_seasonResult = $this->conn->fetchAll($both_influ_vac_current_seasonSQL);
        array_push($result, ['field' => 'both_influ_vac_current_season', 'nbErrorOccurrences' => $both_influ_vac_current_seasonResult ? count($both_influ_vac_current_seasonResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_influ_vac_current_seasonResult ? $both_influ_vac_current_seasonResult : []]);

        // 98- VAR both_vac_14d_before_ili_sym
        $both_vac_14d_before_ili_symSQL = 'SELECT id  FROM data WHERE both_vac_14d_before_ili_sym NOT IN(0,1,2) OR both_vac_14d_before_ili_sym != NULL';
        $both_vac_14d_before_ili_symResult = $this->conn->fetchAll($both_vac_14d_before_ili_symSQL);
        array_push($result, ['field' => 'both_vac_14d_before_ili_sym', 'nbErrorOccurrences' => $both_vac_14d_before_ili_symResult ? count($both_vac_14d_before_ili_symResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_vac_14d_before_ili_symResult ? $both_vac_14d_before_ili_symResult : []]);

        // 99- VAR both_vac_history_validated
        $both_vac_history_validatedSQL = 'SELECT id  FROM data WHERE both_vac_history_validated NOT IN(0,1,2) OR both_vac_history_validated != NULL';
        $both_vac_history_validatedResult = $this->conn->fetchAll($both_vac_history_validatedSQL);
        array_push($result, ['field' => 'both_vac_history_validated', 'nbErrorOccurrences' => $both_vac_history_validatedResult ? count($both_vac_history_validatedResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_vac_history_validatedResult ? $both_vac_history_validatedResult : []]);

        // 100- VAR both_vac_type_vaccine
        $both_vac_type_vaccineSQL = 'SELECT id  FROM data WHERE both_vac_type_vaccine NOT IN(0,1,2) OR both_vac_type_vaccine != NULL';
        $both_vac_type_vaccineResult = $this->conn->fetchAll($both_vac_type_vaccineSQL);
        array_push($result, ['field' => 'both_vac_type_vaccine', 'nbErrorOccurrences' => $both_vac_type_vaccineResult ? count($both_vac_type_vaccineResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_vac_type_vaccineResult ? $both_vac_type_vaccineResult : []]);

        // 101- VAR both_vac_preceding_season
        $both_vac_preceding_seasonSQL = 'SELECT id  FROM data WHERE both_vac_preceding_season NOT IN(0,1,2) AND both_vac_preceding_season IS NULL';
        $both_vac_preceding_seasonResult = $this->conn->fetchAll($both_vac_preceding_seasonSQL);
        array_push($result, ['field' => 'both_vac_preceding_season', 'nbErrorOccurrences' => $both_vac_preceding_seasonResult ? count($both_vac_preceding_seasonResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_vac_preceding_seasonResult ? $both_vac_preceding_seasonResult : []]);

        // 102- VAR both_covid_number_doses
        $both_covid_number_dosesSQL = 'SELECT id FROM data WHERE LOWER(both_covid_number_doses) NOT IN("None","Do not know",1,2,3) AND both_covid_number_doses IS NULL';
        $both_covid_number_dosesResult = $this->conn->fetchAll($both_covid_number_dosesSQL);
        array_push($result, ['field' => 'both_covid_number_doses', 'nbErrorOccurrences' => $both_covid_number_dosesResult ? count($both_covid_number_dosesResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_covid_number_dosesResult ? $both_covid_number_dosesResult : []]);

        // 103- VAR both_covid_last_dose_date
        $both_covid_last_dose_dateSQL = "SELECT id  FROM data WHERE both_covid_last_dose_date NOT REGEXP '^[0-9]{1,2}\\/[0-9]{1,2}\\/[0-9]{4}$' OR both_covid_last_dose_date != NULL";
        $both_covid_last_dose_dateResult = $this->conn->fetchAll($both_covid_last_dose_dateSQL);
        array_push($result, ['field' => 'both_covid_last_dose_date', 'nbErrorOccurrences' => $both_covid_last_dose_dateResult ? count($both_covid_last_dose_dateResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_covid_last_dose_dateResult ? $both_covid_last_dose_dateResult : []]);

        // 104- VAR both_covid_last_dose_date_unknow
        $both_covid_last_dose_date_unknowSQL = 'SELECT id  FROM data WHERE both_covid_last_dose_date_unknow != 1 OR both_covid_last_dose_date_unknow != NULL';
        $both_covid_last_dose_date_unknowResult = $this->conn->fetchAll($both_covid_last_dose_date_unknowSQL);
        array_push($result, ['field' => 'both_covid_last_dose_date_unknow', 'nbErrorOccurrences' => $both_covid_last_dose_date_unknowResult ? count($both_covid_last_dose_date_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_covid_last_dose_date_unknowResult ? $both_covid_last_dose_date_unknowResult : []]);

        // 105- VAR both_covid_vaccine_mrna
        $both_covid_vaccine_mrnaSQL = 'SELECT id  FROM data WHERE both_covid_vaccine_mrna NOT IN(0,1) AND both_covid_vaccine_mrna != NULL';
        $both_covid_vaccine_mrnaResult = $this->conn->fetchAll($both_covid_vaccine_mrnaSQL);
        array_push($result, ['field' => 'both_covid_vaccine_mrna', 'nbErrorOccurrences' => $both_covid_vaccine_mrnaResult ? count($both_covid_vaccine_mrnaResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_covid_vaccine_mrnaResult ? $both_covid_vaccine_mrnaResult : []]);

        // 106- VAR both_covid_vaccine_inactivated_virion
        $both_covid_vaccine_inactivated_virionSQL = 'SELECT id  FROM data WHERE both_covid_vaccine_inactivated_virion NOT IN(0,1) AND both_covid_vaccine_inactivated_virion != NULL';
        $both_covid_vaccine_inactivated_virionResult = $this->conn->fetchAll($both_covid_vaccine_inactivated_virionSQL);
        array_push($result, ['field' => 'both_covid_vaccine_inactivated_virion', 'nbErrorOccurrences' => $both_covid_vaccine_inactivated_virionResult ? count($both_covid_vaccine_inactivated_virionResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_covid_vaccine_inactivated_virionResult ? $both_covid_vaccine_inactivated_virionResult : []]);

        // 107- VAR both_covid_vaccine_viral_vector
        $both_covid_vaccine_viral_vectorSQL = 'SELECT id  FROM data WHERE both_covid_vaccine_viral_vector NOT IN(0,1) OR both_covid_vaccine_viral_vector != NULL';
        $both_covid_vaccine_viral_vectorResult = $this->conn->fetchAll($both_covid_vaccine_viral_vectorSQL);
        array_push($result, ['field' => 'both_covid_vaccine_viral_vector', 'nbErrorOccurrences' => $both_covid_vaccine_viral_vectorResult ? count($both_covid_vaccine_viral_vectorResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_covid_vaccine_viral_vectorResult ? $both_covid_vaccine_viral_vectorResult : []]);

        // 108- VAR both_covid_vaccine_protein_subunit
        $both_covid_vaccine_protein_subunitSQL = 'SELECT id  FROM data WHERE both_covid_vaccine_protein_subunit NOT IN(0,1) OR both_covid_vaccine_protein_subunit != NULL';
        $both_covid_vaccine_protein_subunitResult = $this->conn->fetchAll($both_covid_vaccine_protein_subunitSQL);
        array_push($result, ['field' => 'both_covid_vaccine_protein_subunit', 'nbErrorOccurrences' => $both_covid_vaccine_protein_subunitResult ? count($both_covid_vaccine_protein_subunitResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_covid_vaccine_protein_subunitResult ? $both_covid_vaccine_protein_subunitResult : []]);

        // 109- VAR both_covid_vaccine_unknow
        $both_covid_vaccine_unknowSQL = 'SELECT id  FROM data WHERE both_covid_vaccine_unknow NOT IN(0,1) OR both_covid_vaccine_unknow != NULL';
        $both_covid_vaccine_unknowResult = $this->conn->fetchAll($both_covid_vaccine_unknowSQL);
        array_push($result, ['field' => 'both_covid_vaccine_unknow', 'nbErrorOccurrences' => $both_covid_vaccine_unknowResult ? count($both_covid_vaccine_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_covid_vaccine_unknowResult ? $both_covid_vaccine_unknowResult : []]);

        // 110- VAR both_severity_confusion
        $both_severity_confusionSQL = 'SELECT id  FROM data WHERE both_severity_confusion NOT IN(0,1,2) AND both_severity_confusion IS NULL';
        $both_severity_confusionResult = $this->conn->fetchAll($both_severity_confusionSQL);
        array_push($result, ['field' => 'both_severity_confusion', 'nbErrorOccurrences' => $both_severity_confusionResult ? count($both_severity_confusionResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_severity_confusionResult ? $both_severity_confusionResult : []]);

        //  111- VAR both_severity_blood_pressure
        $both_severity_blood_pressureSQL = "SELECT id  FROM data WHERE both_severity_blood_pressure NOT REGEXP '^[0-9]{3}\/[0-9]{3}$' OR both_severity_blood_pressure != NULL";
        $both_severity_blood_pressureResult = $this->conn->fetchAll($both_severity_blood_pressureSQL);
        array_push($result, ['field' => 'both_severity_blood_pressure', 'nbErrorOccurrences' => $both_severity_blood_pressureResult ? count($both_severity_blood_pressureResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_severity_blood_pressureResult ? $both_severity_blood_pressureResult : []]);

        //  112- VAR both_severity_blood_pressure_unknow
        $both_severity_blood_pressure_unknowSQL = 'SELECT id  FROM data WHERE both_severity_blood_pressure_unknow != 1 OR both_severity_blood_pressure_unknow != NULL';
        $both_severity_blood_pressure_unknowResult = $this->conn->fetchAll($both_severity_blood_pressure_unknowSQL);
        array_push($result, ['field' => 'both_severity_blood_pressure_unknow', 'nbErrorOccurrences' => $both_severity_blood_pressure_unknowResult ? count($both_severity_blood_pressure_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_severity_blood_pressure_unknowResult ? $both_severity_blood_pressure_unknowResult : []]);

        // 113- VAR both_severity_respiration_rate
        $both_severity_respiration_rateSQL = "SELECT id  FROM data WHERE both_severity_respiration_rate NOT REGEXP '^[0-9]{2}$' AND both_severity_respiration_rate != NULL";
        $both_severity_respiration_rateResult = $this->conn->fetchAll($both_severity_respiration_rateSQL);
        array_push($result, ['field' => 'both_severity_respiration_rate', 'nbErrorOccurrences' => $both_severity_respiration_rateResult ? count($both_severity_respiration_rateResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_severity_respiration_rateResult ? $both_severity_respiration_rateResult : []]);

        // 114- VAR both_severity_respiration_rate_unknow
        $both_severity_respiration_rate_unknowSQL = 'SELECT id  FROM data WHERE both_severity_respiration_rate_unknow != 1 OR both_severity_respiration_rate_unknow != NULL';
        $both_severity_respiration_rate_unknowResult = $this->conn->fetchAll($both_severity_respiration_rate_unknowSQL);
        array_push($result, ['field' => 'both_severity_respiration_rate_unknow', 'nbErrorOccurrences' => $both_severity_respiration_rate_unknowResult ? count($both_severity_respiration_rate_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_severity_respiration_rate_unknowResult ? $both_severity_respiration_rate_unknowResult : []]);

        // 115- VAR both_severity_oxygen_saturation
        $both_severity_oxygen_saturationSQL = "SELECT id FROM data WHERE both_severity_oxygen_saturation NOT REGEXP '^[0-9]{3}$' OR both_severity_oxygen_saturation != NULL";
        $both_severity_oxygen_saturationResult = $this->conn->fetchAll($both_severity_oxygen_saturationSQL);
        array_push($result, ['field' => 'both_severity_oxygen_saturation', 'nbErrorOccurrences' => $both_severity_oxygen_saturationResult ? count($both_severity_oxygen_saturationResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_severity_oxygen_saturationResult ? $both_severity_oxygen_saturationResult : []]);

        // 116- VAR both_severity_oxygen_saturation_unknow
        $both_severity_oxygen_saturation_unknowSQL = 'SELECT id  FROM data WHERE both_severity_oxygen_saturation_unknow != 1 OR both_severity_oxygen_saturation_unknow != NULL';
        $both_severity_oxygen_saturation_unknowResult = $this->conn->fetchAll($both_severity_oxygen_saturation_unknowSQL);
        array_push($result, ['field' => 'both_severity_oxygen_saturation_unknow', 'nbErrorOccurrences' => $both_severity_oxygen_saturation_unknowResult ? count($both_severity_oxygen_saturation_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_severity_oxygen_saturation_unknowResult ? $both_severity_oxygen_saturation_unknowResult : []]);

        // 117- VAR both_severity_supp_oxygen
        $both_severity_supp_oxygenSQL = 'SELECT id  FROM data WHERE both_severity_supp_oxygen NOT IN(0,1,2) OR both_severity_supp_oxygen IS NULL';
        $both_severity_supp_oxygenResult = $this->conn->fetchAll($both_severity_supp_oxygenSQL);
        array_push($result, ['field' => 'both_severity_supp_oxygen', 'nbErrorOccurrences' => $both_severity_supp_oxygenResult ? count($both_severity_supp_oxygenResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_severity_supp_oxygenResult ? $both_severity_supp_oxygenResult : []]);

        // 118- VAR both_severity_vaso_support
        $both_severity_vaso_supportSQL = 'SELECT id  FROM data WHERE both_severity_vaso_support NOT IN(0,1,2) OR both_severity_vaso_support IS NULL';
        $both_severity_vaso_supportResult = $this->conn->fetchAll($both_severity_vaso_supportSQL);
        array_push($result, ['field' => 'both_severity_vaso_support', 'nbErrorOccurrences' => $both_severity_vaso_supportResult ? count($both_severity_vaso_supportResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_severity_vaso_supportResult ? $both_severity_vaso_supportResult : []]);

        // 119- VAR both_severity_apnea
        $both_severity_apneaSQL = 'SELECT id  FROM data WHERE both_severity_apnea NOT IN(0,1,2) OR both_severity_apnea IS NULL';
        $both_severity_apneaResult = $this->conn->fetchAll($both_severity_apneaSQL);
        array_push($result, ['field' => 'both_severity_apnea', 'nbErrorOccurrences' => $both_severity_apneaResult ? count($both_severity_apneaResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_severity_apneaResult ? $both_severity_apneaResult : []]);

        // 120- VAR both_frailty_score
        $both_frailty_scoreSQL = 'SELECT id  FROM data WHERE both_frailty_score NOT IN(1,2,3,4,5,6,7,8,9) OR both_frailty_score IS NULL ';
        $both_frailty_scoreResult = $this->conn->fetchAll($both_frailty_scoreSQL);
        array_push($result, ['field' => 'both_frailty_score', 'nbErrorOccurrences' => $both_frailty_scoreResult ? count($both_frailty_scoreResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_frailty_scoreResult ? $both_frailty_scoreResult : []]);

        // 121- VAR both_frailty_score_unknow
        $both_frailty_score_unknowSQL = 'SELECT id  FROM data WHERE both_frailty_score_unknow != 1 OR both_frailty_score_unknow != NULL';
        $both_frailty_score_unknowResult = $this->conn->fetchAll($both_frailty_score_unknowSQL);
        array_push($result, ['field' => 'both_frailty_score_unknow', 'nbErrorOccurrences' => $both_frailty_score_unknowResult ? count($both_frailty_score_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_frailty_score_unknowResult ? $both_frailty_score_unknowResult : []]);

        // 122- VAR both_icu_adm
        $both_icu_admSQL = 'SELECT id  FROM data WHERE both_icu_adm NOT IN(0,1,2) OR both_icu_adm IS NULL';
        $both_icu_admResult = $this->conn->fetchAll($both_icu_admSQL);
        array_push($result, ['field' => 'both_icu_adm', 'nbErrorOccurrences' => $both_icu_admResult ? count($both_icu_admResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_icu_admResult ? $both_icu_admResult : []]);

        // 123- VAR both_severity_high_dependence_unit
        $both_severity_high_dependence_unitSQL = 'SELECT id  FROM data WHERE both_severity_high_dependence_unit NOT IN(0,1,2) OR both_severity_high_dependence_unit IS NULL';
        $both_severity_high_dependence_unitResult = $this->conn->fetchAll($both_severity_high_dependence_unitSQL);
        array_push($result, ['field' => 'both_severity_high_dependence_unit', 'nbErrorOccurrences' => $both_severity_high_dependence_unitResult ? count($both_severity_high_dependence_unitResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_severity_high_dependence_unitResult ? $both_severity_high_dependence_unitResult : []]);

        // 124- VAR both_severity_mech_vent
        $both_severity_mech_ventSQL = 'SELECT id  FROM data WHERE both_severity_mech_vent NOT IN(0,1,2) OR both_severity_mech_vent IS NULL';
        $both_severity_mech_ventResult = $this->conn->fetchAll($both_severity_mech_ventSQL);
        array_push($result, ['field' => 'both_severity_mech_vent', 'nbErrorOccurrences' => $both_severity_mech_ventResult ? count($both_severity_mech_ventResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_severity_mech_ventResult ? $both_severity_mech_ventResult : []]);

        // 125- VAR both_death_hosp
        $both_death_hospSQL = 'SELECT id  FROM data WHERE both_death_hosp NOT IN(0,1) OR both_death_hosp IS NULL';
        $both_death_hospResult = $this->conn->fetchAll($both_death_hospSQL);
        array_push($result, ['field' => 'both_death_hosp', 'nbErrorOccurrences' => $both_death_hospResult ? count($both_death_hospResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_death_hospResult ? $both_death_hospResult : []]);

        // 126- VAR both_discharged_date
        $both_discharged_dateSQL = "SELECT id  FROM data WHERE both_discharged_date NOT REGEXP '^[0-9]{1,2}\\/[0-9]{1,2}\\/[0-9]{4}$' OR both_discharged_date IS NULL OR LENGTH(both_discharged_date) = 0";
        $both_discharged_dateResult = $this->conn->fetchAll($both_discharged_dateSQL);
        array_push($result, ['field' => 'both_discharged_date', 'nbErrorOccurrences' => $both_discharged_dateResult ? count($both_discharged_dateResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_discharged_dateResult ? $both_discharged_dateResult : []]);

        // 127- VAR both_discharge_another_hopital
        $both_discharge_another_hopitalSQL = 'SELECT id  FROM data WHERE both_discharge_another_hopital NOT IN(0,1,2)  OR both_discharge_another_hopital IS NULL';
        $both_discharge_another_hopitalResult = $this->conn->fetchAll($both_discharge_another_hopitalSQL);
        array_push($result, ['field' => 'both_discharge_another_hopital', 'nbErrorOccurrences' => $both_discharge_another_hopitalResult ? count($both_discharge_another_hopitalResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_discharge_another_hopitalResult ? $both_discharge_another_hopitalResult : []]);

        // 128- VAR both_d_icd
        $both_d_icdSQL = 'SELECT id  FROM data WHERE both_d_icd NOT IN(0,1) OR both_d_icd IS NULL';
        $both_d_icdResult = $this->conn->fetchAll($both_d_icdSQL);
        array_push($result, ['field' => 'both_d_icd', 'nbErrorOccurrences' => $both_d_icdResult ? count($both_d_icdResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_d_icdResult ? $both_d_icdResult : []]);

        // 129- VAR both_d_diag1
//        $both_d_diag1SQL = "SELECT id  FROM data WHERE both_d_diag1 NOT REGEXP BINARY'^([0-9]{3})|([A-Z]{1}[0-9]{2})|([0-9]{3}[.][0-9]{1,2})|([A-Z]{1}[0-9]{2}[.][0-9]{1,2})$' OR both_d_diag1 != NULL";
//        $both_d_diag1Result = $this->conn->fetchAll($both_d_diag1SQL);
//        array_push($result, ['field' => 'both_d_diag1', 'nbErrorOccurrences' => $both_d_diag1Result ? count($both_d_diag1Result) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_d_diag1Result ? $both_d_diag1Result : []]);

        // 130- VAR both_d_diag1_unknow
        $both_d_diag1_unknowSQL = 'SELECT id  FROM data WHERE both_d_diag1_unknow != 1 OR both_d_diag1_unknow != NULL';
        $both_d_diag1_unknowResult = $this->conn->fetchAll($both_d_diag1_unknowSQL);
        array_push($result, ['field' => 'both_d_diag1_unknow', 'nbErrorOccurrences' => $both_d_diag1_unknowResult ? count($both_d_diag1_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_d_diag1_unknowResult ? $both_d_diag1_unknowResult : []]);

        // 131- VAR both_d_diag2
//        $both_d_diag2SQL = "SELECT id  FROM data WHERE both_d_diag2 NOT REGEXP BINARY '^([0-9]{3})|([A-Z]{1}[0-9]{2})|([0-9]{3}[.][0-9]{1,2})|([A-Z]{1}[0-9]{2}[.][0-9]{1,2})$' OR both_d_diag2 != NULL";
//        $both_d_diag2Result = $this->conn->fetchAll($both_d_diag2SQL);
//        array_push($result, ['field' => 'both_d_diag2', 'nbErrorOccurrences' => $both_d_diag2Result ? count($both_d_diag2Result) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_d_diag2Result ? $both_d_diag2Result : []]);

        // 132- VAR both_d_diag2_unknow
        $both_d_diag2_unknowSQL = 'SELECT id  FROM data WHERE both_d_diag2_unknow != 1 OR both_d_diag2_unknow != NULL';
        $both_d_diag2_unknowResult = $this->conn->fetchAll($both_d_diag2_unknowSQL);
        array_push($result, ['field' => 'both_d_diag2_unknow', 'nbErrorOccurrences' => $both_d_diag2_unknowResult ? count($both_d_diag2_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_d_diag2_unknowResult ? $both_d_diag2_unknowResult : []]);

        // 133- VAR both_d_diag3
//        $both_d_diag3SQL = "SELECT id  FROM data WHERE both_d_diag3 NOT REGEXP BINARY '/^([0-9]{3})|([A-Z]{1}[0-9]{2})|([0-9]{3}[.][0-9]{1,2})|([A-Z]{1}[0-9]{2}[.][0-9]{1,2})$' OR both_d_diag3 != NULL";
//        $both_d_diag3Result = $this->conn->fetchAll($both_d_diag3SQL);
//        array_push($result, ['field' => 'both_d_diag3', 'nbErrorOccurrences' => $both_d_diag3Result ? count($both_d_diag3Result) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_d_diag3Result ? $both_d_diag3Result : []]);

        // 134- VAR both_d_diag3_unknow
        $both_d_diag3_unknowSQL = "SELECT id  FROM data WHERE both_d_diag3_unknow != 1 OR both_d_diag3_unknow != NULL";
        $both_d_diag3_unknowResult = $this->conn->fetchAll($both_d_diag3_unknowSQL);
        array_push($result, ['field' => 'both_d_diag3_unknow', 'nbErrorOccurrences' => $both_d_diag3_unknowResult ? count($both_d_diag3_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_d_diag3_unknowResult ? $both_d_diag3_unknowResult : []]);

        // 135- VAR both_frailty_score_discharge
        $both_frailty_score_dischargeSQL = 'SELECT id  FROM data WHERE both_frailty_score_discharge NOT IN(1,2,3,4,5,6,7,8,9) OR both_frailty_score_discharge IS NULL OR  LENGTH(both_frailty_score_discharge) = 0 ';
        $both_frailty_score_dischargeResult = $this->conn->fetchAll($both_frailty_score_dischargeSQL);
        array_push($result, ['field' => 'both_frailty_score_discharge', 'nbErrorOccurrences' => $both_frailty_score_dischargeResult ? count($both_frailty_score_dischargeResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_frailty_score_dischargeResult ? $both_frailty_score_dischargeResult : []]);

        // 136- VAR both_frailty_score_discharge_unknow
        $both_frailty_score_discharge_unknowSQL = 'SELECT id  FROM data WHERE both_frailty_score_discharge_unknow != 1 OR both_frailty_score_discharge_unknow != NULL';
        $both_frailty_score_discharge_unknowResult = $this->conn->fetchAll($both_frailty_score_discharge_unknowSQL);
        array_push($result, ['field' => 'both_frailty_score_discharge_unknow', 'nbErrorOccurrences' => $both_frailty_score_discharge_unknowResult ? count($both_frailty_score_discharge_unknowResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_frailty_score_discharge_unknowResult ? $both_frailty_score_discharge_unknowResult : []]);

        // 137- VAR both_sample_submited
        $both_sample_submitedSQL = 'SELECT id  FROM data WHERE both_sample_submited NOT IN(0,1,2) OR both_sample_submited IS NULL OR LENGTH(both_sample_submited) = 0';
        $both_sample_submitedResult = $this->conn->fetchAll($both_sample_submitedSQL);
        array_push($result, ['field' => 'both_sample_submited', 'nbErrorOccurrences' => $both_sample_submitedResult ? count($both_sample_submitedResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_sample_submitedResult ? $both_sample_submitedResult : []]);

        // 138- VAR both_epi_isl
        $both_epi_islSQL = "SELECT id  FROM data WHERE both_epi_isl  NOT REGEXP '^[[:<:]]EPI_ISL_[0-9]{7}$' OR both_epi_isl != NULL";
        $both_epi_islResult = $this->conn->fetchAll($both_epi_islSQL);
        array_push($result, ['field' => 'both_epi_isl', 'nbErrorOccurrences' => $both_epi_islResult ? count($both_epi_islResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_epi_islResult ? $both_epi_islResult : []]);

        // 139- VAR both_sample_type
        $both_sample_typeSQL = 'SELECT id  FROM data WHERE both_sample_type NOT IN(1,2,3)  OR both_sample_type != NULL';
        $both_sample_typeResult = $this->conn->fetchAll($both_sample_typeSQL);
        array_push($result, ['field' => 'both_sample_type', 'nbErrorOccurrences' => $both_sample_typeResult ? count($both_sample_typeResult) . '/' . $nbLinesInData : '0/' . $nbLinesInData, 'errorIds' => $both_sample_typeResult ? $both_sample_typeResult : []]);

        // Export data verification results from GIHSN database to Excel file
        $file = count($result) > 0 ? $this->exportDataToExcel($result) : null;

        return $this->render('data/list_wrong_data.html.twig', [
            'data' => $result,
            'file' => $file,
        ]);
    }

    /**
     * Description :: function for exporting the result of checking the format of database fields in an excel file
     */
    public function exportDataToExcel($result)
    {
        $filename = 'WRONG_DATA_DB_GIHSN_' . (new \DateTime())->format('d_m_Y_H_i') . '.xlsx';
        $header = array('field', 'nbErrorOccurrences', 'errorIds');
        $spreadsheet = new Spreadsheet();
        $Excel_writer = new Xlsx($spreadsheet);
        $spreadsheet->setActiveSheetIndex(0);
        $activeSheet = $spreadsheet->getActiveSheet();

        $col = 0;
        foreach ($header as $key => $label) {
            $activeSheet->setCellValue($this->functions->excelCellName($col) . '1', $label);
            $col++;
        }
        $row = 2;
        foreach ($result as $line) {
            $col = 0;
            foreach ($header as $key => $label) {
                if (is_array($line[$label])) {
                    $value = "";
                    foreach ($line[$label] as $item) {
                        $value = $value . $item['id'] . ', ';
                    }
                } else {
                    $value = $line[$label];
                }
                $activeSheet->setCellValue($this->functions->excelCellName($col) . $row, $value);
                $col++;
            }
            $row++;
        }
        header('Content-Type: application/vnd.ms-excel');
        header('Cache-Control: max-age=0');
        $Excel_writer->save($this->getParameter('absolute_import_directory') . '/' . $filename);

        return $this->getParameter('relative_import_directory') . "/" . $filename;
    }

    /**
     * Description :: verify the format of the all fields and restore in a table with their occurrence identifiers
     * @Route("/completness_database_export", name="completness_database_export")
     */
    public function completnessDatabaseExport(Request $request)
    {

        // verify the user connected
        if (!$this->getUser()->getManager()) {
            $this->addFlash('danger', "This page is accessible only by platform administrators!");
            return $this->redirectToRoute('error_page');
        }
        //save the action of exportation in the historic table
        //$this->globalServices->saveHistoric($this->getUser(), "Exporting data", 1);

        $email = $this->getUser()->getEmail();
        $path = $this->getParameter("PATH_EXPORT");

        //generate the file, an email will automatically be sent to the user who requested the export
        // DEV
//        exec('/usr/bin/nohup php7.3 ' . $path . '/bin/console app:completeness:database:export ' . $email . '  ' .
//            str_replace(" ", "_", $this->getUser()->getManager()->getFullName()) . ' >/dev/null 2>&1 &');

        //PREPROD-PROD
        exec('/usr/bin/nohup php ' . $path . '/bin/console app:completeness:database:export ' . $email . '  ' .
            str_replace(" ", "_", $this->getUser()->getManager()->getFullName()) . ' >/dev/null 2>&1 &');

        return new JsonResponse(array(
            'status' => 200,
            'message' => 'An email will be sent when the export is ready'
        ));
    }

}
