<?php
/**
 * Created by PhpStorm.
 * User: ELLIGY
 * Date: 01/01/2020
 * Time: 18:06
 */

namespace App\Controller;

use App\Service\EmailsTemplateSender;
use DateTime;
use Psr\Container\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Security\Core\Encoder\EncoderFactoryInterface;
use Symfony\Contracts\HttpClient\HttpClientInterface;


class HomeController extends Controller
{
    protected $em;
    private $encoderFactory;
    private $client;
    private $emailsTemplateSender;

    public function __construct(ContainerInterface $container,
                                EncoderFactoryInterface $encoderFactory,
                                HttpClientInterface $client,
                                EmailsTemplateSender   $emailsTemplateSender)
    {
        $this->em = $container->get('doctrine.orm.default_entity_manager');
        $this->encoderFactory = $encoderFactory;
        $this->client = $client;
        $this->emailsTemplateSender = $emailsTemplateSender;
    }

    /**
     * Description :: home page
     * @Route("/", name="home")
     */
    public function index()
    {
//        before the redirection to the home page, we check
//        if the user has a temporary password or not if yes we force the redirection to the page for changing his password.
        if ($this->getUser()->getTemporaryPassword()){
            return $this->redirectToRoute('edit_password');
        }else{
            return $this->render('home/index.html.twig', []);
        }

    }

    /**
     * Description :: validate cgu ajax
     * @Route("/validate_cgu_ajax", name="validate_cgu_ajax")
     */
    public function validateCguAjax()
    {
        // check if the user is visitor or not
        if (!$this->getUser()->getVisitor()) {
            $this->addFlash('danger', "This page is accessible only by platform users!");
            return $this->redirectToRoute('error_page');
        }
        $visitor = $this->getUser()->getVisitor();
        $visitor->setValidateCgu(true);
        $visitor->setDateValidationCgu(new DateTime());
        $this->em->persist($visitor);
        $this->em->flush();
        $this->emailsTemplateSender->email_validation_cgu($visitor);
        return new JsonResponse([
            'status' => 200,
            'message' => "General terms successfully accepted."
        ]);
    }
}
