<?php

namespace App\Controller;

use App\Entity\Reponse;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Mailer\Exception\TransportExceptionInterface;
use Symfony\Component\Routing\Annotation\Route;
use Doctrine\DBAL\Connection;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Mime\Email;
use Symfony\Bridge\Twig\Mime\TemplatedEmail;

class QuestionnaireController extends AbstractController
{
    /**
     * @Route("/q/{token}", name="app_questionnaire")
     */
    public function index(string $token, Request $request): Response
    {
        return $this->render('questionnaire/index.html.twig', [
            'controller_name' => 'QuestionnaireController',
        ]);
    }

    /**
     * @Route("/reponse", name="app_questionnaire_save")
     */
    public function saveResponse(Request $request, Connection $conn): Response
    {

        // 01- sauvegarde réponse question 1
        if($request->get("radio")) {
            $this->sauvegardeReponse('q1', $request->get("radio"));
        }

        // 02 - sauvegarde réponse question 2
        if($request->get("radio2")) {
            $this->sauvegardeReponse('q2', $request->get("radio2"));
        }

        // 03 - sauvegarde réponse question 3
        if($request->get("radio3")) {
            $this->sauvegardeReponse('q3', $request->get("radio3"));
        }

        // 04 - sauvegarde réponse question 4
        if($request->get("radio4")) {
            $this->sauvegardeReponse('q4', $request->get("radio4"));
        }

        // 05 - sauvegarde réponse question 5
        if($request->get("radio5")) {
            $this->sauvegardeReponse('q5', $request->get("radio5"));
        }

        if($request->get('question5d')){
            foreach ($request->get('question5d') as $r){
                $this->sauvegardeReponse('q5d', $r);
            }
        }



        // 06 - sauvegarde réponse question 6
        if($request->get('question6d')){
            foreach ($request->get('question6d') as $r){
                $this->sauvegardeReponse('q6', $r);
            }
        }
        if($request->get("autre6")) {
            $this->sauvegardeReponse('q6autre', $request->get("autre6"));
        }

        // 07 - sauvegarde réponse question 7
        if($request->get("radio7")) {
            $this->sauvegardeReponse('q7', $request->get("radio7"));
        }

        if($request->get('question7d')){
            foreach ($request->get('question7d') as $r){
                $this->sauvegardeReponse('q7d', $r);
            }
        }
        if($request->get("autre7")) {
            $this->sauvegardeReponse('q7autre', $request->get("autre7"));
        }

        // 08 - sauvegarde réponse question 8
        if($request->get("radio8")) {
            $this->sauvegardeReponse('q8', $request->get("radio8"));
        }

        // 09 - sauvegarde réponse question 9
        if($request->get("radio9")) {
            $this->sauvegardeReponse('q9', $request->get("radio9"));
        }

        $link = $this->generateUrl('app_questionnaire', ['token' => '111']);
        return new Response("<html><body>Merci à vous. <br> <a href='$link'>retour</a></body></html>");
        return $this->render('questionnaire/index.html.twig', [
            'controller_name' => 'QuestionnaireController',
        ]);
    }





    /**
     * Permets l'enregistrement d'une nouvelle réponse
     * @param string $codequestion
     * @param string $rep
     * @param $codeuser
     * @return bool
     */
    private function sauvegardeReponse(string $codequestion, string $rep, $codeuser = null){
        $em         = $this->getDoctrine()->getManager();
//        $em         = $this->container->get('doctrine')->getManager();
        $repQ       = $this->container->get('doctrine')->getManager()->getRepository("\App\Entity\Question");
        $repObject = new Reponse();
        $repObject->setCodequestion($codequestion)->setQuestion($repQ->findOneBy(["code" => $codequestion]))->setRep($rep);
        $em->persist($repObject);$em->flush();
        unset($repObject);

        return true;
    }



    /**
     * Permets l'envoi du mailing vers les destinataires.
     * @Route("/send")
     */
    public function mailing(MailerInterface $mailer, Connection $conn){
        $list = $conn->fetchAllAssociative("select * from question limit 1 ");
        foreach ($list as $item) {
            $id = $item['rpps'];
            try {
                $email = (new TemplatedEmail())
//                ->from(new Address('fabien@example.com', 'Fabien'))
                ->from('technique@impactdev.tn')
                ->to('nadhem.khanfir@impactdev.tn')
                ->subject('Test envoi depuis local')
//                ->html('<p>See Twig integration for better HTML integration!</p>')

                // path of the Twig template to render
                ->htmlTemplate('email/email.html.twig')
                // pass variables (name => value) to the template
                ->context([
                    'item' => $item,
                ])
                ;
                $mailer->send($email);

            } catch (TransportExceptionInterface $e) {
                dd($e); exit;
            }
        }

        return new Response("<html><body>envoi terminer</body></html>");
    }

}
