<?php

namespace App\Controller;

use Doctrine\DBAL\Driver\Connection;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class VariableController extends AbstractController
{

    /**
     * @Route("/var/export", name="variable_test")
     */
    public function testtAction(Request $request): Response
    {
        exec('/usr/bin/nohup php /var/www/clients/client18/web33/web/bin/console app:export 1 >/dev/null 2>&1 &');

        return new Response("Génération de fichiers export en cours en arrière-plan");
    }

    /**
     * @Route("/test", name="variable_test")
     */
    public function testAction(Request $request): Response
    {
        return new Response(" envoi de mail en cours => ".$request->get('email'));
    }

    /**
     * @Route("/var/sql", name="variable_sql")
     */
    public function runSQLAction(Connection $conn, Request $request): Response
    {
        // list of variables to calculate after any import
        // only the variables of the lines contained "tocalculate = 1" to be calculated

        set_time_limit(3600);

        // mise à jour des date en format d/m/Y en cas ou nous avons des champs du style Y-m-d H:i:s.f
        $conn->exec("update data set both_doa = date_format(STR_TO_DATE(both_doa,'%Y-%m-%d %H:%i:%s.%f'), '%d/%m/%Y') 
                        where both_doa like '%.%' and both_doa not like '%T%'
        ;");
        $conn->exec("update data set both_discharged_date = date_format(STR_TO_DATE(both_discharged_date,'%Y-%m-%d %H:%i:%s.%f'), '%d/%m/%Y') 
                        where both_discharged_date like '%.%' and both_discharged_date not like '%T%'
        ;");

        $conn->exec("update data set both_doa = date_format(STR_TO_DATE(SUBSTRING_INDEX(both_doa,'T',1),'%Y-%m-%d'), '%d/%m/%Y') 
                        where both_doa like '%.%' and both_doa like '%T%' and LENGTH(both_doa) > 2
        ;");
        $conn->exec("update data set both_discharged_date = date_format(STR_TO_DATE(SUBSTRING_INDEX(both_discharged_date,'T',1),'%Y-%m-%d'), '%d/%m/%Y') 
                        where both_discharged_date like '%.%' and both_discharged_date like '%T%' and LENGTH(both_discharged_date) > 2 
        ;");

        // 02- VAR SCREENED
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `screened` int(11) DEFAULT NULL;");
        $conn->exec("update `data` set `screened` = 1 where tocalculate = 1;");


        // 03- VAR SEQUENCED
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `sequenced` int(11) DEFAULT NULL;");
        $conn->exec("update `data` set `sequenced` = 1 where both_epi_isl is not null and LENGTH(both_epi_isl) > 0 and tocalculate = 1 ;");

        // 04- VAR LCI+
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `lci_plus` int(11) DEFAULT NULL;");
        $conn->exec("update `data` set `lci_plus` = 1 
                     where both_lab_flu_h1n1 = '1' or both_lab_flu_h1nother  = '1' or both_lab_flu_h3n2  = '1' or both_lab_flu_h3nother  = '1'  or both_lab_flu_yamagata  = '1' or both_lab_flu_victoria  = '1'
                     or both_lab_flu_a_nosub = '1' or both_lab_flu_b_nosub = '1' and tocalculate = 1 ;
        ");

        // 05- VAR ORV+
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `orv_plus` int(11) DEFAULT NULL;");
        $conn->exec("update `data` set `orv_plus` = 1 
                                    where both_lab2_corona_yesno = '1' or both_lab2_metaneumo_yesno  = '1' 
                                    or both_lab2_rs_yesno  = '1' or both_lab2_adeno_yesno  = '1'
                                    or both_lab2_boca_yesno = '1' or both_lab2_pi_yesno = '1' or both_lab2_rhino_yesno = '1' 
                                    or both_lab2_sarscov2_yesno = '1' or both_lab2_evd68_yesno = '1' or both_lab2_others_yesno = '1'
                                    and tocalculate = 1 ;
        ");

        // 06- VAR ORV+ (sans RSV)
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `orv_plus_sans_rsv` int(11) DEFAULT NULL;");
        $conn->exec("update `data` set `orv_plus_sans_rsv` = 1 
                                    where both_lab2_corona_yesno = '1' or both_lab2_metaneumo_yesno  = '1' 
                                    or both_lab2_rs_yesno  = '1' or both_lab2_adeno_yesno  = '1' or both_lab2_boca_yesno = '1' 
                                    or both_lab2_pi_yesno = '1' or both_lab2_rhino_yesno = '1' or both_lab2_sarscov2_yesno = '1' 
                                    or both_lab2_evd68_yesno = '1' or both_lab2_others_yesno = '1' and tocalculate = 1 ;
        ");

        // 07- VAR ORV+ (sans SARS-CoV-2)
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `orv_plus_sans_sars_cov_2` int(11) DEFAULT NULL;");
        $conn->exec("update `data` set `orv_plus_sans_sars_cov_2` = 1 
                                    where both_lab2_corona_yesno = '1' or both_lab2_metaneumo_yesno  = '1' 
                                    or both_lab2_rs_yesno  = '1' or both_lab2_adeno_yesno  = '1' or both_lab2_boca_yesno = '1' 
                                    or both_lab2_pi_yesno = '1' or both_lab2_rhino_yesno = '1' or both_lab2_others_yesno = '1' and tocalculate = 1 ;
        ");

        // 08- VAR ORV+ (sans RSV ni SARS-CoV-2)
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `orv_plus_sans_rsv_sans_sars_cov_2` int(11) DEFAULT NULL;");
        $conn->exec("update `data` set `ORV_plus_sans_rsv_sans_sars_cov_2` = 1 
                     where both_lab2_corona_yesno = '1' or both_lab2_metaneumo_yesno  = '1' or both_lab2_adeno_yesno  = '1' or both_lab2_boca_yesno  = '1'
                     or both_lab2_pi_yesno = '1' or both_lab2_rhino_yesno = '1' or both_lab2_others_yesno = '1' and tocalculate = 1 ; 
        ");

        // 09- VAR Test ORV
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `test_orv` int(11) DEFAULT NULL;");
        $conn->exec("update `data` set `test_orv` = 1 
                     where both_lab2_corona = '1' or both_lab2_metaneumo  = '1' or both_lab2_rs = '1' or both_lab2_adeno  = '1'
                     or both_lab2_boca = '1' or both_lab2_pi = '1' or both_lab2_rhino = '1' or both_lab2_sarscov2 = '1' or both_lab2_evd68 = '1' or both_lab2_others = '1' and tocalculate = 1 ;
        ");

        // 10- VAR Test ORV (sans RSV)
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `test_orv_sans_rsv` int(11) DEFAULT NULL;");
        $conn->exec("update `data` set `test_orv_sans_rsv` = 1 
                     where both_lab2_corona = '1' or both_lab2_metaneumo  = '1' or both_lab2_adeno = '1' or both_lab2_boca  = '1'
                     or both_lab2_pi = '1' or both_lab2_rhino = '1' or both_lab2_sarscov2 = '1' or both_lab2_evd68 = '1' or both_lab2_others  = '1' and tocalculate = 1 ;
        ");

        // 11- VAR Test ORV (sans SARS-CoV-2)
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `test_orv_sans_sars_cov_2` int(11) DEFAULT NULL;");
        $conn->exec("update `data` set `test_orv_sans_sars_cov_2` = 1 
                     where both_lab2_corona = '1' or both_lab2_metaneumo  = '1' or both_lab2_rs  = '1' or both_lab2_adeno = '1'
                     or both_lab2_boca = '1' or both_lab2_pi = '1' or both_lab2_rhino = '1' or both_lab2_others  = '1' and tocalculate = 1 ;
        ");

        // 12- VAR Test ORV (sans RSV ni SARS-CoV-2)
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `test_orv_sans_rsv_sans_sars_cov_2` int(11) DEFAULT NULL;");
        $conn->exec("update `data` set `test_orv_sans_rsv_sans_sars_cov_2` = 1 
                     where both_lab2_corona = '1' or both_lab2_metaneumo  = '1' or both_lab2_adeno  = '1' or both_lab2_boca = '1'
                     or both_lab2_pi = '1' or both_lab2_rhino = '1' or both_lab2_others  = '1' and tocalculate = 1 ; 
        ");

        // 13- VAR Traitements à faire pour l’âge
        // both_age_unit et both_age sont calculer par defaut dans l'import a partir de la season 21_22 donc on n'a pas besion de calculer une autre fois
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `both_age` int(11) DEFAULT NULL;");
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `both_age_unit` int(11) DEFAULT NULL;");


        // 14- VAR Tranches d’âge
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `tranche_age_def1` varchar(100) DEFAULT NULL;");
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `tranche_age_def2` varchar(100) DEFAULT NULL;");
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `tranche_age_def3` varchar(100) DEFAULT NULL;");


        $conn->exec("update `data` set `tranche_age_def1` = 
                        CASE  
                                                      
                          WHEN 
                          if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                          if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                          if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 0 AND 5  THEN '< 5 yo'
                          WHEN 
                          if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                          if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                          if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 5 AND 18  THEN '5-18'
                          WHEN 
                          if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                          if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                          if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 18 AND 45 THEN '18-45'
                          WHEN 
                          if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                          if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                          if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 45 AND 65 THEN '45-65'
                          WHEN 
                          if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                          if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                          if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 65 AND 80 THEN '65-80'
                          WHEN 
                          if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                          if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                          if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 80 AND 1000 THEN '80+'
                         END,
                         
                         `tranche_age_def2` = 
                        CASE  
                            WHEN 
                            if(both_age_unit = 3 and LENGTH(both_age) > 0, (both_age/365)*12 ,
                            if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age, 
                            if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age*12, -1))) BETWEEN 0 AND 6  THEN '< 6m'
                            WHEN 
                            if(both_age_unit = 3 and LENGTH(both_age) > 0, (both_age/365)*12 ,
                            if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age, 
                            if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age*12, -1))) BETWEEN 6 AND 11  THEN '6-11m'
                            WHEN 
                            if(both_age_unit = 3 and LENGTH(both_age) > 0, (both_age/365)*12 ,
                            if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age, 
                            if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age*12, -1))) BETWEEN 12 AND 23  THEN '12-23m'
                            WHEN  
                            if(both_age_unit = 3 and LENGTH(both_age) > 0, (both_age/365)*12 ,
                            if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age, 
                            if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age*12, -1))) BETWEEN 24 AND 59  THEN '2-4y'
                            WHEN 
                            if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                            if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                            if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 5 AND 9 THEN '5-9y'
                            WHEN
                            if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                            if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                            if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 10 AND 14 THEN '10-14y'
                            WHEN 
                            if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                            if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                            if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 15 AND 49 THEN '15-49y'
                            WHEN 
                            if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                            if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                            if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 50 AND 64 THEN '50-64y'
                            WHEN 
                            if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                            if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                            if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 65 AND 80 THEN '65-80y'
                            WHEN 
                            if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                            if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                            if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 80 AND 1000 THEN '+80y'
                        END,
                         
                         `tranche_age_def3` = 
                        CASE  
                              WHEN 
                              if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                              if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                              if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 0 AND 5  THEN '< 5y'
                              WHEN  
                              if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                              if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                              if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 5 AND 49 THEN '5-49y'
                              WHEN 
                              if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                              if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                              if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 50 AND 64 THEN '50-64y'
                              WHEN 
                              if(both_age_unit = 3 and LENGTH(both_age) > 0, both_age/365 ,
                              if(both_age_unit = 2 and LENGTH(both_age) > 0, both_age/12, 
                              if(both_age_unit = 1 and LENGTH(both_age) > 0, both_age, -1))) BETWEEN 65 AND 1000 THEN '+65y'
                         END
                        
                         where tocalculate = 1;
        ");

        // 15- VAR Length of hospital stay
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `length_of_hospital_stay` int(11) DEFAULT NULL;");
        $conn->exec("update `data` set `length_of_hospital_stay` = abs(TIMESTAMPDIFF (DAY, STR_TO_DATE(both_discharged_date,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y')))
                    where both_discharged_date is not null and LENGTH(both_discharged_date) > 0 and both_doa is not null and LENGTH(both_doa) > 0 and tocalculate = 1 ;
        ");

        // 16- VAR Week number
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `week_number` varchar(100) DEFAULT NULL;");

        // 17- VAR Exclusion
        $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `exclusion` int(11) DEFAULT NULL;");
        $conn->exec("update `data` set `exclusion` = 1 where site_id in (200,201, 202) and tocalculate = 1 ; ");

        try{
            // 01- VAR INCLUDED

            $conn->exec("ALTER TABLE `data` ADD COLUMN IF NOT EXISTS `included` int(11) DEFAULT NULL;");
            // Start calculation For season 2012-13
            // Spain site calculation
            // For patients under 5 year  spain site
            $conn->exec("update `data` set `included` = 1 where season = '12_13'                     
                           and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null) 
                                is not null 
                           and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null) 
                                * 1 >= 0
                           and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null)
                                * 1 < 5           
                           and communication = '1' and consents = '1' 
                           and institutionalized is not null and LENGTH(institutionalized)  > 0 and institutionalized = '0' 
                           and exclussion_hosp is not null and LENGTH(exclussion_hosp) > 0 and exclussion_hosp = '0'
                           and sym_7d_yn = '1'  and residence = 1 and site_id = 1
                           and tocalculate = 1 ;");
            // For patients over 5 year spain site
            $conn->exec("update `data` set `included` = 1 where season = '12_13'                     
                       and (if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12 ,both_age)),null) 
                            * 1 >= 5
                                OR 
                            if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12 ,both_age)),null) 
                            is null 
                           )                 
                                       
                       and communication = '1' and consents = '1' 
                       and institutionalized is not null and LENGTH(institutionalized) > 0 and institutionalized = '0' 
                       and exclussion_hosp is not null and LENGTH(exclussion_hosp) > 0 and exclussion_hosp = '0' 
                       and sym_7d_yn = '1' and residence = 1 and comp_ili = '1' and site_id = 1 and tocalculate = 1;");
            // End calculation For season 2012-13 spain site
            // For patients under 5 year
            $conn->exec("update `data` set `included` = 1 where season = '12_13'                     
                       and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null) 
                            is not null 
                       and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null) 
                            * 1 >= 0
                       and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null)
                            * 1 < 5           
                       and communication = '1' and consents = '1' 
                       and institutionalized is not null and LENGTH(institutionalized)  > 0 and institutionalized = '0' 
                       and exclussion_hosp is not null and LENGTH(exclussion_hosp) > 0 and exclussion_hosp = '0'
                       and sym_7d_yn = '1'  and site_id NOT IN('1') and tocalculate = 1 ;");

            // For patients over 5 year
            $conn->exec("update `data` set `included` = 1 where season = '12_13'                     
                   and (
                        if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12 ,both_age)),null) 
                        * 1 >= 5
                            OR 
                        if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12 ,both_age)),null) 
                        is null 
                       )                 
                                   
                   and communication = '1' and consents = '1' 
                   and institutionalized is not null and LENGTH(institutionalized) > 0 and institutionalized = '0' 
                   and exclussion_hosp is not null and LENGTH(exclussion_hosp) > 0 and exclussion_hosp = '0' 
                   and sym_7d_yn = '1'  and comp_ili = '1'  and site_id NOT IN('1') and tocalculate = 1;");

            // End calculation For season 2012-13

            $conn->exec("update `data` set `included` = 1 where 
                   season in ('12_13','13_14', '14_15', '15_16', '16_17', '17_18')
                    
                   and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null)
                        is not null 
                   and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null)
                        * 1 >= 0
                   and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null)
                        * 1 < 5 
        
                                   
                   and communication = '1' and consents = '1' and residence  = '1' 
                   and institutionalized is not null and LENGTH(institutionalized)  > 0 and institutionalized = '0' 
                   and exclussion_hosp is not null and LENGTH(exclussion_hosp) > 0 and exclussion_hosp = '0' and sym_7d_yn = '1'  
                   and tocalculate = 1 
                   ;
    
        ");

            $conn->exec("update `data` set `included` = 1 where 
                   season in ('12_13','13_14', '14_15', '15_16', '16_17', '17_18')
                    
                   and 
                       (
                       if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12 ,both_age)),null)
                        * 1 >= 5
                            OR 
                        if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12 ,both_age)),null)
                        is null 
                       )
                   
                                   
                   and communication = '1' and consents = '1' and residence  = '1' 
                   and institutionalized is not null and LENGTH(institutionalized) > 0 and institutionalized = '0' 
                   and exclussion_hosp is not null and LENGTH(exclussion_hosp) > 0 and exclussion_hosp = '0' 
                   and sym_7d_yn = '1'  and comp_ili = '1' 
                   and tocalculate = 1 
                   ;
            ");


            // Start calculation For seasons 2013-14 to 2017-18
            // For patients under 5 year
            $conn->exec("update `data` set `included` = 1 where season in ('13_14', '14_15', '15_16', '16_17', '17_18')                    
                           and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null)
                                is not null 
                           and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null) 
                                * 1 >= 0
                           and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null) 
                                * 1 < 5           
                           and communication = '1' and consents = '1'  and residence = '1'
                           and institutionalized is not null and LENGTH(institutionalized)  > 0 and institutionalized = '0' 
                           and exclussion_hosp is not null and LENGTH(exclussion_hosp) > 0 and exclussion_hosp = '0'
                           and sym_7d_yn = '1' and tocalculate = 1;");
            // For patients over 5 year
            $conn->exec("update `data` set `included` = 1 where season in ('13_14', '14_15', '15_16', '16_17', '17_18')                    
                       and (
                            if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12 ,both_age)),null) 
                            * 1 >= 5
                                OR 
                            if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12 ,both_age)),null) 
                            is null 
                           )                 
                                       
                       and communication = '1' and consents = '1' 
                       and institutionalized is not null and LENGTH(institutionalized) > 0 and institutionalized = '0' 
                       and exclussion_hosp is not null and LENGTH(exclussion_hosp) > 0 and exclussion_hosp = '0' 
                       and sym_7d_yn = '1'  and residence = 1  and comp_ili = '1'  and tocalculate = 1;");
            // End  calculation For seasons 2013-14 to 2017-18


            // Start calculation For season 2018-19
            $conn->exec("update `data` set `included` = 1 where 
                         season = '18_19' and communication = '1' and consents = '1' and (sym_7d_yn  = '1' OR comp_ili  = '1') and tocalculate = 1 ;");
            // End calculation For season 2018-19

            // Start season 19_20 and 20_21 calculation
            //	For patients over 5 year
            $conn->exec("update `data` set `included` = 1 where season in ('19_20', '20_21')
                               and 
                                   (
                                    if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12 ,both_age)),null) 
                                    * 1 >= 5
                                        OR 
                                    if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12 ,both_age)),null) 
                                    is null 
                                   ) and both_comp_a_diag = 1 and more_comply = 1 and tocalculate = 1 ;");

            //For patients under 5 year
            $conn->exec("update `data` set `included` = 1 where season in ('19_20', '20_21') 
                                        and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null) 
                                        is not null 
                                         and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null) 
                                        * 1 >= 0
                                         and if(both_age is not null and both_age_unit is not null, if(both_age_unit = 3, both_age/365, if(both_age_unit = 2, both_age/12, both_age)),null)
                                        * 1 < 5                                    
                                        and both_comp_a_diag = 1  and tocalculate = 1 ;");

            //End  season 19_20 and 20_21 calculation

            //Start calculation For season >= 2021-22
            $conn->exec("update `data` set `included` = 1 where season not in ('12_13', '13_14', '14_15', '15_16', '16_17', '17_18', '18_19', '19_20', '20_21') and tocalculate = 1 ;");
            // End calculation season >= 2021-22

            // après avoir terminé le calcul de toutes les variables, nous mettons à jour tocalculate = 2 pour ne pas être calculé une autre fois.
            $conn->exec("update `data` set `tocalculate` = 2 where tocalculate = 1;");

        }catch(\Exception $e){}


        // Var season
        // $conn->exec("update `data` set `season` = CASE WHEN DATE_FORMAT(STR_TO_DATE(both_doa,'%d/%m/%Y'), '%Y-%m-%d') > CONCAT(DATE_FORMAT(STR_TO_DATE(both_doa,'%d/%m/%Y'), '%Y'),'-11-01') or DATE_FORMAT(STR_TO_DATE(both_doa,'%d/%m/%Y'), '%Y-%m-%d') = CONCAT(DATE_FORMAT(STR_TO_DATE(both_doa,'%d/%m/%Y'), '%Y'),'-11-01') THEN CONCAT(DATE_FORMAT(STR_TO_DATE(both_doa,'%d/%m/%Y'), '%y'), '_', DATE_FORMAT(DATE_ADD(STR_TO_DATE(both_doa,'%d/%m/%Y'), INTERVAL 1 YEAR), '%y'))
        // WHEN DATE_FORMAT(STR_TO_DATE(both_doa,'%d/%m/%Y'), '%Y-%m-%d') < CONCAT(DATE_FORMAT(STR_TO_DATE(both_doa,'%d/%m/%Y'), '%Y'),'-10-31') or DATE_FORMAT(STR_TO_DATE(both_doa,'%d/%m/%Y'), '%Y-%m-%d') = CONCAT(DATE_FORMAT(STR_TO_DATE(both_doa,'%d/%m/%Y'), '%Y'),'-10-31') THEN CONCAT(DATE_FORMAT(DATE_SUB(STR_TO_DATE(both_doa,'%d/%m/%Y'), INTERVAL 1 YEAR), '%y'), '_', DATE_FORMAT(STR_TO_DATE(both_doa,'%d/%m/%Y'), '%y'))
        // ELSE `season`END  where both_doa IS NOT NULL and LENGTH(both_doa) > 0 AND tocalculate = 1 ;");

        return new Response("terminé");
    }

}
