<?php

namespace App\Entity\Main;

use App\Repository\Main\DataRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=DataRepository::class)
 * @ORM\Table(name="data",indexes={@ORM\Index(name="search_season_zone_age",columns={"season", "site_id"}),
 *     @ORM\Index(name="search_season_zone", columns={"season", "site_id"}),
 *     @ORM\Index(name="search_season",columns={"season"}),
 *     @ORM\Index(name="search_philippe",columns={"id_bdd_philippe"}),
 *     @ORM\Index(name="search_portail",columns={"id_wp"})})
 */
class Data
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="season", type="string", length=255, nullable=true)
     */
    private $season;

    /**
     * @var string|null
     *
     * @ORM\Column(name="id_bdd_philippe", type="integer", nullable=true)
     */
    private $idBddPhilippe;

    /**
     * @var string|null
     *
     * @ORM\Column(name="id_wp", type="integer", nullable=true)
     */
    private $idWp;

    /**
     * @var string|null
     * @ORM\Column(name="id_site_bdd_philippe", type="integer", nullable=true)
     */
    private $idSiteBddPhilippe;

    /**
     * @var string|null
     *
     * @ORM\Column(name="OHC_TECH_ID", type="text", length=65535, nullable=true)
     */
    private $ohcTechId;

    /**
     * @var string|null
     *
     * @ORM\Column(name="OHC_TECH_IdIntegration", type="text", length=65535, nullable=true)
     */
    private $ohcTechIdintegration;

    /**
     * @var string|null
     *
     * @ORM\Column(name="OHC_TECH_SEA_ID", type="text", length=65535, nullable=true)
     */
    private $ohcTechSeaId;

    /**
     * @var string|null
     *
     * @ORM\Column(name="date_last_modified", type="text", length=65535, nullable=true)
     */
    private $dateLastModified;

    /**
     * @var string|null
     *
     * @ORM\Column(name="id_last_modificator", type="text", length=65535, nullable=true)
     */
    private $idLastModificator;

    /**
     * @var string|null
     *
     * @ORM\Column(name="name_last_modificator", type="text", length=65535, nullable=true)
     */
    private $nameLastModificator;

    /**
     * @var string|null
     *
     * @ORM\Column(name="is_validated", type="text", length=65535, nullable=true)
     */
    private $isValidated;

    /**
     * @var string|null
     *
     * @ORM\Column(name="form_type", type="text", length=65535, nullable=true)
     */
    private $formType;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_comp_a_diag", type="text", length=65535, nullable=true)
     */
    private $bothCompADiag;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_a_diag", type="text", length=65535, nullable=true)
     */
    private $bothADiag;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_a_diag_icd", type="text", length=65535, nullable=true)
     */
    private $bothADiagIcd;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_doa", type="text", length=65535, nullable=true)
     */
    private $bothDoa;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_id_hospital", type="text", length=65535, nullable=true)
     */
    private $bothIdHospital;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_id_patient", type="text", length=65535, nullable=true)
     */
    private $bothIdPatient;

    /**
     * @var string|null
     *
     * @ORM\Column(name="doq", type="text", length=65535, nullable=true)
     */
    private $doq;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_sex", type="text", length=65535, nullable=true)
     */
    private $bothSex;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dob", type="text", length=65535, nullable=true)
     */
    private $dob;

    /**
     * @var string|null
     *
     * @ORM\Column(name="communication", type="text", length=65535, nullable=true)
     */
    private $communication;

    /**
     * @var string|null
     *
     * @ORM\Column(name="consents", type="text", length=65535, nullable=true)
     */
    private $consents;

    /**
     * @var string|null
     *
     * @ORM\Column(name="residence", type="text", length=65535, nullable=true)
     */
    private $residence;

    /**
     * @var string|null
     *
     * @ORM\Column(name="institutionalized", type="text", length=65535, nullable=true)
     */
    private $institutionalized;

    /**
     * @var string|null
     *
     * @ORM\Column(name="exclussion_hosp", type="text", length=65535, nullable=true)
     */
    private $exclussionHosp;

    /**
     * @var string|null
     *
     * @ORM\Column(name="soc_class", type="text", length=65535, nullable=true)
     */
    private $socClass;

    /**
     * @var string|null
     *
     * @ORM\Column(name="smoking_hab", type="text", length=65535, nullable=true)
     */
    private $smokingHab;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_cond_yn", type="text", length=65535, nullable=true)
     */
    private $bothChronicCondYn;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_clinical3", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical3;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_cvd_blood", type="text", length=65535, nullable=true)
     */
    private $bothChronicCvdBlood;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_copd", type="text", length=65535, nullable=true)
     */
    private $bothChronicCopd;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_asthma", type="text", length=65535, nullable=true)
     */
    private $bothChronicAsthma;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_diabetes", type="text", length=65535, nullable=true)
     */
    private $bothChronicDiabetes;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_immuno", type="text", length=65535, nullable=true)
     */
    private $bothChronicImmuno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_renal", type="text", length=65535, nullable=true)
     */
    private $bothChronicRenal;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_rheumatologic_autoimmune_dis", type="text", length=65535, nullable=true)
     */
    private $bothChronicRheumatologicAutoimmuneDis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_neurological_neuromuscular_dis", type="text", length=65535, nullable=true)
     */
    private $bothChronicNeurologicalNeuromuscularDis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_cirrhosis_liver_dis", type="text", length=65535, nullable=true)
     */
    private $bothChronicCirrhosisLiverDis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_neoplasm", type="text", length=65535, nullable=true)
     */
    private $bothChronicNeoplasm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_obesity", type="text", length=65535, nullable=true)
     */
    private $bothChronicObesity;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_malnutri", type="text", length=65535, nullable=true)
     */
    private $bothChronicMalnutri;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_active_tuberculosis", type="text", length=65535, nullable=true)
     */
    private $bothChronicActiveTuberculosis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_hiv_infection", type="text", length=65535, nullable=true)
     */
    private $bothChronicHivInfection;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_hiv_exposure", type="text", length=65535, nullable=true)
     */
    private $bothChronicHivExposure;


    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_other", type="text", length=65535, nullable=true)
     */
    private $bothChronicOther;

    /**
     * @var string|null
     *
     * @ORM\Column(name="hosp_12m", type="text", length=65535, nullable=true)
     */
    private $hosp12m;

    /**
     * @var string|null
     *
     * @ORM\Column(name="av_current_days", type="text", length=65535, nullable=true)
     */
    private $avCurrentDays;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_av_current", type="text", length=65535, nullable=true)
     */
    private $bothAvCurrent;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_av_starting_date", type="text", length=65535, nullable=true)
     */
    private $bothAvStartingDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="previous_lab", type="text", length=65535, nullable=true)
     */
    private $previousLab;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_influ_vac_current_season", type="text", length=65535, nullable=true)
     */
    private $bothInfluVacCurrentSeason;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_vac_14d_before_ili_sym", type="text", length=65535, nullable=true)
     */
    private $bothVac14dBeforeIliSym;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dov", type="text", length=65535, nullable=true)
     */
    private $dov;

    /**
     * @var string|null
     *
     * @ORM\Column(name="vac_name", type="text", length=65535, nullable=true)
     */
    private $vacName;

    /**
     * @var string|null
     *
     * @ORM\Column(name="vac_type", type="text", length=65535, nullable=true)
     */
    private $vacType;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_vac_preceding_season", type="text", length=65535, nullable=true)
     */
    private $bothVacPrecedingSeason;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_swab_date", type="text", length=65535, nullable=true)
     */
    private $bothSwabDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_swab_date_unknow", type="text", length=65535, nullable=true)
     */
    private $bothSwabDateUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="swab_sent", type="text", length=65535, nullable=true)
     */
    private $swabSent;

    /**
     * @var string|null
     *
     * @ORM\Column(name="swab_np", type="text", length=65535, nullable=true)
     */
    private $swabNp;

    /**
     * @var string|null
     *
     * @ORM\Column(name="swab_n", type="text", length=65535, nullable=true)
     */
    private $swabN;

    /**
     * @var string|null
     *
     * @ORM\Column(name="swab_p", type="text", length=65535, nullable=true)
     */
    private $swabP;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dol", type="text", length=65535, nullable=true)
     */
    private $dol;

    /**
     * @var string|null
     *
     * @ORM\Column(name="hypoxia_adm", type="text", length=65535, nullable=true)
     */
    private $hypoxiaAdm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="lethargy_adm", type="text", length=65535, nullable=true)
     */
    private $lethargyAdm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_oxygen_saturation", type="text", length=65535, nullable=true)
     */
    private $bothSeverityOxygenSaturation;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_oxygen_saturation_unknow", type="text", length=65535, nullable=true)
     */
    private $bothSeverityOxygenSaturationUnknow;


    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_respiration_rate", type="text", length=65535, nullable=true)
     */
    private $bothSeverityRespirationRate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_respiration_rate_unknow", type="text", length=65535, nullable=true)
     */
    private $bothSeverityRespirationRateUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="blood_urea_nitrogen", type="text", length=65535, nullable=true)
     */
    private $bloodUreaNitrogen;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_supp_oxygen", type="text", length=65535, nullable=true)
     */
    private $bothSeveritySuppOxygen;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_vaso_support", type="text", length=65535, nullable=true)
     */
    private $bothSeverityVasoSupport;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_icu_adm", type="text", length=65535, nullable=true)
     */
    private $bothIcuAdm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_death_hosp", type="text", length=65535, nullable=true)
     */
    private $bothDeathHosp;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_mech_vent", type="text", length=65535, nullable=true)
     */
    private $bothSeverityMechVent;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_discharged_date", type="text", length=65535, nullable=true)
     */
    private $bothDischargedDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_d_diag1", type="text", length=65535, nullable=true)
     */
    private $bothDDiag1;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_d_diag2", type="text", length=65535, nullable=true)
     */
    private $bothDDiag2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_d_diag3", type="text", length=65535, nullable=true)
     */
    private $bothDDiag3;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_d_icd", type="text", length=65535, nullable=true)
     */
    private $bothDIcd;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_positive_result", type="text", length=65535, nullable=true)
     */
    private $bothPositiveResult;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_labo2", type="text", length=65535, nullable=true)
     */
    private $bothDisplayLabo2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_h1n1", type="text", length=65535, nullable=true)
     */
    private $bothLabFluH1n1;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_h3n2", type="text", length=65535, nullable=true)
     */
    private $bothLabFluH3n2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_h3nother", type="string", length=1, nullable=true)
     */
    private $bothLabFluH3Nother;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_yamagata", type="text", length=65535, nullable=true)
     */
    private $bothLabFluYamagata;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_victoria", type="text", length=65535, nullable=true)
     */
    private $bothLabFluVictoria;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_h1nother", type="string", length=1, nullable=true)
     */
    private $bothLabFluH1Nother;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_a_nosub", type="text", length=65535, nullable=true)
     */
    private $bothLabFluANosub;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_b_nosub", type="text", length=65535, nullable=true)
     */
    private $bothLabFluBNosub;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_corona_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2CoronaYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_metaneumo_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2MetaneumoYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_rs_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2RsYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_adeno_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2AdenoYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_boca_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2BocaYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_pi_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2PiYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_rhino_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2RhinoYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="lab_mix", type="text", length=65535, nullable=true)
     */
    private $labMix;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_detected_coinfection", type="text", length=65535, nullable=true)
     */
    private $bothDetectedCoinfection;

    /**
     * @var string|null
     *
     * @ORM\Column(name="lab_negative", type="text", length=65535, nullable=true)
     */
    private $labNegative;

    /**
     * @var string|null
     *
     * @ORM\Column(name="sym_7d_yn", type="text", length=65535, nullable=true)
     */
    private $sym7dYn;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_ilisystemic", type="text", length=65535, nullable=true)
     */
    private $bothDisplayIlisystemic;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilisystemic_fever", type="text", length=65535, nullable=true)
     */
    private $bothIlisystemicFever;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilisystemic_malaise", type="text", length=65535, nullable=true)
     */
    private $bothIlisystemicMalaise;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilisystemic_headache", type="text", length=65535, nullable=true)
     */
    private $bothIlisystemicHeadache;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilisystemic_myalgia", type="text", length=65535, nullable=true)
     */
    private $bothIlisystemicMyalgia;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilirespiratory_cough", type="text", length=65535, nullable=true)
     */
    private $bothIlirespiratoryCough;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilirespiratory_sorethroat", type="text", length=65535, nullable=true)
     */
    private $bothIlirespiratorySorethroat;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilirespiratory_shortnessbreath", type="text", length=65535, nullable=true)
     */
    private $bothIlirespiratoryShortnessbreath;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_ilirespiratory", type="text", length=65535, nullable=true)
     */
    private $bothDisplayIlirespiratory;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilirespiratory_nasalcongestion", type="text", length=65535, nullable=true)
     */
    private $bothIlirespiratoryNasalcongestion;

    /**
     * @var string|null
     *
     * @ORM\Column(name="doo", type="text", length=65535, nullable=true)
     */
    private $doo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_epi_isl", type="text", length=65535, nullable=true)
     */
    private $bothEpiIsl;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_clinical2", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_clinical4", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical4;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_clinical5", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical5;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_clinical6", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical6;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_clinical7", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical7;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_pregnancy_status", type="text", length=65535, nullable=true)
     */
    private $bothPregnancyStatus;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_pregnancy_weeks", type="text", length=65535, nullable=true)
     */
    private $bothPregnancyWeeks;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_pregnancy_weeks_unknow", type="text", length=65535, nullable=true)
     */
    private $bothPregnancyWeeksUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_hasonesymptoms", type="text", length=65535, nullable=true)
     */
    private $bothDisplayHasonesymptoms;

    /**
     * @var string|null
     *
     * @ORM\Column(name="comp_ili", type="text", length=65535, nullable=true)
     */
    private $compIli;

    /**
     * @var string|null
     *
     * @ORM\Column(name="comp_ili_7d", type="text", length=65535, nullable=true)
     */
    private $compIli7d;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_comply", type="text", length=65535, nullable=true)
     */
    private $moreComply;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_test_other_virus", type="text", length=65535, nullable=true)
     */
    private $bothTestOtherVirus;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_test_other2", type="text", length=65535, nullable=true)
     */
    private $bothDisplayTestOther2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="display_titre_labo", type="text", length=65535, nullable=true)
     */
    private $displayTitreLabo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_height", type="text", length=65535, nullable=true)
     */
    private $bothHeight;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_weight", type="text", length=65535, nullable=true)
     */
    private $bothWeight;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_height_unknow", type="text", length=65535, nullable=true)
     */
    private $bothHeightUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_weight_unknow", type="text", length=65535, nullable=true)
     */
    private $bothWeightUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="birthweight", type="text", length=65535, nullable=true)
     */
    private $birthweight;


    /**
     * @var string|null
     *
     * @ORM\Column(name="gestbirth_wk_yn", type="text", length=65535, nullable=true)
     */
    private $gestbirthWkYn;

    /**
     * @var string|null
     *
     * @ORM\Column(name="gestbirth_wk", type="text", length=65535, nullable=true)
     */
    private $gestbirthWk;

    /**
     * @var string|null
     *
     * @ORM\Column(name="exclu_breast_fed", type="text", length=65535, nullable=true)
     */
    private $excluBreastFed;

    /**
     * @var string|null
     *
     * @ORM\Column(name="breastfed_yn", type="text", length=65535, nullable=true)
     */
    private $breastfedYn;

    /**
     * @var string|null
     *
     * @ORM\Column(name="breastfed_month_time", type="text", length=65535, nullable=true)
     */
    private $breastfedMonthTime;

    /**
     * @var string|null
     *
     * @ORM\Column(name="temperature_adm", type="text", length=65535, nullable=true)
     */
    private $temperatureAdm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_prematurity", type="text", length=65535, nullable=true)
     */
    private $bothChronicPrematurity;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_chronic_down_syndrom", type="text", length=65535, nullable=true)
     */
    private $lessChronicDownSyndrom;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_chronic_congenital_heart_dis", type="text", length=65535, nullable=true)
     */
    private $lessChronicCongenitalHeartDis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_chronic_leukemia", type="text", length=65535, nullable=true)
     */
    private $moreChronicLeukemia;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_hemoglobinopathies", type="text", length=65535, nullable=true)
     */
    private $bothChronicHemoglobinopathies;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antibio_preceding", type="text", length=65535, nullable=true)
     */
    private $bothAntibioPreceding;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antibio_preceding_date", type="text", length=65535, nullable=true)
     */
    private $bothAntibioPrecedingDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_frailty_score", type="text", length=65535, nullable=true)
     */
    private $bothFrailtyScore;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_frailty_score_unknow", type="text", length=65535, nullable=true)
     */
    private $bothFrailtyScoreUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_influ_vac_current_season_2_doses", type="text", length=65535, nullable=true)
     */
    private $lessInfluVacCurrentSeason2Doses;

    /**
     * @var string|null
     *
     * @ORM\Column(name="barthel_index", type="text", length=65535, nullable=true)
     */
    private $barthelIndex;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_confusion", type="text", length=65535, nullable=true)
     */
    private $bothSeverityConfusion;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_apnea", type="text", length=65535, nullable=true)
     */
    private $bothSeverityApnea;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_discharge_another_hopital", type="text", length=65535, nullable=true)
     */
    private $bothDischargeAnotherHopital;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_frailty_score_discharge", type="text", length=65535, nullable=true)
     */
    private $bothFrailtyScoreDischarge;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_frailty_score_discharge_unknow", type="text", length=65535, nullable=true)
     */
    private $bothFrailtyScoreDischargeUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_sample_submited", type="text", length=65535, nullable=true)
     */
    private $bothSampleSubmited;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_gisaid", type="text", length=65535, nullable=true)
     */
    private $bothDisplayGisaid;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_display_intro", type="text", length=65535, nullable=true)
     */
    private $lessDisplayIntro;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_display_intro", type="text", length=65535, nullable=true)
     */
    private $moreDisplayIntro;

    /**
     * @var string|null
     *
     * @ORM\Column(name="SysStartTime", type="text", length=65535, nullable=true)
     */
    private $sysstarttime;

    /**
     * @var string|null
     *
     * @ORM\Column(name="SysEndTime", type="text", length=65535, nullable=true)
     */
    private $sysendtime;

    /**
     * @var string|null
     *
     * @ORM\Column(name="OHC_CleSignature", type="text", length=65535, nullable=true)
     */
    private $ohcClesignature;

    /**
     * @var string|null
     *
     * @ORM\Column(name="OHC_Signature", type="text", length=65535, nullable=true)
     */
    private $ohcSignature;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_clinical6b", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical6b;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_corona", type="text", length=65535, nullable=true)
     */
    private $bothLab2Corona;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_metaneumo", type="text", length=65535, nullable=true)
     */
    private $bothLab2Metaneumo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_rs", type="text", length=65535, nullable=true)
     */
    private $bothLab2Rs;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_adeno", type="text", length=65535, nullable=true)
     */
    private $bothLab2Adeno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_boca", type="text", length=65535, nullable=true)
     */
    private $bothLab2Boca;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_pi", type="text", length=65535, nullable=true)
     */
    private $bothLab2Pi;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_rhino", type="text", length=65535, nullable=true)
     */
    private $bothLab2Rhino;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_hasothersymptoms", type="text", length=65535, nullable=true)
     */
    private $bothDisplayHasothersymptoms;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_othersymptoms_nausea", type="text", length=65535, nullable=true)
     */
    private $bothOthersymptomsNausea;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_othersymptoms_diarrhea", type="text", length=65535, nullable=true)
     */
    private $bothOthersymptomsDiarrhea;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_othersymptoms_smell", type="text", length=65535, nullable=true)
     */
    private $bothOthersymptomsSmell;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_othersymptoms_chestpain", type="text", length=65535, nullable=true)
     */
    private $bothOthersymptomsChestpain;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilirespiratory_wheezing", type="text", length=65535, nullable=true)
     */
    private $bothIlirespiratoryWheezing;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antibio_during", type="text", length=65535, nullable=true)
     */
    private $bothAntibioDuring;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antibio_during_date", type="text", length=65535, nullable=true)
     */
    private $bothAntibioDuringDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antiviral_preceding", type="text", length=65535, nullable=true)
     */
    private $bothAntiviralPreceding;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antiviral_preceding_date", type="text", length=65535, nullable=true)
     */
    private $bothAntiviralPrecedingDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antiviral_during", type="text", length=65535, nullable=true)
     */
    private $bothAntiviralDuring;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antiviral_during_date", type="text", length=65535, nullable=true)
     */
    private $bothAntiviralDuringDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_vac_history_validated", type="text", length=65535, nullable=true)
     */
    private $bothVacHistoryValidated;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_display_comment", type="text", length=65535, nullable=true)
     */
    private $moreDisplayComment;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_display_comment", type="text", length=65535, nullable=true)
     */
    private $lessDisplayComment;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_sarscov2", type="text", length=65535, nullable=true)
     */
    private $bothLab2Sarscov2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_sarscov2_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2Sarscov2Yesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_sarscov", type="text", length=65535, nullable=true)
     */
    private $bothLab2Sarscov;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_sarscov_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2SarscovYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_others", type="text", length=65535, nullable=true)
     */
    private $bothLab2Others;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_others_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2OthersYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_covid_firstdose", type="text", length=65535, nullable=true)
     */
    private $moreCovidFirstdose;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_covid_full", type="text", length=65535, nullable=true)
     */
    private $moreCovidFull;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_covid_vaccine", type="text", length=65535, nullable=true)
     */
    private $moreCovidVaccine;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2010_11", type="text", length=65535, nullable=true)
     */
    private $fluVac201011;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2011_12", type="text", length=65535, nullable=true)
     */
    private $fluVac201112;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2012_13", type="text", length=65535, nullable=true)
     */
    private $fluVac201213;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2013_14", type="text", length=65535, nullable=true)
     */
    private $fluVac201314;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2014_15", type="text", length=65535, nullable=true)
     */
    private $fluVac201415;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2015_16", type="text", length=65535, nullable=true)
     */
    private $fluVac201516;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2016_17", type="text", length=65535, nullable=true)
     */
    private $fluVac201617;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2017_18", type="text", length=65535, nullable=true)
     */
    private $fluVac201718;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2018_19", type="text", length=65535, nullable=true)
     */
    private $fluVac201819;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2019_20", type="text", length=65535, nullable=true)
     */
    private $fluVac201920;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2020_21", type="text", length=65535, nullable=true)
     */
    private $fluVac202021;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2021_22", type="text", length=65535, nullable=true)
     */
    private $fluVac202122;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2022_23", type="text", length=65535, nullable=true)
     */
    private $fluVac202223;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2023_24", type="text", length=65535, nullable=true)
     */
    private $fluVac202324;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2024_25", type="text", length=65535, nullable=true)
     */
    private $fluVac202425;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2026_27", type="text", length=65535, nullable=true)
     */
    private $fluVac202627;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ecmo", type="text", length=65535, nullable=true)
     */
    private $ecmo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="reason_no_com", type="text", length=65535, nullable=true)
     */
    private $reasonNoCom;

    /**
     * @var string|null
     *
     * @ORM\Column(name="consul_3m", type="text", length=65535, nullable=true)
     */
    private $consul3m;

    /**
     * @var string|null
     *
     * @ORM\Column(name="contra_flu", type="text", length=65535, nullable=true)
     */
    private $contraFlu;

    /**
     * @var string|null
     *
     * @ORM\Column(name="sudden", type="text", length=65535, nullable=true)
     */
    private $sudden;

    /**
     * @var string|null
     *
     * @ORM\Column(name="polypnea", type="text", length=65535, nullable=true)
     */
    private $polypnea;


    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_blood_pressure", type="text", length=65535, nullable=true)
     */
    private $bothSeverityBloodPressure;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_blood_pressure_unknow", type="text", length=65535, nullable=true)
     */
    private $bothSeverityBloodPressureUnknow;

    /**
     * @ORM\Column(name="tocalculate", type="integer", nullable=true)
     */
    private $tocalculate;

    /**
     * @ORM\Column(name="included", type="integer", nullable=true)
     */
    private $included;

    /**
     * @ORM\Column(name="screened", type="integer", nullable=true)
     */
    private $screened;

    /**
     * @ORM\Column(name="sequenced", type="integer", nullable=true)
     */
    private $sequenced;

    /**
     * @ORM\Column(name="lci_plus", type="integer", nullable=true)
     */
    private $lciplus;

    /**
     * @ORM\Column(name="orv_plus", type="integer", nullable=true)
     */
    private $orvplus;

    /**
     * @ORM\Column(name="orv_plus_sans_rsv", type="integer", nullable=true)
     */
    private $orvplussansrsv;

    /**
     * @ORM\Column(name="orv_plus_sans_sars_cov_2", type="integer", nullable=true)
     */
    private $orvplussanssarscov2;

    /**
     * @ORM\Column(name="orv_plus_sans_rsv_sans_sars_cov_2", type="integer", nullable=true)
     */
    private $orvplussansrsvsanssarscov2;

    /**
     * @ORM\Column(name="test_orv", type="integer", nullable=true)
     */
    private $testorv;

    /**
     * @ORM\Column(name="test_orv_sans_rsv", type="integer", nullable=true)
     */
    private $testorvsansrsv;

    /**
     * @ORM\Column(name="test_orv_sans_sars_cov_2", type="integer", nullable=true)
     */
    private $testorvsanssarscov2;

    /**
     * @ORM\Column(name="test_orv_sans_rsv_sans_sars_cov_2", type="integer", nullable=true)
     */
    private $testorvsansrsvsanssarscov2;

    /**
     * @ORM\Column(name="both_age", type="text", length=65535, nullable=true)
     */
    private $bothage;

    /**
     * @ORM\Column(name="both_age_unit", type="text", length=65535, nullable=true)
     */
    private $bothageunit;

    /**
     * @ORM\Column(name="tranche_age_def1", type="text", length=65535, nullable=true)
     */
    private $trancheagedef1;

    /**
     * @ORM\Column(name="tranche_age_def2", type="text", length=65535, nullable=true)
     */
    private $trancheagedef2;

    /**
     * @ORM\Column(name="tranche_age_def3",type="text", length=65535, nullable=true)
     */
    private $trancheagedef3;

    /**
     * @ORM\Column(name="length_of_hospital_stay", type="text", length=65535, nullable=true)
     */
    private $lengthofhospitalstay;

    /**
     * @ORM\Column(name="week_number", type="text", length=65535, nullable=true)
     */
    private $weeknumber;

    /**
     * @ORM\Column(name="exclusion", type="integer", nullable=true)
     */
    private $exclusion;

    /**
     * @ORM\ManyToOne(targetEntity=Site::class, inversedBy="data")
     */
    private $site;

    /**
     * @ORM\ManyToOne(targetEntity=DataFile::class, inversedBy="data")
     */
    private $dataFile;


    /**
     * @ORM\Column(name="both_display_intro", type="text", length=65535, nullable=true)
     */
    private $bothDisplayIntro;

    /**
     * @ORM\Column(name="both_display_how_patient_was_identified", type="text", length=65535, nullable=true)
     */
    private $bothDisplayHowPatientWasIdentified;

    /**
     * @ORM\Column(name="both_a_diag_unknow", type="text", length=65535, nullable=true)
     */
    private $bothAdiagUnknow;

    /**
     * @ORM\Column(name="both_case_identified_based_logs_respiratory", type="text", length=65535, nullable=true)
     */
    private $bothCaseIdentifiedBasedLogsRespiratory;

    /**
     * @ORM\Column(name="both_case_identified_based_positive_swab", type="text", length=65535, nullable=true)
     */
    private $bothCaseIdentifiedBasedPositiveSwab;

    /**
     * @ORM\Column(name="both_case_definition_used", type="text", length=65535, nullable=true)
     */
    private $bothCaseDefinitionUsed;

    /**
     * @ORM\Column(name="both_case_definition_other_detail", type="text", length=65535, nullable=true)
     */
    private $bothCaseDefinitionOtherDetail;

    /**
     * @ORM\Column(name="both_lab2_others_detail", type="text", length=65535, nullable=true)
     */
    private $bothLab2OthersDetail;

    /**
     * @ORM\Column(name="both_antiviral_preceding_date_unknow", type="text", length=65535, nullable=true)
     */
    private $bothAntiviralPrecedingDateUnknow;

    /**
     * @ORM\Column(name="both_antiviral_during_date_unknow", type="text", length=65535, nullable=true)
     */
    private $bothAntiviralDuringDateUnknow;

    /**
     * @ORM\Column(name="both_antibio_preceding_date_unknow", type="text", length=65535, nullable=true)
     */
    private $bothAntibioPrecedingDateUnknow;

    /**
     * @ORM\Column(name="both_antibio_during_date_unknow", type="text", length=65535, nullable=true)
     */
    private $bothAntibioDuringDateUnknow;

    /**
     * @ORM\Column(name="both_vac_type_vaccine", type="text", length=65535, nullable=true)
     */
    private $bothVacTypeVaccine;

    /**
     * @ORM\Column(name="both_display_clinical5bis", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical5bis;

    /**
     * @ORM\Column(name="both_covid_number_doses", type="text", length=65535, nullable=true)
     */
    private $bothCovidNumberDoses;

    /**
     * @ORM\Column(name="both_covid_last_dose_date", type="text", length=65535, nullable=true)
     */
    private $bothCovidLastDoseDate;

    /**
     * @ORM\Column(name="both_swabcovid_date", type="text", length=65535, nullable=true)
     */
    private $bothSwabcovidDate;

    /**
     * @ORM\Column(name="both_covid_last_dose_date_unknow", length=65535, type="text", nullable=true)
     */
    private $bothCovidLastDoseDateUnknow;

    /**
     * @ORM\Column(name="both_display_covid_vaccine", type="text", length=65535, nullable=true)
     */
    private $bothDisplayCovidVaccine;

    /**
     * @ORM\Column(name="both_covid_vaccine_mrna", type="text", length=65535, nullable=true)
     */
    private $bothCovidVaccineMrna;

    /**
     * @ORM\Column(name="both_covid_vaccine_inactivated_virion", type="text", length=65535, nullable=true)
     */
    private $bothCovidVaccineInactivatedVirion;

    /**
     * @ORM\Column(name="both_covid_vaccine_viral_vector", type="text", length=65535, nullable=true)
     */
    private $bothCovidVaccineViralVector;

    /**
     * @ORM\Column(name="both_covid_vaccine_protein_subunit", type="text", length=65535, nullable=true)
     */
    private $bothCovidVaccineProteinSubunit;

    /**
     * @ORM\Column(name="both_covid_vaccine_unknow", type="text", length=65535, nullable=true)
     */
    private $bothCovidVaccineUnknow;

    /**
     * @ORM\Column(name="both_severity_high_dependence_unit", type="text", length=65535, nullable=true)
     */
    private $bothSeverityHighDependenceUnit;

    /**
     * @ORM\Column(name="both_d_diag1_unknow", type="text", length=65535, nullable=true)
     */
    private $bothDDiag1Unknow;

    /**
     * @ORM\Column(name="both_d_diag2_unknow", type="text", length=65535, nullable=true)
     */
    private $bothDDiag2Unknow;

    /**
     * @ORM\Column(name="both_d_diag3_unknow", type="text", length=65535, nullable=true)
     */
    private $bothDDiag3Unknow;

    /**
     * @ORM\Column(name="both_sample_type", type="text", length=65535, nullable=true)
     */
    private $bothSampleType;

    /**
     * @ORM\Column(name="both_swabcovid_date_unknow", type="text", length=65535, nullable=true)
     */
    private $bothSwabcovidDateUnknow;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    private $CreatedAt;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    private $UpdatedAt;

    /**
     * @ORM\Column(name="both_lab2_enterovirus", type="text", length=65535, nullable=true)
     */
    private $bothLab2Enterovirus;

    /**
     * @ORM\Column(name="both_lab2_enterovirus_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2EnterovirusYesno;

    /**
     * @ORM\Column(name="both_lab2_merscov", type="text", length=65535, nullable=true)
     */
    private $bothLab2Merscov;

    /**
     * @ORM\Column(name="both_lab2_merscov_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2MerscovYesno;

    /**
     * @ORM\Column(name="both_lab2_picornavirus", type="text", length=65535, nullable=true)
     */
    private $bothLab2Picornavirus;

    /**
     * @ORM\Column(name="both_lab2_picornavirus_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2PicornavirusYesno;

    /**
     * @ORM\Column(name="both_sample_submited_influenza", type="text", nullable=true)
     */
    private $bothSampleSubmitedInfluenza;

    /**
     * @ORM\Column(name="both_epi_isl_influenza", type="text", nullable=true)
     */
    private $bothEpiIslInfluenza;

    /**
     * @ORM\Column(name="both_sample_submited_sars_cov2", type="text", nullable=true)
     */
    private $bothSampleSubmitedSarsCov2;

    /**
     * @ORM\Column(name="both_epi_isl_sars_cov2", type="text", nullable=true)
     */
    private $bothEpiIslSarsCov2;

    /**
     * @ORM\Column(name="both_sample_submited_rsv", type="text", nullable=true)
     */
    private $bothSampleSubmitedRsv;

    /**
     * @ORM\Column(name="both_epi_isl_rsv", type="text", nullable=true)
     */
    private $bothEpiIslRsv;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $priority = 0;

    /**
     * @ORM\Column(name = "both_case_identified_based_testing", type="string", length=10, nullable=true)
     */
    private $bothCaseIdentifiedBasedTesting;

    /**
     * @ORM\Column(name= "both_lab2_evd68", type="string", length=10, nullable=true)
     */
    private $bothLab2Evd68;

    /**
     * @ORM\Column(name= "both_lab2_evd68_yesno", type="string", length=10, nullable=true)
     */
    private $bothLab2Evd68Yesno;

    public function __construct()
    {
        $this->tocalculate = 1;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getSeason(): ?string
    {
        return $this->season;
    }

    public function setSeason(?string $season): self
    {
        $this->season = $season;

        return $this;
    }

    public function getIdBddPhilippe(): ?int
    {
        return $this->idBddPhilippe;
    }

    public function setIdBddPhilippe(?int $idBddPhilippe): self
    {
        $this->idBddPhilippe = $idBddPhilippe;

        return $this;
    }

    public function getIdWp(): ?int
    {
        return $this->idWp;
    }

    public function setIdWp(?int $idWp): self
    {
        $this->idWp = $idWp;

        return $this;
    }

    public function getIdSiteBddPhilippe(): ?int
    {
        return $this->idSiteBddPhilippe;
    }

    public function setIdSiteBddPhilippe(?int $idSiteBddPhilippe): self
    {
        $this->idSiteBddPhilippe = $idSiteBddPhilippe;

        return $this;
    }

    public function getOhcTechId(): ?string
    {
        return $this->ohcTechId;
    }

    public function setOhcTechId(?string $ohcTechId): self
    {
        $this->ohcTechId = $ohcTechId;

        return $this;
    }

    public function getOhcTechIdintegration(): ?string
    {
        return $this->ohcTechIdintegration;
    }

    public function setOhcTechIdintegration(?string $ohcTechIdintegration): self
    {
        $this->ohcTechIdintegration = $ohcTechIdintegration;

        return $this;
    }

    public function getOhcTechSeaId(): ?string
    {
        return $this->ohcTechSeaId;
    }

    public function setOhcTechSeaId(?string $ohcTechSeaId): self
    {
        $this->ohcTechSeaId = $ohcTechSeaId;

        return $this;
    }

    public function getDateLastModified(): ?string
    {
        return $this->dateLastModified;
    }

    public function setDateLastModified(?string $dateLastModified): self
    {
        $this->dateLastModified = $dateLastModified;

        return $this;
    }

    public function getIdLastModificator(): ?string
    {
        return $this->idLastModificator;
    }

    public function setIdLastModificator(?string $idLastModificator): self
    {
        $this->idLastModificator = $idLastModificator;

        return $this;
    }

    public function getNameLastModificator(): ?string
    {
        return $this->nameLastModificator;
    }

    public function setNameLastModificator(?string $nameLastModificator): self
    {
        $this->nameLastModificator = $nameLastModificator;

        return $this;
    }

    public function getIsValidated(): ?string
    {
        return $this->isValidated;
    }

    public function setIsValidated(?string $isValidated): self
    {
        $this->isValidated = $isValidated;

        return $this;
    }

    public function getFormType(): ?string
    {
        return $this->formType;
    }

    public function setFormType(?string $formType): self
    {
        $this->formType = $formType;

        return $this;
    }

    public function getBothCompADiag(): ?string
    {
        return $this->bothCompADiag;
    }

    public function setBothCompADiag(?string $bothCompADiag): self
    {
        $this->bothCompADiag = $bothCompADiag;

        return $this;
    }

    public function getBothADiag(): ?string
    {
        return $this->bothADiag;
    }

    public function setBothADiag(?string $bothADiag): self
    {
        $this->bothADiag = $bothADiag;

        return $this;
    }

    public function getBothADiagIcd(): ?string
    {
        return $this->bothADiagIcd;
    }

    public function setBothADiagIcd(?string $bothADiagIcd): self
    {
        $this->bothADiagIcd = $bothADiagIcd;

        return $this;
    }

    public function getBothDoa(): ?string
    {
        return $this->bothDoa;
    }

    public function setBothDoa(?string $bothDoa): self
    {
        $this->bothDoa = $bothDoa;

        return $this;
    }

    public function getBothIdHospital(): ?string
    {
        return $this->bothIdHospital;
    }

    public function setBothIdHospital(?string $bothIdHospital): self
    {
        $this->bothIdHospital = $bothIdHospital;

        return $this;
    }

    public function getBothIdPatient(): ?string
    {
        return $this->bothIdPatient;
    }

    public function setBothIdPatient(?string $bothIdPatient): self
    {
        $this->bothIdPatient = $bothIdPatient;

        return $this;
    }

    public function getDoq(): ?string
    {
        return $this->doq;
    }

    public function setDoq(?string $doq): self
    {
        $this->doq = $doq;

        return $this;
    }

    public function getBothSex(): ?string
    {
        return $this->bothSex;
    }

    public function setBothSex(?string $bothSex): self
    {
        $this->bothSex = $bothSex;

        return $this;
    }

    public function getDob(): ?string
    {
        return $this->dob;
    }

    public function setDob(?string $dob): self
    {
        $this->dob = $dob;

        return $this;
    }

    public function getCommunication(): ?string
    {
        return $this->communication;
    }

    public function setCommunication(?string $communication): self
    {
        $this->communication = $communication;

        return $this;
    }

    public function getConsents(): ?string
    {
        return $this->consents;
    }

    public function setConsents(?string $consents): self
    {
        $this->consents = $consents;

        return $this;
    }

    public function getResidence(): ?string
    {
        return $this->residence;
    }

    public function setResidence(?string $residence): self
    {
        $this->residence = $residence;

        return $this;
    }

    public function getInstitutionalized(): ?string
    {
        return $this->institutionalized;
    }

    public function setInstitutionalized(?string $institutionalized): self
    {
        $this->institutionalized = $institutionalized;

        return $this;
    }

    public function getExclussionHosp(): ?string
    {
        return $this->exclussionHosp;
    }

    public function setExclussionHosp(?string $exclussionHosp): self
    {
        $this->exclussionHosp = $exclussionHosp;

        return $this;
    }

    public function getSocClass(): ?string
    {
        return $this->socClass;
    }

    public function setSocClass(?string $socClass): self
    {
        $this->socClass = $socClass;

        return $this;
    }

    public function getSmokingHab(): ?string
    {
        return $this->smokingHab;
    }

    public function setSmokingHab(?string $smokingHab): self
    {
        $this->smokingHab = $smokingHab;

        return $this;
    }

    public function getBothChronicCondYn(): ?string
    {
        return $this->bothChronicCondYn;
    }

    public function setBothChronicCondYn(?string $bothChronicCondYn): self
    {
        $this->bothChronicCondYn = $bothChronicCondYn;

        return $this;
    }

    public function getBothDisplayClinical3(): ?string
    {
        return $this->bothDisplayClinical3;
    }

    public function setBothDisplayClinical3(?string $bothDisplayClinical3): self
    {
        $this->bothDisplayClinical3 = $bothDisplayClinical3;

        return $this;
    }

    public function getBothChronicCvdBlood(): ?string
    {
        return $this->bothChronicCvdBlood;
    }

    public function setBothChronicCvdBlood(?string $bothChronicCvdBlood): self
    {
        $this->bothChronicCvdBlood = $bothChronicCvdBlood;

        return $this;
    }

    public function getBothChronicCopd(): ?string
    {
        return $this->bothChronicCopd;
    }

    public function setBothChronicCopd(?string $bothChronicCopd): self
    {
        $this->bothChronicCopd = $bothChronicCopd;

        return $this;
    }

    public function getBothChronicAsthma(): ?string
    {
        return $this->bothChronicAsthma;
    }

    public function setBothChronicAsthma(?string $bothChronicAsthma): self
    {
        $this->bothChronicAsthma = $bothChronicAsthma;

        return $this;
    }

    public function getBothChronicDiabetes(): ?string
    {
        return $this->bothChronicDiabetes;
    }

    public function setBothChronicDiabetes(?string $bothChronicDiabetes): self
    {
        $this->bothChronicDiabetes = $bothChronicDiabetes;

        return $this;
    }

    public function getBothChronicImmuno(): ?string
    {
        return $this->bothChronicImmuno;
    }

    public function setBothChronicImmuno(?string $bothChronicImmuno): self
    {
        $this->bothChronicImmuno = $bothChronicImmuno;

        return $this;
    }

    public function getBothChronicRenal(): ?string
    {
        return $this->bothChronicRenal;
    }

    public function setBothChronicRenal(?string $bothChronicRenal): self
    {
        $this->bothChronicRenal = $bothChronicRenal;

        return $this;
    }

    public function getBothChronicRheumatologicAutoimmuneDis(): ?string
    {
        return $this->bothChronicRheumatologicAutoimmuneDis;
    }

    public function setBothChronicRheumatologicAutoimmuneDis(?string $bothChronicRheumatologicAutoimmuneDis): self
    {
        $this->bothChronicRheumatologicAutoimmuneDis = $bothChronicRheumatologicAutoimmuneDis;

        return $this;
    }

    public function getBothChronicNeurologicalNeuromuscularDis(): ?string
    {
        return $this->bothChronicNeurologicalNeuromuscularDis;
    }

    public function setBothChronicNeurologicalNeuromuscularDis(?string $bothChronicNeurologicalNeuromuscularDis): self
    {
        $this->bothChronicNeurologicalNeuromuscularDis = $bothChronicNeurologicalNeuromuscularDis;

        return $this;
    }

    public function getBothChronicCirrhosisLiverDis(): ?string
    {
        return $this->bothChronicCirrhosisLiverDis;
    }

    public function setBothChronicCirrhosisLiverDis(?string $bothChronicCirrhosisLiverDis): self
    {
        $this->bothChronicCirrhosisLiverDis = $bothChronicCirrhosisLiverDis;

        return $this;
    }

    public function getBothChronicNeoplasm(): ?string
    {
        return $this->bothChronicNeoplasm;
    }

    public function setBothChronicNeoplasm(?string $bothChronicNeoplasm): self
    {
        $this->bothChronicNeoplasm = $bothChronicNeoplasm;

        return $this;
    }

    public function getBothChronicObesity(): ?string
    {
        return $this->bothChronicObesity;
    }

    public function setBothChronicObesity(?string $bothChronicObesity): self
    {
        $this->bothChronicObesity = $bothChronicObesity;

        return $this;
    }

    public function getBothChronicMalnutri(): ?string
    {
        return $this->bothChronicMalnutri;
    }

    public function setBothChronicMalnutri(?string $bothChronicMalnutri): self
    {
        $this->bothChronicMalnutri = $bothChronicMalnutri;

        return $this;
    }

    public function getBothChronicActiveTuberculosis(): ?string
    {
        return $this->bothChronicActiveTuberculosis;
    }

    public function setBothChronicActiveTuberculosis(?string $bothChronicActiveTuberculosis): self
    {
        $this->bothChronicActiveTuberculosis = $bothChronicActiveTuberculosis;

        return $this;
    }

    public function getBothChronicHivInfection(): ?string
    {
        return $this->bothChronicHivInfection;
    }

    public function setBothChronicHivInfection(?string $bothChronicHivInfection): self
    {
        $this->bothChronicHivInfection = $bothChronicHivInfection;

        return $this;
    }

    public function getBothChronicHivExposure(): ?string
    {
        return $this->bothChronicHivExposure;
    }

    public function setBothChronicHivExposure(?string $bothChronicHivExposure): self
    {
        $this->bothChronicHivExposure = $bothChronicHivExposure;

        return $this;
    }

    public function getBothChronicOther(): ?string
    {
        return $this->bothChronicOther;
    }

    public function setBothChronicOther(?string $bothChronicOther): self
    {
        $this->bothChronicOther = $bothChronicOther;

        return $this;
    }

    public function getHosp12m(): ?string
    {
        return $this->hosp12m;
    }

    public function setHosp12m(?string $hosp12m): self
    {
        $this->hosp12m = $hosp12m;

        return $this;
    }

    public function getAvCurrentDays(): ?string
    {
        return $this->avCurrentDays;
    }

    public function setAvCurrentDays(?string $avCurrentDays): self
    {
        $this->avCurrentDays = $avCurrentDays;

        return $this;
    }

    public function getBothAvCurrent(): ?string
    {
        return $this->bothAvCurrent;
    }

    public function setBothAvCurrent(?string $bothAvCurrent): self
    {
        $this->bothAvCurrent = $bothAvCurrent;

        return $this;
    }

    public function getBothAvStartingDate(): ?string
    {
        return $this->bothAvStartingDate;
    }

    public function setBothAvStartingDate(?string $bothAvStartingDate): self
    {
        $this->bothAvStartingDate = $bothAvStartingDate;

        return $this;
    }

    public function getPreviousLab(): ?string
    {
        return $this->previousLab;
    }

    public function setPreviousLab(?string $previousLab): self
    {
        $this->previousLab = $previousLab;

        return $this;
    }

    public function getBothInfluVacCurrentSeason(): ?string
    {
        return $this->bothInfluVacCurrentSeason;
    }

    public function setBothInfluVacCurrentSeason(?string $bothInfluVacCurrentSeason): self
    {
        $this->bothInfluVacCurrentSeason = $bothInfluVacCurrentSeason;

        return $this;
    }

    public function getBothVac14dBeforeIliSym(): ?string
    {
        return $this->bothVac14dBeforeIliSym;
    }

    public function setBothVac14dBeforeIliSym(?string $bothVac14dBeforeIliSym): self
    {
        $this->bothVac14dBeforeIliSym = $bothVac14dBeforeIliSym;

        return $this;
    }

    public function getDov(): ?string
    {
        return $this->dov;
    }

    public function setDov(?string $dov): self
    {
        $this->dov = $dov;

        return $this;
    }

    public function getVacName(): ?string
    {
        return $this->vacName;
    }

    public function setVacName(?string $vacName): self
    {
        $this->vacName = $vacName;

        return $this;
    }

    public function getVacType(): ?string
    {
        return $this->vacType;
    }

    public function setVacType(?string $vacType): self
    {
        $this->vacType = $vacType;

        return $this;
    }

    public function getBothVacPrecedingSeason(): ?string
    {
        return $this->bothVacPrecedingSeason;
    }

    public function setBothVacPrecedingSeason(?string $bothVacPrecedingSeason): self
    {
        $this->bothVacPrecedingSeason = $bothVacPrecedingSeason;

        return $this;
    }

    public function getBothSwabDate(): ?string
    {
        return $this->bothSwabDate;
    }

    public function setBothSwabDate(?string $bothSwabDate): self
    {
        $this->bothSwabDate = $bothSwabDate;

        return $this;
    }

    public function getBothSwabDateUnknow(): ?string
    {
        return $this->bothSwabDateUnknow;
    }

    public function setBothSwabDateUnknow(?string $bothSwabDateUnknow): self
    {
        $this->bothSwabDateUnknow = $bothSwabDateUnknow;

        return $this;
    }

    public function getSwabSent(): ?string
    {
        return $this->swabSent;
    }

    public function setSwabSent(?string $swabSent): self
    {
        $this->swabSent = $swabSent;

        return $this;
    }

    public function getSwabNp(): ?string
    {
        return $this->swabNp;
    }

    public function setSwabNp(?string $swabNp): self
    {
        $this->swabNp = $swabNp;

        return $this;
    }

    public function getSwabN(): ?string
    {
        return $this->swabN;
    }

    public function setSwabN(?string $swabN): self
    {
        $this->swabN = $swabN;

        return $this;
    }

    public function getSwabP(): ?string
    {
        return $this->swabP;
    }

    public function setSwabP(?string $swabP): self
    {
        $this->swabP = $swabP;

        return $this;
    }

    public function getDol(): ?string
    {
        return $this->dol;
    }

    public function setDol(?string $dol): self
    {
        $this->dol = $dol;

        return $this;
    }

    public function getHypoxiaAdm(): ?string
    {
        return $this->hypoxiaAdm;
    }

    public function setHypoxiaAdm(?string $hypoxiaAdm): self
    {
        $this->hypoxiaAdm = $hypoxiaAdm;

        return $this;
    }

    public function getLethargyAdm(): ?string
    {
        return $this->lethargyAdm;
    }

    public function setLethargyAdm(?string $lethargyAdm): self
    {
        $this->lethargyAdm = $lethargyAdm;

        return $this;
    }

    public function getBothSeverityOxygenSaturation(): ?string
    {
        return $this->bothSeverityOxygenSaturation;
    }

    public function setBothSeverityOxygenSaturation(?string $bothSeverityOxygenSaturation): self
    {
        $this->bothSeverityOxygenSaturation = $bothSeverityOxygenSaturation;

        return $this;
    }

    public function getBothSeverityOxygenSaturationUnknow(): ?string
    {
        return $this->bothSeverityOxygenSaturationUnknow;
    }

    public function setBothSeverityOxygenSaturationUnknow(?string $bothSeverityOxygenSaturationUnknow): self
    {
        $this->bothSeverityOxygenSaturationUnknow = $bothSeverityOxygenSaturationUnknow;

        return $this;
    }

    public function getBothSeverityRespirationRate(): ?string
    {
        return $this->bothSeverityRespirationRate;
    }

    public function setBothSeverityRespirationRate(?string $bothSeverityRespirationRate): self
    {
        $this->bothSeverityRespirationRate = $bothSeverityRespirationRate;

        return $this;
    }

    public function getBothSeverityRespirationRateUnknow(): ?string
    {
        return $this->bothSeverityRespirationRateUnknow;
    }

    public function setBothSeverityRespirationRateUnknow(?string $bothSeverityRespirationRateUnknow): self
    {
        $this->bothSeverityRespirationRateUnknow = $bothSeverityRespirationRateUnknow;

        return $this;
    }

    public function getBloodUreaNitrogen(): ?string
    {
        return $this->bloodUreaNitrogen;
    }

    public function setBloodUreaNitrogen(?string $bloodUreaNitrogen): self
    {
        $this->bloodUreaNitrogen = $bloodUreaNitrogen;

        return $this;
    }

    public function getBothSeveritySuppOxygen(): ?string
    {
        return $this->bothSeveritySuppOxygen;
    }

    public function setBothSeveritySuppOxygen(?string $bothSeveritySuppOxygen): self
    {
        $this->bothSeveritySuppOxygen = $bothSeveritySuppOxygen;

        return $this;
    }

    public function getBothSeverityVasoSupport(): ?string
    {
        return $this->bothSeverityVasoSupport;
    }

    public function setBothSeverityVasoSupport(?string $bothSeverityVasoSupport): self
    {
        $this->bothSeverityVasoSupport = $bothSeverityVasoSupport;

        return $this;
    }

    public function getBothIcuAdm(): ?string
    {
        return $this->bothIcuAdm;
    }

    public function setBothIcuAdm(?string $bothIcuAdm): self
    {
        $this->bothIcuAdm = $bothIcuAdm;

        return $this;
    }

    public function getBothDeathHosp(): ?string
    {
        return $this->bothDeathHosp;
    }

    public function setBothDeathHosp(?string $bothDeathHosp): self
    {
        $this->bothDeathHosp = $bothDeathHosp;

        return $this;
    }

    public function getBothSeverityMechVent(): ?string
    {
        return $this->bothSeverityMechVent;
    }

    public function setBothSeverityMechVent(?string $bothSeverityMechVent): self
    {
        $this->bothSeverityMechVent = $bothSeverityMechVent;

        return $this;
    }

    public function getBothDischargedDate(): ?string
    {
        return $this->bothDischargedDate;
    }

    public function setBothDischargedDate(?string $bothDischargedDate): self
    {
        $this->bothDischargedDate = $bothDischargedDate;

        return $this;
    }

    public function getBothDDiag1(): ?string
    {
        return $this->bothDDiag1;
    }

    public function setBothDDiag1(?string $bothDDiag1): self
    {
        $this->bothDDiag1 = $bothDDiag1;

        return $this;
    }

    public function getBothDDiag2(): ?string
    {
        return $this->bothDDiag2;
    }

    public function setBothDDiag2(?string $bothDDiag2): self
    {
        $this->bothDDiag2 = $bothDDiag2;

        return $this;
    }

    public function getBothDDiag3(): ?string
    {
        return $this->bothDDiag3;
    }

    public function setBothDDiag3(?string $bothDDiag3): self
    {
        $this->bothDDiag3 = $bothDDiag3;

        return $this;
    }

    public function getBothDIcd(): ?string
    {
        return $this->bothDIcd;
    }

    public function setBothDIcd(?string $bothDIcd): self
    {
        $this->bothDIcd = $bothDIcd;

        return $this;
    }

    public function getBothPositiveResult(): ?string
    {
        return $this->bothPositiveResult;
    }

    public function setBothPositiveResult(?string $bothPositiveResult): self
    {
        $this->bothPositiveResult = $bothPositiveResult;

        return $this;
    }

    public function getBothDisplayLabo2(): ?string
    {
        return $this->bothDisplayLabo2;
    }

    public function setBothDisplayLabo2(?string $bothDisplayLabo2): self
    {
        $this->bothDisplayLabo2 = $bothDisplayLabo2;

        return $this;
    }

    public function getBothLabFluH1n1(): ?string
    {
        return $this->bothLabFluH1n1;
    }

    public function setBothLabFluH1n1(?string $bothLabFluH1n1): self
    {
        $this->bothLabFluH1n1 = $bothLabFluH1n1;

        return $this;
    }

    public function getBothLabFluH3n2(): ?string
    {
        return $this->bothLabFluH3n2;
    }

    public function setBothLabFluH3n2(?string $bothLabFluH3n2): self
    {
        $this->bothLabFluH3n2 = $bothLabFluH3n2;

        return $this;
    }

    public function getBothLabFluH3Nother(): ?string
    {
        return $this->bothLabFluH3Nother;
    }

    public function setBothLabFluH3Nother(?string $bothLabFluH3Nother): self
    {
        $this->bothLabFluH3Nother = $bothLabFluH3Nother;

        return $this;
    }

    public function getBothLabFluYamagata(): ?string
    {
        return $this->bothLabFluYamagata;
    }

    public function setBothLabFluYamagata(?string $bothLabFluYamagata): self
    {
        $this->bothLabFluYamagata = $bothLabFluYamagata;

        return $this;
    }

    public function getBothLabFluVictoria(): ?string
    {
        return $this->bothLabFluVictoria;
    }

    public function setBothLabFluVictoria(?string $bothLabFluVictoria): self
    {
        $this->bothLabFluVictoria = $bothLabFluVictoria;

        return $this;
    }

    public function getBothLabFluH1Nother(): ?string
    {
        return $this->bothLabFluH1Nother;
    }

    public function setBothLabFluH1Nother(?string $bothLabFluH1Nother): self
    {
        $this->bothLabFluH1Nother = $bothLabFluH1Nother;

        return $this;
    }

    public function getBothLabFluANosub(): ?string
    {
        return $this->bothLabFluANosub;
    }

    public function setBothLabFluANosub(?string $bothLabFluANosub): self
    {
        $this->bothLabFluANosub = $bothLabFluANosub;

        return $this;
    }

    public function getBothLabFluBNosub(): ?string
    {
        return $this->bothLabFluBNosub;
    }

    public function setBothLabFluBNosub(?string $bothLabFluBNosub): self
    {
        $this->bothLabFluBNosub = $bothLabFluBNosub;

        return $this;
    }

    public function getBothLab2CoronaYesno(): ?string
    {
        return $this->bothLab2CoronaYesno;
    }

    public function setBothLab2CoronaYesno(?string $bothLab2CoronaYesno): self
    {
        $this->bothLab2CoronaYesno = $bothLab2CoronaYesno;

        return $this;
    }

    public function getBothLab2MetaneumoYesno(): ?string
    {
        return $this->bothLab2MetaneumoYesno;
    }

    public function setBothLab2MetaneumoYesno(?string $bothLab2MetaneumoYesno): self
    {
        $this->bothLab2MetaneumoYesno = $bothLab2MetaneumoYesno;

        return $this;
    }

    public function getBothLab2RsYesno(): ?string
    {
        return $this->bothLab2RsYesno;
    }

    public function setBothLab2RsYesno(?string $bothLab2RsYesno): self
    {
        $this->bothLab2RsYesno = $bothLab2RsYesno;

        return $this;
    }

    public function getBothLab2AdenoYesno(): ?string
    {
        return $this->bothLab2AdenoYesno;
    }

    public function setBothLab2AdenoYesno(?string $bothLab2AdenoYesno): self
    {
        $this->bothLab2AdenoYesno = $bothLab2AdenoYesno;

        return $this;
    }

    public function getBothLab2BocaYesno(): ?string
    {
        return $this->bothLab2BocaYesno;
    }

    public function setBothLab2BocaYesno(?string $bothLab2BocaYesno): self
    {
        $this->bothLab2BocaYesno = $bothLab2BocaYesno;

        return $this;
    }

    public function getBothLab2PiYesno(): ?string
    {
        return $this->bothLab2PiYesno;
    }

    public function setBothLab2PiYesno(?string $bothLab2PiYesno): self
    {
        $this->bothLab2PiYesno = $bothLab2PiYesno;

        return $this;
    }

    public function getBothLab2RhinoYesno(): ?string
    {
        return $this->bothLab2RhinoYesno;
    }

    public function setBothLab2RhinoYesno(?string $bothLab2RhinoYesno): self
    {
        $this->bothLab2RhinoYesno = $bothLab2RhinoYesno;

        return $this;
    }

    public function getLabMix(): ?string
    {
        return $this->labMix;
    }

    public function setLabMix(?string $labMix): self
    {
        $this->labMix = $labMix;

        return $this;
    }

    public function getBothDetectedCoinfection(): ?string
    {
        return $this->bothDetectedCoinfection;
    }

    public function setBothDetectedCoinfection(?string $bothDetectedCoinfection): self
    {
        $this->bothDetectedCoinfection = $bothDetectedCoinfection;

        return $this;
    }

    public function getLabNegative(): ?string
    {
        return $this->labNegative;
    }

    public function setLabNegative(?string $labNegative): self
    {
        $this->labNegative = $labNegative;

        return $this;
    }


    public function getSym7dYn(): ?string
    {
        return $this->sym7dYn;
    }

    public function setSym7dYn(?string $sym7dYn): self
    {
        $this->sym7dYn = $sym7dYn;

        return $this;
    }

    public function getBothDisplayIlisystemic(): ?string
    {
        return $this->bothDisplayIlisystemic;
    }

    public function setBothDisplayIlisystemic(?string $bothDisplayIlisystemic): self
    {
        $this->bothDisplayIlisystemic = $bothDisplayIlisystemic;

        return $this;
    }

    public function getBothIlisystemicFever(): ?string
    {
        return $this->bothIlisystemicFever;
    }

    public function setBothIlisystemicFever(?string $bothIlisystemicFever): self
    {
        $this->bothIlisystemicFever = $bothIlisystemicFever;

        return $this;
    }

    public function getBothIlisystemicMalaise(): ?string
    {
        return $this->bothIlisystemicMalaise;
    }

    public function setBothIlisystemicMalaise(?string $bothIlisystemicMalaise): self
    {
        $this->bothIlisystemicMalaise = $bothIlisystemicMalaise;

        return $this;
    }

    public function getBothIlisystemicHeadache(): ?string
    {
        return $this->bothIlisystemicHeadache;
    }

    public function setBothIlisystemicHeadache(?string $bothIlisystemicHeadache): self
    {
        $this->bothIlisystemicHeadache = $bothIlisystemicHeadache;

        return $this;
    }

    public function getBothIlisystemicMyalgia(): ?string
    {
        return $this->bothIlisystemicMyalgia;
    }

    public function setBothIlisystemicMyalgia(?string $bothIlisystemicMyalgia): self
    {
        $this->bothIlisystemicMyalgia = $bothIlisystemicMyalgia;

        return $this;
    }

    public function getBothIlirespiratoryCough(): ?string
    {
        return $this->bothIlirespiratoryCough;
    }

    public function setBothIlirespiratoryCough(?string $bothIlirespiratoryCough): self
    {
        $this->bothIlirespiratoryCough = $bothIlirespiratoryCough;

        return $this;
    }

    public function getBothIlirespiratorySorethroat(): ?string
    {
        return $this->bothIlirespiratorySorethroat;
    }

    public function setBothIlirespiratorySorethroat(?string $bothIlirespiratorySorethroat): self
    {
        $this->bothIlirespiratorySorethroat = $bothIlirespiratorySorethroat;

        return $this;
    }

    public function getBothIlirespiratoryShortnessbreath(): ?string
    {
        return $this->bothIlirespiratoryShortnessbreath;
    }

    public function setBothIlirespiratoryShortnessbreath(?string $bothIlirespiratoryShortnessbreath): self
    {
        $this->bothIlirespiratoryShortnessbreath = $bothIlirespiratoryShortnessbreath;

        return $this;
    }

    public function getBothDisplayIlirespiratory(): ?string
    {
        return $this->bothDisplayIlirespiratory;
    }

    public function setBothDisplayIlirespiratory(?string $bothDisplayIlirespiratory): self
    {
        $this->bothDisplayIlirespiratory = $bothDisplayIlirespiratory;

        return $this;
    }

    public function getBothIlirespiratoryNasalcongestion(): ?string
    {
        return $this->bothIlirespiratoryNasalcongestion;
    }

    public function setBothIlirespiratoryNasalcongestion(?string $bothIlirespiratoryNasalcongestion): self
    {
        $this->bothIlirespiratoryNasalcongestion = $bothIlirespiratoryNasalcongestion;

        return $this;
    }

    public function getDoo(): ?string
    {
        return $this->doo;
    }

    public function setDoo(?string $doo): self
    {
        $this->doo = $doo;

        return $this;
    }

    public function getBothEpiIsl(): ?string
    {
        return $this->bothEpiIsl;
    }

    public function setBothEpiIsl(?string $bothEpiIsl): self
    {
        $this->bothEpiIsl = $bothEpiIsl;

        return $this;
    }

    public function getBothDisplayClinical2(): ?string
    {
        return $this->bothDisplayClinical2;
    }

    public function setBothDisplayClinical2(?string $bothDisplayClinical2): self
    {
        $this->bothDisplayClinical2 = $bothDisplayClinical2;

        return $this;
    }

    public function getBothDisplayClinical4(): ?string
    {
        return $this->bothDisplayClinical4;
    }

    public function setBothDisplayClinical4(?string $bothDisplayClinical4): self
    {
        $this->bothDisplayClinical4 = $bothDisplayClinical4;

        return $this;
    }

    public function getBothDisplayClinical5(): ?string
    {
        return $this->bothDisplayClinical5;
    }

    public function setBothDisplayClinical5(?string $bothDisplayClinical5): self
    {
        $this->bothDisplayClinical5 = $bothDisplayClinical5;

        return $this;
    }

    public function getBothDisplayClinical6(): ?string
    {
        return $this->bothDisplayClinical6;
    }

    public function setBothDisplayClinical6(?string $bothDisplayClinical6): self
    {
        $this->bothDisplayClinical6 = $bothDisplayClinical6;

        return $this;
    }

    public function getBothDisplayClinical7(): ?string
    {
        return $this->bothDisplayClinical7;
    }

    public function setBothDisplayClinical7(?string $bothDisplayClinical7): self
    {
        $this->bothDisplayClinical7 = $bothDisplayClinical7;

        return $this;
    }

    public function getBothPregnancyStatus(): ?string
    {
        return $this->bothPregnancyStatus;
    }

    public function setBothPregnancyStatus(?string $bothPregnancyStatus): self
    {
        $this->bothPregnancyStatus = $bothPregnancyStatus;

        return $this;
    }

    public function getBothPregnancyWeeks(): ?string
    {
        return $this->bothPregnancyWeeks;
    }

    public function setBothPregnancyWeeks(?string $bothPregnancyWeeks): self
    {
        $this->bothPregnancyWeeks = $bothPregnancyWeeks;

        return $this;
    }

    public function getBothPregnancyWeeksUnknow(): ?string
    {
        return $this->bothPregnancyWeeksUnknow;
    }

    public function setBothPregnancyWeeksUnknow(?string $bothPregnancyWeeksUnknow): self
    {
        $this->bothPregnancyWeeksUnknow = $bothPregnancyWeeksUnknow;

        return $this;
    }

    public function getBothDisplayHasonesymptoms(): ?string
    {
        return $this->bothDisplayHasonesymptoms;
    }

    public function setBothDisplayHasonesymptoms(?string $bothDisplayHasonesymptoms): self
    {
        $this->bothDisplayHasonesymptoms = $bothDisplayHasonesymptoms;

        return $this;
    }

    public function getCompIli(): ?string
    {
        return $this->compIli;
    }

    public function setCompIli(?string $compIli): self
    {
        $this->compIli = $compIli;

        return $this;
    }

    public function getCompIli7d(): ?string
    {
        return $this->compIli7d;
    }

    public function setCompIli7d(?string $compIli7d): self
    {
        $this->compIli7d = $compIli7d;

        return $this;
    }

    public function getMoreComply(): ?string
    {
        return $this->moreComply;
    }

    public function setMoreComply(?string $moreComply): self
    {
        $this->moreComply = $moreComply;

        return $this;
    }

    public function getBothTestOtherVirus(): ?string
    {
        return $this->bothTestOtherVirus;
    }

    public function setBothTestOtherVirus(?string $bothTestOtherVirus): self
    {
        $this->bothTestOtherVirus = $bothTestOtherVirus;

        return $this;
    }

    public function getBothDisplayTestOther2(): ?string
    {
        return $this->bothDisplayTestOther2;
    }

    public function setBothDisplayTestOther2(?string $bothDisplayTestOther2): self
    {
        $this->bothDisplayTestOther2 = $bothDisplayTestOther2;

        return $this;
    }

    public function getDisplayTitreLabo(): ?string
    {
        return $this->displayTitreLabo;
    }

    public function setDisplayTitreLabo(?string $displayTitreLabo): self
    {
        $this->displayTitreLabo = $displayTitreLabo;

        return $this;
    }

    public function getBothHeight(): ?string
    {
        return $this->bothHeight;
    }

    public function setBothHeight(?string $bothHeight): self
    {
        $this->bothHeight = $bothHeight;

        return $this;
    }

    public function getBothWeight(): ?string
    {
        return $this->bothWeight;
    }

    public function setBothWeight(?string $bothWeight): self
    {
        $this->bothWeight = $bothWeight;

        return $this;
    }

    public function getBothHeightUnknow(): ?string
    {
        return $this->bothHeightUnknow;
    }

    public function setBothHeightUnknow(?string $bothHeightUnknow): self
    {
        $this->bothHeightUnknow = $bothHeightUnknow;

        return $this;
    }

    public function getBothWeightUnknow(): ?string
    {
        return $this->bothWeightUnknow;
    }

    public function setBothWeightUnknow(?string $bothWeightUnknow): self
    {
        $this->bothWeightUnknow = $bothWeightUnknow;

        return $this;
    }

    public function getBirthweight(): ?string
    {
        return $this->birthweight;
    }

    public function setBirthweight(?string $birthweight): self
    {
        $this->birthweight = $birthweight;

        return $this;
    }


    public function getGestbirthWkYn(): ?string
    {
        return $this->gestbirthWkYn;
    }

    public function setGestbirthWkYn(?string $gestbirthWkYn): self
    {
        $this->gestbirthWkYn = $gestbirthWkYn;

        return $this;
    }

    public function getGestbirthWk(): ?string
    {
        return $this->gestbirthWk;
    }

    public function setGestbirthWk(?string $gestbirthWk): self
    {
        $this->gestbirthWk = $gestbirthWk;

        return $this;
    }

    public function getExcluBreastFed(): ?string
    {
        return $this->excluBreastFed;
    }

    public function setExcluBreastFed(?string $excluBreastFed): self
    {
        $this->excluBreastFed = $excluBreastFed;

        return $this;
    }

    public function getBreastfedYn(): ?string
    {
        return $this->breastfedYn;
    }

    public function setBreastfedYn(?string $breastfedYn): self
    {
        $this->breastfedYn = $breastfedYn;

        return $this;
    }

    public function getBreastfedMonthTime(): ?string
    {
        return $this->breastfedMonthTime;
    }

    public function setBreastfedMonthTime(?string $breastfedMonthTime): self
    {
        $this->breastfedMonthTime = $breastfedMonthTime;

        return $this;
    }

    public function getTemperatureAdm(): ?string
    {
        return $this->temperatureAdm;
    }

    public function setTemperatureAdm(?string $temperatureAdm): self
    {
        $this->temperatureAdm = $temperatureAdm;

        return $this;
    }

    public function getBothChronicPrematurity(): ?string
    {
        return $this->bothChronicPrematurity;
    }

    public function setBothChronicPrematurity(?string $bothChronicPrematurity): self
    {
        $this->bothChronicPrematurity = $bothChronicPrematurity;

        return $this;
    }

    public function getLessChronicDownSyndrom(): ?string
    {
        return $this->lessChronicDownSyndrom;
    }

    public function setLessChronicDownSyndrom(?string $lessChronicDownSyndrom): self
    {
        $this->lessChronicDownSyndrom = $lessChronicDownSyndrom;

        return $this;
    }

    public function getLessChronicCongenitalHeartDis(): ?string
    {
        return $this->lessChronicCongenitalHeartDis;
    }

    public function setLessChronicCongenitalHeartDis(?string $lessChronicCongenitalHeartDis): self
    {
        $this->lessChronicCongenitalHeartDis = $lessChronicCongenitalHeartDis;

        return $this;
    }

    public function getMoreChronicLeukemia(): ?string
    {
        return $this->moreChronicLeukemia;
    }

    public function setMoreChronicLeukemia(?string $moreChronicLeukemia): self
    {
        $this->moreChronicLeukemia = $moreChronicLeukemia;

        return $this;
    }

    public function getBothChronicHemoglobinopathies(): ?string
    {
        return $this->bothChronicHemoglobinopathies;
    }

    public function setBothChronicHemoglobinopathies(?string $bothChronicHemoglobinopathies): self
    {
        $this->bothChronicHemoglobinopathies = $bothChronicHemoglobinopathies;

        return $this;
    }

    public function getBothAntibioPreceding(): ?string
    {
        return $this->bothAntibioPreceding;
    }

    public function setBothAntibioPreceding(?string $bothAntibioPreceding): self
    {
        $this->bothAntibioPreceding = $bothAntibioPreceding;

        return $this;
    }

    public function getBothAntibioPrecedingDate(): ?string
    {
        return $this->bothAntibioPrecedingDate;
    }

    public function setBothAntibioPrecedingDate(?string $bothAntibioPrecedingDate): self
    {
        $this->bothAntibioPrecedingDate = $bothAntibioPrecedingDate;

        return $this;
    }

    public function getBothFrailtyScore(): ?string
    {
        return $this->bothFrailtyScore;
    }

    public function setBothFrailtyScore(?string $bothFrailtyScore): self
    {
        $this->bothFrailtyScore = $bothFrailtyScore;

        return $this;
    }

    public function getBothFrailtyScoreUnknow(): ?string
    {
        return $this->bothFrailtyScoreUnknow;
    }

    public function setBothFrailtyScoreUnknow(?string $bothFrailtyScoreUnknow): self
    {
        $this->bothFrailtyScoreUnknow = $bothFrailtyScoreUnknow;

        return $this;
    }

    public function getLessInfluVacCurrentSeason2Doses(): ?string
    {
        return $this->lessInfluVacCurrentSeason2Doses;
    }

    public function setLessInfluVacCurrentSeason2Doses(?string $lessInfluVacCurrentSeason2Doses): self
    {
        $this->lessInfluVacCurrentSeason2Doses = $lessInfluVacCurrentSeason2Doses;

        return $this;
    }

    public function getBarthelIndex(): ?string
    {
        return $this->barthelIndex;
    }

    public function setBarthelIndex(?string $barthelIndex): self
    {
        $this->barthelIndex = $barthelIndex;

        return $this;
    }


    public function getBothSeverityConfusion(): ?string
    {
        return $this->bothSeverityConfusion;
    }

    public function setBothSeverityConfusion(?string $bothSeverityConfusion): self
    {
        $this->bothSeverityConfusion = $bothSeverityConfusion;

        return $this;
    }

    public function getBothSeverityApnea(): ?string
    {
        return $this->bothSeverityApnea;
    }

    public function setBothSeverityApnea(?string $bothSeverityApnea): self
    {
        $this->bothSeverityApnea = $bothSeverityApnea;

        return $this;
    }

    public function getBothDischargeAnotherHopital(): ?string
    {
        return $this->bothDischargeAnotherHopital;
    }

    public function setBothDischargeAnotherHopital(?string $bothDischargeAnotherHopital): self
    {
        $this->bothDischargeAnotherHopital = $bothDischargeAnotherHopital;

        return $this;
    }

    public function getBothFrailtyScoreDischarge(): ?string
    {
        return $this->bothFrailtyScoreDischarge;
    }

    public function setBothFrailtyScoreDischarge(?string $bothFrailtyScoreDischarge): self
    {
        $this->bothFrailtyScoreDischarge = $bothFrailtyScoreDischarge;

        return $this;
    }

    public function getBothFrailtyScoreDischargeUnknow(): ?string
    {
        return $this->bothFrailtyScoreDischargeUnknow;
    }

    public function setBothFrailtyScoreDischargeUnknow(?string $bothFrailtyScoreDischargeUnknow): self
    {
        $this->bothFrailtyScoreDischargeUnknow = $bothFrailtyScoreDischargeUnknow;

        return $this;
    }

    public function getBothSampleSubmited(): ?string
    {
        return $this->bothSampleSubmited;
    }

    public function setBothSampleSubmited(?string $bothSampleSubmited): self
    {
        $this->bothSampleSubmited = $bothSampleSubmited;

        return $this;
    }

    public function getBothDisplayGisaid(): ?string
    {
        return $this->bothDisplayGisaid;
    }

    public function setBothDisplayGisaid(?string $bothDisplayGisaid): self
    {
        $this->bothDisplayGisaid = $bothDisplayGisaid;

        return $this;
    }

    public function getLessDisplayIntro(): ?string
    {
        return $this->lessDisplayIntro;
    }

    public function setLessDisplayIntro(?string $lessDisplayIntro): self
    {
        $this->lessDisplayIntro = $lessDisplayIntro;

        return $this;
    }

    public function getMoreDisplayIntro(): ?string
    {
        return $this->moreDisplayIntro;
    }

    public function setMoreDisplayIntro(?string $moreDisplayIntro): self
    {
        $this->moreDisplayIntro = $moreDisplayIntro;

        return $this;
    }

    public function getSysstarttime(): ?string
    {
        return $this->sysstarttime;
    }

    public function setSysstarttime(?string $sysstarttime): self
    {
        $this->sysstarttime = $sysstarttime;

        return $this;
    }

    public function getSysendtime(): ?string
    {
        return $this->sysendtime;
    }

    public function setSysendtime(?string $sysendtime): self
    {
        $this->sysendtime = $sysendtime;

        return $this;
    }

    public function getOhcClesignature(): ?string
    {
        return $this->ohcClesignature;
    }

    public function setOhcClesignature(?string $ohcClesignature): self
    {
        $this->ohcClesignature = $ohcClesignature;

        return $this;
    }

    public function getOhcSignature(): ?string
    {
        return $this->ohcSignature;
    }

    public function setOhcSignature(?string $ohcSignature): self
    {
        $this->ohcSignature = $ohcSignature;

        return $this;
    }

    public function getBothDisplayClinical6b(): ?string
    {
        return $this->bothDisplayClinical6b;
    }

    public function setBothDisplayClinical6b(?string $bothDisplayClinical6b): self
    {
        $this->bothDisplayClinical6b = $bothDisplayClinical6b;

        return $this;
    }

    public function getBothLab2Corona(): ?string
    {
        return $this->bothLab2Corona;
    }

    public function setBothLab2Corona(?string $bothLab2Corona): self
    {
        $this->bothLab2Corona = $bothLab2Corona;

        return $this;
    }

    public function getBothLab2Metaneumo(): ?string
    {
        return $this->bothLab2Metaneumo;
    }

    public function setBothLab2Metaneumo(?string $bothLab2Metaneumo): self
    {
        $this->bothLab2Metaneumo = $bothLab2Metaneumo;

        return $this;
    }

    public function getBothLab2Rs(): ?string
    {
        return $this->bothLab2Rs;
    }

    public function setBothLab2Rs(?string $bothLab2Rs): self
    {
        $this->bothLab2Rs = $bothLab2Rs;

        return $this;
    }

    public function getBothLab2Adeno(): ?string
    {
        return $this->bothLab2Adeno;
    }

    public function setBothLab2Adeno(?string $bothLab2Adeno): self
    {
        $this->bothLab2Adeno = $bothLab2Adeno;

        return $this;
    }

    public function getBothLab2Boca(): ?string
    {
        return $this->bothLab2Boca;
    }

    public function setBothLab2Boca(?string $bothLab2Boca): self
    {
        $this->bothLab2Boca = $bothLab2Boca;

        return $this;
    }

    public function getBothLab2Pi(): ?string
    {
        return $this->bothLab2Pi;
    }

    public function setBothLab2Pi(?string $bothLab2Pi): self
    {
        $this->bothLab2Pi = $bothLab2Pi;

        return $this;
    }

    public function getBothLab2Rhino(): ?string
    {
        return $this->bothLab2Rhino;
    }

    public function setBothLab2Rhino(?string $bothLab2Rhino): self
    {
        $this->bothLab2Rhino = $bothLab2Rhino;

        return $this;
    }

    public function getBothDisplayHasothersymptoms(): ?string
    {
        return $this->bothDisplayHasothersymptoms;
    }

    public function setBothDisplayHasothersymptoms(?string $bothDisplayHasothersymptoms): self
    {
        $this->bothDisplayHasothersymptoms = $bothDisplayHasothersymptoms;

        return $this;
    }

    public function getBothOthersymptomsNausea(): ?string
    {
        return $this->bothOthersymptomsNausea;
    }

    public function setBothOthersymptomsNausea(?string $bothOthersymptomsNausea): self
    {
        $this->bothOthersymptomsNausea = $bothOthersymptomsNausea;

        return $this;
    }

    public function getBothOthersymptomsDiarrhea(): ?string
    {
        return $this->bothOthersymptomsDiarrhea;
    }

    public function setBothOthersymptomsDiarrhea(?string $bothOthersymptomsDiarrhea): self
    {
        $this->bothOthersymptomsDiarrhea = $bothOthersymptomsDiarrhea;

        return $this;
    }

    public function getBothOthersymptomsSmell(): ?string
    {
        return $this->bothOthersymptomsSmell;
    }

    public function setBothOthersymptomsSmell(?string $bothOthersymptomsSmell): self
    {
        $this->bothOthersymptomsSmell = $bothOthersymptomsSmell;

        return $this;
    }

    public function getBothOthersymptomsChestpain(): ?string
    {
        return $this->bothOthersymptomsChestpain;
    }

    public function setBothOthersymptomsChestpain(?string $bothOthersymptomsChestpain): self
    {
        $this->bothOthersymptomsChestpain = $bothOthersymptomsChestpain;

        return $this;
    }

    public function getBothIlirespiratoryWheezing(): ?string
    {
        return $this->bothIlirespiratoryWheezing;
    }

    public function setBothIlirespiratoryWheezing(?string $bothIlirespiratoryWheezing): self
    {
        $this->bothIlirespiratoryWheezing = $bothIlirespiratoryWheezing;

        return $this;
    }

    public function getBothAntibioDuring(): ?string
    {
        return $this->bothAntibioDuring;
    }

    public function setBothAntibioDuring(?string $bothAntibioDuring): self
    {
        $this->bothAntibioDuring = $bothAntibioDuring;

        return $this;
    }

    public function getBothAntibioDuringDate(): ?string
    {
        return $this->bothAntibioDuringDate;
    }

    public function setBothAntibioDuringDate(?string $bothAntibioDuringDate): self
    {
        $this->bothAntibioDuringDate = $bothAntibioDuringDate;

        return $this;
    }

    public function getBothAntiviralPreceding(): ?string
    {
        return $this->bothAntiviralPreceding;
    }

    public function setBothAntiviralPreceding(?string $bothAntiviralPreceding): self
    {
        $this->bothAntiviralPreceding = $bothAntiviralPreceding;

        return $this;
    }

    public function getBothAntiviralPrecedingDate(): ?string
    {
        return $this->bothAntiviralPrecedingDate;
    }

    public function setBothAntiviralPrecedingDate(?string $bothAntiviralPrecedingDate): self
    {
        $this->bothAntiviralPrecedingDate = $bothAntiviralPrecedingDate;

        return $this;
    }

    public function getBothAntiviralDuring(): ?string
    {
        return $this->bothAntiviralDuring;
    }

    public function setBothAntiviralDuring(?string $bothAntiviralDuring): self
    {
        $this->bothAntiviralDuring = $bothAntiviralDuring;

        return $this;
    }

    public function getBothAntiviralDuringDate(): ?string
    {
        return $this->bothAntiviralDuringDate;
    }

    public function setBothAntiviralDuringDate(?string $bothAntiviralDuringDate): self
    {
        $this->bothAntiviralDuringDate = $bothAntiviralDuringDate;

        return $this;
    }

    public function getBothVacHistoryValidated(): ?string
    {
        return $this->bothVacHistoryValidated;
    }

    public function setBothVacHistoryValidated(?string $bothVacHistoryValidated): self
    {
        $this->bothVacHistoryValidated = $bothVacHistoryValidated;

        return $this;
    }

    public function getMoreDisplayComment(): ?string
    {
        return $this->moreDisplayComment;
    }

    public function setMoreDisplayComment(?string $moreDisplayComment): self
    {
        $this->moreDisplayComment = $moreDisplayComment;

        return $this;
    }

    public function getLessDisplayComment(): ?string
    {
        return $this->lessDisplayComment;
    }

    public function setLessDisplayComment(?string $lessDisplayComment): self
    {
        $this->lessDisplayComment = $lessDisplayComment;

        return $this;
    }

    public function getBothLab2Sarscov2(): ?string
    {
        return $this->bothLab2Sarscov2;
    }

    public function setBothLab2Sarscov2(?string $bothLab2Sarscov2): self
    {
        $this->bothLab2Sarscov2 = $bothLab2Sarscov2;

        return $this;
    }

    public function getBothLab2Sarscov2Yesno(): ?string
    {
        return $this->bothLab2Sarscov2Yesno;
    }

    public function setBothLab2Sarscov2Yesno(?string $bothLab2Sarscov2Yesno): self
    {
        $this->bothLab2Sarscov2Yesno = $bothLab2Sarscov2Yesno;

        return $this;
    }

    public function getBothLab2Sarscov(): ?string
    {
        return $this->bothLab2Sarscov;
    }

    public function setBothLab2Sarscov(?string $bothLab2Sarscov): self
    {
        $this->bothLab2Sarscov = $bothLab2Sarscov;

        return $this;
    }

    public function getBothLab2SarscovYesno(): ?string
    {
        return $this->bothLab2SarscovYesno;
    }

    public function setBothLab2SarscovYesno(?string $bothLab2SarscovYesno): self
    {
        $this->bothLab2SarscovYesno = $bothLab2SarscovYesno;

        return $this;
    }

    public function getBothLab2Others(): ?string
    {
        return $this->bothLab2Others;
    }

    public function setBothLab2Others(?string $bothLab2Others): self
    {
        $this->bothLab2Others = $bothLab2Others;

        return $this;
    }

    public function getBothLab2OthersYesno(): ?string
    {
        return $this->bothLab2OthersYesno;
    }

    public function setBothLab2OthersYesno(?string $bothLab2OthersYesno): self
    {
        $this->bothLab2OthersYesno = $bothLab2OthersYesno;

        return $this;
    }

    public function getMoreCovidFirstdose(): ?string
    {
        return $this->moreCovidFirstdose;
    }

    public function setMoreCovidFirstdose(?string $moreCovidFirstdose): self
    {
        $this->moreCovidFirstdose = $moreCovidFirstdose;

        return $this;
    }

    public function getMoreCovidFull(): ?string
    {
        return $this->moreCovidFull;
    }

    public function setMoreCovidFull(?string $moreCovidFull): self
    {
        $this->moreCovidFull = $moreCovidFull;

        return $this;
    }

    public function getMoreCovidVaccine(): ?string
    {
        return $this->moreCovidVaccine;
    }

    public function setMoreCovidVaccine(?string $moreCovidVaccine): self
    {
        $this->moreCovidVaccine = $moreCovidVaccine;

        return $this;
    }

    public function getFluVac201011(): ?string
    {
        return $this->fluVac201011;
    }

    public function setFluVac201011(?string $fluVac201011): self
    {
        $this->fluVac201011 = $fluVac201011;

        return $this;
    }

    public function getFluVac201112(): ?string
    {
        return $this->fluVac201112;
    }

    public function setFluVac201112(?string $fluVac201112): self
    {
        $this->fluVac201112 = $fluVac201112;

        return $this;
    }

    public function getFluVac201213(): ?string
    {
        return $this->fluVac201213;
    }

    public function setFluVac201213(?string $fluVac201213): self
    {
        $this->fluVac201213 = $fluVac201213;

        return $this;
    }

    public function getFluVac201314(): ?string
    {
        return $this->fluVac201314;
    }

    public function setFluVac201314(?string $fluVac201314): self
    {
        $this->fluVac201314 = $fluVac201314;

        return $this;
    }

    public function getFluVac201415(): ?string
    {
        return $this->fluVac201415;
    }

    public function setFluVac201415(?string $fluVac201415): self
    {
        $this->fluVac201415 = $fluVac201415;

        return $this;
    }

    public function getFluVac201516(): ?string
    {
        return $this->fluVac201516;
    }

    public function setFluVac201516(?string $fluVac201516): self
    {
        $this->fluVac201516 = $fluVac201516;

        return $this;
    }

    public function getFluVac201617(): ?string
    {
        return $this->fluVac201617;
    }

    public function setFluVac201617(?string $fluVac201617): self
    {
        $this->fluVac201617 = $fluVac201617;

        return $this;
    }

    public function getFluVac201718(): ?string
    {
        return $this->fluVac201718;
    }

    public function setFluVac201718(?string $fluVac201718): self
    {
        $this->fluVac201718 = $fluVac201718;

        return $this;
    }

    public function getFluVac201819(): ?string
    {
        return $this->fluVac201819;
    }

    public function setFluVac201819(?string $fluVac201819): self
    {
        $this->fluVac201819 = $fluVac201819;

        return $this;
    }

    public function getFluVac201920(): ?string
    {
        return $this->fluVac201920;
    }

    public function setFluVac201920(?string $fluVac201920): self
    {
        $this->fluVac201920 = $fluVac201920;

        return $this;
    }

    public function getFluVac202021(): ?string
    {
        return $this->fluVac202021;
    }

    public function setFluVac202021(?string $fluVac202021): self
    {
        $this->fluVac202021 = $fluVac202021;

        return $this;
    }

    public function getFluVac202122(): ?string
    {
        return $this->fluVac202122;
    }

    public function setFluVac202122(?string $fluVac202122): self
    {
        $this->fluVac202122 = $fluVac202122;

        return $this;
    }

    public function getFluVac202223(): ?string
    {
        return $this->fluVac202223;
    }

    public function setFluVac202223(?string $fluVac202223): self
    {
        $this->fluVac202223 = $fluVac202223;

        return $this;
    }

    public function getFluVac202324(): ?string
    {
        return $this->fluVac202324;
    }

    public function setFluVac202324(?string $fluVac202324): self
    {
        $this->fluVac202324 = $fluVac202324;

        return $this;
    }

    public function getFluVac202425(): ?string
    {
        return $this->fluVac202425;
    }

    public function setFluVac202425(?string $fluVac202425): self
    {
        $this->fluVac202425 = $fluVac202425;

        return $this;
    }

    public function getFluVac202627(): ?string
    {
        return $this->fluVac202627;
    }

    public function setFluVac202627(?string $fluVac202627): self
    {
        $this->fluVac202627 = $fluVac202627;

        return $this;
    }

    public function getEcmo(): ?string
    {
        return $this->ecmo;
    }

    public function setEcmo(?string $ecmo): self
    {
        $this->ecmo = $ecmo;

        return $this;
    }

    public function getReasonNoCom(): ?string
    {
        return $this->reasonNoCom;
    }

    public function setReasonNoCom(?string $reasonNoCom): self
    {
        $this->reasonNoCom = $reasonNoCom;

        return $this;
    }

    public function getConsul3m(): ?string
    {
        return $this->consul3m;
    }

    public function setConsul3m(?string $consul3m): self
    {
        $this->consul3m = $consul3m;

        return $this;
    }

    public function getContraFlu(): ?string
    {
        return $this->contraFlu;
    }

    public function setContraFlu(?string $contraFlu): self
    {
        $this->contraFlu = $contraFlu;

        return $this;
    }

    public function getSudden(): ?string
    {
        return $this->sudden;
    }

    public function setSudden(?string $sudden): self
    {
        $this->sudden = $sudden;

        return $this;
    }

    public function getPolypnea(): ?string
    {
        return $this->polypnea;
    }

    public function setPolypnea(?string $polypnea): self
    {
        $this->polypnea = $polypnea;

        return $this;
    }

    public function getBothSeverityBloodPressure(): ?string
    {
        return $this->bothSeverityBloodPressure;
    }

    public function setBothSeverityBloodPressure(?string $bothSeverityBloodPressure): self
    {
        $this->bothSeverityBloodPressure = $bothSeverityBloodPressure;

        return $this;
    }

    public function getBothSeverityBloodPressureUnknow(): ?string
    {
        return $this->bothSeverityBloodPressureUnknow;
    }

    public function setBothSeverityBloodPressureUnknow(?string $bothSeverityBloodPressureUnknow): self
    {
        $this->bothSeverityBloodPressureUnknow = $bothSeverityBloodPressureUnknow;

        return $this;
    }

    public function getTocalculate(): ?int
    {
        return $this->tocalculate;
    }

    public function setTocalculate(?int $tocalculate): self
    {
        $this->tocalculate = $tocalculate;

        return $this;
    }

    public function getIncluded(): ?int
    {
        return $this->included;
    }

    public function setIncluded(?int $included): self
    {
        $this->included = $included;

        return $this;
    }

    public function getScreened(): ?int
    {
        return $this->screened;
    }

    public function setScreened(?int $screened): self
    {
        $this->screened = $screened;

        return $this;
    }

    public function getSequenced(): ?int
    {
        return $this->sequenced;
    }

    public function setSequenced(?int $sequenced): self
    {
        $this->sequenced = $sequenced;

        return $this;
    }

    public function getLciplus(): ?int
    {
        return $this->lciplus;
    }

    public function setLciplus(?int $lciplus): self
    {
        $this->lciplus = $lciplus;

        return $this;
    }

    public function getOrvplus(): ?int
    {
        return $this->orvplus;
    }

    public function setOrvplus(?int $orvplus): self
    {
        $this->orvplus = $orvplus;

        return $this;
    }

    public function getOrvplussansrsv(): ?int
    {
        return $this->orvplussansrsv;
    }

    public function setOrvplussansrsv(?int $orvplussansrsv): self
    {
        $this->orvplussansrsv = $orvplussansrsv;

        return $this;
    }

    public function getOrvplussanssarscov2(): ?int
    {
        return $this->orvplussanssarscov2;
    }

    public function setOrvplussanssarscov2(?int $orvplussanssarscov2): self
    {
        $this->orvplussanssarscov2 = $orvplussanssarscov2;

        return $this;
    }

    public function getOrvplussansrsvsanssarscov2(): ?int
    {
        return $this->orvplussansrsvsanssarscov2;
    }

    public function setOrvplussansrsvsanssarscov2(?int $orvplussansrsvsanssarscov2): self
    {
        $this->orvplussansrsvsanssarscov2 = $orvplussansrsvsanssarscov2;

        return $this;
    }

    public function getTestorv(): ?int
    {
        return $this->testorv;
    }

    public function setTestorv(?int $testorv): self
    {
        $this->testorv = $testorv;

        return $this;
    }

    public function getTestorvsansrsv(): ?int
    {
        return $this->testorvsansrsv;
    }

    public function setTestorvsansrsv(?int $testorvsansrsv): self
    {
        $this->testorvsansrsv = $testorvsansrsv;

        return $this;
    }

    public function getTestorvsanssarscov2(): ?int
    {
        return $this->testorvsanssarscov2;
    }

    public function setTestorvsanssarscov2(?int $testorvsanssarscov2): self
    {
        $this->testorvsanssarscov2 = $testorvsanssarscov2;

        return $this;
    }

    public function getTestorvsansrsvsanssarscov2(): ?int
    {
        return $this->testorvsansrsvsanssarscov2;
    }

    public function setTestorvsansrsvsanssarscov2(?int $testorvsansrsvsanssarscov2): self
    {
        $this->testorvsansrsvsanssarscov2 = $testorvsansrsvsanssarscov2;

        return $this;
    }

    public function getBothage(): ?string
    {
        return $this->bothage;
    }

    public function setBothage(?string $bothage): self
    {
        $this->bothage = $bothage;

        return $this;
    }

    public function getBothageunit(): ?string
    {
        return $this->bothageunit;
    }

    public function setBothageunit(?string $bothageunit): self
    {
        $this->bothageunit = $bothageunit;

        return $this;
    }

    public function getTrancheagedef1(): ?string
    {
        return $this->trancheagedef1;
    }

    public function setTrancheagedef1(?string $trancheagedef1): self
    {
        $this->trancheagedef1 = $trancheagedef1;

        return $this;
    }

    public function getTrancheagedef2(): ?string
    {
        return $this->trancheagedef2;
    }

    public function setTrancheagedef2(?string $trancheagedef2): self
    {
        $this->trancheagedef2 = $trancheagedef2;

        return $this;
    }

    public function getTrancheagedef3(): ?string
    {
        return $this->trancheagedef3;
    }

    public function setTrancheagedef3(?string $trancheagedef3): self
    {
        $this->trancheagedef3 = $trancheagedef3;

        return $this;
    }

    public function getLengthofhospitalstay(): ?string
    {
        return $this->lengthofhospitalstay;
    }

    public function setLengthofhospitalstay(?string $lengthofhospitalstay): self
    {
        $this->lengthofhospitalstay = $lengthofhospitalstay;

        return $this;
    }

    public function getWeeknumber(): ?string
    {
        return $this->weeknumber;
    }

    public function setWeeknumber(?string $weeknumber): self
    {
        $this->weeknumber = $weeknumber;

        return $this;
    }

    public function getExclusion(): ?int
    {
        return $this->exclusion;
    }

    public function setExclusion(?int $exclusion): self
    {
        $this->exclusion = $exclusion;

        return $this;
    }

    public function getBothDisplayIntro(): ?string
    {
        return $this->bothDisplayIntro;
    }

    public function setBothDisplayIntro(?string $bothDisplayIntro): self
    {
        $this->bothDisplayIntro = $bothDisplayIntro;

        return $this;
    }

    public function getBothDisplayHowPatientWasIdentified(): ?string
    {
        return $this->bothDisplayHowPatientWasIdentified;
    }

    public function setBothDisplayHowPatientWasIdentified(?string $bothDisplayHowPatientWasIdentified): self
    {
        $this->bothDisplayHowPatientWasIdentified = $bothDisplayHowPatientWasIdentified;

        return $this;
    }

    public function getBothAdiagUnknow(): ?string
    {
        return $this->bothAdiagUnknow;
    }

    public function setBothAdiagUnknow(?string $bothAdiagUnknow): self
    {
        $this->bothAdiagUnknow = $bothAdiagUnknow;

        return $this;
    }

    public function getBothCaseIdentifiedBasedLogsRespiratory(): ?string
    {
        return $this->bothCaseIdentifiedBasedLogsRespiratory;
    }

    public function setBothCaseIdentifiedBasedLogsRespiratory(?string $bothCaseIdentifiedBasedLogsRespiratory): self
    {
        $this->bothCaseIdentifiedBasedLogsRespiratory = $bothCaseIdentifiedBasedLogsRespiratory;

        return $this;
    }

    public function getBothCaseIdentifiedBasedPositiveSwab(): ?string
    {
        return $this->bothCaseIdentifiedBasedPositiveSwab;
    }

    public function setBothCaseIdentifiedBasedPositiveSwab(?string $bothCaseIdentifiedBasedPositiveSwab): self
    {
        $this->bothCaseIdentifiedBasedPositiveSwab = $bothCaseIdentifiedBasedPositiveSwab;

        return $this;
    }

    public function getBothCaseDefinitionUsed(): ?string
    {
        return $this->bothCaseDefinitionUsed;
    }

    public function setBothCaseDefinitionUsed(?string $bothCaseDefinitionUsed): self
    {
        $this->bothCaseDefinitionUsed = $bothCaseDefinitionUsed;

        return $this;
    }

    public function getBothCaseDefinitionOtherDetail(): ?string
    {
        return $this->bothCaseDefinitionOtherDetail;
    }

    public function setBothCaseDefinitionOtherDetail(?string $bothCaseDefinitionOtherDetail): self
    {
        $this->bothCaseDefinitionOtherDetail = $bothCaseDefinitionOtherDetail;

        return $this;
    }

    public function getBothLab2OthersDetail(): ?string
    {
        return $this->bothLab2OthersDetail;
    }

    public function setBothLab2OthersDetail(?string $bothLab2OthersDetail): self
    {
        $this->bothLab2OthersDetail = $bothLab2OthersDetail;

        return $this;
    }

    public function getBothAntiviralPrecedingDateUnknow(): ?string
    {
        return $this->bothAntiviralPrecedingDateUnknow;
    }

    public function setBothAntiviralPrecedingDateUnknow(?string $bothAntiviralPrecedingDateUnknow): self
    {
        $this->bothAntiviralPrecedingDateUnknow = $bothAntiviralPrecedingDateUnknow;

        return $this;
    }

    public function getBothAntiviralDuringDateUnknow(): ?string
    {
        return $this->bothAntiviralDuringDateUnknow;
    }

    public function setBothAntiviralDuringDateUnknow(?string $bothAntiviralDuringDateUnknow): self
    {
        $this->bothAntiviralDuringDateUnknow = $bothAntiviralDuringDateUnknow;

        return $this;
    }

    public function getBothAntibioPrecedingDateUnknow(): ?string
    {
        return $this->bothAntibioPrecedingDateUnknow;
    }

    public function setBothAntibioPrecedingDateUnknow(?string $bothAntibioPrecedingDateUnknow): self
    {
        $this->bothAntibioPrecedingDateUnknow = $bothAntibioPrecedingDateUnknow;

        return $this;
    }

    public function getBothAntibioDuringDateUnknow(): ?string
    {
        return $this->bothAntibioDuringDateUnknow;
    }

    public function setBothAntibioDuringDateUnknow(?string $bothAntibioDuringDateUnknow): self
    {
        $this->bothAntibioDuringDateUnknow = $bothAntibioDuringDateUnknow;

        return $this;
    }

    public function getBothVacTypeVaccine(): ?string
    {
        return $this->bothVacTypeVaccine;
    }

    public function setBothVacTypeVaccine(?string $bothVacTypeVaccine): self
    {
        $this->bothVacTypeVaccine = $bothVacTypeVaccine;

        return $this;
    }

    public function getBothDisplayClinical5bis(): ?string
    {
        return $this->bothDisplayClinical5bis;
    }

    public function setBothDisplayClinical5bis(?string $bothDisplayClinical5bis): self
    {
        $this->bothDisplayClinical5bis = $bothDisplayClinical5bis;

        return $this;
    }

    public function getBothCovidNumberDoses(): ?string
    {
        return $this->bothCovidNumberDoses;
    }

    public function setBothCovidNumberDoses(?string $bothCovidNumberDoses): self
    {
        $this->bothCovidNumberDoses = $bothCovidNumberDoses;

        return $this;
    }

    public function getBothCovidLastDoseDate(): ?string
    {
        return $this->bothCovidLastDoseDate;
    }

    public function setBothCovidLastDoseDate(?string $bothCovidLastDoseDate): self
    {
        $this->bothCovidLastDoseDate = $bothCovidLastDoseDate;

        return $this;
    }

    public function getBothSwabcovidDate(): ?string
    {
        return $this->bothSwabcovidDate;
    }

    public function setBothSwabcovidDate(?string $bothSwabcovidDate): self
    {
        $this->bothSwabcovidDate = $bothSwabcovidDate;

        return $this;
    }

    public function getBothCovidLastDoseDateUnknow(): ?string
    {
        return $this->bothCovidLastDoseDateUnknow;
    }

    public function setBothCovidLastDoseDateUnknow(?string $bothCovidLastDoseDateUnknow): self
    {
        $this->bothCovidLastDoseDateUnknow = $bothCovidLastDoseDateUnknow;

        return $this;
    }

    public function getBothDisplayCovidVaccine(): ?string
    {
        return $this->bothDisplayCovidVaccine;
    }

    public function setBothDisplayCovidVaccine(?string $bothDisplayCovidVaccine): self
    {
        $this->bothDisplayCovidVaccine = $bothDisplayCovidVaccine;

        return $this;
    }

    public function getBothCovidVaccineMrna(): ?string
    {
        return $this->bothCovidVaccineMrna;
    }

    public function setBothCovidVaccineMrna(?string $bothCovidVaccineMrna): self
    {
        $this->bothCovidVaccineMrna = $bothCovidVaccineMrna;

        return $this;
    }

    public function getBothCovidVaccineInactivatedVirion(): ?string
    {
        return $this->bothCovidVaccineInactivatedVirion;
    }

    public function setBothCovidVaccineInactivatedVirion(?string $bothCovidVaccineInactivatedVirion): self
    {
        $this->bothCovidVaccineInactivatedVirion = $bothCovidVaccineInactivatedVirion;

        return $this;
    }

    public function getBothCovidVaccineViralVector(): ?string
    {
        return $this->bothCovidVaccineViralVector;
    }

    public function setBothCovidVaccineViralVector(?string $bothCovidVaccineViralVector): self
    {
        $this->bothCovidVaccineViralVector = $bothCovidVaccineViralVector;

        return $this;
    }

    public function getBothCovidVaccineProteinSubunit(): ?string
    {
        return $this->bothCovidVaccineProteinSubunit;
    }

    public function setBothCovidVaccineProteinSubunit(?string $bothCovidVaccineProteinSubunit): self
    {
        $this->bothCovidVaccineProteinSubunit = $bothCovidVaccineProteinSubunit;

        return $this;
    }

    public function getBothCovidVaccineUnknow(): ?string
    {
        return $this->bothCovidVaccineUnknow;
    }

    public function setBothCovidVaccineUnknow(?string $bothCovidVaccineUnknow): self
    {
        $this->bothCovidVaccineUnknow = $bothCovidVaccineUnknow;

        return $this;
    }

    public function getBothSeverityHighDependenceUnit(): ?string
    {
        return $this->bothSeverityHighDependenceUnit;
    }

    public function setBothSeverityHighDependenceUnit(?string $bothSeverityHighDependenceUnit): self
    {
        $this->bothSeverityHighDependenceUnit = $bothSeverityHighDependenceUnit;

        return $this;
    }

    public function getBothDDiag1Unknow(): ?string
    {
        return $this->bothDDiag1Unknow;
    }

    public function setBothDDiag1Unknow(?string $bothDDiag1Unknow): self
    {
        $this->bothDDiag1Unknow = $bothDDiag1Unknow;

        return $this;
    }

    public function getBothDDiag2Unknow(): ?string
    {
        return $this->bothDDiag2Unknow;
    }

    public function setBothDDiag2Unknow(?string $bothDDiag2Unknow): self
    {
        $this->bothDDiag2Unknow = $bothDDiag2Unknow;

        return $this;
    }

    public function getBothDDiag3Unknow(): ?string
    {
        return $this->bothDDiag3Unknow;
    }

    public function setBothDDiag3Unknow(?string $bothDDiag3Unknow): self
    {
        $this->bothDDiag3Unknow = $bothDDiag3Unknow;

        return $this;
    }

    public function getBothSampleType(): ?string
    {
        return $this->bothSampleType;
    }

    public function setBothSampleType(?string $bothSampleType): self
    {
        $this->bothSampleType = $bothSampleType;

        return $this;
    }

    public function getBothSwabcovidDateUnknow(): ?string
    {
        return $this->bothSwabcovidDateUnknow;
    }

    public function setBothSwabcovidDateUnknow(?string $bothSwabcovidDateUnknow): self
    {
        $this->bothSwabcovidDateUnknow = $bothSwabcovidDateUnknow;

        return $this;
    }

    public function getSite(): ?Site
    {
        return $this->site;
    }

    public function setSite(?Site $site): self
    {
        $this->site = $site;

        return $this;
    }

    public function getDataFile(): ?DataFile
    {
        return $this->dataFile;
    }

    public function setDataFile(?DataFile $dataFile): self
    {
        $this->dataFile = $dataFile;

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeInterface
    {
        return $this->CreatedAt;
    }

    public function setCreatedAt(?\DateTimeInterface $CreatedAt): self
    {
        $this->CreatedAt = $CreatedAt;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeInterface
    {
        return $this->UpdatedAt;
    }

    public function setUpdatedAt(?\DateTimeInterface $UpdatedAt): self
    {
        $this->UpdatedAt = $UpdatedAt;

        return $this;
    }

    public function getBothLab2Enterovirus(): ?string
    {
        return $this->bothLab2Enterovirus;
    }

    public function setBothLab2Enterovirus(?string $bothLab2Enterovirus): self
    {
        $this->bothLab2Enterovirus = $bothLab2Enterovirus;

        return $this;
    }

    public function getBothLab2EnterovirusYesno(): ?string
    {
        return $this->bothLab2EnterovirusYesno;
    }

    public function setBothLab2EnterovirusYesno(?string $bothLab2EnterovirusYesno): self
    {
        $this->bothLab2EnterovirusYesno = $bothLab2EnterovirusYesno;

        return $this;
    }

    public function getBothLab2Merscov(): ?string
    {
        return $this->bothLab2Merscov;
    }

    public function setBothLab2Merscov(?string $bothLab2Merscov): self
    {
        $this->bothLab2Merscov = $bothLab2Merscov;
        return $this;
    }

    public function getBothLab2MerscovYesno(): ?string
    {
        return $this->bothLab2MerscovYesno;
    }

    public function setBothLab2MerscovYesno(?string $bothLab2MerscovYesno): self
    {
        $this->bothLab2MerscovYesno = $bothLab2MerscovYesno;
        return $this;
    }

    public function getBothLab2Picornavirus(): ?string
    {
        return $this->bothLab2Picornavirus;
    }

    public function setBothLab2Picornavirus($bothLab2Picornavirus): self
    {
        $this->bothLab2Picornavirus = $bothLab2Picornavirus;
        return $this;
    }

    public function getBothLab2PicornavirusYesno(): ?string
    {
        return $this->bothLab2PicornavirusYesno;
    }

    public function setBothLab2PicornavirusYesno(?string $bothLab2PicornavirusYesno): self
    {
        $this->bothLab2PicornavirusYesno = $bothLab2PicornavirusYesno;
        return $this;
    }

    public function getBothSampleSubmitedInfluenza(): ?string
    {
        return $this->bothSampleSubmitedInfluenza;
    }

    public function setBothSampleSubmitedInfluenza(?string $bothSampleSubmitedInfluenza): self
    {
        $this->bothSampleSubmitedInfluenza = $bothSampleSubmitedInfluenza;

        return $this;
    }

    public function getBothEpiIslInfluenza(): ?string
    {
        return $this->bothEpiIslInfluenza;
    }

    public function setBothEpiIslInfluenza(?string $bothEpiIslInfluenza): self
    {
        $this->bothEpiIslInfluenza = $bothEpiIslInfluenza;

        return $this;
    }

    public function getBothSampleSubmitedSarsCov2(): ?string
    {
        return $this->bothSampleSubmitedSarsCov2;
    }

    public function setBothSampleSubmitedSarsCov2(?string $bothSampleSubmitedSarsCov2): self
    {
        $this->bothSampleSubmitedSarsCov2 = $bothSampleSubmitedSarsCov2;

        return $this;
    }

    public function getBothEpiIslSarsCov2(): ?string
    {
        return $this->bothEpiIslSarsCov2;
    }

    public function setBothEpiIslSarsCov2(?string $bothEpiIslSarsCov2): self
    {
        $this->bothEpiIslSarsCov2 = $bothEpiIslSarsCov2;

        return $this;
    }

    public function getBothSampleSubmitedRsv(): ?string
    {
        return $this->bothSampleSubmitedRsv;
    }

    public function setBothSampleSubmitedRsv(?string $bothSampleSubmitedRsv): self
    {
        $this->bothSampleSubmitedRsv = $bothSampleSubmitedRsv;

        return $this;
    }

    public function getBothEpiIslRsv(): ?string
    {
        return $this->bothEpiIslRsv;
    }

    public function setBothEpiIslRsv(?string $bothEpiIslRsv): self
    {
        $this->bothEpiIslRsv = $bothEpiIslRsv;

        return $this;
    }

    public function getPriority(): ?int
    {
        return $this->priority;
    }

    public function setPriority(?int $priority): self
    {
        $this->priority = $priority;

        return $this;
    }

    public function getBothCaseIdentifiedBasedTesting(): ?string
    {
        return $this->bothCaseIdentifiedBasedTesting;
    }

    public function setBothCaseIdentifiedBasedTesting(?string $bothCaseIdentifiedBasedTesting): self
    {
        $this->bothCaseIdentifiedBasedTesting = $bothCaseIdentifiedBasedTesting;

        return $this;
    }

    public function getBothLab2Evd68(): ?string
    {
        return $this->bothLab2Evd68;
    }

    public function setBothLab2Evd68(?string $bothLab2Evd68): self
    {
        $this->bothLab2Evd68 = $bothLab2Evd68;

        return $this;
    }

    public function getBothLab2Evd68Yesno(): ?string
    {
        return $this->bothLab2Evd68Yesno;
    }

    public function setBothLab2Evd68Yesno(?string $bothLab2Evd68Yesno): self
    {
        $this->bothLab2Evd68Yesno = $bothLab2Evd68Yesno;

        return $this;
    }

}
