<?php

namespace App\Entity\Main;

use App\Repository\Main\DataDashboardRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=DataDashboardRepository::class)
 * @ORM\Table(name="data_dashboard", indexes={
 *     @ORM\Index(name="search_dashboard_season_zone", columns={"season", "site_id"}),
 *     @ORM\Index(name="search_dashboard__season_zone", columns={"site_id"}),
 *     @ORM\Index(name="search_dashboard__season", columns={"season"})
 * })
 */
class DataDashboard
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="season", type="string", length=255, nullable=true)
     */
    private $season;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_doa", type="text", length=65535, nullable=true)
     */
    private $bothDoa;

    /**
     * @ORM\Column(name="both_age", type="text", length=65535, nullable=true)
     */
    private $bothage;

    /**
     * @ORM\Column(name="both_age_unit", type="text", length=65535, nullable=true)
     */
    private $bothageunit;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_cvd_blood", type="text", length=65535, nullable=true)
     */
    private $bothChronicCvdBlood;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_copd", type="text", length=65535, nullable=true)
     */
    private $bothChronicCopd;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_asthma", type="text", length=65535, nullable=true)
     */
    private $bothChronicAsthma;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_diabetes", type="text", length=65535, nullable=true)
     */
    private $bothChronicDiabetes;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_immuno", type="text", length=65535, nullable=true)
     */
    private $bothChronicImmuno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_renal", type="text", length=65535, nullable=true)
     */
    private $bothChronicRenal;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_rheumatologic_autoimmune_dis", type="text", length=65535, nullable=true)
     */
    private $bothChronicRheumatologicAutoimmuneDis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_neurological_neuromuscular_dis", type="text", length=65535, nullable=true)
     */
    private $bothChronicNeurologicalNeuromuscularDis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_cirrhosis_liver_dis", type="text", length=65535, nullable=true)
     */
    private $bothChronicCirrhosisLiverDis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_neoplasm", type="text", length=65535, nullable=true)
     */
    private $bothChronicNeoplasm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_obesity", type="text", length=65535, nullable=true)
     */
    private $bothChronicObesity;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_malnutri", type="text", length=65535, nullable=true)
     */
    private $bothChronicMalnutri;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_active_tuberculosis", type="text", length=65535, nullable=true)
     */
    private $bothChronicActiveTuberculosis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_hiv_infection", type="text", length=65535, nullable=true)
     */
    private $bothChronicHivInfection;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_hiv_exposure", type="text", length=65535, nullable=true)
     */
    private $bothChronicHivExposure;


    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_other", type="text", length=65535, nullable=true)
     */
    private $bothChronicOther;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_icu_adm", type="text", length=65535, nullable=true)
     */
    private $bothIcuAdm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_death_hosp", type="text", length=65535, nullable=true)
     */
    private $bothDeathHosp;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_positive_result", type="text", length=65535, nullable=true)
     */
    private $bothPositiveResult;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_h1n1", type="text", length=65535, nullable=true)
     */
    private $bothLabFluH1n1;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_h3n2", type="text", length=65535, nullable=true)
     */
    private $bothLabFluH3n2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_yamagata", type="text", length=65535, nullable=true)
     */
    private $bothLabFluYamagata;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_victoria", type="text", length=65535, nullable=true)
     */
    private $bothLabFluVictoria;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_a_nosub", type="text", length=65535, nullable=true)
     */
    private $bothLabFluANosub;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_b_nosub", type="text", length=65535, nullable=true)
     */
    private $bothLabFluBNosub;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_rs_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2RsYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_prematurity", type="text", length=65535, nullable=true)
     */
    private $bothChronicPrematurity;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_hemoglobinopathies", type="text", length=65535, nullable=true)
     */
    private $bothChronicHemoglobinopathies;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_rs", type="text", length=65535, nullable=true)
     */
    private $bothLab2Rs;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilirespiratory_wheezing", type="text", length=65535, nullable=true)
     */
    private $bothIlirespiratoryWheezing;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_sarscov2", type="text", length=65535, nullable=true)
     */
    private $bothLab2Sarscov2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_sarscov2_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2Sarscov2Yesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_sarscov", type="text", length=65535, nullable=true)
     */
    private $bothLab2Sarscov;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_sarscov_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2SarscovYesno;

    /**
     * @ORM\Column(name="included", type="integer", nullable=true)
     */
    private $included;

    /**
     * @ORM\Column(name="orv_plus", type="integer", nullable=true)
     */
    private $orvplus;

    /**
     * @ORM\Column(name="orv_plus_sans_rsv", type="integer", nullable=true)
     */
    private $orvplussansrsv;

    /**
     * @ORM\Column(name="orv_plus_sans_sars_cov_2", type="integer", nullable=true)
     */
    private $orvplussanssarscov2;

    /**
     * @ORM\Column(name="orv_plus_sans_rsv_sans_sars_cov_2", type="integer", nullable=true)
     */
    private $orvplussansrsvsanssarscov2;

    /**
     * @ORM\Column(name="test_orv", type="integer", nullable=true)
     */
    private $testorv;

    /**
     * @ORM\Column(name="test_orv_sans_rsv", type="integer", nullable=true)
     */
    private $testorvsansrsv;

    /**
     * @ORM\Column(name="test_orv_sans_sars_cov_2", type="integer", nullable=true)
     */
    private $testorvsanssarscov2;

    /**
     * @ORM\Column(name="test_orv_sans_rsv_sans_sars_cov_2", type="integer", nullable=true)
     */
    private $testorvsansrsvsanssarscov2;

    /**
     * @ORM\Column(name="tranche_age_def3",type="text", length=65535, nullable=true)
     */
    private $trancheagedef3;

    /**
     * @ORM\Column(name="week_number", type="text", length=65535, nullable=true)
     */
    private $weeknumber;

    /**
     * @ORM\Column(name="exclusion", type="integer", nullable=true)
     */
    private $exclusion;

    /**
     * @ORM\ManyToOne(targetEntity=Site::class, inversedBy="data")
     */
    private $site;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getSeason(): ?string
    {
        return $this->season;
    }

    public function setSeason(?string $season): self
    {
        $this->season = $season;

        return $this;
    }

    public function getBothDoa(): ?string
    {
        return $this->bothDoa;
    }

    public function setBothDoa(?string $bothDoa): self
    {
        $this->bothDoa = $bothDoa;

        return $this;
    }
    public function getBothage(): ?string
    {
        return $this->bothage;
    }

    public function setBothage(?string $bothage): self
    {
        $this->bothage = $bothage;

        return $this;
    }

    public function getBothageunit(): ?string
    {
        return $this->bothageunit;
    }

    public function setBothageunit(?string $bothageunit): self
    {
        $this->bothageunit = $bothageunit;

        return $this;
    }
    public function getBothChronicCvdBlood(): ?string
    {
        return $this->bothChronicCvdBlood;
    }

    public function setBothChronicCvdBlood(?string $bothChronicCvdBlood): self
    {
        $this->bothChronicCvdBlood = $bothChronicCvdBlood;

        return $this;
    }

    public function getBothChronicCopd(): ?string
    {
        return $this->bothChronicCopd;
    }

    public function setBothChronicCopd(?string $bothChronicCopd): self
    {
        $this->bothChronicCopd = $bothChronicCopd;

        return $this;
    }

    public function getBothChronicAsthma(): ?string
    {
        return $this->bothChronicAsthma;
    }

    public function setBothChronicAsthma(?string $bothChronicAsthma): self
    {
        $this->bothChronicAsthma = $bothChronicAsthma;

        return $this;
    }

    public function getBothChronicDiabetes(): ?string
    {
        return $this->bothChronicDiabetes;
    }

    public function setBothChronicDiabetes(?string $bothChronicDiabetes): self
    {
        $this->bothChronicDiabetes = $bothChronicDiabetes;

        return $this;
    }

    public function getBothChronicImmuno(): ?string
    {
        return $this->bothChronicImmuno;
    }

    public function setBothChronicImmuno(?string $bothChronicImmuno): self
    {
        $this->bothChronicImmuno = $bothChronicImmuno;

        return $this;
    }

    public function getBothChronicRenal(): ?string
    {
        return $this->bothChronicRenal;
    }

    public function setBothChronicRenal(?string $bothChronicRenal): self
    {
        $this->bothChronicRenal = $bothChronicRenal;

        return $this;
    }

    public function getBothChronicRheumatologicAutoimmuneDis(): ?string
    {
        return $this->bothChronicRheumatologicAutoimmuneDis;
    }

    public function setBothChronicRheumatologicAutoimmuneDis(?string $bothChronicRheumatologicAutoimmuneDis): self
    {
        $this->bothChronicRheumatologicAutoimmuneDis = $bothChronicRheumatologicAutoimmuneDis;

        return $this;
    }

    public function getBothChronicNeurologicalNeuromuscularDis(): ?string
    {
        return $this->bothChronicNeurologicalNeuromuscularDis;
    }

    public function setBothChronicNeurologicalNeuromuscularDis(?string $bothChronicNeurologicalNeuromuscularDis): self
    {
        $this->bothChronicNeurologicalNeuromuscularDis = $bothChronicNeurologicalNeuromuscularDis;

        return $this;
    }

    public function getBothChronicCirrhosisLiverDis(): ?string
    {
        return $this->bothChronicCirrhosisLiverDis;
    }

    public function setBothChronicCirrhosisLiverDis(?string $bothChronicCirrhosisLiverDis): self
    {
        $this->bothChronicCirrhosisLiverDis = $bothChronicCirrhosisLiverDis;

        return $this;
    }

    public function getBothChronicNeoplasm(): ?string
    {
        return $this->bothChronicNeoplasm;
    }

    public function setBothChronicNeoplasm(?string $bothChronicNeoplasm): self
    {
        $this->bothChronicNeoplasm = $bothChronicNeoplasm;

        return $this;
    }

    public function getBothChronicObesity(): ?string
    {
        return $this->bothChronicObesity;
    }

    public function setBothChronicObesity(?string $bothChronicObesity): self
    {
        $this->bothChronicObesity = $bothChronicObesity;

        return $this;
    }

    public function getBothChronicMalnutri(): ?string
    {
        return $this->bothChronicMalnutri;
    }

    public function setBothChronicMalnutri(?string $bothChronicMalnutri): self
    {
        $this->bothChronicMalnutri = $bothChronicMalnutri;

        return $this;
    }

    public function getBothChronicActiveTuberculosis(): ?string
    {
        return $this->bothChronicActiveTuberculosis;
    }

    public function setBothChronicActiveTuberculosis(?string $bothChronicActiveTuberculosis): self
    {
        $this->bothChronicActiveTuberculosis = $bothChronicActiveTuberculosis;

        return $this;
    }

    public function getBothChronicHivInfection(): ?string
    {
        return $this->bothChronicHivInfection;
    }

    public function setBothChronicHivInfection(?string $bothChronicHivInfection): self
    {
        $this->bothChronicHivInfection = $bothChronicHivInfection;

        return $this;
    }

    public function getBothChronicHivExposure(): ?string
    {
        return $this->bothChronicHivExposure;
    }

    public function setBothChronicHivExposure(?string $bothChronicHivExposure): self
    {
        $this->bothChronicHivExposure = $bothChronicHivExposure;

        return $this;
    }

    public function getBothChronicOther(): ?string
    {
        return $this->bothChronicOther;
    }

    public function setBothChronicOther(?string $bothChronicOther): self
    {
        $this->bothChronicOther = $bothChronicOther;

        return $this;
    }

    public function getBothIcuAdm(): ?string
    {
        return $this->bothIcuAdm;
    }

    public function setBothIcuAdm(?string $bothIcuAdm): self
    {
        $this->bothIcuAdm = $bothIcuAdm;

        return $this;
    }

    public function getBothDeathHosp(): ?string
    {
        return $this->bothDeathHosp;
    }

    public function setBothDeathHosp(?string $bothDeathHosp): self
    {
        $this->bothDeathHosp = $bothDeathHosp;

        return $this;
    }

    public function getBothPositiveResult(): ?string
    {
        return $this->bothPositiveResult;
    }

    public function setBothPositiveResult(?string $bothPositiveResult): self
    {
        $this->bothPositiveResult = $bothPositiveResult;

        return $this;
    }

    public function getBothLabFluH1n1(): ?string
    {
        return $this->bothLabFluH1n1;
    }

    public function setBothLabFluH1n1(?string $bothLabFluH1n1): self
    {
        $this->bothLabFluH1n1 = $bothLabFluH1n1;

        return $this;
    }

    public function getBothLabFluH3n2(): ?string
    {
        return $this->bothLabFluH3n2;
    }

    public function setBothLabFluH3n2(?string $bothLabFluH3n2): self
    {
        $this->bothLabFluH3n2 = $bothLabFluH3n2;

        return $this;
    }

    public function getBothLabFluYamagata(): ?string
    {
        return $this->bothLabFluYamagata;
    }

    public function setBothLabFluYamagata(?string $bothLabFluYamagata): self
    {
        $this->bothLabFluYamagata = $bothLabFluYamagata;

        return $this;
    }

    public function getBothLabFluVictoria(): ?string
    {
        return $this->bothLabFluVictoria;
    }

    public function setBothLabFluVictoria(?string $bothLabFluVictoria): self
    {
        $this->bothLabFluVictoria = $bothLabFluVictoria;

        return $this;
    }

    public function getBothLabFluANosub(): ?string
    {
        return $this->bothLabFluANosub;
    }

    public function setBothLabFluANosub(?string $bothLabFluANosub): self
    {
        $this->bothLabFluANosub = $bothLabFluANosub;

        return $this;
    }

    public function getBothLabFluBNosub(): ?string
    {
        return $this->bothLabFluBNosub;
    }

    public function setBothLabFluBNosub(?string $bothLabFluBNosub): self
    {
        $this->bothLabFluBNosub = $bothLabFluBNosub;

        return $this;
    }

    public function getBothLab2RsYesno(): ?string
    {
        return $this->bothLab2RsYesno;
    }

    public function setBothLab2RsYesno(?string $bothLab2RsYesno): self
    {
        $this->bothLab2RsYesno = $bothLab2RsYesno;

        return $this;
    }

    public function getCompIli(): ?string
    {
        return $this->compIli;
    }

    public function setCompIli(?string $compIli): self
    {
        $this->compIli = $compIli;

        return $this;
    }

    public function getBothChronicPrematurity(): ?string
    {
        return $this->bothChronicPrematurity;
    }

    public function setBothChronicPrematurity(?string $bothChronicPrematurity): self
    {
        $this->bothChronicPrematurity = $bothChronicPrematurity;

        return $this;
    }

    public function getBothChronicHemoglobinopathies(): ?string
    {
        return $this->bothChronicHemoglobinopathies;
    }

    public function setBothChronicHemoglobinopathies(?string $bothChronicHemoglobinopathies): self
    {
        $this->bothChronicHemoglobinopathies = $bothChronicHemoglobinopathies;

        return $this;
    }

    public function getSysendtime(): ?string
    {
        return $this->sysendtime;
    }

    public function setSysendtime(?string $sysendtime): self
    {
        $this->sysendtime = $sysendtime;

        return $this;
    }

    public function getBothLab2Rs(): ?string
    {
        return $this->bothLab2Rs;
    }

    public function setBothLab2Rs(?string $bothLab2Rs): self
    {
        $this->bothLab2Rs = $bothLab2Rs;

        return $this;
    }

    public function getBothIlirespiratoryWheezing(): ?string
    {
        return $this->bothIlirespiratoryWheezing;
    }

    public function setBothIlirespiratoryWheezing(?string $bothIlirespiratoryWheezing): self
    {
        $this->bothIlirespiratoryWheezing = $bothIlirespiratoryWheezing;

        return $this;
    }

    public function getBothLab2Sarscov2(): ?string
    {
        return $this->bothLab2Sarscov2;
    }

    public function setBothLab2Sarscov2(?string $bothLab2Sarscov2): self
    {
        $this->bothLab2Sarscov2 = $bothLab2Sarscov2;

        return $this;
    }

    public function getBothLab2Sarscov2Yesno(): ?string
    {
        return $this->bothLab2Sarscov2Yesno;
    }

    public function setBothLab2Sarscov2Yesno(?string $bothLab2Sarscov2Yesno): self
    {
        $this->bothLab2Sarscov2Yesno = $bothLab2Sarscov2Yesno;

        return $this;
    }

    public function getBothLab2Sarscov(): ?string
    {
        return $this->bothLab2Sarscov;
    }

    public function setBothLab2Sarscov(?string $bothLab2Sarscov): self
    {
        $this->bothLab2Sarscov = $bothLab2Sarscov;

        return $this;
    }

    public function getBothLab2SarscovYesno(): ?string
    {
        return $this->bothLab2SarscovYesno;
    }

    public function setBothLab2SarscovYesno(?string $bothLab2SarscovYesno): self
    {
        $this->bothLab2SarscovYesno = $bothLab2SarscovYesno;

        return $this;
    }

    public function getOrvplus(): ?int
    {
        return $this->orvplus;
    }

    public function setOrvplus(?int $orvplus): self
    {
        $this->orvplus = $orvplus;

        return $this;
    }

    public function getOrvplussansrsv(): ?int
    {
        return $this->orvplussansrsv;
    }

    public function setOrvplussansrsv(?int $orvplussansrsv): self
    {
        $this->orvplussansrsv = $orvplussansrsv;

        return $this;
    }

    public function getOrvplussanssarscov2(): ?int
    {
        return $this->orvplussanssarscov2;
    }

    public function setOrvplussanssarscov2(?int $orvplussanssarscov2): self
    {
        $this->orvplussanssarscov2 = $orvplussanssarscov2;

        return $this;
    }

    public function getOrvplussansrsvsanssarscov2(): ?int
    {
        return $this->orvplussansrsvsanssarscov2;
    }

    public function setOrvplussansrsvsanssarscov2(?int $orvplussansrsvsanssarscov2): self
    {
        $this->orvplussansrsvsanssarscov2 = $orvplussansrsvsanssarscov2;

        return $this;
    }

    public function getIncluded(): ?int
    {
        return $this->included;
    }

    public function setIncluded(?int $included): self
    {
        $this->included = $included;

        return $this;
    }

    public function getTestorv(): ?int
    {
        return $this->testorv;
    }

    public function setTestorv(?int $testorv): self
    {
        $this->testorv = $testorv;

        return $this;
    }

    public function getTestorvsansrsv(): ?int
    {
        return $this->testorvsansrsv;
    }

    public function setTestorvsansrsv(?int $testorvsansrsv): self
    {
        $this->testorvsansrsv = $testorvsansrsv;

        return $this;
    }

    public function getTestorvsanssarscov2(): ?int
    {
        return $this->testorvsanssarscov2;
    }

    public function setTestorvsanssarscov2(?int $testorvsanssarscov2): self
    {
        $this->testorvsanssarscov2 = $testorvsanssarscov2;

        return $this;
    }

    public function getTestorvsansrsvsanssarscov2(): ?int
    {
        return $this->testorvsansrsvsanssarscov2;
    }

    public function setTestorvsansrsvsanssarscov2(?int $testorvsansrsvsanssarscov2): self
    {
        $this->testorvsansrsvsanssarscov2 = $testorvsansrsvsanssarscov2;

        return $this;
    }

    public function getTrancheagedef3(): ?string
    {
        return $this->trancheagedef3;
    }

    public function setTrancheagedef3(?string $trancheagedef3): self
    {
        $this->trancheagedef3 = $trancheagedef3;

        return $this;
    }

    public function getWeeknumber(): ?string
    {
        return $this->weeknumber;
    }

    public function setWeeknumber(?string $weeknumber): self
    {
        $this->weeknumber = $weeknumber;

        return $this;
    }

    public function getBothLab2OthersDetail(): ?string
    {
        return $this->bothLab2OthersDetail;
    }

    public function setBothLab2OthersDetail(?string $bothLab2OthersDetail): self
    {
        $this->bothLab2OthersDetail = $bothLab2OthersDetail;

        return $this;
    }

    public function getSite(): ?Site
    {
        return $this->site;
    }

    public function setSite(?Site $site): self
    {
        $this->site = $site;

        return $this;
    }
}
