<?php

namespace App\Entity\Main;

use App\Entity\Main\Traits\TimestampableTrait;
use App\Repository\Main\DataFileRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=DataFileRepository::class)
 */
class DataFile
{
    use TimestampableTrait;
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $fileName;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $fileNameOrigine;

    /**
     * @ORM\OneToMany(targetEntity=Data::class, mappedBy="dataFile", orphanRemoval=true)
     */
    private $data;

    /**
     * @ORM\ManyToOne(targetEntity=Site::class)
     */
    private $site;


    public function __construct()
    {
        $this->data = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getFileName(): ?string
    {
        return $this->fileName;
    }

    public function setFileName(string $fileName): self
    {
        $this->fileName = $fileName;

        return $this;
    }

    /**
     * @return Collection|Data[]
     */
    public function getData(): Collection
    {
        return $this->data;
    }

    public function addData(Data $data): self
    {
        if (!$this->data->contains($data)) {
            $this->data[] = $data;
            $data->setDataFile($this);
        }

        return $this;
    }

    public function removeData(Data $data): self
    {
        if ($this->data->removeElement($data)) {
            // set the owning side to null (unless already changed)
            if ($data->getDataFile() === $this) {
                $data->setDataFile(null);
            }
        }

        return $this;
    }

    public function getFileNameOrigine(): ?string
    {
        return $this->fileNameOrigine;
    }

    public function setFileNameOrigine(?string $fileNameOrigine): self
    {
        $this->fileNameOrigine = $fileNameOrigine;

        return $this;
    }

    public function getSite(): ?Site
    {
        return $this->site;
    }

    public function setSite(?Site $site): self
    {
        $this->site = $site;

        return $this;
    }
}
