<?php

namespace App\Entity\Main;

use App\Repository\Main\DataOldRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=DataOldRepository::class)
 * @ORM\Table(name="data_old",indexes={@ORM\Index(name="search_season_zone_age",columns={"season", "site_id","age"}),
 *     @ORM\Index(name="search_season_zone", columns={"season", "site_id"}),
 *     @ORM\Index(name="search_season",columns={"season"})})
 */
class DataOld
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="season", type="string", length=255, nullable=true)
     */
    private $season;

    /**
     * @var string|null
     *
     * @ORM\Column(name="id_bdd_philippe", type="text", length=65535, nullable=true)
     */
    private $idBddPhilippe;

    /**
     * @var string|null
     *
     * @ORM\Column(name="OHC_TECH_ID", type="text", length=65535, nullable=true)
     */
    private $ohcTechId;

    /**
     * @var string|null
     *
     * @ORM\Column(name="OHC_TECH_IdIntegration", type="text", length=65535, nullable=true)
     */
    private $ohcTechIdintegration;

    /**
     * @var string|null
     *
     * @ORM\Column(name="OHC_TECH_SEA_ID", type="text", length=65535, nullable=true)
     */
    private $ohcTechSeaId;

    /**
     * @var string|null
     *
     * @ORM\Column(name="date_last_modified", type="text", length=65535, nullable=true)
     */
    private $dateLastModified;

    /**
     * @var string|null
     *
     * @ORM\Column(name="id_last_modificator", type="text", length=65535, nullable=true)
     */
    private $idLastModificator;

    /**
     * @var string|null
     *
     * @ORM\Column(name="name_last_modificator", type="text", length=65535, nullable=true)
     */
    private $nameLastModificator;

    /**
     * @var string|null
     *
     * @ORM\Column(name="is_validated", type="text", length=65535, nullable=true)
     */
    private $isValidated;

    /**
     * @var string|null
     *
     * @ORM\Column(name="form_type", type="text", length=65535, nullable=true)
     */
    private $formType;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_comp_a_diag", type="text", length=65535, nullable=true)
     */
    private $bothCompADiag;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_a_diag", type="text", length=65535, nullable=true)
     */
    private $bothADiag;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_a_diag_icd", type="text", length=65535, nullable=true)
     */
    private $bothADiagIcd;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_doa", type="text", length=65535, nullable=true)
     */
    private $bothDoa;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_id_hospital", type="text", length=65535, nullable=true)
     */
    private $bothIdHospital;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_id_patient", type="text", length=65535, nullable=true)
     */
    private $bothIdPatient;

    /**
     * @var string|null
     *
     * @ORM\Column(name="doq", type="text", length=65535, nullable=true)
     */
    private $doq;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_sex", type="text", length=65535, nullable=true)
     */
    private $bothSex;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dob", type="text", length=65535, nullable=true)
     */
    private $dob;

    /**
     * @var string|null
     *
     * @ORM\Column(name="communication", type="text", length=65535, nullable=true)
     */
    private $communication;

    /**
     * @var string|null
     *
     * @ORM\Column(name="consents", type="text", length=65535, nullable=true)
     */
    private $consents;

    /**
     * @var string|null
     *
     * @ORM\Column(name="residence", type="text", length=65535, nullable=true)
     */
    private $residence;

    /**
     * @var string|null
     *
     * @ORM\Column(name="institutionalized", type="text", length=65535, nullable=true)
     */
    private $institutionalized;

    /**
     * @var string|null
     *
     * @ORM\Column(name="exclussion_hosp", type="text", length=65535, nullable=true)
     */
    private $exclussionHosp;

    /**
     * @var string|null
     *
     * @ORM\Column(name="soc_class", type="text", length=65535, nullable=true)
     */
    private $socClass;

    /**
     * @var string|null
     *
     * @ORM\Column(name="smoking_hab", type="text", length=65535, nullable=true)
     */
    private $smokingHab;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_cond_yn", type="text", length=65535, nullable=true)
     */
    private $bothChronicCondYn;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_clinical3", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical3;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_cvd_blood", type="text", length=65535, nullable=true)
     */
    private $bothChronicCvdBlood;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_copd", type="text", length=65535, nullable=true)
     */
    private $bothChronicCopd;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_asthma", type="text", length=65535, nullable=true)
     */
    private $bothChronicAsthma;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_diabetes", type="text", length=65535, nullable=true)
     */
    private $bothChronicDiabetes;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_immuno", type="text", length=65535, nullable=true)
     */
    private $bothChronicImmuno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_renal", type="text", length=65535, nullable=true)
     */
    private $bothChronicRenal;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_rheumatologic_autoimmune_dis", type="text", length=65535, nullable=true)
     */
    private $bothChronicRheumatologicAutoimmuneDis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_neurological_neuromuscular_dis", type="text", length=65535, nullable=true)
     */
    private $bothChronicNeurologicalNeuromuscularDis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_cirrhosis_liver_dis", type="text", length=65535, nullable=true)
     */
    private $bothChronicCirrhosisLiverDis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_neoplasm", type="text", length=65535, nullable=true)
     */
    private $bothChronicNeoplasm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_obesity", type="text", length=65535, nullable=true)
     */
    private $bothChronicObesity;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_malnutri", type="text", length=65535, nullable=true)
     */
    private $bothChronicMalnutri;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_active_tuberculosis", type="text", length=65535, nullable=true)
     */
    private $bothChronicActiveTuberculosis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_hiv_infection", type="text", length=65535, nullable=true)
     */
    private $bothChronicHivInfection;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_hiv_exposure", type="text", length=65535, nullable=true)
     */
    private $bothChronicHivExposure;

    /**
     * @var string|null
     *
     * @ORM\Column(name="chronic_auto", type="text", length=65535, nullable=true)
     */
    private $chronicAuto;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_other", type="text", length=65535, nullable=true)
     */
    private $bothChronicOther;

    /**
     * @var string|null
     *
     * @ORM\Column(name="hosp_12m", type="text", length=65535, nullable=true)
     */
    private $hosp12m;

    /**
     * @var string|null
     *
     * @ORM\Column(name="av_current_days", type="text", length=65535, nullable=true)
     */
    private $avCurrentDays;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_av_current", type="text", length=65535, nullable=true)
     */
    private $bothAvCurrent;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_av_starting_date", type="text", length=65535, nullable=true)
     */
    private $bothAvStartingDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="previous_lab", type="text", length=65535, nullable=true)
     */
    private $previousLab;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_influ_vac_current_season", type="text", length=65535, nullable=true)
     */
    private $bothInfluVacCurrentSeason;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_vac_14d_before_ili_sym", type="text", length=65535, nullable=true)
     */
    private $bothVac14dBeforeIliSym;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dov", type="text", length=65535, nullable=true)
     */
    private $dov;

    /**
     * @var string|null
     *
     * @ORM\Column(name="vac_name", type="text", length=65535, nullable=true)
     */
    private $vacName;

    /**
     * @var string|null
     *
     * @ORM\Column(name="vac_type", type="text", length=65535, nullable=true)
     */
    private $vacType;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_vac_preceding_season", type="text", length=65535, nullable=true)
     */
    private $bothVacPrecedingSeason;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_swab_date", type="text", length=65535, nullable=true)
     */
    private $bothSwabDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_swab_date_unknow", type="text", length=65535, nullable=true)
     */
    private $bothSwabDateUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="swab_sent", type="text", length=65535, nullable=true)
     */
    private $swabSent;

    /**
     * @var string|null
     *
     * @ORM\Column(name="swab_np", type="text", length=65535, nullable=true)
     */
    private $swabNp;

    /**
     * @var string|null
     *
     * @ORM\Column(name="swab_n", type="text", length=65535, nullable=true)
     */
    private $swabN;

    /**
     * @var string|null
     *
     * @ORM\Column(name="swab_p", type="text", length=65535, nullable=true)
     */
    private $swabP;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dol", type="text", length=65535, nullable=true)
     */
    private $dol;

    /**
     * @var string|null
     *
     * @ORM\Column(name="hypoxia_adm", type="text", length=65535, nullable=true)
     */
    private $hypoxiaAdm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="lethargy_adm", type="text", length=65535, nullable=true)
     */
    private $lethargyAdm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_oxygen_saturation", type="text", length=65535, nullable=true)
     */
    private $bothSeverityOxygenSaturation;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_oxygen_saturation_unknow", type="text", length=65535, nullable=true)
     */
    private $bothSeverityOxygenSaturationUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_severity_blood_pressure", type="text", length=65535, nullable=true)
     */
    private $moreSeverityBloodPressure;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_severity_blood_pressure_unknow", type="text", length=65535, nullable=true)
     */
    private $moreSeverityBloodPressureUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_respiration_rate", type="text", length=65535, nullable=true)
     */
    private $bothSeverityRespirationRate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_respiration_rate_unknow", type="text", length=65535, nullable=true)
     */
    private $bothSeverityRespirationRateUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="blood_urea_nitrogen", type="text", length=65535, nullable=true)
     */
    private $bloodUreaNitrogen;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_supp_oxygen", type="text", length=65535, nullable=true)
     */
    private $bothSeveritySuppOxygen;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_vaso_support", type="text", length=65535, nullable=true)
     */
    private $bothSeverityVasoSupport;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_icu_adm", type="text", length=65535, nullable=true)
     */
    private $bothIcuAdm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_death_hosp", type="text", length=65535, nullable=true)
     */
    private $bothDeathHosp;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_mech_vent", type="text", length=65535, nullable=true)
     */
    private $bothSeverityMechVent;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_discharged_date", type="text", length=65535, nullable=true)
     */
    private $bothDischargedDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_d_diag1", type="text", length=65535, nullable=true)
     */
    private $bothDDiag1;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_d_diag2", type="text", length=65535, nullable=true)
     */
    private $bothDDiag2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_d_diag3", type="text", length=65535, nullable=true)
     */
    private $bothDDiag3;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_d_icd", type="text", length=65535, nullable=true)
     */
    private $bothDIcd;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_positive_result", type="text", length=65535, nullable=true)
     */
    private $bothPositiveResult;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_labo2", type="text", length=65535, nullable=true)
     */
    private $bothDisplayLabo2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_h1n1", type="text", length=65535, nullable=true)
     */
    private $bothLabFluH1n1;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_h3n2", type="text", length=65535, nullable=true)
     */
    private $bothLabFluH3n2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_yamagata", type="text", length=65535, nullable=true)
     */
    private $bothLabFluYamagata;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_victoria", type="text", length=65535, nullable=true)
     */
    private $bothLabFluVictoria;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_a_nosub", type="text", length=65535, nullable=true)
     */
    private $bothLabFluANosub;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab_flu_b_nosub", type="text", length=65535, nullable=true)
     */
    private $bothLabFluBNosub;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_corona_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2CoronaYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_metaneumo_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2MetaneumoYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_rs_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2RsYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_adeno_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2AdenoYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_boca_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2BocaYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_pi_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2PiYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_rhino_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2RhinoYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="lab_mix", type="text", length=65535, nullable=true)
     */
    private $labMix;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_detected_coinfection", type="text", length=65535, nullable=true)
     */
    private $bothDetectedCoinfection;

    /**
     * @var string|null
     *
     * @ORM\Column(name="lab_negative", type="text", length=65535, nullable=true)
     */
    private $labNegative;

    /**
     * @var string|null
     *
     * @ORM\Column(name="lab_inadequate", type="text", length=65535, nullable=true)
     */
    private $labInadequate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="age", type="string", length=255, nullable=true)
     */
    private $age;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_age_months", type="text", length=65535, nullable=true)
     */
    private $lessAgeMonths;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_age_years", type="text", length=65535, nullable=true)
     */
    private $moreAgeYears;

    /**
     * @var string|null
     *
     * @ORM\Column(name="sym_7d_yn", type="text", length=65535, nullable=true)
     */
    private $sym7dYn;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_ilisystemic", type="text", length=65535, nullable=true)
     */
    private $bothDisplayIlisystemic;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilisystemic_fever", type="text", length=65535, nullable=true)
     */
    private $bothIlisystemicFever;

    /**
     * @var string|null
     *
     * @ORM\Column(name="fever_adm", type="text", length=65535, nullable=true)
     */
    private $feverAdm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilisystemic_malaise", type="text", length=65535, nullable=true)
     */
    private $bothIlisystemicMalaise;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilisystemic_headache", type="text", length=65535, nullable=true)
     */
    private $bothIlisystemicHeadache;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilisystemic_myalgia", type="text", length=65535, nullable=true)
     */
    private $bothIlisystemicMyalgia;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilirespiratory_cough", type="text", length=65535, nullable=true)
     */
    private $bothIlirespiratoryCough;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilirespiratory_sorethroat", type="text", length=65535, nullable=true)
     */
    private $bothIlirespiratorySorethroat;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilirespiratory_shortnessbreath", type="text", length=65535, nullable=true)
     */
    private $bothIlirespiratoryShortnessbreath;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_ilirespiratory", type="text", length=65535, nullable=true)
     */
    private $bothDisplayIlirespiratory;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilirespiratory_nasalcongestion", type="text", length=65535, nullable=true)
     */
    private $bothIlirespiratoryNasalcongestion;

    /**
     * @var string|null
     *
     * @ORM\Column(name="doo", type="text", length=65535, nullable=true)
     */
    private $doo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_epi_isl", type="text", length=65535, nullable=true)
     */
    private $bothEpiIsl;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_clinical2", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_clinical4", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical4;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_clinical5", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical5;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_clinical6", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical6;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_clinical7", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical7;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_pregnancy_status", type="text", length=65535, nullable=true)
     */
    private $bothPregnancyStatus;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_pregnancy_weeks", type="text", length=65535, nullable=true)
     */
    private $bothPregnancyWeeks;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_pregnancy_weeks_unknow", type="text", length=65535, nullable=true)
     */
    private $bothPregnancyWeeksUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_hasonesymptoms", type="text", length=65535, nullable=true)
     */
    private $bothDisplayHasonesymptoms;

    /**
     * @var string|null
     *
     * @ORM\Column(name="comp_ili", type="text", length=65535, nullable=true)
     */
    private $compIli;

    /**
     * @var string|null
     *
     * @ORM\Column(name="comp_ili_7d", type="text", length=65535, nullable=true)
     */
    private $compIli7d;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_comply", type="text", length=65535, nullable=true)
     */
    private $moreComply;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_test_other_virus", type="text", length=65535, nullable=true)
     */
    private $bothTestOtherVirus;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_test_other2", type="text", length=65535, nullable=true)
     */
    private $bothDisplayTestOther2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="display_titre_labo", type="text", length=65535, nullable=true)
     */
    private $displayTitreLabo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_height", type="text", length=65535, nullable=true)
     */
    private $bothHeight;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_weight", type="text", length=65535, nullable=true)
     */
    private $bothWeight;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_height_unknow", type="text", length=65535, nullable=true)
     */
    private $bothHeightUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_weight_unknow", type="text", length=65535, nullable=true)
     */
    private $bothWeightUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="birthweight", type="text", length=65535, nullable=true)
     */
    private $birthweight;

    /**
     * @var string|null
     *
     * @ORM\Column(name="child_born", type="text", length=65535, nullable=true)
     */
    private $childBorn;

    /**
     * @var string|null
     *
     * @ORM\Column(name="birth_week", type="text", length=65535, nullable=true)
     */
    private $birthWeek;

    /**
     * @var string|null
     *
     * @ORM\Column(name="gestbirth_wk_yn", type="text", length=65535, nullable=true)
     */
    private $gestbirthWkYn;

    /**
     * @var string|null
     *
     * @ORM\Column(name="gestbirth_wk", type="text", length=65535, nullable=true)
     */
    private $gestbirthWk;

    /**
     * @var string|null
     *
     * @ORM\Column(name="exclu_breast_fed", type="text", length=65535, nullable=true)
     */
    private $excluBreastFed;

    /**
     * @var string|null
     *
     * @ORM\Column(name="breastfed_yn", type="text", length=65535, nullable=true)
     */
    private $breastfedYn;

    /**
     * @var string|null
     *
     * @ORM\Column(name="breastfed_month_time", type="text", length=65535, nullable=true)
     */
    private $breastfedMonthTime;

    /**
     * @var string|null
     *
     * @ORM\Column(name="temperature_adm", type="text", length=65535, nullable=true)
     */
    private $temperatureAdm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_prematurity", type="text", length=65535, nullable=true)
     */
    private $bothChronicPrematurity;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_chronic_down_syndrom", type="text", length=65535, nullable=true)
     */
    private $lessChronicDownSyndrom;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_chronic_congenital_heart_dis", type="text", length=65535, nullable=true)
     */
    private $lessChronicCongenitalHeartDis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_chronic_leukemia", type="text", length=65535, nullable=true)
     */
    private $moreChronicLeukemia;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_chronic_hemoglobinopathies", type="text", length=65535, nullable=true)
     */
    private $bothChronicHemoglobinopathies;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antibio_preceding", type="text", length=65535, nullable=true)
     */
    private $bothAntibioPreceding;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antibio_preceding_date", type="text", length=65535, nullable=true)
     */
    private $bothAntibioPrecedingDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_frailty_score", type="text", length=65535, nullable=true)
     */
    private $bothFrailtyScore;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_frailty_score_unknow", type="text", length=65535, nullable=true)
     */
    private $bothFrailtyScoreUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_influ_vac_current_season_2_doses", type="text", length=65535, nullable=true)
     */
    private $lessInfluVacCurrentSeason2Doses;

    /**
     * @var string|null
     *
     * @ORM\Column(name="barthel_index", type="text", length=65535, nullable=true)
     */
    private $barthelIndex;

    /**
     * @var string|null
     *
     * @ORM\Column(name="confusion_adm", type="text", length=65535, nullable=true)
     */
    private $confusionAdm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_confusion", type="text", length=65535, nullable=true)
     */
    private $bothSeverityConfusion;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_apnea", type="text", length=65535, nullable=true)
     */
    private $bothSeverityApnea;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_discharge_another_hopital", type="text", length=65535, nullable=true)
     */
    private $bothDischargeAnotherHopital;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_frailty_score_discharge", type="text", length=65535, nullable=true)
     */
    private $bothFrailtyScoreDischarge;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_frailty_score_discharge_unknow", type="text", length=65535, nullable=true)
     */
    private $bothFrailtyScoreDischargeUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_sample_submited", type="text", length=65535, nullable=true)
     */
    private $bothSampleSubmited;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_gisaid", type="text", length=65535, nullable=true)
     */
    private $bothDisplayGisaid;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_display_intro", type="text", length=65535, nullable=true)
     */
    private $lessDisplayIntro;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_display_intro", type="text", length=65535, nullable=true)
     */
    private $moreDisplayIntro;

    /**
     * @var string|null
     *
     * @ORM\Column(name="SysStartTime", type="text", length=65535, nullable=true)
     */
    private $sysstarttime;

    /**
     * @var string|null
     *
     * @ORM\Column(name="SysEndTime", type="text", length=65535, nullable=true)
     */
    private $sysendtime;

    /**
     * @var string|null
     *
     * @ORM\Column(name="OHC_CleSignature", type="text", length=65535, nullable=true)
     */
    private $ohcClesignature;

    /**
     * @var string|null
     *
     * @ORM\Column(name="OHC_Signature", type="text", length=65535, nullable=true)
     */
    private $ohcSignature;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_clinical6b", type="text", length=65535, nullable=true)
     */
    private $bothDisplayClinical6b;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_corona", type="text", length=65535, nullable=true)
     */
    private $bothLab2Corona;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_metaneumo", type="text", length=65535, nullable=true)
     */
    private $bothLab2Metaneumo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_rs", type="text", length=65535, nullable=true)
     */
    private $bothLab2Rs;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_adeno", type="text", length=65535, nullable=true)
     */
    private $bothLab2Adeno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_boca", type="text", length=65535, nullable=true)
     */
    private $bothLab2Boca;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_pi", type="text", length=65535, nullable=true)
     */
    private $bothLab2Pi;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_rhino", type="text", length=65535, nullable=true)
     */
    private $bothLab2Rhino;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_display_hasothersymptoms", type="text", length=65535, nullable=true)
     */
    private $bothDisplayHasothersymptoms;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_othersymptoms_nausea", type="text", length=65535, nullable=true)
     */
    private $bothOthersymptomsNausea;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_othersymptoms_diarrhea", type="text", length=65535, nullable=true)
     */
    private $bothOthersymptomsDiarrhea;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_othersymptoms_smell", type="text", length=65535, nullable=true)
     */
    private $bothOthersymptomsSmell;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_othersymptoms_chestpain", type="text", length=65535, nullable=true)
     */
    private $bothOthersymptomsChestpain;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_othersymptoms_fever", type="text", length=65535, nullable=true)
     */
    private $lessOthersymptomsFever;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_othersymptoms_malaise", type="text", length=65535, nullable=true)
     */
    private $lessOthersymptomsMalaise;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_othersymptoms_headache", type="text", length=65535, nullable=true)
     */
    private $lessOthersymptomsHeadache;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_othersymptoms_myalgia", type="text", length=65535, nullable=true)
     */
    private $lessOthersymptomsMyalgia;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_othersymptoms_cough", type="text", length=65535, nullable=true)
     */
    private $lessOthersymptomsCough;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_othersymptoms_sorethroat", type="text", length=65535, nullable=true)
     */
    private $lessOthersymptomsSorethroat;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_othersymptoms_shortnessofbreath", type="text", length=65535, nullable=true)
     */
    private $lessOthersymptomsShortnessofbreath;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_ilirespiratory_wheezing", type="text", length=65535, nullable=true)
     */
    private $bothIlirespiratoryWheezing;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_othersymptoms_nasalcongestion", type="text", length=65535, nullable=true)
     */
    private $lessOthersymptomsNasalcongestion;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antibio_during", type="text", length=65535, nullable=true)
     */
    private $bothAntibioDuring;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antibio_during_date", type="text", length=65535, nullable=true)
     */
    private $bothAntibioDuringDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antiviral_preceding", type="text", length=65535, nullable=true)
     */
    private $bothAntiviralPreceding;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antiviral_preceding_date", type="text", length=65535, nullable=true)
     */
    private $bothAntiviralPrecedingDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antiviral_during", type="text", length=65535, nullable=true)
     */
    private $bothAntiviralDuring;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_antiviral_during_date", type="text", length=65535, nullable=true)
     */
    private $bothAntiviralDuringDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_vac_history_validated", type="text", length=65535, nullable=true)
     */
    private $bothVacHistoryValidated;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_display_comment", type="text", length=65535, nullable=true)
     */
    private $moreDisplayComment;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_display_comment", type="text", length=65535, nullable=true)
     */
    private $lessDisplayComment;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_sarscov2", type="text", length=65535, nullable=true)
     */
    private $bothLab2Sarscov2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_sarscov2_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2Sarscov2Yesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_others", type="text", length=65535, nullable=true)
     */
    private $bothLab2Others;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_lab2_others_yesno", type="text", length=65535, nullable=true)
     */
    private $bothLab2OthersYesno;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_covid_firstdose", type="text", length=65535, nullable=true)
     */
    private $moreCovidFirstdose;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_covid_full", type="text", length=65535, nullable=true)
     */
    private $moreCovidFull;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_covid_vaccine", type="text", length=65535, nullable=true)
     */
    private $moreCovidVaccine;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2010_11", type="text", length=65535, nullable=true)
     */
    private $fluVac201011;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2011_12", type="text", length=65535, nullable=true)
     */
    private $fluVac201112;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2012_13", type="text", length=65535, nullable=true)
     */
    private $fluVac201213;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2013_14", type="text", length=65535, nullable=true)
     */
    private $fluVac201314;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2014_15", type="text", length=65535, nullable=true)
     */
    private $fluVac201415;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2015_16", type="text", length=65535, nullable=true)
     */
    private $fluVac201516;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2016_17", type="text", length=65535, nullable=true)
     */
    private $fluVac201617;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2017_18", type="text", length=65535, nullable=true)
     */
    private $fluVac201718;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2018_19", type="text", length=65535, nullable=true)
     */
    private $fluVac201819;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2019_20", type="text", length=65535, nullable=true)
     */
    private $fluVac201920;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2020_21", type="text", length=65535, nullable=true)
     */
    private $fluVac202021;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2021_22", type="text", length=65535, nullable=true)
     */
    private $fluVac202122;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2022_23", type="text", length=65535, nullable=true)
     */
    private $fluVac202223;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2023_24", type="text", length=65535, nullable=true)
     */
    private $fluVac202324;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2024_25", type="text", length=65535, nullable=true)
     */
    private $fluVac202425;

    /**
     * @var string|null
     *
     * @ORM\Column(name="flu_vac_2026_27", type="text", length=65535, nullable=true)
     */
    private $fluVac202627;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ecmo", type="text", length=65535, nullable=true)
     */
    private $ecmo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="reason_no_com", type="text", length=65535, nullable=true)
     */
    private $reasonNoCom;

    /**
     * @var string|null
     *
     * @ORM\Column(name="consul_3m", type="text", length=65535, nullable=true)
     */
    private $consul3m;

    /**
     * @var string|null
     *
     * @ORM\Column(name="contra_flu", type="text", length=65535, nullable=true)
     */
    private $contraFlu;

    /**
     * @var string|null
     *
     * @ORM\Column(name="sudden", type="text", length=65535, nullable=true)
     */
    private $sudden;

    /**
     * @var string|null
     *
     * @ORM\Column(name="polypnea", type="text", length=65535, nullable=true)
     */
    private $polypnea;

    /**
     * @var int|null
     *
     * @ORM\Column(name="education", type="integer", nullable=true)
     */
    private $education;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_blood_pressure", type="text", length=65535, nullable=true)
     */
    private $bothSeverityBloodPressure;

    /**
     * @var string|null
     *
     * @ORM\Column(name="both_severity_blood_pressure_unknow", type="text", length=65535, nullable=true)
     */
    private $bothSeverityBloodPressureUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_severity_oxygen_saturation", type="text", length=65535, nullable=true)
     */
    private $lessSeverityOxygenSaturation;

    /**
     * @var string|null
     *
     * @ORM\Column(name="less_severity_oxygen_saturation_unknow", type="text", length=65535, nullable=true)
     */
    private $lessSeverityOxygenSaturationUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_severity_respiration_rate", type="text", length=65535, nullable=true)
     */
    private $moreSeverityRespirationRate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_severity_respiration_rate_unknow", type="text", length=65535, nullable=true)
     */
    private $moreSeverityRespirationRateUnknow;

    /**
     * @var string|null
     *
     * @ORM\Column(name="more_severity_apnea", type="text", length=65535, nullable=true)
     */
    private $moreSeverityApnea;

    /**
     * @ORM\Column(name="tocalculate", type="integer", nullable=true)
     */
    private $tocalculate;

    /**
     * @ORM\Column(name="included", type="integer", nullable=true)
     */
    private $included;

    /**
     * @ORM\Column(name="screened", type="integer", nullable=true)
     */
    private $screened;

    /**
     * @ORM\Column(name="sequenced", type="integer", nullable=true)
     */
    private $sequenced;

    /**
     * @ORM\Column(name="lci_plus", type="integer", nullable=true)
     */
    private $lciplus;

    /**
     * @ORM\Column(name="orv_plus", type="integer", nullable=true)
     */
    private $orvplus;

    /**
     * @ORM\Column(name="orv_plus_sans_rsv", type="integer", nullable=true)
     */
    private $orvplussansrsv;

    /**
     * @ORM\Column(name="orv_plus_sans_sars_cov_2", type="integer", nullable=true)
     */
    private $orvplussanssarscov2;

    /**
     * @ORM\Column(name="orv_plus_sans_rsv_sans_sars_cov_2", type="integer", nullable=true)
     */
    private $orvplussansrsvsanssarscov2;

    /**
     * @ORM\Column(name="test_orv", type="integer", nullable=true)
     */
    private $testorv;

    /**
     * @ORM\Column(name="test_orv_sans_rsv", type="integer", nullable=true)
     */
    private $testorvsansrsv;

    /**
     * @ORM\Column(name="test_orv_sans_sars_cov_2", type="integer", nullable=true)
     */
    private $testorvsanssarscov2;

    /**
     * @ORM\Column(name="test_orv_sans_rsv_sans_sars_cov_2", type="integer", nullable=true)
     */
    private $testorvsansrsvsanssarscov2;

    /**
     * @ORM\Column(name="both_age", type="integer", nullable=true)
     */
    private $bothage;

    /**
     * @ORM\Column(name="both_age_unit", type="integer", nullable=true)
     */
    private $bothageunit;

    /**
     * @ORM\Column(name="tranche_age_def1", type="string", length=255, nullable=true)
     */
    private $trancheagedef1;

    /**
     * @ORM\Column(name="tranche_age_def2", type="string", length=255, nullable=true)
     */
    private $trancheagedef2;

    /**
     * @ORM\Column(name="tranche_age_def3", type="string", length=255, nullable=true)
     */
    private $trancheagedef3;

    /**
     * @ORM\Column(name="length_of_hospital_stay", type="integer", nullable=true)
     */
    private $lengthofhospitalstay;

    /**
     * @ORM\Column(name="week_number", type="string", length=255, nullable=true)
     */
    private $weeknumber;

    /**
     * @ORM\Column(name="exclusion", type="integer", nullable=true)
     */
    private $exclusion;

    /**
     * @ORM\Column(name="site_id", type="integer", nullable=true)
     */
    private $siteId;

    /**
     * @ORM\Column(name="data_file_id", type="integer", nullable=true)
     */
    private $dataFileId;


    /**
     * @ORM\Column(name="both_display_intro", type="text", nullable=true)
     */
    private $bothDisplayIntro;

    /**
     * @ORM\Column(name="both_display_how_patient_was_identified", type="text", nullable=true)
     */
    private $bothDisplayHowPatientWasIdentified;

    /**
     * @ORM\Column(name="both_a_diag_unknow", type="integer", nullable=true)
     */
    private $bothAdiagUnknow;

    /**
     * @ORM\Column(name="both_case_identified_based_logs_respiratory", type="integer", nullable=true)
     */
    private $bothCaseIdentifiedBasedLogsRespiratory;

    /**
     * @ORM\Column(name="both_case_identified_based_positive_swab", type="integer", nullable=true)
     */
    private $bothCaseIdentifiedBasedPositiveSwab;

    /**
     * @ORM\Column(name="both_case_definition_used", type="integer", nullable=true)
     */
    private $bothCaseDefinitionUsed;

    /**
     * @ORM\Column(name="both_case_definition_other_detail", type="text", nullable=true)
     */
    private $bothCaseDefinitionOtherDetail;

    /**
     * @ORM\Column(name="both_lab2_others_detail", type="text", nullable=true)
     */
    private $bothLab2OthersDetail;

    /**
     * @ORM\Column(name="both_antiviral_preceding_date_unknow", type="integer", nullable=true)
     */
    private $bothAntiviralPrecedingDateUnknow;

    /**
     * @ORM\Column(name="both_antiviral_during_date_unknow", type="integer", nullable=true)
     */
    private $bothAntiviralDuringDateUnknow;

    /**
     * @ORM\Column(name="both_antibio_preceding_date_unknow", type="integer", nullable=true)
     */
    private $bothAntibioPrecedingDateUnknow;

    /**
     * @ORM\Column(name="both_antibio_during_date_unknow", type="integer", nullable=true)
     */
    private $bothAntibioDuringDateUnknow;

    /**
     * @ORM\Column(name="both_vac_type_vaccine", type="integer", nullable=true)
     */
    private $bothVacTypeVaccine;

    /**
     * @ORM\Column(name="both_display_clinical5bis", type="text", nullable=true)
     */
    private $bothDisplayClinical5bis;

    /**
     * @ORM\Column(name="both_covid_number_doses", type="text", nullable=true)
     */
    private $bothCovidNumberDoses;

    /**
     * @ORM\Column(name="both_covid_last_dose_date", type="text", nullable=true)
     */
    private $bothCovidLastDoseDate;

    /**
     * @ORM\Column(name="both_swabcovid_date", type="text", nullable=true)
     */
    private $bothSwabcovidDate;

    /**
     * @ORM\Column(name="both_covid_last_dose_date_unknow", type="text", nullable=true)
     */
    private $bothCovidLastDoseDateUnknow;

    /**
     * @ORM\Column(name="both_display_covid_vaccine", type="text", nullable=true)
     */
    private $bothDisplayCovidVaccine;

    /**
     * @ORM\Column(name="both_covid_vaccine_mrna", type="integer", nullable=true)
     */
    private $bothCovidVaccineMrna;

    /**
     * @ORM\Column(name="both_covid_vaccine_inactivated_virion", type="integer", nullable=true)
     */
    private $bothCovidVaccineInactivatedVirion;

    /**
     * @ORM\Column(name="both_covid_vaccine_viral_vector", type="integer", nullable=true)
     */
    private $bothCovidVaccineViralVector;

    /**
     * @ORM\Column(name="both_covid_vaccine_protein_subunit", type="integer", nullable=true)
     */
    private $bothCovidVaccineProteinSubunit;

    /**
     * @ORM\Column(name="both_covid_vaccine_unknow", type="integer", nullable=true)
     */
    private $bothCovidVaccineUnknow;

    /**
     * @ORM\Column(name="both_severity_high_dependence_unit", type="integer", nullable=true)
     */
    private $bothSeverityHighDependenceUnit;

    /**
     * @ORM\Column(name="both_d_diag1_unknow", type="integer", nullable=true)
     */
    private $bothDDiag1Unknow;

    /**
     * @ORM\Column(name="both_d_diag2_unknow", type="integer", nullable=true)
     */
    private $bothDDiag2Unknow;

    /**
     * @ORM\Column(name="both_d_diag3_unknow", type="integer", nullable=true)
     */
    private $bothDDiag3Unknow;

    /**
     * @ORM\Column(name="both_sample_type", type="integer", nullable=true)
     */
    private $bothSampleType;

    /**
     * @ORM\Column(name="both_swabcovid_date_unknow", type="integer", nullable=true)
     */
    private $bothSwabcovidDateUnknow;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $lessChronicMalnutri;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $moreChronicHivInfection;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $lessChronicHivExposure;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $moreDisplayIlisystemic;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $moreIlisystemicFever;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $moreIlisystemicMalaise;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $moreIlisystemicHeadache;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $moreIlisystemicMyalgia;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $moreIlirespiratoryCough;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $moreIlirespiratorySorethroat;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $moreIlirespiratoryShortnessbreath;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $moreDisplayIlirespiratory;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $moreIlirespiratoryNasalcongestion;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $morePregnancyStatus;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $morePregnancyWeeks;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $morePregnancyWeeksUnknow;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $moreDisplayHasonesymptoms;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $lessWeightUnknow;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $lessHeightUnknow;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $lessChronicPrematurity;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $moreChronicHemoglobinopathies;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $moreFrailtyScore;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)fi
     */
    private $moreFrailtyScoreUnknow;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $lessSeverityApnea;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $moreFrailtyScoreDischarge;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $moreFrailtyScoreDischargeUnknow;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $moreOthersymptomsChestpain;

    /**
     * @ORM\Column(type="integer", nullable=true, length=1)
     */
    private $lessOthersymptomsWheezing;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $lessHeight;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $lessWeight;


}
