<?php

namespace App\Entity\Main;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use App\Repository\Main\SiteRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=SiteRepository::class)
 */
class Site
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $category;

    /**
     * @var string|null
     *
     * @ORM\Column(name="zone", type="string", length=255, nullable=true)
     */
    private $zone;

    /**
     * @ORM\OneToMany(targetEntity=Data::class, mappedBy="site")
     */
    private $data;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $categoryEn;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $latitude;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $longitude ;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $orderZone;

    /**
     * @var string|null
     *
     * @ORM\Column(name="site_name_season_22", type="string", length=255, nullable=true)
     */
    private $siteNameSeason22;
    /**
     * @var string|null
     *
     * @ORM\Column(name="site_name_season_23", type="string", length=255, nullable=true)
     */
    private $siteNameSeason23;

    public function __construct()
    {
        $this->data = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCategory(): ?string
    {
        return $this->category;
    }

    public function setCategory(string $category): self
    {
        $this->category = $category;

        return $this;
    }

    public function getZone(): ?string
    {
        return $this->zone;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function setZone(?string $zone): self
    {
        $this->zone = $zone;

        return $this;
    }

    /**
     * @return Collection|Data[]
     */
    public function getData(): Collection
    {
        return $this->data;
    }

    public function addData(Data $data): self
    {
        if (!$this->data->contains($data)) {
            $this->data[] = $data;
            $data->setSite($this);
        }

        return $this;
    }

    public function removeData(Data $data): self
    {
        if ($this->data->removeElement($data)) {
            // set the owning side to null (unless already changed)
            if ($data->getSite() === $this) {
                $data->setSite(null);
            }
        }

        return $this;
    }

    public function getCategoryEn(): ?string
    {
        return $this->categoryEn;
    }

    public function setCategoryEn(?string $categoryEn): self
    {
        $this->categoryEn = $categoryEn;

        return $this;
    }

    public function getLongitude(): ?string
    {
        return $this->longitude;
    }

    public function setLongitude(?string $longitude): self
    {
        $this->longitude = $longitude;

        return $this;
    }
    public function getLatitude(): ?string
    {
        return $this->latitude;
    }

    public function setLatitude(?string $latitude): self
    {
        $this->latitude = $latitude;

        return $this;
    }
    public function getOrderZone(): ?int
    {
        return $this->orderZone;
    }

    public function setOrderZone(?int $orderZone): self
    {
        $this->orderZone = $orderZone;

        return $this;
    }

    public function getSiteNameSeason22(): ?string
    {
        return $this->siteNameSeason22;
    }

    public function setSiteNameSeason22(?string $siteNameSeason22): self
    {
        $this->siteNameSeason22 = $siteNameSeason22;

        return $this;
    }

    public function getSiteNameSeason23(): ?string
    {
        return $this->siteNameSeason23;
    }

    public function setSiteNameSeason23(?string $siteNameSeason23): self
    {
        $this->siteNameSeason23 = $siteNameSeason23;

        return $this;
    }


}