<?php

namespace App\Form;

use App\Entity\Main\Data;
use App\Entity\Main\Site;
use App\Repository\Main\DataRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class FilterType extends AbstractType
{
    protected $em;
    protected $security;

    public function __construct(EntityManagerInterface $entityManager, Security $security)
    {
        $this->em = $entityManager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $addFilter = $options['add'];
        $fullNames= $options['fullNames'];

        if (array_search('firstName',$addFilter) !== false){
            $builder->add('firstName', TextType::class, [
                'label' => 'First name',
                'attr' => [
                    'class' => 'filter_firstName',
                ],
                'required' => false,
                'mapped' => false
            ]);
        }
        if (array_search('lastName',$addFilter) !== false){
            $builder->add('lastName', TextType::class, [
                'label' => 'Last name',
                'attr' => [
                    'class' => 'filter_lastName',
                ],
                'required' => false,
                'mapped' => false
            ]);
        }
        if (array_search('email',$addFilter) !== false){
            $builder->add('email', TextType::class, [
                'label' => 'Email',
                'attr' => [
                    'class' => 'filter_email',
                ],
                'required' => false,
                'mapped' => false
            ]);
        }
        if (array_search('fullName',$addFilter) !== false){
            $builder
                ->add('fullName', ChoiceType::class, [
                    'label' => 'Full name',
                    'choices' => $fullNames,
                    'multiple' => false,
                    'expanded' => false,
                    'attr' => [
                        'class' => 'filter_fullName select2-without-add',
                    ],
                    'required' => false,
                    'mapped' => false
                ]);
        }
        if (array_search('dateStart',$addFilter) !== false){
            $builder->add('dateStart', DateTimeType::class, [
                'label' => "Start date",
                'widget' => 'single_text',
                'format' => 'dd-MM-yyyy',
                'attr' => [
                    'class' => 'filter_dateStart datepicker-here digits'
                ],
                'required' => false,
                'mapped' => false
            ]);
        }if (array_search('dateEnd',$addFilter) !== false){
            $builder->add('dateEnd', DateTimeType::class, [
                'label' => "End date",
                'widget' => 'single_text',
                'format' => 'dd-MM-yyyy',
                'attr' => [
                    'class' => 'filter_dateEnd datepicker-here digits'
                ],
                'required' => false,
                'mapped' => false
            ]);
        }
        if (array_search('action',$addFilter) !== false){
            $builder->add('action', ChoiceType::class, [
                'label' => 'Action',
                'choices' => [
                    'Filter' => 3,
                    'Import' => 2,
                    'Export' => 1,
                ],
                'multiple' => false,
                'expanded' => false,
                'attr' => [
                    'class' => 'filter_action select2-without-add',
                ],
                'required' => false,
                'mapped' => false
            ]);
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'add' => [],
            'fullNames' => [],
        ]);
    }
}
