<?php
/**
 * Created by PhpStorm.
 * User: ELLIGY
 * Date: 03/04/2020
 * Time: 17:40
 */

namespace App\Mercure;

use App\Entity\Main\User;
use Lcobucci\JWT\Builder;
use Lcobucci\JWT\Signer\Hmac\Sha256;
use Lcobucci\JWT\Signer\Key;
use Symfony\Component\HttpFoundation\Cookie;

class CookieGenerator
{
    private $secret;

    public function __construct(string $secret)
    {
        $this->secret = $secret;
    }

    public function generate(User $user): Cookie
    {
        $token = (new Builder())
            ->withClaim('mercure', ['subscribe' => [$this->secret . "/user/{$user->getId()}"]])
            ->getToken(new Sha256(), new Key($this->secret));

        return Cookie::create('mercureAuthorization', $token, 0, '/.well-known/mercure');
    }
}
