<?php
/**
 * Created by PhpStorm.
 * User: ELLIGY
 * Date: 30/10/2019
 * Time: 16:38
 */

namespace App\Mercure;

use App\Entity\Main\User;
use Symfony\Component\Mercure\Update;
use Symfony\Component\Messenger\MessageBusInterface;

class NotificationSender
{
    private $secret;
    /**
     * @var MessageBusInterface
     */
    private $bus;

    public function __construct(
        string $secret,
        MessageBusInterface $bus
    )
    {
        $this->secret = $secret;
        $this->bus = $bus;
    }

    public function sendNotification(string $topic, User $receiver, $data = null)
    {
        $target = [$this->secret . "/user/{$receiver->getId()}"];
        $update = new Update(
            $topic,
            json_encode([
                'data' => $data,
            ]),
            $target
        );
        $this->bus->dispatch($update);
    }
}
