<?php

namespace App\Repository\Main;

use App\Entity\Main\DashboardUserExport;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\OptimisticLockException;
use Doctrine\ORM\ORMException;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<DashboardUserExport>
 *
 * @method DashboardUserExport|null find($id, $lockMode = null, $lockVersion = null)
 * @method DashboardUserExport|null findOneBy(array $criteria, array $orderBy = null)
 * @method DashboardUserExport[]    findAll()
 * @method DashboardUserExport[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class DashboardUserExportRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, DashboardUserExport::class);
    }

    /**
     * @throws ORMException
     * @throws OptimisticLockException
     */
    public function add(DashboardUserExport $entity, bool $flush = true): void
    {
        $this->_em->persist($entity);
        if ($flush) {
            $this->_em->flush();
        }
    }

    /**
     * @throws ORMException
     * @throws OptimisticLockException
     */
    public function remove(DashboardUserExport $entity, bool $flush = true): void
    {
        $this->_em->remove($entity);
        if ($flush) {
            $this->_em->flush();
        }
    }

    // /**
    //  * @return DashboardUserExport[] Returns an array of DashboardUserExport objects
    //  */
    /*
    public function findByExampleField($value)
    {
        return $this->createQueryBuilder('d')
            ->andWhere('d.exampleField = :val')
            ->setParameter('val', $value)
            ->orderBy('d.id', 'ASC')
            ->setMaxResults(10)
            ->getQuery()
            ->getResult()
        ;
    }
    */

    /*
    public function findOneBySomeField($value): ?DashboardUserExport
    {
        return $this->createQueryBuilder('d')
            ->andWhere('d.exampleField = :val')
            ->setParameter('val', $value)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
    */
}
