<?php
namespace App\Service;

class Functions
{
    public function excelCellName($i)
    {
        $entiere = floor($i / 26);
        $reste = $i % 26;
        if($entiere > 0){
            return chr($entiere + 64).chr($reste + 65);
        }
        else{
            return chr($reste + 65);
        }
    }

    public function passwordGenerate($length)
    {
        $data = '1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcefghijklmnopqrstuvwxyz&-][+-';
        return substr(str_shuffle($data), 0, $length);
    }

    function convertDate($date){
		if(substr_count($date,'-') > 1){
			return (new \DateTime(date('Y-m-d', strtotime($date))))->format('d/m/Y');
		} else if(substr_count($date,'/') > 1){
			return $date;
		} else if(is_int($date)){
            $unix_date = ($date - 25569) * 86400;
            $excel_date = 25569 + ($unix_date / 86400);
            $unix_date = ($excel_date - 25569) * 86400;
            return gmdate("d/m/Y", $unix_date);
        } else{
			return null;
		}
       
       
    }
}
