<?php

namespace App\Service;

use Symfony\Component\Serializer\SerializerInterface;

class GihsnWpApiService
{
    protected $wpConfig;
    protected $serializer;

    public function __construct($wpConfig, SerializerInterface $serializer)
    {
        $this->wpConfig = $wpConfig;
        $this->serializer = $serializer;
    }

    public function fetchEntries()
    {
        $result = [];
        $result['entries'] = [];
        $result['error'] = '';
        $curl = curl_init();
        // Check if initialization had gone wrong*
        if ($curl === false) {
            $result['error'] = "Fetch Entries: Échec de l'initialisation de curl";
            return $result;
        }

        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->wpConfig['gihsn_wp_url'] . 'wp-json/gihsn/api/v1/survey',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                "X-API-Key: " . $this->wpConfig['gihsn_wp_api_key']
            )
            /* for test in local
        , CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_SSL_VERIFYPEER => false */
        ));

        $response = curl_exec($curl);
        if ($response === false) {
            $result['error'] = curl_error($curl);
            return $result;
        }
        curl_close($curl);

        // Decode JSON string into a PHP associative array
        $decodedResponse = json_decode($response, true);

        if ($decodedResponse !== null) {
            if (array_key_exists('code', $decodedResponse)) {
                $result['error'] = "Récuperation entries non effectuée => " . $decodedResponse['message'];
            } else {
                $result['entries'] = $decodedResponse;
            }
        }
        return $result;
    }

    public function fetchEntriesIds()
    {
        $result = [];
        $result['ids'] = [];
        $result['error'] = '';
        $curl = curl_init();
        // Check if initialization had gone wrong*
        if ($curl === false) {
            $result['error'] = "Fetch Entries ids: Échec de l'initialisation de curl";
            return $result;
        }

        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->wpConfig['gihsn_wp_url'] . 'wp-json/gihsn/api/v1/getEntriesIds',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                "X-API-Key: " . $this->wpConfig['gihsn_wp_api_key']
            )
            /* for test in local
            , CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_SSL_VERIFYPEER => false*/
        ));

        $response = curl_exec($curl);
        if ($response === false) {
            $result['error'] = curl_error($curl);
            return $result;
        }

        curl_close($curl);

        // Decode JSON string into a PHP associative array
        $decodedResponse = json_decode($response, true);
        if ($decodedResponse != null) {
            if (array_key_exists('code', $decodedResponse)) {
                $result['error'] = "Récuperation les ids d'entries non effectuée => " . $decodedResponse['message'];
            } else {
                $result['ids'] = $response;
            }
        }
        return $result;
    }

    public function fetchSites()
    {
        $result = [];
        $result['sites'] = [];
        $result['error'] = '';
        $curl = curl_init();
        // Check if initialization had gone wrong*
        if ($curl === false) {
            $result['error'] = "Fetch sites: Échec de l'initialisation de curl";
            return $result;
        }

        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->wpConfig['gihsn_wp_url'] . 'wp-json/gihsn/api/v1/sites',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                "X-API-Key: " . $this->wpConfig['gihsn_wp_api_key']
            )
            /* for test in local
            , CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_SSL_VERIFYPEER => false*/
        ));

        $response = curl_exec($curl);
        if ($response === false) {
            $result['error'] = curl_error($curl);
            return $result;
        }
        curl_close($curl);


        // Decode JSON string into a PHP associative array
        $decodedResponse = json_decode($response, true);
        if ($decodedResponse != null) {
            if (array_key_exists('code', $decodedResponse)) {
                $result['error'] = "Récuperation sites non effectuée => " . $decodedResponse['message'];
            } else {
                $result['sites'] = $decodedResponse;
            }
        }

        return $result;
    }

}