<?php
/**
 * Created by PhpStorm.
 * User: ELLIGY
 * Date: 16/03/2020
 * Time: 23:43
 */

namespace App\Service;


use App\Entity\Main\DataFile;
use App\Entity\Main\Historic;
use App\Entity\Main\Manager;
use App\Entity\Main\User;
use App\Entity\Main\Visitor;
use Doctrine\ORM\EntityManagerInterface;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Psr\Container\ContainerInterface;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;
use Symfony\Contracts\HttpClient\HttpClientInterface;

class GlobalServices
{
    protected $container;
    public $functions;
    protected $em;
    private $client;

    public function __construct(
        ContainerInterface $container,
        Functions $functions,
        TokenStorageInterface $tokenStorage,
        EntityManagerInterface $entityManager,
        HttpClientInterface $client
    )
    {
        $this->container = $container;
        $this->functions = $functions;
        $this->user = $tokenStorage->getToken() ? $tokenStorage->getToken()->getUser() : null;
        $this->em = $entityManager;
        $this->client = $client;
    }
    public function managerRegistration(Manager $manager,array $data){
        // Prepare a visitor object
        $manager->setLastName($data['lastName']);
        $manager->setFirstName($data['firstName']);
        $manager->setEmail($data['email']);
        if($manager->getId()){
            $user = $this->em->getRepository(User::class)->find($manager->getUser()->getId());
        }
        else{
            $user = new User();
        }
        // Verify existance of email
        $userManager = $this->container->get('fos_user.user_manager');

        if (((!is_object($this->user)) && ($userManager->findUserByEmail($data['email']))) || ((is_object($this->user)) && ($user->getEmail() !== $data['email']) && ($userManager->findUserByEmail($data['email'])))) {
            return array("status" => 500, "message" => "E-mail address already used.");
        }

        // Persist a user object
        $user->setFullName($data['firstName'].' '.$data['lastName']);
        $user->setUsername($data['email']);
        $user->setEmail($data['email']);
        $user->setEmailCanonical(strtolower($data['email']));
        $user->setRoles(['ROLE_MANAGER']);
        $user->setEnabled(true);
        if($manager->getId()== null){
            $password = $this->functions->passwordGenerate(8);
            $user->setPlainPassword($password);
            $user->setTemporaryPassword($password);
        }
        $userManager->updateUser($user);

        // Persist a visitor object
        $manager->setUser($user);
        $this->em->persist($manager);

        return array(
            "status" => 200,
            "message" => $manager->getId()? 'Administrator Modified successfully' : 'Administrator created successfully',
            "user" => $user
        );
    }

    public function visitorRegistration(Visitor $visitor,array $data){
        // Prepare a visitor object
        $visitor->setLastName($data['lastName']);
        $visitor->setFirstName($data['firstName']);
        $visitor->setEmail($data['email']);


        // Verify existance of email
        $userVisitor = $this->container->get('fos_user.user_manager');
        if($visitor->getId()){
            $user = $this->em->getRepository(User::class)->find($visitor->getUser()->getId());
        }
        else{
            $user = new User();
        }
        if (((!is_object($this->user)) && ($userVisitor->findUserByEmail($data['email']))) || ((is_object($this->user)) && ($user->getEmail() !== $data['email']) && ($userVisitor->findUserByEmail($data['email'])))) {
            return array("status" => 500, "message" => "E-mail address already used.");
        }

        // Persist a user object
        $user->setFullName($data['firstName'].' '.$data['lastName']);
        $user->setUsername($data['email']);
        $user->setEmail($data['email']);
        $user->setEmailCanonical(strtolower($data['email']));
        $user->setRoles(['ROLE_VISITOR']);
        $user->setEnabled(true);
        if($visitor->getId()== null){
            $password = $this->functions->passwordGenerate(8);
            $user->setPlainPassword($password);
            $user->setTemporaryPassword($password);
        }
        $userVisitor->updateUser($user);

        // Persist a visitor object
        $visitor->setUser($user);
        $this->em->persist($visitor);

        return array(
            "status" => 200,
            "message" =>  $visitor->getId()? 'User Modified successfully' : 'User created successfully',
            "user" => $user
        );
    }

    public function saveHistoric($user,$action,$type)
    {
        //save the histocic of each action in the DB
        $historic = new Historic();
        $historic->setUser($user);
        $historic->setAction($action);
        $historic->setType($type);
        $this->em->persist($historic);
        $this->em->flush();
    }
}
