<?php

namespace App\Twig\Extension;

use App\Service\AppParams;
use Doctrine\ORM\EntityManagerInterface;
use Twig\Extension\AbstractExtension;
use Twig\Extension\GlobalsInterface;

class DatabaseGlobalsExtension extends AbstractExtension implements GlobalsInterface
{
    protected $em;
    protected $notification;
    protected $appParams;

    public function __construct(
        EntityManagerInterface $em,
        AppParams $appParams

    )
    {
        $this->em = $em;
        $this->appParams = $appParams;

    }

    public function getGlobals()
    {
        $appParams = $this->appParams->getAllParams();

        return [
            'appParams' => $appParams,
        ];
    }
}
