<?php
/**
 * Created by PhpStorm.
 * User: ELLIGY
 * Date: 14/03/2020
 * Time: 10:09
 */

namespace App\Twig\Extension;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class VarsExtension extends AbstractExtension
{
    protected $container;
    protected $em;

    public function __construct(
        ContainerInterface $container,
        EntityManagerInterface $entityManager
    )
    {
        $this->container = $container;
        $this->em = $entityManager;
    }

    public function getFilters()
    {
        return [
            new TwigFilter('json_decode_assoc', [$this, 'jsonDecodeAssoc']),
            new TwigFilter('json_decode', [$this, 'jsonDecode']),
        ];
    }

    public function jsonDecode($str)
    {
        return json_decode($str);
    }

    public function jsonDecodeAssoc($str)
    {
        return json_decode($str, true);
    }
}
